/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Structure.AntFarm;

import Reika.ChromatiCraft.Base.StructurePiece;
import Reika.ChromatiCraft.Block.Worldgen.BlockStructureShield;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.World.Dimension.Structure.AntFarmGenerator;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Worldgen.ChunkSplicedGenerationCache;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.block.Block;

public class AntFarmLevel
extends StructurePiece {
    public final int posX;
    public final int posY;
    public final int posZ;
    public final int horizontalRadius;
    public final int verticalRadius;
    private final HashMap<Coordinate, Boolean> blocks = new HashMap();

    public AntFarmLevel(AntFarmGenerator a, int x, int y, int z, int rh, int rv) {
        super(a);
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        this.horizontalRadius = rh;
        this.verticalRadius = rv;
        this.initialize();
    }

    private void initialize() {
        Block b = ChromaBlocks.STRUCTSHIELD.getBlockInstance();
        int meta = BlockStructureShield.BlockType.STONE.metadata;
        int r = this.horizontalRadius;
        int r2 = this.verticalRadius;
        for (int i = -r; i <= r; ++i) {
            for (int k = -r; k <= r; ++k) {
                for (int j = -r2; j <= r2; ++j) {
                    if (!ReikaMathLibrary.isPointInsidePowerEllipse((double)i, (double)j, (double)k, (double)((double)r + 0.5), (double)((double)r2 + 0.5), (double)((double)r + 0.5), (double)4.0)) continue;
                    int dx = this.posX + i;
                    int dy = this.posY + j;
                    int dz = this.posZ + k;
                    Coordinate c = new Coordinate(dx, dy, dz);
                    boolean air = ReikaMathLibrary.isPointInsidePowerEllipse((double)i, (double)j, (double)k, (double)(r - 1), (double)(r2 - 1), (double)(r - 1), (double)4.0);
                    this.blocks.put(c, air);
                }
            }
        }
    }

    public void register(AntFarmGenerator g, HashSet<Coordinate> tunnelSpaces) {
        for (Coordinate c : this.blocks.keySet()) {
            g.cutBlock(c, this.blocks.get(c));
        }
        tunnelSpaces.addAll(this.blocks.keySet());
    }

    public boolean intersectsWith(HashSet<Coordinate> tunnelSpaces) {
        for (Coordinate c : this.blocks.keySet()) {
            if (!tunnelSpaces.contains(c)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void generate(ChunkSplicedGenerationCache world, int x, int y, int z) {
    }
}

