/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Structure;

import Reika.ChromatiCraft.Base.DimensionStructureGenerator;
import Reika.ChromatiCraft.Base.StructureData;
import Reika.ChromatiCraft.World.Dimension.Structure.Altar.AltarCenter;
import Reika.ChromatiCraft.World.Dimension.Structure.Altar.AltarNode;
import Reika.ChromatiCraft.World.Dimension.Structure.Altar.AltarTunnel;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class AltarGenerator
extends DimensionStructureGenerator {
    private int lastPosY;

    @Override
    public void calculate(int chunkX, int chunkZ, Random rand) {
        this.posY = 10 + rand.nextInt(30);
        this.posY = 80;
        new AltarCenter(this).generate(this.world, chunkX, this.posY, chunkZ);
        ArrayList<ForgeDirection> li = new ArrayList<ForgeDirection>();
        for (int i = 2; i < 6; ++i) {
            if (rand.nextInt(3) <= 0) continue;
            li.add(ForgeDirection.VALID_DIRECTIONS[i]);
        }
        this.recursiveGeneratePaths(chunkX, this.posY, chunkZ, rand, li, 0, 17);
    }

    private void recursiveGeneratePaths(int x, int y, int z, Random rand, ArrayList<ForgeDirection> li, int depth, int step) {
        if (depth > 2) {
            return;
        }
        for (ForgeDirection dir : li) {
            ForgeDirection dir2;
            int i;
            int len = 8 + rand.nextInt(32);
            AltarTunnel at = new AltarTunnel(this, dir, len);
            int dx = x + dir.offsetX * step;
            int dz = z + dir.offsetZ * step;
            at.generate(this.world, dx, y, dz);
            AltarNode node = new AltarNode(this, rand.nextBoolean());
            int dx2 = dx + dir.offsetX * (len + 5);
            int dz2 = dz + dir.offsetZ * (len + 5);
            node.generate(this.world, dx2, y, dz2);
            for (i = 2; i < 6; ++i) {
                dir2 = ForgeDirection.VALID_DIRECTIONS[i];
                if (dir2 == dir.getOpposite() || rand.nextInt(1 + step * 0) != 0) continue;
                this.recursiveGeneratePaths(dx2, y, dz2, rand, ReikaJavaLibrary.makeListFrom((Object)dir2), depth + 1, 5);
            }
            if (!node.Yshunt) continue;
            for (i = 2; i < 6; ++i) {
                dir2 = ForgeDirection.VALID_DIRECTIONS[i];
                if (rand.nextInt(1 + step * 0) != 0) continue;
                this.recursiveGeneratePaths(dx2, y + 11, dz2, rand, ReikaJavaLibrary.makeListFrom((Object)dir2), depth + 1, 5);
            }
        }
    }

    @Override
    protected int getCenterXOffset() {
        return 0;
    }

    @Override
    protected int getCenterZOffset() {
        return 0;
    }

    @Override
    public StructureData createDataStorage() {
        return null;
    }

    @Override
    public boolean hasBeenSolved(World world) {
        return false;
    }
}

