/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension;

import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.ExtraChromaIDs;
import Reika.ChromatiCraft.World.Dimension.SkyRiverGenerator;
import Reika.ChromatiCraft.World.Dimension.SkyRiverManager;
import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Interfaces.Registry.SoundEnum;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkCoordIntPair;

public class SkyRiverManagerClient {
    private static boolean allowClientSkyRiverMovement = false;

    @SideOnly(value=Side.CLIENT)
    public static void handleSkyRiverMovementClient() {
        double d;
        WorldClient w = Minecraft.func_71410_x().field_71441_e;
        if (w == null || w.field_73011_w.field_76574_g != ExtraChromaIDs.DIMID.getValue()) {
            return;
        }
        EntityClientPlayerMP pl = Minecraft.func_71410_x().field_71439_g;
        SkyRiverGenerator.RiverPoint closest = SkyRiverGenerator.getClosestPoint((EntityPlayer)pl, 48.0, false);
        if (closest != null && closest.positionID == 1 && (d = closest.position.getDistanceTo(pl.field_70165_t, pl.field_70163_u, pl.field_70161_v)) <= 48.0 && w.func_82737_E() % 111L == 0L) {
            float v = 0.5f + 0.5f * (float)Math.sqrt(1.0 - d / 48.0);
            ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.SKYRIVER, (Entity)pl, (float)v, (float)1.0f);
        }
        if (!allowClientSkyRiverMovement) {
            return;
        }
        if (closest != null && SkyRiverGenerator.isWithinSkyRiver((EntityPlayer)pl, closest)) {
            SkyRiverManager.movePlayer((EntityPlayer)pl, closest, SkyRiverManagerClient.doesClientTryToMove());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleRayUpdatePacket(NBTTagCompound cmp) {
        SkyRiverGenerator.Ray r = SkyRiverGenerator.Ray.readFromPktNBT(cmp);
        List<DecimalPosition> points = r.getPoints();
        SkyRiverGenerator.RiverPoint prev = null;
        for (int i = 1; i < points.size() - 1; ++i) {
            DecimalPosition p1 = points.get(i);
            DecimalPosition pb = points.get(i + 1);
            DecimalPosition pa = points.get(i - 1);
            ChunkCoordIntPair ch = new ChunkCoordIntPair(MathHelper.func_76128_c((double)p1.xCoord) / 16, MathHelper.func_76128_c((double)p1.zCoord) / 16);
            SkyRiverGenerator.RiverPoint p = new SkyRiverGenerator.RiverPoint(i, ch, p1, pa, pb);
            if (prev != null) {
                prev.nextRiverPoint = p;
            }
            prev = p;
            MultiMap<ChunkCoordIntPair, SkyRiverGenerator.RiverPoint> multiMap = SkyRiverGenerator.clientPoints;
            synchronized (multiMap) {
                SkyRiverGenerator.clientPoints.addValue((Object)ch, (Object)p);
                continue;
            }
        }
        SkyRiverManager.debugMessage("Client> Received " + points.size() + " SkyRiver Ray-Points from Server.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleRayClearPacket() {
        MultiMap<ChunkCoordIntPair, SkyRiverGenerator.RiverPoint> multiMap = SkyRiverGenerator.clientPoints;
        synchronized (multiMap) {
            SkyRiverGenerator.clientPoints.clear();
        }
        allowClientSkyRiverMovement = false;
        SkyRiverManager.debugMessage("Client> Cleared Client-SkyRiver.");
    }

    public static void handleClientState(int state) {
        switch (state) {
            case 0: {
                SkyRiverManagerClient.handleRayClearPacket();
                break;
            }
            case 1: {
                SkyRiverManager.debugMessage("Client> StateChange: ALLOW");
                allowClientSkyRiverMovement = true;
                break;
            }
            case 2: {
                SkyRiverManager.debugMessage("Client> StateChange: DENY");
                allowClientSkyRiverMovement = false;
                break;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static boolean doesClientTryToMove() {
        GameSettings settings = Minecraft.func_71410_x().field_71474_y;
        if (settings.field_74368_y.func_151470_d()) {
            return true;
        }
        if (settings.field_74351_w.func_151470_d()) {
            return true;
        }
        if (settings.field_74370_x.func_151470_d()) {
            return true;
        }
        return settings.field_74366_z.func_151470_d();
    }

    public static boolean stopSlowFall() {
        return !allowClientSkyRiverMovement;
    }
}

