/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension;

import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ExtraChromaIDs;
import Reika.ChromatiCraft.World.Dimension.SkyRiverGenerator;
import Reika.DragonAPI.Auxiliary.Trackers.PlayerChunkTracker;
import Reika.DragonAPI.Auxiliary.Trackers.TickScheduler;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Instantiable.Event.ScheduledTickEvent;
import Reika.DragonAPI.Instantiable.IO.PacketTarget;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.Java.ReikaObfuscationHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaVectorHelper;
import cpw.mods.fml.relauncher.Side;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class SkyRiverManager {
    public static final PlayerChunkTracker.TrackingCondition skyRiverCondition = new TrackingConditionSkyRiver();
    private static final List<DelayedSkyRiverPacketEvent> delayedPackets = new LinkedList<DelayedSkyRiverPacketEvent>();
    private static final Map<EntityPlayer, Integer> recentlyLeftSkyRiver = new HashMap<EntityPlayer, Integer>();
    private static final int SKYRIVER_ENTER_DELAY = 60;

    public static void tickSkyRiverServer(World w) {
        if (!w.field_72995_K) {
            for (Object objPl : w.field_73010_i) {
                if (!(objPl instanceof EntityPlayer) || ((EntityPlayer)objPl).field_70128_L) continue;
                EntityPlayer pl = (EntityPlayer)objPl;
                if (recentlyLeftSkyRiver.containsKey(pl)) {
                    int delay = recentlyLeftSkyRiver.get(pl);
                    if (--delay <= 0) {
                        recentlyLeftSkyRiver.remove(pl);
                        SkyRiverManager.debugMessage("Player " + pl.func_70005_c_() + " may enter the SkyRiver again.");
                        continue;
                    }
                    recentlyLeftSkyRiver.put(pl, delay);
                    continue;
                }
                SkyRiverGenerator.RiverPoint closest = SkyRiverGenerator.getClosestPoint(pl, 16.0, true);
                if (closest == null || !SkyRiverGenerator.isWithinSkyRiver(pl, closest)) continue;
                if (!PlayerChunkTracker.shouldStopChunkloadingFor((EntityPlayer)pl)) {
                    PlayerChunkTracker.startTrackingPlayer((EntityPlayer)pl, (PlayerChunkTracker.TrackingCondition)skyRiverCondition);
                    SkyRiverManager.sendSkyriverEnterStatePacket(pl, true);
                    SkyRiverManager.debugMessage("Player " + pl.func_70005_c_() + " has entered a SkyRiver.");
                }
                SkyRiverManager.movePlayer(pl, closest, false);
            }
        }
    }

    protected static void movePlayer(EntityPlayer player, SkyRiverGenerator.RiverPoint rp, boolean doesMove) {
        Vec3 nodeVector;
        Vec3 pullVector;
        DecimalPosition plPos = new DecimalPosition((Entity)player);
        double dst = ReikaVectorHelper.getDistFromPointToLine((double)rp.next.xCoord, (double)rp.next.yCoord, (double)rp.next.zCoord, (double)rp.position.xCoord, (double)rp.position.yCoord, (double)rp.position.zCoord, (double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v);
        if (dst < 12.0) {
            pullVector = Vec3.func_72443_a((double)(rp.next.xCoord - rp.position.xCoord), (double)(rp.next.yCoord - rp.position.yCoord), (double)(rp.next.zCoord - rp.position.zCoord));
            nodeVector = Vec3.func_72443_a((double)(rp.next.xCoord - plPos.xCoord), (double)(rp.next.yCoord - plPos.yCoord), (double)(rp.next.zCoord - plPos.zCoord));
        } else {
            dst = ReikaVectorHelper.getDistFromPointToLine((double)rp.position.xCoord, (double)rp.position.yCoord, (double)rp.position.zCoord, (double)rp.prev.xCoord, (double)rp.prev.yCoord, (double)rp.prev.zCoord, (double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v);
            if (dst < 12.0) {
                pullVector = Vec3.func_72443_a((double)(rp.position.xCoord - rp.prev.xCoord), (double)(rp.position.yCoord - rp.prev.yCoord), (double)(rp.position.zCoord - rp.prev.zCoord));
                nodeVector = Vec3.func_72443_a((double)(rp.position.xCoord - plPos.xCoord), (double)(rp.position.yCoord - plPos.yCoord), (double)(rp.position.zCoord - plPos.zCoord));
            } else {
                return;
            }
        }
        pullVector = pullVector.func_72432_b();
        nodeVector = nodeVector.func_72432_b();
        Vec3 moveVector = Vec3.func_72443_a((double)(pullVector.field_72450_a * 0.6 + nodeVector.field_72450_a * 0.4), (double)(pullVector.field_72448_b * 0.6 + nodeVector.field_72448_b * 0.4), (double)(pullVector.field_72449_c * 0.6 + nodeVector.field_72449_c * 0.4));
        if (doesMove) {
            Vec3 playerMove = Vec3.func_72443_a((double)player.field_70159_w, (double)player.field_70181_x, (double)player.field_70179_y).func_72432_b();
            moveVector = Vec3.func_72443_a((double)(moveVector.field_72450_a * 0.1 + playerMove.field_72450_a * 0.9), (double)moveVector.field_72448_b, (double)(moveVector.field_72449_c * 0.1 + playerMove.field_72449_c * 0.9));
        }
        double multiplier = 7.0;
        player.field_70159_w = moveVector.field_72450_a * multiplier;
        player.field_70181_x = moveVector.field_72448_b * multiplier;
        player.field_70179_y = moveVector.field_72449_c * multiplier;
    }

    protected static void debugMessage(String message) {
        if (DragonAPICore.isReikasComputer() && ReikaObfuscationHelper.isDeObfEnvironment() || DragonAPICore.debugtest) {
            ChromatiCraft.logger.log((Object)("SkyRiver> " + message));
        }
    }

    private static void sendRiverPoints(EntityPlayer player, SkyRiverGenerator.Ray r) {
        NBTTagCompound cmp = new NBTTagCompound();
        r.writeToPktNBT(cmp);
        ReikaPacketHelper.sendNBTPacket((String)"ChromaData", (int)ChromaPackets.SKYRIVER_SYNC.ordinal(), (NBTTagCompound)cmp, (PacketTarget)new PacketTarget.PlayerTarget((EntityPlayerMP)player));
    }

    protected static void sendRiverClearPacketsToAll() {
        List objPlayers;
        try {
            objPlayers = MinecraftServer.func_71276_C().func_71203_ab().field_72404_b;
        }
        catch (NullPointerException exc) {
            return;
        }
        for (Object player : objPlayers) {
            SkyRiverManager.clearClientRiver((EntityPlayer)player);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearClientRiver(EntityPlayer player) {
        List<DelayedSkyRiverPacketEvent> list = delayedPackets;
        synchronized (list) {
            for (DelayedSkyRiverPacketEvent event : delayedPackets) {
                if (!event.recipient.equals((Object)player)) continue;
                event.aborted = true;
            }
        }
        SkyRiverManager.debugMessage("Sending SkyRiver clear to " + player.func_70005_c_());
        ReikaPacketHelper.sendDataPacket((String)"ChromaData", (int)ChromaPackets.SKYRIVER_STATE.ordinal(), (EntityPlayerMP)((EntityPlayerMP)player), (int[])new int[]{0});
    }

    private static void sendSkyriverEnterStatePacket(EntityPlayer player, boolean allowEntering) {
        SkyRiverManager.debugMessage("Sending SkyRiver State-Change to " + player.func_70005_c_() + " - new State: " + (allowEntering ? "Allow" : "Deny"));
        ReikaPacketHelper.sendDataPacket((String)"ChromaData", (int)ChromaPackets.SKYRIVER_STATE.ordinal(), (EntityPlayerMP)((EntityPlayerMP)player), (int[])new int[]{allowEntering ? 1 : 2});
    }

    private static void handleUntrack() {
        List objPlayers;
        try {
            objPlayers = MinecraftServer.func_71276_C().func_71203_ab().field_72404_b;
        }
        catch (NullPointerException exc) {
            return;
        }
        for (Object pl : objPlayers) {
            if (PlayerChunkTracker.shouldStopChunkloadingFor((EntityPlayer)((EntityPlayer)pl))) continue;
            SkyRiverManager.sendSkyriverEnterStatePacket((EntityPlayer)pl, false);
            recentlyLeftSkyRiver.put((EntityPlayer)pl, 60);
        }
    }

    protected static void startSendingRiverPackets(EntityPlayer player) {
        SkyRiverManager.debugMessage("Scheduling SkyRiver Packets for " + player.func_70005_c_());
        int ticksDelay = 200;
        int startIndex = 0;
        if (player.field_70170_p.field_73011_w.field_76574_g == ExtraChromaIDs.DIMID.getValue()) {
            ticksDelay = 0;
            SkyRiverGenerator.RiverPoint rp = SkyRiverGenerator.getClosestPoint(player, 128.0, true);
            if (rp != null) {
                DecimalPosition pos = rp.position;
                for (int i = 0; i < SkyRiverGenerator.rays.size(); ++i) {
                    SkyRiverGenerator.Ray r = SkyRiverGenerator.rays.get(i);
                    if (!r.getPoints().contains(pos)) continue;
                    startIndex = i;
                    break;
                }
            }
        }
        for (int i = 0; i < SkyRiverGenerator.rays.size(); ++i) {
            int index = (startIndex + i) % SkyRiverGenerator.rays.size();
            SkyRiverGenerator.Ray toSend = SkyRiverGenerator.rays.get(index);
            SkyRiverManager.schedulePacketSending(player, toSend, ticksDelay + i * 10);
        }
    }

    protected static void startSendingRiverPacketsToAll() {
        List objPlayers;
        try {
            objPlayers = MinecraftServer.func_71276_C().func_71203_ab().field_72404_b;
        }
        catch (NullPointerException exc) {
            return;
        }
        for (Object player : objPlayers) {
            SkyRiverManager.startSendingRiverPackets((EntityPlayer)player);
        }
    }

    private static void schedulePacketSending(EntityPlayer player, SkyRiverGenerator.Ray toSend, int delay) {
        DelayedSkyRiverPacketEvent pktEvent = new DelayedSkyRiverPacketEvent(player, toSend);
        delayedPackets.add(pktEvent);
        TickScheduler.instance.scheduleEvent(new ScheduledTickEvent((ScheduledTickEvent.ScheduledEvent)pktEvent), delay);
    }

    public static class TrackingConditionSkyRiver
    implements PlayerChunkTracker.TrackingCondition {
        public boolean shouldBeTracked(EntityPlayer player) {
            return SkyRiverGenerator.isWithinSkyRiver(player, true);
        }

        public void onUntrack(EntityPlayer player) {
            SkyRiverManager.debugMessage("Player " + player.func_70005_c_() + " has left a SkyRiver");
            SkyRiverManager.handleUntrack();
        }
    }

    private static class DelayedSkyRiverPacketEvent
    implements ScheduledTickEvent.ScheduledEvent {
        private final EntityPlayer recipient;
        private final SkyRiverGenerator.Ray toSend;
        private boolean aborted = false;

        public DelayedSkyRiverPacketEvent(EntityPlayer player, SkyRiverGenerator.Ray toSend) {
            this.recipient = player;
            this.toSend = toSend;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fire() {
            List list = delayedPackets;
            synchronized (list) {
                delayedPackets.remove(this);
            }
            if (this.aborted) {
                return;
            }
            SkyRiverManager.sendRiverPoints(this.recipient, this.toSend);
        }

        public boolean runOnSide(Side s) {
            return s == Side.SERVER;
        }
    }
}

