/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension;

import Reika.ChromatiCraft.Base.ThreadedGenerator;
import Reika.ChromatiCraft.World.Dimension.SkyRiverManager;
import Reika.ChromatiCraft.World.Dimension.StructureCalculator;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Instantiable.Math.Spline;
import Reika.DragonAPI.Libraries.Java.ReikaObfuscationHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaVectorHelper;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.imageio.ImageIO;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkCoordIntPair;

public class SkyRiverGenerator
extends ThreadedGenerator {
    protected static final List<Ray> rays = new ArrayList<Ray>();
    protected static final MultiMap<ChunkCoordIntPair, RiverPoint> clientPoints = new MultiMap().setNullEmpty();
    protected static final MultiMap<ChunkCoordIntPair, RiverPoint> serverPoints = new MultiMap().setNullEmpty();
    public static final double RIVER_TUNNEL_RADIUS = 12.0;
    private static final double INNER_RADIUS_MIN = 64.0;
    private static final double INNER_RADIUS_MAX = 256.0;
    private static final double LAYER2_RADIUS_MIN = 1024.0;
    private static final double LAYER2_RADIUS_MAX = 3072.0;
    private static final double OUTER_RADIUS_MIN = StructureCalculator.getMaximumPossibleDistance() + 1500.0 + 512.0;
    private static final double OUTER_RADIUS_MAX = OUTER_RADIUS_MIN + 2048.0;
    private static final double FULL_RAY_ANGLE = 45.0;
    private static final double LAYER2_RAY_ANGLE = 11.25;
    private static final double NODE_LENGTH = 128.0;
    private static final double INNER_ANGLE_VARIATION = 10.0;
    private static final double ANGLE_VARIATION = 5.0;
    private static final double MAX_ANGLE_STEP = 2.5;
    private static final double VERTICAL_POSITION_MIN = 384.0;
    private static final double VERTICAL_POSITION_MAX = 512.0;
    private static final double ANGLE_VARIATION_FADE_RANGE = 384.0;

    public SkyRiverGenerator(long seed) {
        super(seed);
    }

    @Override
    public void run() throws Throwable {
        double r2;
        double r1;
        double d;
        rays.clear();
        serverPoints.clear();
        SkyRiverManager.sendRiverClearPacketsToAll();
        for (d = 0.0; d < 360.0; d += 45.0) {
            r1 = 64.0 + this.rand.nextDouble() * 192.0;
            r2 = OUTER_RADIUS_MIN + this.rand.nextDouble() * (OUTER_RADIUS_MAX - OUTER_RADIUS_MIN);
            this.generateRay(d, r1, r2);
        }
        for (d = 0.0; d < 360.0; d += 11.25) {
            if (d % 45.0 == 0.0) continue;
            r1 = 1024.0 + this.rand.nextDouble() * 2048.0;
            r2 = OUTER_RADIUS_MIN + this.rand.nextDouble() * (OUTER_RADIUS_MAX - OUTER_RADIUS_MIN);
            this.generateRay(d, r1, r2);
        }
        for (Ray r : rays) {
            RiverPoint prev = null;
            for (int i = 1; i < r.points.size() - 1; ++i) {
                DecimalPosition pos = (DecimalPosition)r.points.get(i);
                DecimalPosition nextPos = (DecimalPosition)r.points.get(i + 1);
                DecimalPosition prevPos = (DecimalPosition)r.points.get(i - 1);
                ChunkCoordIntPair ch = new ChunkCoordIntPair(MathHelper.func_76128_c((double)pos.xCoord) / 16, MathHelper.func_76128_c((double)pos.zCoord) / 16);
                RiverPoint p = new RiverPoint(i, ch, pos, prevPos, nextPos);
                if (prev != null) {
                    prev.nextRiverPoint = p;
                }
                prev = p;
                serverPoints.addValue((Object)ch, (Object)p);
            }
        }
        if (DragonAPICore.isReikasComputer() && ReikaObfuscationHelper.isDeObfEnvironment() || DragonAPICore.debugtest) {
            // empty if block
        }
        SkyRiverManager.startSendingRiverPacketsToAll();
    }

    private void exportAsImage() throws IOException {
        File f = new File(DragonAPICore.getMinecraftDirectory(), "DimensionRiver/" + this.seed + "L/" + System.nanoTime() + ".png");
        if (f.exists()) {
            f.delete();
        }
        f.getParentFile().mkdirs();
        f.createNewFile();
        int n = 0;
        for (RiverPoint p : serverPoints.allValues(false)) {
            DecimalPosition c = p.position;
            n = Math.max(n, Math.max(1 + (int)Math.abs(c.xCoord), 1 + (int)Math.abs(c.zCoord)));
        }
        BufferedImage img = new BufferedImage((n /= 5) * 2 + 1, n * 2 + 1, 2);
        for (RiverPoint p : serverPoints.allValues(false)) {
            int x = (int)p.position.xCoord / 5 + n;
            int z = (int)p.position.zCoord / 5 + n;
            for (int i = -1; i <= 1; ++i) {
                for (int k = -1; k <= 1; ++k) {
                    try {
                        img.setRGB(x + i, z + k, -16777216);
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        }
        ImageIO.write((RenderedImage)img, "png", f);
    }

    public static Collection<RiverPoint> getPointsForChunk(int x, int z, boolean isServerSide) {
        ChunkCoordIntPair pos = new ChunkCoordIntPair(x, z);
        MultiMap<ChunkCoordIntPair, RiverPoint> points = isServerSide ? serverPoints : clientPoints;
        Collection c = points.get((Object)pos);
        return c != null ? Collections.unmodifiableCollection(c) : null;
    }

    public static Collection<RiverPoint> getPointsWithin(EntityPlayer ep, double range, boolean isServerSide) {
        int x = MathHelper.func_76128_c((double)ep.field_70165_t) / 16;
        int z = MathHelper.func_76128_c((double)ep.field_70161_v) / 16;
        int chRange = MathHelper.func_76128_c((double)range) / 16;
        LinkedList<RiverPoint> c2 = new LinkedList<RiverPoint>();
        if (chRange == 0) {
            Collection<RiverPoint> c = SkyRiverGenerator.getPointsForChunk(x, z, isServerSide);
            if (c != null) {
                c2.addAll(c);
            }
        } else {
            for (int xDiff = -chRange - 1; xDiff <= chRange; ++xDiff) {
                for (int zDiff = -chRange - 1; zDiff <= chRange; ++zDiff) {
                    Collection<RiverPoint> c = SkyRiverGenerator.getPointsForChunk(x + xDiff, z + zDiff, isServerSide);
                    if (c == null) continue;
                    c2.addAll(c);
                }
            }
        }
        return c2;
    }

    public static boolean isWithinSkyRiver(EntityPlayer player, boolean isServerSide) {
        RiverPoint closest = SkyRiverGenerator.getClosestPoint(player, 32.0, isServerSide);
        return SkyRiverGenerator.isWithinSkyRiver(player, closest);
    }

    public static boolean isWithinSkyRiver(EntityPlayer player, RiverPoint closestPoint) {
        DecimalPosition plPos = new DecimalPosition((Entity)player);
        if (closestPoint == null) {
            return false;
        }
        return SkyRiverGenerator.isBetween(closestPoint.prev, closestPoint.position, plPos) || SkyRiverGenerator.isBetween(closestPoint.position, closestPoint.next, plPos);
    }

    public static boolean isBetween(DecimalPosition pos1, DecimalPosition pos2, DecimalPosition toCheck) {
        double dst = ReikaVectorHelper.getDistFromPointToLine((double)pos1.xCoord, (double)pos1.yCoord, (double)pos1.zCoord, (double)pos2.xCoord, (double)pos2.yCoord, (double)pos2.zCoord, (double)toCheck.xCoord, (double)toCheck.yCoord, (double)toCheck.zCoord);
        return dst < 12.0;
    }

    public static RiverPoint getClosestPoint(EntityPlayer ep, double range, boolean isServerSide) {
        Collection<RiverPoint> c = SkyRiverGenerator.getPointsWithin(ep, range, isServerSide);
        Double d = Double.POSITIVE_INFINITY;
        RiverPoint cl = null;
        for (RiverPoint p : c) {
            double dist = ep.func_70092_e(p.position.xCoord, p.position.yCoord, p.position.zCoord);
            if (!(dist < d) || !(dist <= range * range)) continue;
            d = dist;
            cl = p;
        }
        return cl;
    }

    private void generateRay(double ang, double r1, double r2) {
        Ray r = new Ray();
        r.lastAngle = ang;
        for (double d = r1; d <= r2; d += Math.max(128.0, 2.0 * Math.sqrt(d))) {
            double var = 5.0;
            if (d < 1024.0) {
                var = d < 640.0 ? 10.0 : ReikaMathLibrary.linterpolate((double)d, (double)640.0, (double)1024.0, (double)10.0, (double)5.0);
            }
            double a = ang + this.rand.nextDouble() * var * 2.0 - var;
            while (Math.abs(a - r.lastAngle) > 2.5) {
                a = ang + this.rand.nextDouble() * var * 2.0 - var;
            }
            r.lastAngle = a;
            a = Math.toRadians(a);
            double x = d * Math.cos(a);
            double z = d * Math.sin(a);
            double y = 384.0 + this.rand.nextDouble() * 128.0;
            r.addPoint(x, y, z);
        }
        if (r.points.size() <= 2) {
            throw new RuntimeException(r1 + ">" + r2 + "@" + ang);
        }
        r.spline();
        r.rebuildWithMaxDst(18.0);
        rays.add(r);
    }

    @Override
    public String getStateMessage() {
        return "Generated sky rivers, with " + rays.size() + " rays and " + serverPoints.totalSize() + " points.";
    }

    public static class RiverPoint {
        private final ChunkCoordIntPair chunk;
        public final DecimalPosition position;
        public final DecimalPosition next;
        public final DecimalPosition prev;
        public final int positionID;
        public RiverPoint nextRiverPoint;

        public RiverPoint(int id, ChunkCoordIntPair ch, DecimalPosition pos, DecimalPosition prev, DecimalPosition next) {
            this.positionID = id;
            this.chunk = ch;
            this.position = pos;
            this.next = next;
            this.prev = prev;
        }

        public String toString() {
            return this.prev + " > " + this.position + " > " + this.next;
        }
    }

    protected static class Ray {
        private static final double MAX_POINT_DST = 18.0;
        private List<DecimalPosition> points = new ArrayList<DecimalPosition>();
        private double lastAngle;

        protected Ray() {
        }

        private void addPoint(double x, double y, double z) {
            this.points.add(new DecimalPosition(x, y, z));
        }

        private void spline() {
            Spline s = new Spline(Spline.SplineType.CHORDAL);
            for (DecimalPosition p : this.points) {
                s.addPoint((Spline.SplineAnchor)new Spline.BasicSplinePoint(p));
            }
            this.points = s.get(8, false);
        }

        public void rebuildWithMaxDst(double maxDst) {
            ArrayList<DecimalPosition> newPoints = new ArrayList<DecimalPosition>();
            for (int i = 0; i < this.points.size() - 1; ++i) {
                DecimalPosition next;
                DecimalPosition pos = this.points.get(i);
                double dst = pos.getDistanceTo(next = this.points.get(i + 1));
                if (dst < maxDst) {
                    newPoints.add(pos);
                    continue;
                }
                double pointsToAdd = Math.floor(dst / maxDst);
                Vec3 vec = Vec3.func_72443_a((double)((next.xCoord - pos.xCoord) / pointsToAdd), (double)((next.yCoord - pos.yCoord) / pointsToAdd), (double)((next.zCoord - pos.zCoord) / pointsToAdd));
                int j = 0;
                while ((long)j < Math.round(pointsToAdd)) {
                    newPoints.add(new DecimalPosition(pos.xCoord + vec.field_72450_a * (double)j, pos.yCoord + vec.field_72448_b * (double)j, pos.zCoord + vec.field_72449_c * (double)j));
                    ++j;
                }
            }
            newPoints.add(this.points.get(this.points.size() - 1));
            this.points = newPoints;
        }

        public String toString() {
            return this.points.toString();
        }

        protected List<DecimalPosition> getPoints() {
            return Collections.unmodifiableList(this.points);
        }

        protected void writeToPktNBT(NBTTagCompound cmp) {
            NBTTagList list = new NBTTagList();
            for (DecimalPosition point : this.points) {
                list.func_74742_a((NBTBase)point.writeToTag());
            }
            cmp.func_74782_a("list", (NBTBase)list);
        }

        protected static Ray readFromPktNBT(NBTTagCompound cmp) {
            Ray r = new Ray();
            NBTTagList list = cmp.func_150295_c("list", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                r.points.add(DecimalPosition.readTag((NBTTagCompound)list.func_150305_b(i)));
            }
            return r;
        }
    }
}

