/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Rendering;

import Reika.ChromatiCraft.Base.ChromaDimensionBiome;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.DragonAPI.Libraries.IO.ReikaRenderHelper;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Java.ReikaGLHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Locale;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.MathHelper;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.client.IRenderHandler;
import org.lwjgl.opengl.GL11;

public class ChromaWeatherRenderer
extends IRenderHandler {
    public static final ChromaWeatherRenderer instance = new ChromaWeatherRenderer();
    private final float[] rainXCoords;
    private final float[] rainYCoords;
    private int rendererUpdateCount;
    private final Random rand = new Random();

    private ChromaWeatherRenderer() {
        this.rainXCoords = new float[1024];
        this.rainYCoords = new float[1024];
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 32; ++j) {
                float f2 = j - 16;
                float f3 = i - 16;
                float f4 = MathHelper.func_76129_c((float)(f2 * f2 + f3 * f3));
                this.rainXCoords[i << 5 | j] = -f3 / f4;
                this.rainYCoords[i << 5 | j] = f2 / f4;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void render(float ptick, WorldClient world, Minecraft mc) {
        EntityLivingBase e = mc.field_71451_h;
        int ex = MathHelper.func_76128_c((double)e.field_70165_t);
        int ey = MathHelper.func_76128_c((double)e.field_70163_u);
        int ez = MathHelper.func_76128_c((double)e.field_70161_v);
        Tessellator v5 = Tessellator.field_78398_a;
        GL11.glPushAttrib((int)1048575);
        GL11.glPushMatrix();
        GL11.glDisable((int)2884);
        GL11.glDisable((int)3008);
        GL11.glDisable((int)2896);
        ReikaRenderHelper.disableEntityLighting();
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glEnable((int)3042);
        ReikaGLHelper.BlendMode.ADDITIVEDARK.apply();
        double rdx = e.field_70142_S + (e.field_70165_t - e.field_70142_S) * (double)ptick;
        double rdy = e.field_70137_T + (e.field_70163_u - e.field_70137_T) * (double)ptick;
        double rdz = e.field_70136_U + (e.field_70161_v - e.field_70136_U) * (double)ptick;
        int rdh = MathHelper.func_76128_c((double)rdy);
        int radius = 10;
        int b1 = -1;
        float tick = (float)world.func_82737_E() + ptick;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int d = 8;
        for (int z = ez - radius; z <= ez + radius; z += d) {
            for (int x = ex - radius; x <= ex + radius; x += d) {
                int od = x * (radius * 2 + 1) + z;
                int idx = (z - ez + 16) * 32 + x - ex + 16;
                float staggerX = this.rainXCoords[idx] * 4.0f;
                float staggerY = this.rainYCoords[idx] * 4.0f;
                BiomeGenBase biome = world.func_72807_a(x, z);
                if (!(biome instanceof ChromaDimensionBiome)) continue;
                ChromaDimensionBiome b = (ChromaDimensionBiome)biome;
                if (!biome.func_76738_d() && !biome.func_76746_c()) continue;
                int rainY = world.func_72874_g(x, z);
                int minY = ey - radius;
                int maxY = ey + radius;
                if (minY < rainY) {
                    minY = rainY;
                }
                if (maxY < rainY) {
                    maxY = rainY;
                }
                int y = rainY;
                if (rainY < rdh) {
                    y = rdh;
                }
                if (minY == maxY) continue;
                this.rand.setSeed(x * x * 3121 + x * 45238971 ^ z * z * 418711 + z * 13761);
                if (b1 != 0) {
                    if (b1 >= 0) {
                        v5.func_78381_a();
                    }
                    b1 = 0;
                    ReikaTextureHelper.bindTexture(ChromatiCraft.class, (String)("Textures/DimWeather/" + b.getExactType().name().toLowerCase(Locale.ENGLISH) + ".png"));
                    ReikaTextureHelper.bindTexture(ChromatiCraft.class, (String)"Textures/DimWeather/deepocean.png");
                    v5.func_78382_b();
                }
                float f = (float)(96.0 + 32.0 * Math.sin((double)System.currentTimeMillis() / 2000.0));
                float frame = (tick + (float)(x % 16 * 6) + (float)(z % 16 * 8)) / f;
                double dx = (double)((float)x + 0.5f) - e.field_70165_t;
                double dz = (double)((float)z + 0.5f) - e.field_70161_v;
                float dd = MathHelper.func_76133_a((double)(dx * dx + dz * dz)) / (float)radius;
                float colorFactor = 1.0f;
                v5.func_78380_c(240);
                float alpha = 1.0f;
                float frameSizeX = 1.0f;
                float frameSizeY = 1.0f;
                double u = (double)od / 16.0;
                v5.func_78369_a(colorFactor, colorFactor, colorFactor, ((1.0f - dd * dd) * 0.5f + 0.5f) * alpha);
                v5.func_78373_b(-rdx * 1.0, -rdy * 1.0, -rdz * 1.0);
                v5.func_78374_a((double)((float)x - staggerX) + 0.5, (double)minY, (double)((float)z - staggerY) + 0.5, u + (double)(0.0f * frameSizeX), (double)((float)minY * frameSizeY / 4.0f + frame * frameSizeY));
                v5.func_78374_a((double)((float)x + staggerX) + 0.5, (double)minY, (double)((float)z + staggerY) + 0.5, u + (double)(1.0f * frameSizeX), (double)((float)minY * frameSizeY / 4.0f + frame * frameSizeY));
                v5.func_78374_a((double)((float)x + staggerX) + 0.5, (double)maxY, (double)((float)z + staggerY) + 0.5, u + (double)(1.0f * frameSizeX), (double)((float)maxY * frameSizeY / 4.0f + frame * frameSizeY));
                v5.func_78374_a((double)((float)x - staggerX) + 0.5, (double)maxY, (double)((float)z - staggerY) + 0.5, u + (double)(0.0f * frameSizeX), (double)((float)maxY * frameSizeY / 4.0f + frame * frameSizeY));
                v5.func_78373_b(0.0, 0.0, 0.0);
            }
        }
        if (b1 >= 0) {
            v5.func_78381_a();
        }
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }
}

