/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension;

import Reika.ChromatiCraft.Base.ThreadedGenerator;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.World.Dimension.StructureCalculator;
import Reika.ChromatiCraft.World.Dimension.ThreadedGenerators;
import Reika.DragonAPI.Instantiable.Math.LobulatedCurve;

public class RegionMapper
extends ThreadedGenerator {
    private static final double MIN_BUFFER = 200.0;
    public static final double MAX_BUFFER = 1500.0;
    private static LobulatedCurve region;

    public RegionMapper(long seed) {
        super(seed);
    }

    @Override
    public void run() throws Throwable {
        StructureCalculator calc = (StructureCalculator)ThreadedGenerators.STRUCTURE.getCurrentlyActiveGenerator();
        boolean printed = false;
        while (!calc.arePositionsDetermined()) {
            Thread.sleep(50L);
            if (!printed) {
                ChromatiCraft.logger.log((Object)"Waiting for structure generator to finish to calculate locations...");
            }
            printed = true;
        }
        double maxr = calc.getMaximumDistanceFromOrigin();
        double r1 = maxr + 200.0;
        double r2 = maxr + 1500.0;
        region = LobulatedCurve.fromMinMaxRadii((double)r1, (double)r2, (int)20).generate(this.rand);
    }

    public static boolean isPointInCentralRegion(double x, double z) {
        return region.isPointInsideCurve(x, z);
    }

    @Override
    public String getStateMessage() {
        return "Central region created; " + RegionMapper.region.minRadius + " +/- " + RegionMapper.region.amplitudeVariation * 20.0;
    }
}

