/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension;

import Reika.ChromatiCraft.Auxiliary.ChromaAux;
import Reika.ChromatiCraft.Auxiliary.ChromaTeleporter;
import Reika.ChromatiCraft.Entity.EntityDimensionFlare;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityBlurFX;
import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Instantiable.Effects.LightningBolt;
import Reika.DragonAPI.Interfaces.Registry.SoundEnum;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;

public class OuterRegionsEvents {
    public static OuterRegionsEvents instance = new OuterRegionsEvents();

    private OuterRegionsEvents() {
    }

    public void tickPlayerInOuterRegion(EntityPlayer ep) {
        AxisAlignedBB box;
        if (ep.field_70170_p.field_73012_v.nextInt(400) == 0 && ep.field_70170_p.func_72872_a(EntityDimensionFlare.class, box = ReikaAABBHelper.getEntityCenteredAABB((Entity)ep, (double)192.0)).size() < 8) {
            this.spawnFlare(ep.field_70170_p, ep, 192.0);
        }
    }

    private EntityDimensionFlare spawnFlare(World world, EntityPlayer ep, double r) {
        EntityDimensionFlare f = new EntityDimensionFlare(world, ep);
        double dx = ReikaRandomHelper.getRandomPlusMinus((double)ep.field_70165_t, (double)r);
        double dy = ReikaRandomHelper.getRandomPlusMinus((double)ep.field_70163_u, (double)(r / 2.0));
        double dz = ReikaRandomHelper.getRandomPlusMinus((double)ep.field_70161_v, (double)r);
        f.func_70012_b(dx, dy, dz, 0.0f, 0.0f);
        if (!world.field_72995_K) {
            world.func_72838_d((Entity)f);
        }
        return f;
    }

    public boolean doRejectAttack(EntityDimensionFlare e, EntityPlayer ep) {
        this.doFlareAggro(ep);
        return this.doRejectAttack(e, ep, Math.max(3.0f, ep.func_110143_aJ() / 2.0f));
    }

    public boolean doRejectAttack(EntityDimensionFlare e, EntityPlayer ep, float dmg) {
        if (ep.field_70170_p.field_72995_K) {
            this.doRejectAttackFX(e, ep);
            return false;
        }
        ReikaPacketHelper.sendDataPacket((String)"ChromaData", (int)ChromaPackets.FLAREATTACK.ordinal(), (EntityPlayerMP)((EntityPlayerMP)ep), (int[])new int[]{e.func_145782_y()});
        if (ep.func_110143_aJ() <= dmg) {
            if (!ep.field_71075_bZ.field_75098_d) {
                ReikaEntityHelper.transferEntityToDimension((Entity)ep, (int)0, (Teleporter)new ChromaTeleporter(0));
            }
            return true;
        }
        if (!ep.field_71075_bZ.field_75098_d) {
            ChromaAux.doPylonAttack(CrystalElement.WHITE, (EntityLivingBase)ep, dmg, false);
        }
        ReikaEntityHelper.knockbackEntity((Entity)e, (Entity)ep, (double)ep.field_70170_p.field_73012_v.nextDouble());
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    private void doRejectAttackFX(EntityDimensionFlare e, EntityPlayer ep) {
        ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.FLAREATTACK, (Entity)ep, (float)1.0f, (float)e.getIdentity().soundPitch);
        int n = 4 + ep.field_70170_p.field_73012_v.nextInt(4);
        LightningBolt b = new LightningBolt(new DecimalPosition((Entity)e), new DecimalPosition((Entity)ep).offset(0.0, -0.8, 0.0), n);
        b.variance *= 2.0;
        b.update();
        int clr = e.getIdentity().flareColor;
        for (int i = 0; i < b.nsteps; ++i) {
            DecimalPosition pos1 = b.getPosition(i);
            DecimalPosition pos2 = b.getPosition(i + 1);
            for (double r = 0.0; r <= 1.0; r += 0.03125) {
                double f = (double)i + r;
                float s = 1.75f;
                int l = 20;
                int a = (int)(2.0 * f);
                DecimalPosition dd = DecimalPosition.interpolate((DecimalPosition)pos1, (DecimalPosition)pos2, (double)r);
                EntityBlurFX fx = new EntityBlurFX(ep.field_70170_p, dd.xCoord, dd.yCoord, dd.zCoord).setScale(s).setColor(clr).setLife(l).setRapidExpand().freezeLife(a);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            }
        }
    }

    public void doFlareAggro(EntityPlayer ep) {
        AxisAlignedBB box = ReikaAABBHelper.getEntityCenteredAABB((Entity)ep, (double)96.0);
        List li = ep.field_70170_p.func_72872_a(EntityDimensionFlare.class, box);
        for (EntityDimensionFlare e : li) {
            e.aggroTo(ep);
        }
        box = ReikaAABBHelper.getEntityCenteredAABB((Entity)ep, (double)192.0);
        int n = 1 + ep.field_70170_p.field_73012_v.nextInt(12);
        for (int i = 0; i < n; ++i) {
            if (ep.field_70170_p.func_72872_a(EntityDimensionFlare.class, box).size() >= 12) continue;
            EntityDimensionFlare e = this.spawnFlare(ep.field_70170_p, ep, 64.0);
            e.aggroTo(ep);
        }
    }
}

