/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Generators;

import Reika.ChromatiCraft.Base.ChromaDimensionBiome;
import Reika.ChromatiCraft.Base.ChromaWorldGenerator;
import Reika.ChromatiCraft.Block.Dimension.BlockDimensionDeco;
import Reika.ChromatiCraft.Block.Worldgen.BlockStructureShield;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.World.Dimension.DimensionGenerators;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Libraries.MathSci.ReikaPhysicsHelper;
import Reika.DragonAPI.ModRegistry.ModOreList;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class WorldGenTerrainBlob
extends ChromaWorldGenerator {
    public WorldGenTerrainBlob(DimensionGenerators g, Random r, long s) {
        super(g, r, s);
    }

    @Override
    public float getGenerationChance(World world, int cx, int cz, ChromaDimensionBiome biome) {
        return 0.25f;
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        y = rand.nextInt(104);
        Blob b = new Blob(rand.nextDouble() * 360.0, 8.0 + rand.nextDouble() * 24.0, 2.0 + rand.nextDouble() * 6.0);
        b.curvePower = 1.75 + rand.nextDouble() * 1.25;
        b.hasDirtTop = rand.nextInt(4) > 0;
        switch (rand.nextInt(24)) {
            case 0: 
            case 1: 
            case 2: {
                b.innerBlock = new BlockKey(Blocks.field_150353_l);
                break;
            }
            case 3: {
                b.innerBlock = new BlockKey(Blocks.field_150343_Z);
                break;
            }
            case 4: {
                b.innerBlock = new BlockKey(ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.ordinal());
                break;
            }
            case 5: {
                b.outerBlock = new BlockKey(ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.ordinal());
                b.innerBlock = new BlockKey(ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.ordinal());
                break;
            }
            case 6: {
                b.innerBlock = new BlockKey(Blocks.field_150366_p);
                break;
            }
            case 7: {
                b.innerBlock = new BlockKey(Blocks.field_150450_ax);
                break;
            }
            case 8: {
                b.innerBlock = new BlockKey(Blocks.field_150369_x);
            }
        }
        switch (rand.nextInt(20)) {
            case 0: 
            case 6: {
                b.centerBlock = new BlockKey(Blocks.field_150482_ag);
            }
            case 1: 
            case 7: {
                b.centerBlock = new BlockKey(Blocks.field_150412_bA);
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: {
                b.centerBlock = new BlockKey(Blocks.field_150352_o);
                break;
            }
            case 4: {
                if (!ModOreList.PLATINUM.existsInGame()) break;
                b.centerBlock = new BlockKey(ModOreList.PLATINUM.getRandomOreBlock());
                break;
            }
            case 5: {
                if (!ModOreList.IRIDIUM.existsInGame()) break;
                b.centerBlock = new BlockKey(ModOreList.IRIDIUM.getRandomOreBlock());
                break;
            }
            case 10: {
                b.centerBlock = new BlockKey(ChromaBlocks.DIMGEN.getBlockInstance(), BlockDimensionDeco.DimDecoTypes.OCEANSTONE.ordinal());
                break;
            }
        }
        b.calculate(x, y, z, rand);
        b.generate(world, rand);
        return true;
    }

    private static class Blob {
        private BlockKey centerBlock = new BlockKey(Blocks.field_150348_b);
        private BlockKey innerBlock = new BlockKey(Blocks.field_150348_b);
        private BlockKey outerBlock = new BlockKey(Blocks.field_150348_b);
        private boolean hasDirtTop = false;
        private final double compassAngle;
        private final double length;
        private final double maxWidth;
        private double curvePower = 2.0;
        private final HashSet<Coordinate> coords = new HashSet();
        private final HashSet<Coordinate> centercoords = new HashSet();

        private Blob(double a, double l, double w) {
            this.compassAngle = a;
            this.length = l;
            this.maxWidth = w;
        }

        private void calculate(int x, int y, int z, Random rand) {
            double x1 = (double)x + 0.5;
            double y1 = (double)y + 0.5;
            double z1 = (double)z + 0.5;
            double[] dp = ReikaPhysicsHelper.polarToCartesian((double)this.length, (double)0.0, (double)this.compassAngle);
            double x2 = x1 + dp[0];
            double y2 = y1 + dp[1];
            double z2 = z1 + dp[2];
            for (double d = 0.0; d <= 1.0; d += 0.5 / this.length) {
                double dx = x1 + dp[0] * d;
                double dy = y1 + dp[1] * d;
                double dz = z1 + dp[2] * d;
                double r = this.maxWidth * Math.pow(0.25 + 3.0 * (0.5 - Math.abs(d - 0.5) / 2.0), 1.0);
                this.placeSphere(rand, dx, dy, dz, r);
            }
        }

        private void placeSphere(Random rand, double x, double y, double z, double r) {
            double pow = 1.75 + rand.nextDouble() * 2.25;
            for (double i = -r; i <= r; i += 0.5) {
                for (double j = -r; j <= r; j += 0.5) {
                    for (double k = -r; k <= r; k += 0.5) {
                        if (!(Math.pow(Math.abs(i), pow) + Math.pow(Math.abs(j), pow) + Math.pow(Math.abs(k), pow) <= Math.pow(Math.abs(r), pow))) continue;
                        Coordinate c = new Coordinate(x + i, y + j, z + k);
                        this.coords.add(c);
                        if (!(Math.abs(i) <= 1.0) || !(Math.abs(j) <= 1.0) || !(Math.abs(k) <= 1.0)) continue;
                        this.centercoords.add(c);
                    }
                }
            }
        }

        private void generate(World world, Random rand) {
            for (Coordinate c : this.coords) {
                if (!this.hasDirtTop || this.coords.contains(c.offset(0, 1, 0))) {
                    BlockKey bk = this.outerBlock;
                    if (this.centercoords.contains(c)) {
                        bk = this.centerBlock;
                    } else {
                        boolean flag = true;
                        for (int i = 0; i < 6; ++i) {
                            if (this.coords.contains(c.offset(ForgeDirection.VALID_DIRECTIONS[i], 1))) continue;
                            flag = false;
                            break;
                        }
                        if (flag) {
                            bk = this.innerBlock;
                        }
                    }
                    c.setBlock(world, bk.blockID, Math.max(0, bk.metadata));
                    continue;
                }
                Block b = c.offset(0, 1, 0).getBlock(world);
                c.setBlock(world, (Block)(b.isAir((IBlockAccess)world, c.xCoord, c.yCoord + 1, c.zCoord) ? Blocks.field_150349_c : Blocks.field_150346_d));
            }
        }
    }
}

