/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Generators;

import Reika.ChromatiCraft.Auxiliary.ChromaStacks;
import Reika.ChromatiCraft.Base.ChromaDimensionBiome;
import Reika.ChromatiCraft.Base.ChromaWorldGenerator;
import Reika.ChromatiCraft.Block.Worldgen.BlockLootChest;
import Reika.ChromatiCraft.Block.Worldgen.BlockStructureShield;
import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ItemMagicRegistry;
import Reika.ChromatiCraft.World.Dimension.DimensionGenerators;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class WorldGenMiniAltar
extends ChromaWorldGenerator {
    public WorldGenMiniAltar(DimensionGenerators g, Random rand, long seed) {
        super(g, rand, seed);
    }

    @Override
    public float getGenerationChance(World world, int cx, int cz, ChromaDimensionBiome biome) {
        return 0.025f;
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        if (this.canGenerate(world, x, --y, z)) {
            Block bk = ChromaBlocks.STRUCTSHIELD.getBlockInstance();
            int r = 3;
            for (int i = -r; i <= r; ++i) {
                for (int k = -r; k <= r; ++k) {
                    int m = i == 0 && k == 0 ? BlockStructureShield.BlockType.LIGHT.metadata % 8 : BlockStructureShield.BlockType.STONE.metadata % 8;
                    world.func_147465_d(x + i, y, z + k, bk, m, 3);
                }
            }
            this.generateArches(world, x, y, z, rand, bk);
            this.generateBurrow(world, x, y, z, rand, bk);
        }
        return false;
    }

    private void generateArches(World world, int x, int y, int z, Random rand, Block bk) {
        int t = 4;
        for (int h = 1; h <= t; ++h) {
            world.func_147465_d(x + 2, y + h, z + 2, bk, BlockStructureShield.BlockType.COBBLE.metadata % 8, 3);
            world.func_147465_d(x - 2, y + h, z + 2, bk, BlockStructureShield.BlockType.COBBLE.metadata % 8, 3);
            world.func_147465_d(x + 2, y + h, z - 2, bk, BlockStructureShield.BlockType.COBBLE.metadata % 8, 3);
            world.func_147465_d(x - 2, y + h, z - 2, bk, BlockStructureShield.BlockType.COBBLE.metadata % 8, 3);
        }
        for (int n = -1; n <= 1; ++n) {
            world.func_147465_d(x - 2, y + t, z + n, bk, BlockStructureShield.BlockType.COBBLE.metadata % 8, 3);
            world.func_147465_d(x + 2, y + t, z + n, bk, BlockStructureShield.BlockType.COBBLE.metadata % 8, 3);
            world.func_147465_d(x + n, y + t, z - 2, bk, BlockStructureShield.BlockType.COBBLE.metadata % 8, 3);
            world.func_147465_d(x + n, y + t, z + 2, bk, BlockStructureShield.BlockType.COBBLE.metadata % 8, 3);
            world.func_147465_d(x - 2, y, z + n, bk, BlockStructureShield.BlockType.COBBLE.metadata % 8, 3);
            world.func_147465_d(x + 2, y, z + n, bk, BlockStructureShield.BlockType.COBBLE.metadata % 8, 3);
            world.func_147465_d(x + n, y, z - 2, bk, BlockStructureShield.BlockType.COBBLE.metadata % 8, 3);
            world.func_147465_d(x + n, y, z + 2, bk, BlockStructureShield.BlockType.COBBLE.metadata % 8, 3);
        }
        for (int a = -1; a <= 1; ++a) {
            for (int b = -1; b <= 1; ++b) {
                world.func_147465_d(x + a, y + t, z + b, bk, BlockStructureShield.BlockType.GLASS.metadata % 8, 3);
            }
        }
        world.func_147465_d(x, y + t, z, bk, BlockStructureShield.BlockType.LIGHT.metadata % 8, 3);
        world.func_147465_d(x, y + t + 1, z, ChromaBlocks.LAMP.getBlockInstance(), rand.nextInt(16), 3);
    }

    private void generateBurrow(World world, int x, int y, int z, Random rand, Block bk) {
        int yc = 3;
        for (int d = 1; d <= yc + 1; ++d) {
            for (int a = -2; a <= 2; ++a) {
                for (int b = -2; b <= 2; ++b) {
                    boolean wall = Math.abs(a) == 2 || Math.abs(b) == 2 || d == yc + 1;
                    world.func_147465_d(x + a, y - d, z + b, wall ? bk : Blocks.field_150350_a, wall ? BlockStructureShield.BlockType.STONE.metadata % 8 : 0, 3);
                }
            }
        }
        this.generateChest(world, x, y, z, yc, rand);
    }

    private void generateChest(World world, int x, int y, int z, int yc, Random rand) {
        ItemStack is;
        world.func_147465_d(x, y - yc, z, ChromaBlocks.LOOTCHEST.getBlockInstance(), rand.nextInt(4), 3);
        BlockLootChest.TileEntityLootChest te = (BlockLootChest.TileEntityLootChest)world.func_147438_o(x, y - yc, z);
        int n = 4 + rand.nextInt(24);
        ArrayList<ItemStack> li = ItemMagicRegistry.instance.getAllRegisteredItems();
        for (int i = 0; i < n; ++i) {
            int idx = rand.nextInt(li.size());
            ItemStack in = li.get(idx);
            ElementTagCompound value = ItemMagicRegistry.instance.getItemValue(in);
            int max = Math.min(16, 24 / value.getMaximumValue());
            int num = Math.min(1 + rand.nextInt(max), in.func_77976_d());
            ItemStack is2 = ReikaItemHelper.getSizedItemStack((ItemStack)in, (int)num);
            int slot = rand.nextInt(te.func_70302_i_());
            while (te.func_70301_a(slot) != null) {
                slot = rand.nextInt(te.func_70302_i_());
            }
            te.func_70299_a(slot, is2);
        }
        BiomeGenBase b = world.func_72807_a(x, z);
        if (b instanceof ChromaDimensionBiome && (is = this.getRandomBiomeItem((ChromaDimensionBiome)b)) != null) {
            te.func_70299_a(rand.nextInt(te.func_70302_i_()), is);
        }
    }

    private ItemStack getRandomBiomeItem(ChromaDimensionBiome biome) {
        switch (biome.biomeType) {
            case FOREST: {
                return ChromaStacks.multiShard;
            }
            case ISLANDS: {
                return null;
            }
            case PLAINS: {
                return ChromaStacks.iridCrystal;
            }
            case SKYLANDS: {
                return null;
            }
        }
        return null;
    }

    private boolean canGenerate(World world, int x, int y, int z) {
        int r = 3;
        for (int i = -r; i <= 3; ++i) {
            for (int k = -r; k <= 3; ++k) {
                if (world.func_147439_a(x + i, y, z + k) == Blocks.field_150349_c && world.func_147439_a(x + i, y + 1, z + k) == Blocks.field_150350_a) continue;
                return false;
            }
        }
        return true;
    }
}

