/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Generators;

import Reika.ChromatiCraft.Base.ChromaDimensionBiome;
import Reika.ChromatiCraft.Base.ChromaWorldGenerator;
import Reika.ChromatiCraft.World.Dimension.DimensionGenerators;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Libraries.MathSci.ReikaPhysicsHelper;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class WorldGenIslandArch
extends ChromaWorldGenerator {
    public WorldGenIslandArch(DimensionGenerators g, Random r, long s) {
        super(g, r, s);
    }

    @Override
    public float getGenerationChance(World world, int cx, int cz, ChromaDimensionBiome biome) {
        return 0.02f;
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        y = 0;
        Block b = world.func_147439_a(x, y, z);
        while (b != Blocks.field_150355_j && b != Blocks.field_150350_a) {
            b = world.func_147439_a(x, ++y, z);
        }
        if (b == Blocks.field_150355_j) {
            Arch a = new Arch(x, y, z, rand.nextDouble() * 360.0, 30.0 + rand.nextDouble() * 60.0, 0.5 + rand.nextDouble(), 4 + rand.nextInt(17), rand.nextInt(4), 1.0 + rand.nextDouble() * 2.0);
            a.calculate(rand);
            a.generate(world, rand);
            return true;
        }
        return false;
    }

    private static class Arch {
        private final int posX1;
        private final int posY1;
        private final int posZ1;
        private final double initAngle;
        private final double compassAngle;
        private final double angleDelta;
        private final double radius;
        private final double radiusVariation;
        private final double stepDistance;
        private double angle;
        private double posX;
        private double posY;
        private double posZ;
        private final HashSet<Coordinate> coords = new HashSet();

        private Arch(int x, int y, int z, double ca, double ia, double da, double r, double rv, double d) {
            this.posX1 = x;
            this.posY1 = y;
            this.posZ1 = z;
            r = Math.max(r, d * 1.25);
            this.initAngle = ia;
            this.compassAngle = ca;
            this.angleDelta = da;
            this.radius = r;
            this.radiusVariation = rv;
            this.stepDistance = d;
        }

        private void calculate(Random rand) {
            this.angle = this.initAngle;
            this.posX = (double)this.posX1 + 0.5;
            this.posY = (double)this.posY1 + 0.5;
            this.posZ = (double)this.posZ1 + 0.5;
            do {
                this.placeBlob(rand);
                double[] d = ReikaPhysicsHelper.polarToCartesian((double)this.stepDistance, (double)this.angle, (double)this.compassAngle);
                this.posX += d[0];
                this.posY += d[1];
                this.posZ += d[2];
                this.angle -= this.angleDelta;
            } while (this.angle > -this.initAngle);
        }

        private void placeBlob(Random rand) {
            double pow = 1.75 + rand.nextDouble() * 2.25;
            double r = this.radius - this.radiusVariation / 2.0 + rand.nextDouble() * this.radiusVariation;
            for (double i = -r; i <= r; i += 0.5) {
                for (double j = -r; j <= r; j += 0.5) {
                    for (double k = -r; k <= r; k += 0.5) {
                        if (!(Math.pow(Math.abs(i), pow) + Math.pow(Math.abs(j), pow) + Math.pow(Math.abs(k), pow) <= Math.pow(Math.abs(r), pow))) continue;
                        this.coords.add(new Coordinate(this.posX + i, this.posY + j, this.posZ + k));
                    }
                }
            }
        }

        private void generate(World world, Random rand) {
            for (Coordinate c : this.coords) {
                if (!this.coords.contains(c.offset(0, 1, 0)) && !this.coords.contains(c.offset(0, -1, 0))) continue;
                if (this.coords.contains(c.offset(0, 1, 0))) {
                    c.setBlock(world, Blocks.field_150348_b);
                    continue;
                }
                c.setBlock(world, (Block)Blocks.field_150349_c);
            }
        }
    }
}

