/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Generators;

import Reika.ChromatiCraft.Base.ChromaDimensionBiome;
import Reika.ChromatiCraft.Base.ChromaWorldGenerator;
import Reika.ChromatiCraft.Block.Dimension.BlockDimensionDecoTile;
import Reika.ChromatiCraft.Block.Worldgen.BlockTieredOre;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.World.Dimension.DimensionGenerators;
import Reika.DragonAPI.Instantiable.Data.WeightedRandom;
import Reika.DragonAPI.Interfaces.Registry.OreType;
import Reika.DragonAPI.Libraries.Registry.ReikaOreHelper;
import Reika.DragonAPI.ModRegistry.ModOreList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenMinable;

public class WorldGenGlowingCracks
extends ChromaWorldGenerator {
    private final WeightedRandom<OreType> oreRand = new WeightedRandom();

    public WorldGenGlowingCracks(DimensionGenerators g, Random rand, long seed) {
        super(g, rand, seed);
        this.oreRand.addEntry((Object)ReikaOreHelper.EMERALD, 10.0);
        this.oreRand.addEntry((Object)ReikaOreHelper.DIAMOND, 20.0);
        this.oreRand.addEntry((Object)ReikaOreHelper.REDSTONE, 50.0);
        this.oreRand.addEntry((Object)ReikaOreHelper.GOLD, 40.0);
        if (ModOreList.SAPPHIRE.existsInGame()) {
            this.oreRand.addEntry((Object)ModOreList.SAPPHIRE, 30.0);
        }
        if (ModOreList.PLATINUM.existsInGame()) {
            this.oreRand.addEntry((Object)ModOreList.PLATINUM, 20.0);
        }
        if (ModOreList.AMETHYST.existsInGame()) {
            this.oreRand.addEntry((Object)ModOreList.AMETHYST, 30.0);
        }
        if (ModOreList.MANA.existsInGame()) {
            this.oreRand.addEntry((Object)ModOreList.MANA, 20.0);
        }
        if (ModOreList.MOONSTONE.existsInGame()) {
            this.oreRand.addEntry((Object)ModOreList.MOONSTONE, 10.0);
        }
        if (ModOreList.VINTEUM.existsInGame()) {
            this.oreRand.addEntry((Object)ModOreList.VINTEUM, 30.0);
        }
    }

    @Override
    public float getGenerationChance(World world, int cx, int cz, ChromaDimensionBiome biome) {
        return 0.25f;
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        int r = 4;
        for (int i = -r; i <= r; ++i) {
            for (int k = -r; k <= r; ++k) {
                if (world.func_147439_a(x + i, y - 1, z + k) == Blocks.field_150349_c) continue;
                return false;
            }
        }
        world.func_147465_d(x, y, z, ChromaBlocks.DIMGENTILE.getBlockInstance(), BlockDimensionDecoTile.DimDecoTileTypes.GLOWCRACKS.ordinal(), 3);
        if (rand.nextInt(2) == 0) {
            new WorldGenMinable(ChromaBlocks.TIEREDORE.getBlockInstance(), this.getRandomOre(rand), 32, Blocks.field_150348_b).func_76484_a(world, rand, x - 7, y - 4, z - 7);
        } else {
            this.oreRand.setSeed(rand.nextLong());
            OreType ore = (OreType)this.oreRand.getRandomEntry();
            ItemStack is = ore.getFirstOreBlock();
            new WorldGenMinable(Block.func_149634_a((Item)is.func_77973_b()), is.func_77960_j(), 32, Blocks.field_150348_b).func_76484_a(world, rand, x - 7, y - 4, z - 7);
        }
        return true;
    }

    private int getRandomOre(Random rand) {
        BlockTieredOre.TieredOres ore = BlockTieredOre.TieredOres.list[rand.nextInt(BlockTieredOre.TieredOres.list.length)];
        while (ore.genBlock != Blocks.field_150348_b) {
            ore = BlockTieredOre.TieredOres.list[rand.nextInt(BlockTieredOre.TieredOres.list.length)];
        }
        return ore.ordinal();
    }
}

