/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Generators;

import Reika.ChromatiCraft.Base.ChromaDimensionBiome;
import Reika.ChromatiCraft.Base.ChromaWorldGenerator;
import Reika.ChromatiCraft.Block.Dimension.BlockDimensionDeco;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.World.Dimension.DimensionGenerators;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class WorldGenGlassCliffs
extends ChromaWorldGenerator {
    public WorldGenGlassCliffs(DimensionGenerators g, Random r, long s) {
        super(g, r, s);
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        double ang = rand.nextDouble() * 360.0;
        double ang2 = ang + 90.0;
        double len = 16 + rand.nextInt(33);
        double h = 16 + rand.nextInt(17);
        double sp = 6.0 + rand.nextDouble() * 6.0;
        double o = 0.0;
        for (double d = -32.0; d <= 32.0; d += sp) {
            double dx = (double)x + d * Math.cos(Math.toRadians(ang2)) + o * Math.cos(Math.toRadians(ang));
            double dz = (double)z + d * Math.sin(Math.toRadians(ang2)) + o * Math.sin(Math.toRadians(ang));
            Coordinate loc = new Coordinate(dx, (double)y, dz);
            double f = 1.0 - 0.8 * Math.abs(d) / 32.0;
            double l2 = len * Math.pow(f, 0.75);
            double h2 = h * Math.pow(f, 0.5);
            Cliff c = new Cliff(loc, ang, l2, h2);
            c.calculate(rand);
            c.generate(world, rand);
            o += (-len / 2.0 + rand.nextDouble() * len) / 4.0;
        }
        return true;
    }

    @Override
    public float getGenerationChance(World world, int cx, int cz, ChromaDimensionBiome biome) {
        return 0.015f;
    }

    private static class Cliff {
        private final double length;
        private final double angle;
        private final double maxHeight;
        private final Coordinate origin;
        private final HashMap<Coordinate, Integer> heightMap = new HashMap();

        private Cliff(Coordinate c, double a, double l, double h) {
            this.origin = c;
            this.length = l;
            this.angle = a;
            this.maxHeight = h;
        }

        private void calculate(Random r) {
            for (double d = -this.length; d <= this.length; d += 0.25) {
                double x = (double)this.origin.xCoord + 0.5 + d * Math.cos(Math.toRadians(this.angle));
                double z = (double)this.origin.zCoord + 0.5 + d * Math.sin(Math.toRadians(this.angle));
                double h = this.maxHeight * Math.pow(1.0 - Math.abs(d) / this.length, 0.5);
                this.addHeightBlob(x, z, d, h);
            }
        }

        private void addHeightBlob(double x, double z, double d, double h) {
            double r = 0.0625 + 0.75 * Math.pow(0.75, Math.abs(d) / this.length);
            for (double i = -r; i <= r; i += Math.min(r / 2.0, 0.5)) {
                for (double k = -r; k <= r; k += Math.min(r / 2.0, 0.5)) {
                    if (!(i * i + k * k <= r * r)) continue;
                    Coordinate c = new Coordinate(x + i, 0.0, z + k);
                    Integer get = this.heightMap.get(c);
                    int ih = i == 0.0 && k == 0.0 ? (int)Math.round(h) : (int)h;
                    this.heightMap.put(c, Math.max(ih, get != null ? get : 0));
                }
            }
        }

        private void generate(World world, Random r) {
            for (Coordinate c : this.heightMap.keySet()) {
                int s;
                int h = this.heightMap.get(c);
                int x = c.xCoord;
                int z = c.zCoord;
                for (int i = s = world.func_72825_h(x, z) - this.origin.yCoord; i <= h; ++i) {
                    int dy = this.origin.yCoord + i;
                    Block b = ChromaBlocks.DIMGEN.getBlockInstance();
                    int m = BlockDimensionDeco.DimDecoTypes.CLIFFGLASS.ordinal();
                    if (i == h) {
                        b = Blocks.field_150349_c;
                        m = 0;
                    } else if (h - i < 3) {
                        b = Blocks.field_150348_b;
                        m = 0;
                    }
                    world.func_147465_d(x, dy, z, b, m, 3);
                }
            }
        }
    }
}

