/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Generators;

import Reika.ChromatiCraft.Base.ChromaDimensionBiome;
import Reika.ChromatiCraft.Base.ChromaWorldGenerator;
import Reika.ChromatiCraft.Block.Dimension.BlockDimensionDeco;
import Reika.ChromatiCraft.Block.Worldgen.BlockStructureShield;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.World.Dimension.ChromaDimensionManager;
import Reika.ChromatiCraft.World.Dimension.DimensionGenerators;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Interfaces.Block.SemiUnbreakable;
import Reika.DragonAPI.Libraries.ReikaDirectionHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class WorldGenFissure
extends ChromaWorldGenerator {
    public WorldGenFissure(DimensionGenerators g, Random rand, long seed) {
        super(g, rand, seed);
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        if (world.func_147439_a(x, y, z) == Blocks.field_150355_j) {
            return false;
        }
        if (world.func_147439_a(x, y + 1, z) == Blocks.field_150355_j) {
            return false;
        }
        int my = 8 + rand.nextInt(16);
        double w = rand.nextDouble();
        ArrayList<ForgeDirection> dirs = new ArrayList<ForgeDirection>();
        for (int i = 2; i < 6; ++i) {
            if (rand.nextInt(3) <= 0) continue;
            ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
            dirs.add(dir);
        }
        int color = rand.nextInt(16);
        HashMap<Coordinate, Integer> columns = new HashMap<Coordinate, Integer>();
        for (ForgeDirection dir : dirs) {
            int l = 12;
            ArrayList<ForgeDirection> li = new ArrayList<ForgeDirection>();
            li.add(dir);
            this.cut(rand, world, x, y, z, w, my, 0, l, li, columns, color);
        }
        for (Coordinate c : columns.keySet()) {
            int h;
            if (c.offset(0, (h = ((Integer)columns.get(c)).intValue()) - 1, 0).getBlock(world) != ChromaBlocks.STRUCTSHIELD.getBlockInstance()) continue;
            c.offset(0, h, 0).setBlock(world, ChromaBlocks.VOIDRIFT.getBlockInstance(), color, 3);
        }
        return true;
    }

    private void cut(Random rand, World world, int x, int y, int z, double w, int my, int dist, int len, ArrayList<ForgeDirection> follow, HashMap<Coordinate, Integer> columns, int color) {
        for (int dy = my; dy <= y + 12; ++dy) {
            int r = (int)(w * Math.sqrt(1.0 + (double)(dy - my) / 4.0));
            for (int i = -r; i <= r; ++i) {
                for (int k = -r; k <= r; ++k) {
                    int dx = x + i;
                    int dz = z + k;
                    if (!WorldGenFissure.canCutInto(world, dx, dy, dz)) continue;
                    world.func_147449_b(dx, dy, dz, Blocks.field_150350_a);
                    for (int d = 0; d < 6; ++d) {
                        ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[d];
                        int dx2 = dx + dir.offsetX;
                        int dy2 = dy + dir.offsetY;
                        int dz2 = dz + dir.offsetZ;
                        Block b = world.func_147439_a(dx2, dy2, dz2);
                        int m = world.func_72805_g(dx2, dy2, dz2);
                        if (b.func_149688_o() != Material.field_151576_e) continue;
                        if (!WorldGenFissure.canCutInto(world, dx2, dy2, dz2)) continue;
                        world.func_147465_d(dx2, dy2, dz2, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.CLOAK.ordinal(), 3);
                        Coordinate c = new Coordinate(dx2, 0, dz2);
                        Integer get = columns.get(c);
                        int h = get != null ? get : 0;
                        columns.put(c, Math.max(dy2 + 1, h));
                    }
                    int gy = my - 6;
                    for (int d = 0; d < 6; ++d) {
                        ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[d];
                        int dx2 = dx + dir.offsetX;
                        int dy2 = gy + dir.offsetY;
                        int dz2 = dz + dir.offsetZ;
                        if (!WorldGenFissure.canCutInto(world, dx2, dy2, dz2)) continue;
                        if (dir == ForgeDirection.UP) {
                            for (int h = 1; h < my; ++h) {
                                dy2 = gy + dir.offsetY * h;
                                if (!WorldGenFissure.canCutInto(world, dx2, dy2, dz2)) continue;
                                world.func_147465_d(dx2, dy2, dz2, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.CLOAK.ordinal(), 3);
                            }
                            continue;
                        }
                        if (world.func_147439_a(dx2, dy2, dz2) == ChromaBlocks.DIMGEN.getBlockInstance()) continue;
                        world.func_147465_d(dx2, dy2, dz2, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.CLOAK.metadata, 3);
                    }
                    world.func_147465_d(dx, gy, dz, ChromaBlocks.DIMGEN.getBlockInstance(), BlockDimensionDeco.DimDecoTypes.LIFEWATER.ordinal(), 3);
                }
            }
        }
        if (dist > 1 && rand.nextInt(2) == 0) {
            ForgeDirection dir = ReikaDirectionHelper.getLeftBy90((ForgeDirection)follow.get(follow.size() - 1));
            if (rand.nextBoolean()) {
                dir = dir.getOpposite();
            }
            follow.add(dir);
            this.cut(rand, world, x + dir.offsetX, y, z + dir.offsetZ, w, my, 0, len - 1, follow, columns, color);
            follow.remove(follow.size() - 1);
        }
        if (len > 0 && rand.nextInt(6 + len) > 0) {
            ForgeDirection dir = follow.get(rand.nextInt(follow.size()));
            this.cut(rand, world, x + dir.offsetX, y, z + dir.offsetZ, w, my, dist + 1, len - 1, follow, columns, color);
        }
    }

    public static boolean canCutInto(World world, int x, int y, int z) {
        int meta;
        Block b = world.func_147439_a(x, y, z);
        if (ChromaTiles.getTileFromIDandMetadata(b, meta = world.func_72805_g(x, y, z)) == ChromaTiles.DIMENSIONCORE) {
            return false;
        }
        if (b instanceof BlockStructureShield && meta >= 8) {
            return false;
        }
        if (b.func_149712_f(world, x, y, z) < 0.0f) {
            return false;
        }
        if (b instanceof SemiUnbreakable && ((SemiUnbreakable)b).isUnbreakable(world, x, y, z, meta)) {
            return false;
        }
        if (b == ChromaBlocks.RUNE.getBlockInstance()) {
            return false;
        }
        ChromaBlocks cb = ChromaBlocks.getEntryByID(b);
        return cb == null || !cb.isDimensionStructureBlock();
    }

    @Override
    public float getGenerationChance(World world, int cx, int cz, ChromaDimensionBiome biome) {
        return biome.getExactType() == ChromaDimensionManager.Biomes.PLAINS ? 0.05f : 0.01f;
    }
}

