/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Generators;

import Reika.ChromatiCraft.Base.ChromaDimensionBiome;
import Reika.ChromatiCraft.Base.ChromaWorldGenerator;
import Reika.ChromatiCraft.Block.Dimension.BlockDimensionDeco;
import Reika.ChromatiCraft.Block.Worldgen.BlockStructureShield;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.World.Dimension.DimensionGenerators;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.FilledBlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.WeightedRandom;
import Reika.DragonAPI.Instantiable.RevolvedPattern;
import Reika.DragonAPI.Interfaces.BlockCheck;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.ReikaDirectionHelper;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class WorldGenCrystalTree
extends ChromaWorldGenerator {
    private static final ArrayList<CrystalTree>[] crystalTrees;
    private static final int[][] treeHeights;
    private static final WeightedRandom<Integer> sizeRand;
    public static final BlockKey CRYSTAL_TRUNK;

    public WorldGenCrystalTree(DimensionGenerators g, Random rand, long seed) {
        super(g, rand, seed);
    }

    @Override
    public float getGenerationChance(World world, int cx, int cz, ChromaDimensionBiome biome) {
        return 0.5f;
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        int size = (Integer)sizeRand.getRandomEntry();
        ArrayList<CrystalTree> li = crystalTrees[size];
        FilledBlockArray tree = new FilledBlockArray(world);
        CrystalTree c = li.get(rand.nextInt(li.size()));
        c.populate(tree);
        tree.offset(x, y, z);
        if (this.checkSpace(world, x, y, z, tree)) {
            int[] hs = treeHeights[size];
            int h = ReikaRandomHelper.getRandomBetween((int)hs[0], (int)hs[1]);
            tree.offset(0, h, 0);
            for (int i = 0; i < h; ++i) {
                int n = c.trunkWidth;
                world.func_147465_d(x, y + i, z, WorldGenCrystalTree.CRYSTAL_TRUNK.blockID, WorldGenCrystalTree.CRYSTAL_TRUNK.metadata, 3);
                for (int a = 0; a < n; ++a) {
                    for (int b = 0; b < n; ++b) {
                        world.func_147465_d(x - a, y + i, z - b, WorldGenCrystalTree.CRYSTAL_TRUNK.blockID, WorldGenCrystalTree.CRYSTAL_TRUNK.metadata, 3);
                    }
                }
            }
            tree.place();
            return true;
        }
        return false;
    }

    private boolean checkSpace(World world, int x, int y, int z, FilledBlockArray tree) {
        for (Coordinate c : tree.keySet()) {
            Block b = tree.getBlockAt(c.xCoord, c.yCoord, c.zCoord);
            int meta = tree.getMetaAt(c.xCoord, c.yCoord, c.zCoord);
            boolean needsAir = false;
            if (b != ChromaBlocks.DIMGEN.getBlockInstance() || meta != BlockDimensionDeco.DimDecoTypes.CRYSTALLEAF.ordinal()) {
                needsAir = true;
            }
            Block at = world.func_147439_a(c.xCoord, c.yCoord, c.zCoord);
            boolean flag = needsAir ? at.isAir((IBlockAccess)world, c.xCoord, c.yCoord, c.zCoord) : at.canBeReplacedByLeaves((IBlockAccess)world, c.xCoord, c.yCoord, c.zCoord);
            if (flag) continue;
            return false;
        }
        return true;
    }

    static {
        int i;
        crystalTrees = new ArrayList[4];
        treeHeights = new int[][]{{2, 5}, {3, 7}, {4, 10}, {12, 30}};
        sizeRand = new WeightedRandom();
        CRYSTAL_TRUNK = new BlockKey(ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.ordinal());
        for (i = 0; i < crystalTrees.length; ++i) {
            WorldGenCrystalTree.crystalTrees[i] = new ArrayList();
        }
        sizeRand.addEntry((Object)0, 10.0);
        sizeRand.addEntry((Object)1, 7.0);
        sizeRand.addEntry((Object)2, 4.0);
        sizeRand.addEntry((Object)3, 1.0);
        for (i = 0; i < CrystalTree.list.length; ++i) {
            CrystalTree tree = CrystalTree.list[i];
            if (tree == CrystalTree.XMAS) continue;
            tree.register();
        }
    }

    private static enum CrystalTree {
        VANILLA(0, 1),
        DYE(1, 1),
        CLIPPED(0, 1),
        ARCH(0, 1),
        UMBRELLA(1, 1),
        GROVE(0, 1),
        GROVE2(0, 1),
        RINGS(1, 1),
        BOWL(1, 1),
        WAVE(2, 2),
        FIR(2, 1),
        XMAS(3, 2),
        CANOPY(3, 2);

        public final int treeSize;
        public final int trunkWidth;
        private static final CrystalTree[] list;

        private CrystalTree(int s, int w) {
            this.treeSize = s;
            this.trunkWidth = w;
        }

        private void register() {
            crystalTrees[this.treeSize].add(this);
        }

        private void populate(FilledBlockArray f) {
            BlockKey t = CRYSTAL_TRUNK;
            BlockKey l = new BlockKey(ChromaBlocks.DIMGEN.getBlockInstance(), BlockDimensionDeco.DimDecoTypes.CRYSTALLEAF.ordinal());
            switch (this) {
                case VANILLA: 
                case CLIPPED: 
                case ARCH: {
                    for (int i = 0; i <= 2; ++i) {
                        int r = i == 2 ? 1 : 2;
                        for (int a = -r; a <= r; ++a) {
                            for (int b = -r; b <= r; ++b) {
                                if (this != VANILLA && (this != ARCH || i != 0) && Math.abs(a) == 2 && Math.abs(b) == 2 || this == ARCH && i != 2 && (a != 0 || b != 0) && Math.abs(a) <= 1 && Math.abs(b) <= 1) continue;
                                if (a != 0 || b != 0) {
                                    f.setBlock(a, i, b, (BlockCheck)l);
                                    continue;
                                }
                                f.setBlock(a, i, b, (BlockCheck)t);
                            }
                        }
                    }
                    f.setBlock(0, 3, 0, (BlockCheck)l);
                    f.setBlock(1, 3, 0, (BlockCheck)l);
                    f.setBlock(-1, 3, 0, (BlockCheck)l);
                    f.setBlock(0, 3, 1, (BlockCheck)l);
                    f.setBlock(0, 3, -1, (BlockCheck)l);
                    break;
                }
                case DYE: {
                    int[] r = new int[]{1, 2, 1, 2, 1, 2, 1};
                    for (int i = 0; i < r.length; ++i) {
                        for (int a = -r[i]; a <= r[i]; ++a) {
                            for (int b = -r[i]; b <= r[i]; ++b) {
                                if (a != 0 || b != 0) {
                                    f.setBlock(a, i, b, (BlockCheck)l);
                                    continue;
                                }
                                f.setBlock(a, i, b, (BlockCheck)t);
                            }
                        }
                    }
                    f.setBlock(0, r.length, 0, (BlockCheck)l);
                    f.setBlock(1, r.length, 0, (BlockCheck)l);
                    f.setBlock(-1, r.length, 0, (BlockCheck)l);
                    f.setBlock(0, r.length, 1, (BlockCheck)l);
                    f.setBlock(0, r.length, -1, (BlockCheck)l);
                    break;
                }
                case UMBRELLA: {
                    int b;
                    int a;
                    int h;
                    for (h = 0; h <= 1; ++h) {
                        f.setBlock(-4, h, -1, (BlockCheck)l);
                        f.setBlock(-4, h, 0, (BlockCheck)l);
                        f.setBlock(-4, h, 1, (BlockCheck)l);
                        f.setBlock(-3, h, -3, (BlockCheck)l);
                        f.setBlock(-3, h, -2, (BlockCheck)l);
                        f.setBlock(-3, h, 2, (BlockCheck)l);
                        f.setBlock(-3, h, 3, (BlockCheck)l);
                        if (h == 1) {
                            f.setBlock(-3, h, -1, (BlockCheck)l);
                            f.setBlock(-3, h, 0, (BlockCheck)l);
                            f.setBlock(-3, h, 1, (BlockCheck)l);
                        }
                        for (int i = 2; i <= 6; ++i) {
                            int o = i > 2 && i < 6 ? 0 : 1;
                            f.setBlock(i - 4, h, -4 + o, (BlockCheck)l);
                            f.setBlock(i - 4, h, 4 - o, (BlockCheck)l);
                            if (h != 1) continue;
                            f.setBlock(i - 4, h, -3 + o, (BlockCheck)l);
                            f.setBlock(i - 4, h, 3 - o, (BlockCheck)l);
                        }
                        f.setBlock(3, h, -3, (BlockCheck)l);
                        f.setBlock(3, h, -2, (BlockCheck)l);
                        f.setBlock(3, h, 2, (BlockCheck)l);
                        f.setBlock(3, h, 3, (BlockCheck)l);
                        if (h == 1) {
                            f.setBlock(3, h, -1, (BlockCheck)l);
                            f.setBlock(3, h, 0, (BlockCheck)l);
                            f.setBlock(3, h, 1, (BlockCheck)l);
                        }
                        f.setBlock(4, h, -1, (BlockCheck)l);
                        f.setBlock(4, h, 0, (BlockCheck)l);
                        f.setBlock(4, h, 1, (BlockCheck)l);
                    }
                    for (a = -3; a <= 3; ++a) {
                        for (b = -3; b <= 3; ++b) {
                            if (Math.abs(a) + Math.abs(b) > 4) continue;
                            f.setBlock(a, 2, b, (BlockCheck)l);
                        }
                    }
                    for (a = -1; a <= 1; ++a) {
                        for (b = -1; b <= 1; ++b) {
                            f.setBlock(a, 3, b, (BlockCheck)l);
                        }
                    }
                    for (h = 0; h < 3; ++h) {
                        f.setBlock(0, h, 0, (BlockCheck)t);
                    }
                    break;
                }
                case GROVE: 
                case GROVE2: {
                    int[] r = new int[]{1, 2, 2, 2, 2, 1};
                    if (this == GROVE2) {
                        r = new int[]{1, 2, 2, 2, 1};
                    }
                    for (int h = 0; h < r.length; ++h) {
                        for (int a = -2; a <= 2; ++a) {
                            for (int b = -2; b <= 2; ++b) {
                                if (Math.abs(a) + Math.abs(b) > r[h] || this != GROVE && h == 1 && Math.abs(a) > 1 && Math.abs(b) > 1) continue;
                                if (a != 0 || b != 0) {
                                    f.setBlock(a, h, b, (BlockCheck)l);
                                    continue;
                                }
                                f.setBlock(a, h, b, (BlockCheck)t);
                            }
                        }
                    }
                    f.setBlock(0, r.length, 0, (BlockCheck)l);
                    break;
                }
                case RINGS: {
                    int b;
                    int a;
                    int b2;
                    int a2;
                    int h;
                    for (h = 0; h <= 1; ++h) {
                        for (a2 = -2; a2 <= 2; ++a2) {
                            for (b2 = -2; b2 <= 2; ++b2) {
                                if (Math.abs(a2) + Math.abs(b2) > h + 1) continue;
                                if (a2 != 0 || b2 != 0) {
                                    f.setBlock(a2, h, b2, (BlockCheck)l);
                                    continue;
                                }
                                f.setBlock(a2, h, b2, (BlockCheck)t);
                            }
                        }
                    }
                    for (h = 2; h <= 6; ++h) {
                        if (h % 2 == 0) {
                            for (a2 = -3; a2 <= 3; ++a2) {
                                for (b2 = -3; b2 <= 3; ++b2) {
                                    if (Math.abs(a2) >= 3 && Math.abs(b2) >= 3) continue;
                                    if (a2 != 0 || b2 != 0) {
                                        f.setBlock(a2, h, b2, (BlockCheck)l);
                                        continue;
                                    }
                                    f.setBlock(a2, h, b2, (BlockCheck)t);
                                }
                            }
                            f.setBlock(-4, h, 0, (BlockCheck)l);
                            f.setBlock(4, h, 0, (BlockCheck)l);
                            f.setBlock(0, h, 4, (BlockCheck)l);
                            f.setBlock(0, h, -4, (BlockCheck)l);
                            continue;
                        }
                        for (a2 = -3; a2 <= 3; ++a2) {
                            for (b2 = -3; b2 <= 3; ++b2) {
                                if (Math.abs(a2) + Math.abs(b2) > 3) continue;
                                if (a2 != 0 || b2 != 0) {
                                    f.setBlock(a2, h, b2, (BlockCheck)l);
                                    continue;
                                }
                                f.setBlock(a2, h, b2, (BlockCheck)t);
                            }
                        }
                    }
                    for (a = -2; a <= 2; ++a) {
                        for (b = -2; b <= 2; ++b) {
                            if (Math.abs(a) >= 2 && Math.abs(b) >= 2) continue;
                            if (a != 0 || b != 0) {
                                f.setBlock(a, 7, b, (BlockCheck)l);
                                continue;
                            }
                            f.setBlock(a, 7, b, (BlockCheck)t);
                        }
                    }
                    for (a = -1; a <= 1; ++a) {
                        for (b = -1; b <= 1; ++b) {
                            f.setBlock(a, 8, b, (BlockCheck)l);
                        }
                    }
                    break;
                }
                case BOWL: {
                    BlockKey[][] slice = new BlockKey[][]{{null, null, l, l, l, null, null}, {null, l, null, null, null, l, null}, {l, null, null, null, null, null, l}, {l, null, null, t, null, null, l}, {l, null, null, null, null, null, l}, {null, l, null, null, null, l, null}, {null, null, l, l, l, null, null}};
                    for (int h = 0; h <= 2; ++h) {
                        for (int a = 0; a < slice.length; ++a) {
                            for (int b = 0; b < slice.length; ++b) {
                                BlockKey bk = slice[a][b];
                                if (bk == null) continue;
                                int dx = a - 3;
                                int dz = b - 3;
                                f.setBlock(dx, h, dz, bk.blockID, bk.metadata);
                            }
                        }
                    }
                    for (int a = -2; a <= 2; ++a) {
                        for (int b = -2; b <= 2; ++b) {
                            if (Math.abs(a) >= 2 && Math.abs(b) >= 2) continue;
                            if (a != 0 || b != 0) {
                                f.setBlock(a, 3, b, (BlockCheck)l);
                                continue;
                            }
                            f.setBlock(a, 3, b, (BlockCheck)t);
                        }
                    }
                    f.setBlock(0, 4, 0, (BlockCheck)l);
                    f.setBlock(1, 4, 0, (BlockCheck)l);
                    f.setBlock(-1, 4, 0, (BlockCheck)l);
                    f.setBlock(0, 4, 1, (BlockCheck)l);
                    f.setBlock(0, 4, -1, (BlockCheck)l);
                    f.setBlock(1, 2, 2, (BlockCheck)l);
                    f.setBlock(1, 2, -2, (BlockCheck)l);
                    f.setBlock(-1, 2, 2, (BlockCheck)l);
                    f.setBlock(-1, 2, -2, (BlockCheck)l);
                    f.setBlock(2, 2, 1, (BlockCheck)l);
                    f.setBlock(-2, 2, 1, (BlockCheck)l);
                    f.setBlock(2, 2, -1, (BlockCheck)l);
                    f.setBlock(-2, 2, -1, (BlockCheck)l);
                    break;
                }
                case WAVE: {
                    RevolvedPattern p = new RevolvedPattern(f.world, this.trunkWidth, 13, 5);
                    for (int i = 0; i < 12; ++i) {
                        p.addBlock(i < 11 ? t : l, i, 0, 0);
                    }
                    int[][] r = new int[][]{{4, 4, 4, 3, 1}, {5, 5, 5, 4, 3, 1}, {4, 4, 4, 3, 1}, {2, 3, 2}, {2, 2, 1}, {4, 4, 4, 3, 1}, {5, 5, 5, 4, 3}, {4, 4, 4, 3, 1}, {3, 3, 3, 1}, {2, 2, 1}, {2, 1}, {1}};
                    for (int h = 0; h < r.length; ++h) {
                        int[] dr = r[h];
                        for (int d = 0; d < dr.length; ++d) {
                            int b = d == 0 ? 1 : 0;
                            int m = b + dr[d];
                            for (int a = b; a < m; ++a) {
                                p.addBlock(l, h, a, d);
                            }
                        }
                    }
                    p.calculate();
                    p.populate(f);
                    break;
                }
                case FIR: {
                    int[] d = new int[]{3, 2, 2, 4, 5, 4, 2, 3, 2, 1};
                    int[] r = new int[]{3, 2, 2, 3, 4, 3, 2, 3, 2, 1};
                    for (int h = 0; h < d.length; ++h) {
                        int dr = r[h];
                        for (int a = -dr; a <= dr; ++a) {
                            for (int b = -dr; b <= dr; ++b) {
                                if (Math.abs(a) + Math.abs(b) > d[h]) continue;
                                if (a != 0 || b != 0) {
                                    f.setBlock(a, h, b, (BlockCheck)l);
                                    continue;
                                }
                                f.setBlock(a, h, b, (BlockCheck)t);
                            }
                        }
                    }
                    f.setBlock(0, d.length, 0, (BlockCheck)l);
                    for (int i = 2; i < 6; ++i) {
                        int dd;
                        ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
                        ForgeDirection dir2 = ReikaDirectionHelper.getLeftBy90((ForgeDirection)dir);
                        for (dd = 0; dd < 2; ++dd) {
                            f.setBlock(dd * dir.offsetX, 0, dd * dir.offsetZ, (BlockCheck)t);
                            f.setBlock(dd * dir.offsetX, 8, dd * dir.offsetZ, (BlockCheck)t);
                        }
                        for (dd = 0; dd < 3; ++dd) {
                            f.setBlock(dd * dir.offsetX, 4, dd * dir.offsetZ, (BlockCheck)t);
                        }
                        f.setBlock(3 * dir.offsetX + dir2.offsetX, 4, 3 * dir.offsetZ + dir2.offsetZ, (BlockCheck)t);
                        f.setBlock(3 * dir.offsetX - dir2.offsetX, 4, 3 * dir.offsetZ - dir2.offsetZ, (BlockCheck)t);
                    }
                    break;
                }
                case XMAS: {
                    RevolvedPattern p = new RevolvedPattern(f.world, this.trunkWidth, 19, 5);
                    for (int i = 0; i < 19; ++i) {
                        p.addBlock(t, i, 0, 0);
                    }
                    int[][] r = new int[][]{};
                    for (int h = 0; h < r.length; ++h) {
                        int[] dr = r[h];
                        for (int d = 0; d < dr.length; ++d) {
                            int b = d == 0 ? 1 : 0;
                            int m = b + dr[d];
                            for (int a = b; a < m; ++a) {
                                p.addBlock(l, h, a, d);
                            }
                        }
                    }
                    p.calculate();
                    p.populate(f);
                    break;
                }
                case CANOPY: {
                    RevolvedPattern p = new RevolvedPattern(f.world, this.trunkWidth, 7, 7);
                    for (int i = 0; i < 7; ++i) {
                        p.addBlock(i < 6 ? t : l, i, 0, 0);
                    }
                    int[][] r = new int[][]{{5, 5, 5, 4, 3, 1}, {5, 6, 6, 5, 4, 3}, {5, 5, 5, 4, 3, 1}, {4, 5, 4, 3, 2}, {3, 4, 3, 2}, {2, 3, 2}, {1, 1}};
                    for (int h = 0; h < r.length; ++h) {
                        int[] dr = r[h];
                        for (int d = 0; d < dr.length; ++d) {
                            int b = d == 0 ? 1 : 0;
                            int m = b + dr[d];
                            for (int a = b; a < m; ++a) {
                                p.addBlock(l, h, a, d);
                            }
                        }
                    }
                    p.calculate();
                    p.populate(f);
                    break;
                }
            }
        }

        static {
            list = CrystalTree.values();
        }
    }
}

