/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Generators;

import Reika.ChromatiCraft.Base.ChromaDimensionBiome;
import Reika.ChromatiCraft.Base.ChromaWorldGenerator;
import Reika.ChromatiCraft.World.Dimension.DimensionGenerators;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.WeightedRandom;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.ModList;
import Reika.MeteorCraft.MeteorGenerator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class WorldGenChromaMeteor
extends ChromaWorldGenerator {
    private static final WeightedRandom<BlockKey> basicOres = new WeightedRandom();

    public WorldGenChromaMeteor(DimensionGenerators g, Random rand, long seed) {
        super(g, rand, seed);
    }

    @Override
    public float getGenerationChance(World world, int cx, int cz, ChromaDimensionBiome biome) {
        return 0.002f;
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        Block b;
        if (!this.canGenerateOn(b = world.func_147439_a(x, --y, z))) {
            return false;
        }
        int d = 1 + rand.nextInt(4);
        y -= d;
        int r = 3 + rand.nextInt(rand.nextBoolean() ? 5 : 4);
        double e = rand.nextDouble() * 0.5;
        int ra = (int)((double)r * (1.0 - e));
        double ang = rand.nextDouble() * 360.0;
        if (r > 4 && rand.nextInt(12) == 0) {
            this.generateCrater(world, x, y, z, rand, r);
        } else {
            this.generateTrack(world, x, y, z, rand, r, ra, ang);
        }
        this.generateMeteor(world, x, y, z, rand, r, ra);
        return true;
    }

    private boolean canGenerateOn(Block b) {
        return b == Blocks.field_150349_c || b == Blocks.field_150348_b || b == Blocks.field_150354_m;
    }

    private void generateMeteor(World world, int x, int y, int z, Random rand, int r, int ra) {
        for (int i = -r; i <= r; ++i) {
            for (int k = -r; k <= r; ++k) {
                for (int h = -ra; h <= ra; ++h) {
                    if (!ReikaMathLibrary.isPointInsideEllipse((double)i, (double)h, (double)k, (double)r, (double)ra, (double)r)) continue;
                    BlockKey bk = this.getMeteorBlock();
                    int dx = x + i;
                    int dy = y + h - 3;
                    int dz = z + k;
                    world.func_147465_d(dx, dy, dz, bk.blockID, bk.metadata, 3);
                }
            }
        }
    }

    private BlockKey getMeteorBlock() {
        return ModList.METEORCRAFT.isLoaded() ? new BlockKey(MeteorGenerator.instance.getBlock(MeteorGenerator.MeteorType.STONE, true)) : (BlockKey)basicOres.getRandomEntry();
    }

    private void generateTrack(World world, int x, int y, int z, Random rand, int r, int ra, double ang) {
        int rc = (int)((double)r * (1.125 + rand.nextDouble() * 0.125));
        double f = ReikaRandomHelper.getRandomPlusMinus((double)4.0, (double)2.0);
        for (int o = 0; o < 18; ++o) {
            int ox = MathHelper.func_76128_c((double)((double)x + (double)o * Math.sin(Math.toRadians(ang))));
            int oz = MathHelper.func_76128_c((double)((double)z + (double)o * Math.cos(Math.toRadians(ang))));
            int oy = MathHelper.func_76128_c((double)((double)y + (double)o / f));
            for (int i = -r; i <= r; ++i) {
                for (int k = -r; k <= r; ++k) {
                    for (int h = -ra; h <= ra; ++h) {
                        if (!ReikaMathLibrary.isPointInsideEllipse((double)i, (double)h, (double)k, (double)rc, (double)ra, (double)rc)) continue;
                        int dx = ox + i;
                        int dy = oy + h;
                        int dz = oz + k;
                        world.func_147449_b(dx, dy, dz, Blocks.field_150350_a);
                        Block b = world.func_147439_a(dx, dy - 1, dz);
                        Block b2 = b == Blocks.field_150348_b ? (rand.nextInt(40) == 0 ? Blocks.field_150343_Z : Blocks.field_150347_e) : (b == Blocks.field_150346_d || b == Blocks.field_150349_c ? Blocks.field_150346_d : Blocks.field_150351_n);
                    }
                }
            }
        }
    }

    private void generateCrater(World world, int x, int y, int z, Random rand, int r) {
        int rc = (int)((double)r * (1.0 + rand.nextDouble() * 2.0));
        int ra = (int)((double)rc * 0.5);
        y += ra / 2;
        for (int i = -rc; i <= rc; ++i) {
            for (int k = -rc; k <= rc; ++k) {
                for (int h = ra; h >= -ra; --h) {
                    int dx = x + i;
                    int dy = y + h;
                    int dz = z + k;
                    if (!ReikaMathLibrary.isPointInsideEllipse((double)i, (double)h, (double)k, (double)rc, (double)ra, (double)rc)) continue;
                    world.func_147449_b(dx, dy, dz, Blocks.field_150350_a);
                    Block b = world.func_147439_a(dx, dy - 1, dz);
                    Block b2 = b == Blocks.field_150348_b ? (rand.nextInt(40) == 0 ? Blocks.field_150343_Z : Blocks.field_150347_e) : (b == Blocks.field_150346_d || b == Blocks.field_150349_c ? Blocks.field_150346_d : Blocks.field_150351_n);
                }
            }
        }
        for (double a = 0.0; a < 360.0; a += 1.0) {
            int t = 3 + rand.nextInt(5);
            for (int hy = -3; hy <= t; ++hy) {
                int cx = MathHelper.func_76128_c((double)((double)x + (double)(rc + hy) * Math.cos(Math.toRadians(a))));
                int cz = MathHelper.func_76128_c((double)((double)z + (double)(rc + hy) * Math.sin(Math.toRadians(a))));
                int cy = y + hy - 3;
                for (int h = 0; h < 16; ++h) {
                    Block b = world.func_147439_a(cx, cy + h, cz);
                    if (b.isAir((IBlockAccess)world, cx, cy + h, cz)) continue;
                    world.func_147449_b(cx, cy + h, cz, h == 0 ? (rand.nextInt(18) == 0 ? Blocks.field_150371_ca : Blocks.field_150348_b) : Blocks.field_150350_a);
                }
            }
        }
        int n = 8 + rand.nextInt(24);
        for (int i = 0; i < n; ++i) {
            double a = rand.nextDouble() * 360.0;
            double dmin = (double)(rc + 4) + rand.nextDouble();
            double dmax = (double)(rc + 12) + rand.nextDouble() * 8.0;
            for (double d = dmin; d <= dmax; d += 1.0) {
                double da = Math.toRadians(ReikaRandomHelper.getRandomPlusMinus((double)a, (double)5.0));
                int dx = MathHelper.func_76128_c((double)((double)x + d * Math.cos(da)));
                int dz = MathHelper.func_76128_c((double)((double)z + d * Math.sin(da)));
                int dy = world.func_72825_h(dx, dz);
                BlockKey bk = this.getMeteorBlock();
                world.func_147465_d(dx, dy, dz, bk.blockID, bk.metadata, 3);
            }
        }
    }

    static {
        basicOres.addEntry((Object)new BlockKey(Blocks.field_150348_b), 50.0);
        basicOres.addEntry((Object)new BlockKey(Blocks.field_150365_q), 20.0);
        basicOres.addEntry((Object)new BlockKey(Blocks.field_150366_p), 12.0);
        basicOres.addEntry((Object)new BlockKey(Blocks.field_150450_ax), 10.0);
        basicOres.addEntry((Object)new BlockKey(Blocks.field_150482_ag), 4.0);
        basicOres.addEntry((Object)new BlockKey(Blocks.field_150412_bA), 2.0);
        basicOres.addEntry((Object)new BlockKey(Blocks.field_150369_x), 6.0);
        basicOres.addEntry((Object)new BlockKey(Blocks.field_150352_o), 8.0);
    }
}

