/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension.Generators;

import Reika.ChromatiCraft.Base.ChromaDimensionBiome;
import Reika.ChromatiCraft.Base.ChromaWorldGenerator;
import Reika.ChromatiCraft.Entity.EntityAurora;
import Reika.ChromatiCraft.World.Dimension.DimensionGenerators;
import Reika.DragonAPI.Instantiable.Data.Maps.PairMap;
import Reika.DragonAPI.Instantiable.Data.WeightedRandom;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;

public class WorldGenAurorae
extends ChromaWorldGenerator {
    private static final WeightedRandom<AuroraColor> auroraColors = new WeightedRandom();
    private static final PairMap<AuroraColor> disallowedCombinations = new PairMap();

    public WorldGenAurorae(DimensionGenerators g, Random rand, long seed) {
        super(g, rand, seed);
    }

    @Override
    public float getGenerationChance(World world, int cx, int cz, ChromaDimensionBiome biome) {
        return 0.0078125f;
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        double ang = Math.toRadians(rand.nextDouble() * 360.0);
        double sep = 8.0 + rand.nextDouble() * 24.0;
        double len = 60.0 + rand.nextDouble() * 120.0;
        double dx = sep * Math.cos(ang + Math.toRadians(90.0));
        double dz = sep * Math.sin(ang + Math.toRadians(90.0));
        AuroraColor c1 = (AuroraColor)((Object)auroraColors.getRandomEntry());
        AuroraColor c2 = (AuroraColor)((Object)auroraColors.getRandomEntry());
        while (disallowedCombinations.contains((Object)c1, (Object)c2)) {
            c2 = (AuroraColor)((Object)auroraColors.getRandomEntry());
        }
        int num = 1 + rand.nextInt(12);
        for (int i = 0; i < num; ++i) {
            double x1 = (double)x + 0.5 + len / 2.0 * Math.cos(ang) + dx * ((double)i - (double)num / 2.0);
            double z1 = (double)z + 0.5 + len / 2.0 * Math.sin(ang) + dz * ((double)i - (double)num / 2.0);
            double x2 = (double)x + 0.5 - len / 2.0 * Math.cos(ang) + dx * ((double)i - (double)num / 2.0);
            double z2 = (double)z + 0.5 - len / 2.0 * Math.sin(ang) + dz * ((double)i - (double)num / 2.0);
            double y1 = Math.max((double)(ReikaWorldHelper.getTopSolidOrLiquidBlockForDouble((World)world, (double)x1, (double)z1) + 40), 120.0 + rand.nextDouble() * 100.0);
            double y2 = Math.max((double)(ReikaWorldHelper.getTopSolidOrLiquidBlockForDouble((World)world, (double)x2, (double)z2) + 40), 120.0 + rand.nextDouble() * 100.0);
            double ymax = Math.max(y1, y2);
            y1 = ymax + rand.nextDouble() * 20.0 - 10.0;
            y2 = ymax + rand.nextDouble() * 20.0 - 10.0;
            double speed = 0.125 + rand.nextDouble() * 2.375;
            EntityAurora.AuroraData dat = new EntityAurora.AuroraData(x1, y1, z1, x2, y2, z2, c1.color, c2.color, speed);
            EntityAurora e = new EntityAurora(world, dat);
            world.func_72838_d((Entity)e);
        }
        return true;
    }

    static {
        for (int i = 0; i < AuroraColor.list.length; ++i) {
            AuroraColor a = AuroraColor.list[i];
            auroraColors.addEntry((Object)a, a.weight);
        }
        disallowedCombinations.add((Object)AuroraColor.ARGON, (Object)AuroraColor.PINK);
        disallowedCombinations.add((Object)AuroraColor.APPLE, (Object)AuroraColor.PINK);
        disallowedCombinations.add((Object)AuroraColor.GREEN, (Object)AuroraColor.PINK);
    }

    private static enum AuroraColor {
        RED(0xFF0000, 100.0),
        GREEN(65280, 100.0),
        BLUE(255, 100.0),
        WHITE(0xFFFFFF, 60.0),
        YELLOW(0xFFFF00, 40.0),
        CYAN(65535, 40.0),
        MAGENTA(0xFF00FF, 40.0),
        ARGON(5291775, 30.0),
        ORANGE(16747520, 20.0),
        APPLE(10223360, 20.0),
        PURPLE(8990975, 20.0),
        PINK(16750510, 10.0);

        public final int color;
        public final double weight;
        private static final AuroraColor[] list;

        private AuroraColor(int c, double w) {
            this.color = c;
            this.weight = w;
        }

        static {
            list = AuroraColor.values();
        }
    }
}

