/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension;

import Reika.ChromatiCraft.ChromatiCraft;
import Reika.DragonAPI.Libraries.IO.ReikaColorAPI;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Java.ReikaGLHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraftforge.client.IRenderHandler;
import org.lwjgl.opengl.GL11;

public class ChromaSkyRenderer
extends IRenderHandler {
    public static final ChromaSkyRenderer instance = new ChromaSkyRenderer();
    private final int[] starColors = new int[]{0xFFFFFF, 13041658, 13035007, 10204927, 8155391, 0xFF6868, 0xFFADAD, 0xFFDAAD, 16773293};

    private ChromaSkyRenderer() {
    }

    @SideOnly(value=Side.CLIENT)
    public void render(float partialTicks, WorldClient world, Minecraft mc) {
        GL11.glDisable((int)2912);
        GL11.glDisable((int)3553);
        this.renderBlackscreen();
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3042);
        ReikaGLHelper.BlendMode.ADDITIVEDARK.apply();
        GL11.glPushMatrix();
        this.renderStars();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        this.renderPlanets();
        GL11.glPopMatrix();
        ReikaGLHelper.BlendMode.DEFAULT.apply();
        GL11.glDisable((int)3042);
    }

    private void renderBrightStars() {
        ReikaTextureHelper.bindTexture(ChromatiCraft.class, (String)"Textures/stars2.png");
        Random random = new Random(10842L);
        for (int i = 0; i < 16; ++i) {
            GL11.glPushMatrix();
            double rx = i * 8;
            double ry = i % 4 * 32;
            double rz = -i * 15 + 90;
            GL11.glRotated((double)rx, (double)1.0, (double)0.0, (double)0.0);
            GL11.glRotated((double)ry, (double)0.0, (double)1.0, (double)0.0);
            GL11.glRotated((double)rz, (double)0.0, (double)0.0, (double)1.0);
            double d0 = random.nextFloat() * 2.0f - 1.0f;
            double d1 = random.nextFloat() * 2.0f - 1.0f;
            double d2 = random.nextFloat() * 2.0f - 1.0f;
            double d3 = 0.15f + random.nextFloat() * 0.1f;
            double d4 = d0 * d0 + d1 * d1 + d2 * d2;
            double size = 175.0;
            if (d4 < 1.0 && d4 > 0.01) {
                d4 = 1.0 / Math.sqrt(d4);
                double d8 = Math.atan2(d0 *= d4, d2 *= d4);
                double d9 = Math.sin(d8);
                double d10 = Math.cos(d8);
                double d11 = Math.atan2(Math.sqrt(d0 * d0 + d2 * d2), d1 *= d4);
                double d12 = Math.sin(d11);
                double d13 = Math.cos(d11);
                double d14 = random.nextDouble() * Math.PI * 2.0;
                double d16 = Math.cos(d14);
                Tessellator v5 = Tessellator.field_78398_a;
                v5.func_78371_b(7);
                v5.func_78380_c(240);
                v5.func_78378_d(0xFFFFFF);
                double d = 380.0;
                double d5 = d0 * d;
                double d6 = d1 * d;
                double d7 = d2 * d;
                double du = (double)(i % 4) / 4.0;
                double dv = (double)(i / 4) / 4.0;
                double[] u = new double[]{du, du, du + 0.25, du + 0.25};
                double[] v = new double[]{dv, dv + 0.25, dv + 0.25, dv};
                for (int j = 0; j < 4; ++j) {
                    double d17 = 0.0;
                    double d18 = (double)((j & 2) - 1) * d3;
                    double d19 = (double)((j + 1 & 2) - 1) * d3;
                    double d20 = d18 * d16 - d19 * size;
                    double d21 = d19 * d16 + d18 * size;
                    double d22 = d20 * d12 + d17 * d13;
                    double d23 = d17 * d12 - d20 * d13;
                    double d24 = d23 * d9 - d21 * d10;
                    double d25 = d21 * d9 + d23 * d10;
                    v5.func_78374_a(d5 + d24, d6 + d22, d7 + d25, u[j], v[j]);
                }
                v5.func_78381_a();
            }
            GL11.glPopMatrix();
        }
    }

    private void renderPlanets() {
        Random random = new Random(245434L);
        double f1 = 1.0 + 0.125 * random.nextDouble();
        double f2 = 1.0 + 0.125 * random.nextDouble();
        double f3 = 1.0 + 0.125 * random.nextDouble();
        ReikaTextureHelper.bindTexture(ChromatiCraft.class, (String)"Textures/planets2.png");
        for (int k = 0; k < 32; ++k) {
            int i = k % 4;
            GL11.glPushMatrix();
            double rx = (double)(k * 8) + (double)System.currentTimeMillis() / 4000.0 % 360.0 + (double)i * 90.0 * Math.signum((double)(k % 2) - 0.5);
            double ry = (double)(i / 2 * 180) + (double)System.currentTimeMillis() / 16000.0 % 360.0 - (double)i * 30.0;
            double rz = (double)(k % 4 * 60) + (double)System.currentTimeMillis() / 240000.0 % 360.0 * (double)(1 + i % 2);
            GL11.glRotated((double)(rx * f1), (double)1.0, (double)0.0, (double)0.0);
            GL11.glRotated((double)(ry * f2), (double)0.0, (double)1.0, (double)0.0);
            GL11.glRotated((double)(rz * f3), (double)0.0, (double)0.0, (double)1.0);
            double d0 = random.nextFloat() * 2.0f - 1.0f;
            double d1 = random.nextFloat() * 2.0f - 1.0f;
            double d2 = random.nextFloat() * 2.0f - 1.0f;
            double d3 = 0.15f + random.nextFloat() * 0.1f;
            double d4 = d0 * d0 + d1 * d1 + d2 * d2;
            double size = 30.0;
            if (d4 < 1.0 && d4 > 0.01) {
                d4 = 1.0 / Math.sqrt(d4);
                double d8 = Math.atan2(d0 *= d4, d2 *= d4);
                double d9 = Math.sin(d8);
                double d10 = Math.cos(d8);
                double d11 = Math.atan2(Math.sqrt(d0 * d0 + d2 * d2), d1 *= d4);
                double d12 = Math.sin(d11);
                double d13 = Math.cos(d11);
                double d14 = random.nextDouble() * Math.PI * 2.0;
                double d16 = Math.cos(d14);
                Tessellator v5 = Tessellator.field_78398_a;
                v5.func_78371_b(7);
                v5.func_78380_c(240);
                v5.func_78378_d(0xFFFFFF);
                double d = 380.0;
                double d5 = d0 * d;
                double d6 = d1 * d;
                double d7 = d2 * d;
                double du = (double)(i % 2) / 2.0;
                double dv = (double)(i / 2) / 2.0;
                double[] u = new double[]{du, du, du + 0.5, du + 0.5};
                double[] v = new double[]{dv, dv + 0.5, dv + 0.5, dv};
                for (int j = 0; j < 4; ++j) {
                    double d17 = 0.0;
                    double d18 = (double)((j & 2) - 1) * d3;
                    double d19 = (double)((j + 1 & 2) - 1) * d3;
                    double d20 = d18 * d16 - d19 * size;
                    double d21 = d19 * d16 + d18 * size;
                    double d22 = d20 * d12 + d17 * d13;
                    double d23 = d17 * d12 - d20 * d13;
                    double d24 = d23 * d9 - d21 * d10;
                    double d25 = d21 * d9 + d23 * d10;
                    v5.func_78374_a(d5 + d24, d6 + d22, d7 + d25, u[j], v[j]);
                }
                v5.func_78381_a();
            }
            GL11.glPopMatrix();
        }
    }

    private void renderBlackscreen() {
        Tessellator v5 = Tessellator.field_78398_a;
        for (int i = 0; i < 6; ++i) {
            double d = 450.0;
            double u = 0.0;
            double v = 0.0;
            double du = 1.0 - u;
            double dv = 1.0 - v;
            GL11.glPushMatrix();
            switch (i) {
                case 1: {
                    GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    break;
                }
                case 2: {
                    GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    break;
                }
                case 3: {
                    GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    break;
                }
                case 4: {
                    GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    break;
                }
                case 5: {
                    GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                }
            }
            GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            v5.func_78382_b();
            v5.func_78378_d(0);
            v5.func_78374_a(-d, -d, -d, u, v);
            v5.func_78374_a(-d, -d, d, u, dv);
            v5.func_78374_a(d, -d, d, du, dv);
            v5.func_78374_a(d, -d, -d, du, v);
            v5.func_78381_a();
            GL11.glPopMatrix();
        }
    }

    private void renderStars() {
        Random random = new Random(10842L);
        double f1 = 0.125 + 0.0625 * random.nextDouble();
        double f2 = 0.125 + 0.0625 * random.nextDouble();
        double f3 = 0.125 + 0.0625 * random.nextDouble();
        GL11.glRotated((double)(RenderManager.field_78725_b * f1), (double)1.0, (double)0.0, (double)0.0);
        GL11.glRotated((double)(RenderManager.field_78726_c * f2), (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)(RenderManager.field_78723_d * f3), (double)0.0, (double)0.0, (double)1.0);
        GL11.glRotated((double)((double)System.currentTimeMillis() / 12000.0 % 360.0), (double)0.0, (double)0.0, (double)1.0);
        this.renderBrightStars();
        ReikaTextureHelper.bindTexture(ChromatiCraft.class, (String)"Textures/stars.png");
        int nstar = 5000 + (int)(2500.0 * Math.sin((double)System.currentTimeMillis() / 24000.0));
        for (int i = 0; i < nstar; ++i) {
            double d0 = random.nextFloat() * 2.0f - 1.0f;
            double d1 = random.nextFloat() * 2.0f - 1.0f;
            double d2 = random.nextFloat() * 2.0f - 1.0f;
            double d3 = 0.15f + random.nextFloat() * 0.1f;
            double d4 = d0 * d0 + d1 * d1 + d2 * d2;
            if (!(d4 < 1.0) || !(d4 > 0.01)) continue;
            d4 = 1.0 / Math.sqrt(d4);
            double d8 = Math.atan2(d0 *= d4, d2 *= d4);
            double d9 = Math.sin(d8);
            double d10 = Math.cos(d8);
            double d11 = Math.atan2(Math.sqrt(d0 * d0 + d2 * d2), d1 *= d4);
            double d12 = Math.sin(d11);
            double d13 = Math.cos(d11);
            double d14 = random.nextDouble() * Math.PI * 2.0;
            double size = 1.0 + Math.sin(d14) * (random.nextDouble() * 4.0);
            double d16 = Math.cos(d14);
            int n = random.nextInt(16);
            int dt = nstar - i;
            int c1 = this.starColors[random.nextInt(this.starColors.length)];
            int c = dt >= 4 ? c1 : ReikaColorAPI.getColorWithBrightnessMultiplier((int)c1, (float)((float)dt / 4.0f));
            double dl = (double)i / 10.0 / (double)nstar;
            this.renderStar(random, c, 320.0 - dl, size * 4.0 * 3.0, n, d0, d1, d2, d3, d9, d10, d12, d13, d16);
        }
    }

    private void renderStar(Random random, int c, double d, double size, int n, double d0, double d1, double d2, double d3, double d9, double d10, double d12, double d13, double d16) {
        Tessellator v5 = Tessellator.field_78398_a;
        v5.func_78371_b(7);
        v5.func_78380_c(240);
        v5.func_78378_d(c);
        double d5 = d0 * d;
        double d6 = d1 * d;
        double d7 = d2 * d;
        double du = (double)(n % 4) / 4.0;
        double dv = (double)(n / 4) / 4.0;
        double[] u = new double[]{du, du, du + 0.25, du + 0.25};
        double[] v = new double[]{dv, dv + 0.25, dv + 0.25, dv};
        for (int j = 0; j < 4; ++j) {
            double d17 = 0.0;
            double d18 = (double)((j & 2) - 1) * d3;
            double d19 = (double)((j + 1 & 2) - 1) * d3;
            double d20 = d18 * d16 - d19 * size;
            double d21 = d19 * d16 + d18 * size;
            double d22 = d20 * d12 + d17 * d13;
            double d23 = d17 * d12 - d20 * d13;
            double d24 = d23 * d9 - d21 * d10;
            double d25 = d21 * d9 + d23 * d10;
            v5.func_78374_a(d5 + d24, d6 + d22, d7 + d25, u[j], v[j]);
        }
        v5.func_78381_a();
    }
}

