/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension;

import Reika.ChromatiCraft.Auxiliary.MonumentCompletionRitual;
import Reika.ChromatiCraft.Auxiliary.MusicLoader;
import Reika.ChromatiCraft.Auxiliary.ProgressionManager;
import Reika.ChromatiCraft.ChromaClient;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ExtraChromaIDs;
import Reika.ChromatiCraft.World.Dimension.ChromaDimensionManager;
import Reika.ChromatiCraft.World.Dimension.OuterRegionsEvents;
import Reika.ChromatiCraft.World.Dimension.RegionMapper;
import Reika.ChromatiCraft.World.Dimension.SkyRiverManager;
import Reika.ChromatiCraft.World.Dimension.SkyRiverManagerClient;
import Reika.DragonAPI.Auxiliary.Trackers.RemoteAssetLoader;
import Reika.DragonAPI.Auxiliary.Trackers.TickRegistry;
import Reika.DragonAPI.IO.DirectResourceManager;
import Reika.DragonAPI.Instantiable.IO.CustomMusic;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaObfuscationHelper;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import org.lwjgl.input.Keyboard;
import paulscode.sound.StreamThread;

public class ChromaDimensionTicker
implements TickRegistry.TickHandler {
    public static final ChromaDimensionTicker instance = new ChromaDimensionTicker();
    private final Random rand = new Random();
    public final int dimID = ExtraChromaIDs.DIMID.getValue();
    private final Collection<ForgeChunkManager.Ticket> tickets = new ArrayList<ForgeChunkManager.Ticket>();
    private final ArrayList<DimensionMusic> music = new ArrayList();
    private final ArrayList<DimensionMusic> freshTracks = new ArrayList();
    private int musicCooldown;
    @SideOnly(value=Side.CLIENT)
    private ISound currentMusic;

    private ChromaDimensionTicker() {
    }

    @SideOnly(value=Side.CLIENT)
    public ISound getCurrentMusic() {
        return this.currentMusic;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void registerMusic(RemoteAssetLoader.RemoteAssetsDownloadCompleteEvent evt) {
        Collection<String> li = MusicLoader.instance.getMusicFiles();
        ChromatiCraft.logger.log((Object)(li.size() + " music tracks available for the dimension: " + li));
        for (String path : li) {
            DimensionMusic mus = new DimensionMusic(path, path.substring(0, path.length() - 4).endsWith("_c"));
            this.music.add(mus);
            DirectResourceManager.getInstance().registerCustomPath(mus.path, ChromaClient.chromaCategory, true);
        }
    }

    public void tick(TickRegistry.TickType type, Object ... tickData) {
        switch (type) {
            case WORLD: {
                World world = (World)tickData[0];
                if (world.field_73011_w.field_76574_g != this.dimID) break;
                world.field_72990_M = Integer.MAX_VALUE;
                if (!world.field_72995_K) {
                    this.unloadChunks();
                }
                ChromaDimensionManager.tickPlayersInStructures(world);
                SkyRiverManager.tickSkyRiverServer(world);
                world.func_72891_a(false, false);
                break;
            }
            case CLIENT: {
                if (!this.music.isEmpty()) {
                    this.playMusic();
                }
                SkyRiverManagerClient.handleSkyRiverMovementClient();
                break;
            }
            case PLAYER: {
                EntityPlayer ep = (EntityPlayer)tickData[0];
                if (ep.field_70170_p.field_73011_w.field_76574_g != this.dimID || RegionMapper.isPointInCentralRegion(ep.field_70165_t, ep.field_70161_v)) break;
                OuterRegionsEvents.instance.tickPlayerInOuterRegion(ep);
                break;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void playMusic() {
        if (Minecraft.func_71410_x().field_71441_e != null && Minecraft.func_71410_x().field_71441_e.field_73011_w.field_76574_g == this.dimID && !MonumentCompletionRitual.areRitualsRunning()) {
            SoundHandler sh = Minecraft.func_71410_x().func_147118_V();
            StreamThread th = ReikaSoundHelper.getStreamingThread((SoundHandler)sh);
            if (th == null || !th.isAlive()) {
                sh.func_147690_c();
                ReikaSoundHelper.restartStreamingSystem((SoundHandler)sh);
            }
            if (this.currentMusic != null && ReikaObfuscationHelper.isDeObfEnvironment() && Keyboard.isKeyDown((int)207)) {
                sh.func_147683_b(this.currentMusic);
                this.musicCooldown = 0;
            }
            if (this.currentMusic != null && sh.func_147692_c(this.currentMusic)) {
                return;
            }
            if (this.musicCooldown > 0) {
                --this.musicCooldown;
                return;
            }
            DimensionMusic s = this.selectTrack((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
            if (s != null) {
                s.play(sh);
            }
            this.currentMusic = s;
            this.musicCooldown = 300 + this.rand.nextInt(900);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private DimensionMusic selectTrack(EntityPlayer ep) {
        if (this.freshTracks.isEmpty()) {
            this.freshTracks.addAll(this.music);
            Collections.shuffle(this.freshTracks);
        }
        DimensionMusic s = this.freshTracks.remove(0);
        while (!s.canPlay(ep) && !this.freshTracks.isEmpty()) {
            s = this.freshTracks.remove(0);
        }
        return s.canPlay(ep) ? s : null;
    }

    private void unloadChunks() {
        for (ForgeChunkManager.Ticket t : this.tickets) {
            for (ChunkCoordIntPair p : t.getChunkList()) {
                ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)t, (ChunkCoordIntPair)p);
            }
        }
        this.tickets.clear();
    }

    public void scheduleTicketUnload(ForgeChunkManager.Ticket t) {
        this.tickets.add(t);
    }

    public EnumSet<TickRegistry.TickType> getType() {
        return EnumSet.of(TickRegistry.TickType.WORLD, TickRegistry.TickType.CLIENT, TickRegistry.TickType.PLAYER);
    }

    public boolean canFire(TickEvent.Phase p) {
        return p == TickEvent.Phase.END;
    }

    public String getLabel() {
        return "Chroma Dimension Tag";
    }

    private static class DimensionMusic
    extends CustomMusic {
        private final boolean isCompletionGated;

        private DimensionMusic(String path, boolean b) {
            super(path);
            this.isCompletionGated = b;
        }

        public final boolean canPlay(EntityPlayer ep) {
            return this.isCompletionGated ? ProgressionManager.ProgressStage.CTM.isPlayerAtStage(ep) : true;
        }
    }
}

