/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension;

import Reika.ChromatiCraft.Base.ChromaDimensionBiome;
import Reika.ChromatiCraft.Base.DimensionStructureGenerator;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ExtraChromaIDs;
import Reika.ChromatiCraft.World.Dimension.Biome.BiomeGenCentral;
import Reika.ChromatiCraft.World.Dimension.Biome.BiomeGenChromaMountains;
import Reika.ChromatiCraft.World.Dimension.Biome.BiomeGenChromaOcean;
import Reika.ChromatiCraft.World.Dimension.Biome.BiomeGenCrystalForest;
import Reika.ChromatiCraft.World.Dimension.Biome.BiomeGenCrystalPlains;
import Reika.ChromatiCraft.World.Dimension.Biome.BiomeGenGlowingForest;
import Reika.ChromatiCraft.World.Dimension.Biome.BiomeGenIslands;
import Reika.ChromatiCraft.World.Dimension.Biome.BiomeGenSkylands;
import Reika.ChromatiCraft.World.Dimension.Biome.BiomeGenSparkle;
import Reika.ChromatiCraft.World.Dimension.Biome.BiomeGenVoidlands;
import Reika.ChromatiCraft.World.Dimension.Biome.StructureBiome;
import Reika.ChromatiCraft.World.Dimension.ChunkProviderChroma;
import Reika.ChromatiCraft.World.Dimension.WorldProviderChroma;
import Reika.DragonAPI.Auxiliary.Trackers.BiomeCollisionTracker;
import Reika.DragonAPI.Auxiliary.Trackers.RetroGenController;
import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Exception.RegistrationException;
import Reika.DragonAPI.IO.ReikaFileReader;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.KeyedItemStack;
import Reika.DragonAPI.Instantiable.Data.Maps.PlayerMap;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaParticleHelper;
import Reika.DragonAPI.ModList;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.DimensionManager;

public class ChromaDimensionManager {
    private static final HashSet<BlockKey> bannedBlocks;
    private static final HashSet<KeyedItemStack> bannedItems;
    private static final PlayerMap<DimensionStructureGenerator> playersInStructures;
    private static final HashMap<Integer, ChromaDimensionBiomeType> IDMap;

    public static void initialize() {
        int id = ExtraChromaIDs.DIMID.getValue();
        DimensionManager.registerProviderType((int)id, WorldProviderChroma.class, (boolean)false);
        DimensionManager.registerDimension((int)id, (int)id);
        RetroGenController.instance.excludeWorld(id);
        for (int i = 0; i < Biomes.biomeList.length; ++i) {
            Biomes b = Biomes.biomeList[i];
            b.create();
            BiomeDictionary.registerBiomeType((BiomeGenBase)b.instance, (BiomeDictionary.Type[])b.types);
            if (b.subBiome == null) continue;
            BiomeDictionary.registerBiomeType((BiomeGenBase)b.subBiome.instance, (BiomeDictionary.Type[])b.subBiome.types);
        }
    }

    public static void resetDimension(World world) {
        playersInStructures.clear();
        if (world instanceof WorldServer) {
            ((WorldServer)world).func_73041_k();
        }
        ChromaDimensionManager.getChunkProvider(world).clearCaches();
        System.gc();
        String path = DimensionManager.getCurrentSaveRootDirectory().getAbsolutePath().replaceAll("\\\\", "/").replaceAll("/\\./", "/");
        File dim = new File(path + "/DIM" + ExtraChromaIDs.DIMID.getValue());
        if (dim.exists() && dim.isDirectory()) {
            boolean bl = ReikaFileReader.deleteFolderWithContents((File)dim, (int)100);
        }
    }

    public static void resetDimensionClient() {
        playersInStructures.clear();
        System.gc();
        String path = DragonAPICore.getMinecraftDirectoryString() + "mods/VoxelMods/voxelMap/cache/";
        File f = new File(path);
        if (f.exists() && f.isDirectory()) {
            File[] saves = f.listFiles();
            for (int i = 0; i < saves.length; ++i) {
                File f2 = new File(saves[i], "Chroma (dimension 60)");
                if (!f2.exists()) continue;
                f2.delete();
            }
        }
    }

    public static ChunkProviderChroma getChunkProvider(World world) {
        return ((WorldProviderChroma)world.field_73011_w).getChunkGenerator();
    }

    public static boolean isBannedDimensionBlock(Block b, int meta) {
        return bannedBlocks.contains(new BlockKey(b, meta));
    }

    public static void tickPlayersInStructures(World world) {
        for (UUID id : playersInStructures.keySet()) {
            EntityPlayer ep = world.func_152378_a(id);
            if (ep == null) continue;
            ((DimensionStructureGenerator)playersInStructures.directGet(id)).tickPlayer(ep);
            ChromaDimensionManager.disallowBannedItems(ep);
        }
    }

    private static void disallowBannedItems(EntityPlayer ep) {
        ItemStack held = ep.func_71045_bC();
        if (held != null && bannedItems.contains(new KeyedItemStack(held).setSimpleHash(true))) {
            ReikaItemHelper.dropItem((Entity)ep, (ItemStack)held);
            ReikaSoundHelper.playSoundAtEntity((World)ep.field_70170_p, (Entity)ep, (String)"random.explode");
            ReikaParticleHelper.EXPLODE.spawnAt((Entity)ep);
            ep.func_70097_a(DamageSource.field_76377_j, 1.0f);
            ep.func_70062_b(0, null);
        }
    }

    public static DimensionStructureGenerator getStructurePlayerIsIn(EntityPlayer ep) {
        return (DimensionStructureGenerator)playersInStructures.get(ep);
    }

    public static void addPlayerToStructure(EntityPlayer ep, DimensionStructureGenerator structure) {
        playersInStructures.put(ep, (Object)structure);
    }

    @SideOnly(value=Side.CLIENT)
    public static void addPlayerToStructureClient(EntityPlayer ep, DimensionStructureGenerator.DimensionStructureType structure) {
        playersInStructures.put(ep, (Object)structure.createGenerator());
    }

    public static void removePlayerFromStructure(EntityPlayer ep) {
        playersInStructures.remove(ep);
    }

    static {
        Block b;
        bannedBlocks = new HashSet();
        bannedItems = new HashSet();
        playersInStructures = new PlayerMap();
        IDMap = new HashMap();
        if (ModList.ENDERIO.isLoaded()) {
            Item i;
            b = GameRegistry.findBlock((String)ModList.ENDERIO.modLabel, (String)"blockTravelAnchor");
            if (b != null) {
                bannedBlocks.add(new BlockKey(b));
            }
            if ((b = GameRegistry.findBlock((String)ModList.ENDERIO.modLabel, (String)"blockTelePad")) != null) {
                bannedBlocks.add(new BlockKey(b));
            }
            if ((i = GameRegistry.findItem((String)ModList.ENDERIO.modLabel, (String)"itemTravelStaff")) != null) {
                bannedItems.add(new KeyedItemStack(i));
            }
        }
        if (ModList.THAUMICTINKER.isLoaded() && (b = GameRegistry.findBlock((String)ModList.THAUMICTINKER.modLabel, (String)"warpGate")) != null) {
            bannedBlocks.add(new BlockKey(b));
        }
    }

    public static interface ChromaDimensionBiomeType {
        public ChromaDimensionBiome getBiome();

        public boolean isWaterBiome();

        public boolean isReasonablyFlat();

        public int getBaseHeightDelta();

        public String name();
    }

    public static enum SubBiomes implements ChromaDimensionBiomeType
    {
        MOUNTAINS(BiomeGenChromaMountains.class, "Crystal Mountains", 0.75, 0, ExtraChromaIDs.MOUNTAIN, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.MOUNTAIN),
        DEEPOCEAN(BiomeGenChromaOcean.class, "Aura Ocean", 0.4, -30, ExtraChromaIDs.OCEAN, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.OCEAN),
        CRYSFOREST(BiomeGenCrystalForest.class, "Crystal Forest", 0.2, 15, ExtraChromaIDs.CRYSFOREST, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.FOREST),
        VOIDLANDS(BiomeGenVoidlands.class, "Voidland", 0.1, 8, ExtraChromaIDs.VOID, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.COLD, BiomeDictionary.Type.END);

        private int id;
        public final String biomeName;
        private final Class biomeClass;
        private ChromaDimensionBiome.ChromaDimensionSubBiome instance;
        private final BiomeDictionary.Type[] types;
        public final double spawnWeight;
        private ExtraChromaIDs config;
        private Biomes parent;
        public final int baseHeightDelta;
        public static final SubBiomes[] biomeList;

        private SubBiomes(Class<? extends ChromaDimensionBiome.ChromaDimensionSubBiome> c, String n2, double w, int h, ExtraChromaIDs id, BiomeDictionary.Type ... t) {
            this.biomeClass = c;
            this.types = t;
            this.config = id;
            this.spawnWeight = w;
            this.biomeName = n2;
            this.baseHeightDelta = h;
        }

        private void create(Biomes b) {
            this.parent = b;
            this.id = this.config.getValue();
            BiomeCollisionTracker.instance.addBiomeID((DragonAPIMod)ChromatiCraft.instance, this.id, this.biomeClass);
            IDMap.put(this.id, this);
            try {
                Constructor c = this.biomeClass.getConstructor(Integer.TYPE, String.class, SubBiomes.class);
                this.instance = (ChromaDimensionBiome.ChromaDimensionSubBiome)((Object)c.newInstance(this.id, this.biomeName, this));
            }
            catch (Exception e) {
                throw new RegistrationException((DragonAPIMod)ChromatiCraft.instance, "Could not create biome instance " + this + ": " + e.getLocalizedMessage());
            }
        }

        public Biomes getParent() {
            return this.parent;
        }

        @Override
        public ChromaDimensionBiome getBiome() {
            return this.instance;
        }

        @Override
        public boolean isWaterBiome() {
            return this.parent.isWaterBiome();
        }

        @Override
        public boolean isReasonablyFlat() {
            return this != MOUNTAINS && this != VOIDLANDS;
        }

        @Override
        public int getBaseHeightDelta() {
            return this.baseHeightDelta;
        }

        static {
            biomeList = SubBiomes.values();
        }
    }

    public static enum Biomes implements ChromaDimensionBiomeType
    {
        PLAINS(BiomeGenCrystalPlains.class, "Crystal Plains", 8, 0, ExtraChromaIDs.PLAINS, SubBiomes.MOUNTAINS, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.PLAINS),
        ISLANDS(BiomeGenIslands.class, "Iridescent Archipelago", 6, -5, ExtraChromaIDs.ISLANDS, SubBiomes.DEEPOCEAN, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.BEACH, BiomeDictionary.Type.WET),
        SKYLANDS(BiomeGenSkylands.class, "Lumen Skylands", 2, 0, ExtraChromaIDs.SKYLANDS, SubBiomes.VOIDLANDS, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.COLD),
        FOREST(BiomeGenGlowingForest.class, "Glowing Forest", 10, 10, ExtraChromaIDs.FOREST, SubBiomes.CRYSFOREST, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.FOREST),
        SPARKLE(BiomeGenSparkle.class, "Sparkling Sands", 4, 0, ExtraChromaIDs.SPARKLE, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.BEACH, BiomeDictionary.Type.SANDY),
        STRUCTURE(StructureBiome.class, "Structure Field", 0, 0, ExtraChromaIDs.STRUCTURE, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.PLAINS),
        CENTER(BiomeGenCentral.class, "Luminescent Sanctuary", 0, 0, ExtraChromaIDs.CENTRAL, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.DENSE);

        private int id;
        public final String biomeName;
        private final Class biomeClass;
        private ChromaDimensionBiome instance;
        private final BiomeDictionary.Type[] types;
        public final int spawnWeight;
        private ExtraChromaIDs config;
        private final SubBiomes subBiome;
        public final int baseHeightDelta;
        public static final Biomes[] biomeList;

        private Biomes(Class<? extends ChromaDimensionBiome> c, String n2, int w, int h, ExtraChromaIDs id, BiomeDictionary.Type ... t) {
            this(c, n2, w, h, id, (SubBiomes)null, t);
        }

        private Biomes(Class<? extends ChromaDimensionBiome> c, String n2, int w, int h, ExtraChromaIDs id, SubBiomes s, BiomeDictionary.Type ... t) {
            this.biomeClass = c;
            this.types = t;
            this.config = id;
            this.spawnWeight = w;
            this.subBiome = s;
            this.biomeName = n2;
            this.baseHeightDelta = h;
        }

        private void create() {
            this.id = this.config.getValue();
            BiomeCollisionTracker.instance.addBiomeID((DragonAPIMod)ChromatiCraft.instance, this.id, this.biomeClass);
            IDMap.put(this.id, this);
            if (this.subBiome != null) {
                this.subBiome.create(this);
            }
            try {
                Constructor c = this.biomeClass.getConstructor(Integer.TYPE, String.class, Biomes.class);
                this.instance = (ChromaDimensionBiome)((Object)c.newInstance(this.id, this.biomeName, this));
            }
            catch (Exception e) {
                throw new RegistrationException((DragonAPIMod)ChromatiCraft.instance, "Could not create biome instance " + this + ": " + e.getLocalizedMessage());
            }
        }

        @Override
        public ChromaDimensionBiome getBiome() {
            return this.instance;
        }

        public SubBiomes getSubBiome() {
            return this.subBiome;
        }

        public boolean isTechnical() {
            return this.spawnWeight == 0;
        }

        @Override
        public boolean isWaterBiome() {
            return this == ISLANDS;
        }

        @Override
        public boolean isReasonablyFlat() {
            return this != SKYLANDS && this != ISLANDS;
        }

        @Override
        public int getBaseHeightDelta() {
            return this.baseHeightDelta;
        }

        public static ChromaDimensionBiomeType getFromID(int id) {
            return (ChromaDimensionBiomeType)IDMap.get(id);
        }

        static {
            biomeList = Biomes.values();
        }
    }
}

