/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension;

import Reika.ChromatiCraft.ChromatiCraft;
import Reika.DragonAPI.Libraries.IO.ReikaColorAPI;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Java.ReikaGLHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraftforge.client.IRenderHandler;
import org.lwjgl.opengl.GL11;

public class ChromaCloudRenderer
extends IRenderHandler {
    public static final ChromaCloudRenderer instance = new ChromaCloudRenderer();

    private ChromaCloudRenderer() {
    }

    @SideOnly(value=Side.CLIENT)
    public void render(float ptick, WorldClient world, Minecraft mc) {
        GL11.glPushMatrix();
        GL11.glDisable((int)2884);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2912);
        Tessellator v5 = Tessellator.field_78398_a;
        double w = 512.0;
        float f2 = 1.0f;
        float playerY = (float)(mc.field_71451_h.field_70137_T + (mc.field_71451_h.field_70163_u - mc.field_71451_h.field_70137_T) * (double)ptick);
        float y = 36.0f - playerY * 0.0625f;
        double x = (mc.field_71451_h.field_70169_q + (mc.field_71451_h.field_70165_t - mc.field_71451_h.field_70169_q) * (double)ptick) / (double)f2;
        double z = (mc.field_71451_h.field_70166_s + (mc.field_71451_h.field_70161_v - mc.field_71451_h.field_70166_s) * (double)ptick) / (double)f2 + 0.33;
        GL11.glTranslated((double)(-x % (w * 2.0)), (double)y, (double)(-z % (w * 2.0)));
        GL11.glEnable((int)3042);
        ReikaGLHelper.BlendMode.ADDITIVEDARK.apply();
        GL11.glDisable((int)3008);
        GL11.glDisable((int)2929);
        int r = 2;
        for (int a = -r; a <= r; ++a) {
            for (int b = -r; b <= r; ++b) {
                for (int i = 0; i < 4; ++i) {
                    ReikaTextureHelper.bindTexture(ChromatiCraft.class, (String)("Textures/clouds/dimsky_" + i + ".png"));
                    double s = 0.75 + 0.25 * (double)i;
                    double slide = (double)((float)(world.func_82737_E() % 24000L) + ptick) / 24000.0 * w * s % w;
                    GL11.glPushMatrix();
                    GL11.glRotated((double)(i * 60), (double)0.0, (double)1.0, (double)0.0);
                    GL11.glTranslated((double)slide, (double)0.0, (double)0.0);
                    double d = -i * 6;
                    int c1 = 160;
                    int c2 = 112;
                    c1 = (int)((double)c1 * Math.min(1.0, Math.max(0.0, (double)playerY / 64.0)));
                    c2 = (int)((double)c2 * Math.min(1.0, Math.max(0.0, (double)playerY / 64.0)));
                    double mult = 0.625 + 0.375 * Math.sin((double)System.currentTimeMillis() / 2000.0 + (double)i * Math.PI / 2.0);
                    c1 = (int)((double)c1 * mult);
                    c2 = (int)((double)c2 * mult);
                    c1 = (int)((double)c1 * (1.0 - (double)(a * a + b * b) / 8.0));
                    c2 = (int)((double)c2 * (1.0 - (double)(a * a + b * b) / 8.0));
                    c1 = ReikaColorAPI.GStoHex((int)c1);
                    c2 = ReikaColorAPI.GStoHex((int)c2);
                    this.drawCloudLayer2(v5, a, b, c1, w * 1.0, 180.0 + d - (double)playerY * 0.4375, i);
                    this.drawCloudLayer2(v5, a, b, c2, w, 0.0 + d, i);
                    GL11.glPopMatrix();
                }
            }
        }
        GL11.glPopMatrix();
        ReikaGLHelper.BlendMode.DEFAULT.apply();
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2884);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)2896);
    }

    private double getCloudOffset(int i, int k, int index) {
        long time = System.currentTimeMillis() + (long)(index * 40000000);
        double d = 2.0 + 2.0 * Math.sin((double)(i * i + k * k) / 32.0 * (double)((time % 250000L + 250000L) % 250000L) / 250000.0);
        return d * (Math.sin((double)i + (double)time / 5000.0) + Math.sin((double)k / 2.0 + (double)time / 2000.0));
    }

    private void drawCloudLayer2(Tessellator v5, int a, int b, int color, double w, double h, int index) {
        v5.func_78382_b();
        v5.func_78378_d(color);
        long time = System.currentTimeMillis() + (long)(index * 40000000);
        double d1 = 4.0 * Math.sin((double)time / 10000.0);
        double d2 = 9.0 * Math.sin((double)time / 20000.0);
        double d3 = 3.0 * Math.sin((double)time / 4000.0);
        double d4 = 6.0 * Math.cos((double)time / 15000.0);
        double h1 = h + d1;
        double h2 = h + d2;
        double h3 = h + d3;
        double h4 = h + d4;
        double dw = (double)a * w * 2.0;
        double dw2 = (double)b * w * 2.0;
        v5.func_78374_a(dw - w, h1, dw2 - w, 0.0, 0.0);
        v5.func_78374_a(dw + w, h2, dw2 - w, 1.0, 0.0);
        v5.func_78374_a(dw + w, h3, dw2 + w, 1.0, 1.0);
        v5.func_78374_a(dw - w, h4, dw2 + w, 0.0, 1.0);
        v5.func_78381_a();
    }

    private void drawCloudLayer(Tessellator v5, int color, double w, double h, int index) {
        v5.func_78382_b();
        v5.func_78384_a(0xFFFFFF, color);
        int s = 128;
        double[][] off = new double[s + 2][s + 2];
        for (int i = -1; i <= s; ++i) {
            for (int k = -1; k <= s; ++k) {
                off[i + 1][k + 1] = this.getCloudOffset(i, k, index) * (double)(h > 0.0 ? 4 : 1);
            }
        }
        double f = 1.0 / (double)s;
        double f2 = f * w;
        for (int i = 0; i < s; ++i) {
            double fxt = (double)i * f;
            double fx = (double)i * f2;
            double dx = -w + fx;
            for (int k = 0; k < s; ++k) {
                double fzt = (double)k * f;
                double fz = (double)k * f2;
                double dz = -w + fz;
                double hmm = h + (off[i + 1][k + 1] + off[i - 1 + 1][k - 1 + 1] + off[i - 1 + 1][k + 1] + off[i + 1][k - 1 + 1]) / 5.0;
                double hpm = h + (off[i + 1][k + 1] + off[i + 1 + 1][k - 1 + 1] + off[i + 1 + 1][k + 1] + off[i + 1][k - 1 + 1]) / 5.0;
                double hpp = h + (off[i + 1][k + 1] + off[i + 1 + 1][k + 1 + 1] + off[i + 1 + 1][k + 1] + off[i + 1][k + 1 + 1]) / 5.0;
                double hmp = h + (off[i + 1][k + 1] + off[i - 1 + 1][k + 1 + 1] + off[i - 1 + 1][k + 1] + off[i + 1][k + 1 + 1]) / 5.0;
                v5.func_78374_a(dx, hmm, dz, fxt, fzt);
                v5.func_78374_a(dx + f2, hpm, dz, fxt + f, fzt);
                v5.func_78374_a(dx + f2, hpp, dz + f2, fxt + f, fzt + f);
                v5.func_78374_a(dx, hmp, dz + f2, fxt, fzt + f);
            }
        }
        v5.func_78381_a();
    }

    private void renderCloudsVanilla(WorldClient world, Minecraft mc, float ptick) {
        float f10;
        float f9;
        float f8;
        float playerY = (float)(mc.field_71451_h.field_70137_T + (mc.field_71451_h.field_70163_u - mc.field_71451_h.field_70137_T) * (double)ptick);
        Tessellator tessellator = Tessellator.field_78398_a;
        float f2 = 12.0f;
        float cloudTickCounter = world.func_82737_E();
        double slide = cloudTickCounter + ptick;
        double posX = (mc.field_71451_h.field_70169_q + (mc.field_71451_h.field_70165_t - mc.field_71451_h.field_70169_q) * (double)ptick + slide * 0.03) / (double)f2;
        double posZ = (mc.field_71451_h.field_70166_s + (mc.field_71451_h.field_70161_v - mc.field_71451_h.field_70166_s) * (double)ptick) / (double)f2 + 0.33;
        float f4 = world.field_73011_w.func_76571_f() - playerY + 0.33f;
        int i = MathHelper.func_76128_c((double)(posX / 2048.0));
        int j = MathHelper.func_76128_c((double)(posZ / 2048.0));
        posX -= (double)(i * 2048);
        posZ -= (double)(j * 2048);
        ReikaTextureHelper.bindTexture(ChromatiCraft.class, (String)"Textures/clouds/dimension.png");
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        Vec3 vec3 = world.func_72824_f(ptick);
        float red = (float)vec3.field_72450_a;
        float green = (float)vec3.field_72448_b;
        float blue = (float)vec3.field_72449_c;
        if (mc.field_71474_y.field_74337_g) {
            f8 = (red * 30.0f + green * 59.0f + blue * 11.0f) / 100.0f;
            f9 = (red * 30.0f + green * 70.0f) / 100.0f;
            f10 = (red * 30.0f + blue * 70.0f) / 100.0f;
            red = f8;
            green = f9;
            blue = f10;
        }
        f8 = (float)(posX * 0.0);
        f9 = (float)(posZ * 0.0);
        f10 = 0.00390625f;
        f8 = (float)MathHelper.func_76128_c((double)posX) * f10;
        f9 = (float)MathHelper.func_76128_c((double)posZ) * f10;
        float floatX = (float)(posX - (double)MathHelper.func_76128_c((double)posX));
        float floatZ = (float)(posZ - (double)MathHelper.func_76128_c((double)posZ));
        int b0 = 8;
        int b1 = 4;
        float f13 = 0.0f;
        GL11.glScalef((float)f2, (float)1.0f, (float)f2);
        for (int k = 0; k < 2; ++k) {
            if (k == 0) {
                GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            } else if (mc.field_71474_y.field_74337_g) {
                if (EntityRenderer.field_78515_b == 0) {
                    GL11.glColorMask((boolean)false, (boolean)true, (boolean)true, (boolean)true);
                } else {
                    GL11.glColorMask((boolean)true, (boolean)false, (boolean)false, (boolean)true);
                }
            } else {
                GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            }
            for (int dx = -b1 + 1; dx <= b1; ++dx) {
                for (int dz = -b1 + 1; dz <= b1; ++dz) {
                    int j1;
                    tessellator.func_78382_b();
                    float f14 = dx * b0;
                    float f15 = dz * b0;
                    float f16 = f14 - floatX;
                    float f17 = f15 - floatZ;
                    double sx = (double)f16 - mc.field_71451_h.field_70165_t;
                    double sz = (double)f17 - mc.field_71451_h.field_70161_v;
                    double f3 = 4.0 + 2.0 * Math.sin((sx * sx + sz * sz) / 10000.0);
                    if ((double)f4 > -f3 - 1.0) {
                        tessellator.func_78369_a(red * 0.7f, green * 0.7f, blue * 0.7f, 0.8f);
                        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
                        tessellator.func_78374_a((double)(f16 + 0.0f), (double)(f4 + 0.0f), (double)(f17 + (float)b0), (double)((f14 + 0.0f) * f10 + f8), (double)((f15 + (float)b0) * f10 + f9));
                        tessellator.func_78374_a((double)(f16 + (float)b0), (double)(f4 + 0.0f), (double)(f17 + (float)b0), (double)((f14 + (float)b0) * f10 + f8), (double)((f15 + (float)b0) * f10 + f9));
                        tessellator.func_78374_a((double)(f16 + (float)b0), (double)(f4 + 0.0f), (double)(f17 + 0.0f), (double)((f14 + (float)b0) * f10 + f8), (double)((f15 + 0.0f) * f10 + f9));
                        tessellator.func_78374_a((double)(f16 + 0.0f), (double)(f4 + 0.0f), (double)(f17 + 0.0f), (double)((f14 + 0.0f) * f10 + f8), (double)((f15 + 0.0f) * f10 + f9));
                    }
                    if ((double)f4 <= f3 + 1.0) {
                        tessellator.func_78369_a(red, green, blue, 0.8f);
                        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
                        tessellator.func_78374_a((double)(f16 + 0.0f), (double)f4 + f3 - (double)f13, (double)(f17 + (float)b0), (double)((f14 + 0.0f) * f10 + f8), (double)((f15 + (float)b0) * f10 + f9));
                        tessellator.func_78374_a((double)(f16 + (float)b0), (double)f4 + f3 - (double)f13, (double)(f17 + (float)b0), (double)((f14 + (float)b0) * f10 + f8), (double)((f15 + (float)b0) * f10 + f9));
                        tessellator.func_78374_a((double)(f16 + (float)b0), (double)f4 + f3 - (double)f13, (double)(f17 + 0.0f), (double)((f14 + (float)b0) * f10 + f8), (double)((f15 + 0.0f) * f10 + f9));
                        tessellator.func_78374_a((double)(f16 + 0.0f), (double)f4 + f3 - (double)f13, (double)(f17 + 0.0f), (double)((f14 + 0.0f) * f10 + f8), (double)((f15 + 0.0f) * f10 + f9));
                    }
                    tessellator.func_78369_a(red * 0.9f, green * 0.9f, blue * 0.9f, 0.8f);
                    if (dx > -1) {
                        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
                        for (j1 = 0; j1 < b0; ++j1) {
                            tessellator.func_78374_a((double)(f16 + (float)j1 + 0.0f), (double)(f4 + 0.0f), (double)(f17 + (float)b0), (double)((f14 + (float)j1 + 0.5f) * f10 + f8), (double)((f15 + (float)b0) * f10 + f9));
                            tessellator.func_78374_a((double)(f16 + (float)j1 + 0.0f), (double)f4 + f3, (double)(f17 + (float)b0), (double)((f14 + (float)j1 + 0.5f) * f10 + f8), (double)((f15 + (float)b0) * f10 + f9));
                            tessellator.func_78374_a((double)(f16 + (float)j1 + 0.0f), (double)f4 + f3, (double)(f17 + 0.0f), (double)((f14 + (float)j1 + 0.5f) * f10 + f8), (double)((f15 + 0.0f) * f10 + f9));
                            tessellator.func_78374_a((double)(f16 + (float)j1 + 0.0f), (double)(f4 + 0.0f), (double)(f17 + 0.0f), (double)((f14 + (float)j1 + 0.5f) * f10 + f8), (double)((f15 + 0.0f) * f10 + f9));
                        }
                    }
                    if (dx <= 1) {
                        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
                        for (j1 = 0; j1 < b0; ++j1) {
                            tessellator.func_78374_a((double)(f16 + (float)j1 + 1.0f - f13), (double)(f4 + 0.0f), (double)(f17 + (float)b0), (double)((f14 + (float)j1 + 0.5f) * f10 + f8), (double)((f15 + (float)b0) * f10 + f9));
                            tessellator.func_78374_a((double)(f16 + (float)j1 + 1.0f - f13), (double)f4 + f3, (double)(f17 + (float)b0), (double)((f14 + (float)j1 + 0.5f) * f10 + f8), (double)((f15 + (float)b0) * f10 + f9));
                            tessellator.func_78374_a((double)(f16 + (float)j1 + 1.0f - f13), (double)f4 + f3, (double)(f17 + 0.0f), (double)((f14 + (float)j1 + 0.5f) * f10 + f8), (double)((f15 + 0.0f) * f10 + f9));
                            tessellator.func_78374_a((double)(f16 + (float)j1 + 1.0f - f13), (double)(f4 + 0.0f), (double)(f17 + 0.0f), (double)((f14 + (float)j1 + 0.5f) * f10 + f8), (double)((f15 + 0.0f) * f10 + f9));
                        }
                    }
                    tessellator.func_78369_a(red * 0.8f, green * 0.8f, blue * 0.8f, 0.8f);
                    if (dz > -1) {
                        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
                        for (j1 = 0; j1 < b0; ++j1) {
                            tessellator.func_78374_a((double)(f16 + 0.0f), (double)f4 + f3, (double)(f17 + (float)j1 + 0.0f), (double)((f14 + 0.0f) * f10 + f8), (double)((f15 + (float)j1 + 0.5f) * f10 + f9));
                            tessellator.func_78374_a((double)(f16 + (float)b0), (double)f4 + f3, (double)(f17 + (float)j1 + 0.0f), (double)((f14 + (float)b0) * f10 + f8), (double)((f15 + (float)j1 + 0.5f) * f10 + f9));
                            tessellator.func_78374_a((double)(f16 + (float)b0), (double)(f4 + 0.0f), (double)(f17 + (float)j1 + 0.0f), (double)((f14 + (float)b0) * f10 + f8), (double)((f15 + (float)j1 + 0.5f) * f10 + f9));
                            tessellator.func_78374_a((double)(f16 + 0.0f), (double)(f4 + 0.0f), (double)(f17 + (float)j1 + 0.0f), (double)((f14 + 0.0f) * f10 + f8), (double)((f15 + (float)j1 + 0.5f) * f10 + f9));
                        }
                    }
                    if (dz <= 1) {
                        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
                        for (j1 = 0; j1 < b0; ++j1) {
                            tessellator.func_78374_a((double)(f16 + 0.0f), (double)f4 + f3, (double)(f17 + (float)j1 + 1.0f - f13), (double)((f14 + 0.0f) * f10 + f8), (double)((f15 + (float)j1 + 0.5f) * f10 + f9));
                            tessellator.func_78374_a((double)(f16 + (float)b0), (double)f4 + f3, (double)(f17 + (float)j1 + 1.0f - f13), (double)((f14 + (float)b0) * f10 + f8), (double)((f15 + (float)j1 + 0.5f) * f10 + f9));
                            tessellator.func_78374_a((double)(f16 + (float)b0), (double)(f4 + 0.0f), (double)(f17 + (float)j1 + 1.0f - f13), (double)((f14 + (float)b0) * f10 + f8), (double)((f15 + (float)j1 + 0.5f) * f10 + f9));
                            tessellator.func_78374_a((double)(f16 + 0.0f), (double)(f4 + 0.0f), (double)(f17 + (float)j1 + 1.0f - f13), (double)((f14 + 0.0f) * f10 + f8), (double)((f15 + (float)j1 + 0.5f) * f10 + f9));
                        }
                    }
                    tessellator.func_78381_a();
                }
            }
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2884);
    }
}

