/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World.Dimension;

import Reika.ChromatiCraft.Base.ChromaDimensionBiome;
import Reika.ChromatiCraft.Base.DimensionStructureGenerator;
import Reika.ChromatiCraft.Base.ThreadedGenerator;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.World.Dimension.ChromaDimensionManager;
import Reika.ChromatiCraft.World.Dimension.ChunkProviderChroma;
import Reika.ChromatiCraft.World.Dimension.RegionMapper;
import Reika.ChromatiCraft.World.Dimension.Structure.MonumentGenerator;
import Reika.ChromatiCraft.World.Dimension.ThreadedGenerators;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.Maps.CountMap;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Instantiable.Data.WeightedRandom;
import Reika.DragonAPI.Instantiable.Math.LobulatedCurve;
import Reika.DragonAPI.Libraries.IO.ReikaColorAPI;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaObfuscationHelper;
import Reika.DragonAPI.Libraries.ReikaDirectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import javax.imageio.ImageIO;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;

public class BiomeDistributor
extends ThreadedGenerator {
    private static final int SIZE = 4096;
    public static final int SCALE_FACTOR = 2;
    private static final double MIN_STRUCTURE_RADIUS = 96.0;
    private static final double MAX_STRUCTURE_RADIUS = 384.0;
    private static ChromaDimensionManager.ChromaDimensionBiomeType[][] biomes = new ChromaDimensionManager.ChromaDimensionBiomeType[4096][4096];
    private static LobulatedCurve monumentBlob;
    private static final EnumMap<CrystalElement, LobulatedCurve> structureBlobs;
    private final Collection<Spreader> spreaders = new ArrayList<Spreader>();
    private final MultiMap<ChromaDimensionManager.ChromaDimensionBiomeType, Point> blobLocations = new MultiMap((MultiMap.CollectionFactory)new MultiMap.ListFactory());

    public BiomeDistributor(long seed) {
        super(seed);
    }

    public static NBTTagList getDataForPacket() {
        int n = 8;
        NBTTagList tag = new NBTTagList();
        for (int i = 0; i < 4096; i += n) {
            for (int k = 0; k < 4096; k += n) {
                tag.func_74742_a((NBTBase)new NBTTagByte((byte)BiomeDistributor.biomes[i][k].getBiome().field_76756_M));
            }
        }
        return tag;
    }

    public static void fillFromPacket(NBTTagList tag) {
        int n = 8;
        for (int i = 0; i < 4096; i += n) {
            for (int k = 0; k < 4096; k += n) {
                int idx = (i * 4096 + k) / n;
                byte id = ((NBTTagByte)tag.field_74747_a.get(idx)).func_150290_f();
                BiomeDistributor.biomes[i][k] = ChromaDimensionManager.Biomes.getFromID(id);
            }
        }
    }

    public static ChromaDimensionBiome getBiome(int x, int z) {
        double d = ChunkProviderChroma.getDistanceToNearestStructureBlockCoords(x, z);
        if (d <= 384.0) {
            int dz;
            int dx;
            DimensionStructureGenerator.StructurePair p = ChunkProviderChroma.getNearestStructure(x, z);
            LobulatedCurve map = monumentBlob;
            if (p != null) {
                map = structureBlobs.get((Object)p.color);
            }
            if (map.isPointInsideCurve((double)(dx = x - p.generator.getEntryPosX()), (double)(dz = z - p.generator.getEntryPosZ()))) {
                return ChromaDimensionManager.Biomes.STRUCTURE.getBiome();
            }
        }
        if (RegionMapper.isPointInCentralRegion(x, z)) {
            return ChromaDimensionManager.Biomes.CENTER.getBiome();
        }
        return BiomeDistributor.getAdj(x / 2, z / 2, 0, 0).getBiome();
    }

    @Override
    public void run() throws Throwable {
        biomes = new ChromaDimensionManager.ChromaDimensionBiomeType[4096][4096];
        monumentBlob = null;
        structureBlobs.clear();
        this.distributeDots();
        this.spreadDots();
        boolean flag = this.fillEmptySpaces();
        while (flag) {
            flag = this.fillEmptySpaces();
        }
        this.featherEdges();
        this.addInternalBiomes();
        this.addStructureBiomes();
        if (DragonAPICore.isReikasComputer() && ReikaObfuscationHelper.isDeObfEnvironment() || DragonAPICore.debugtest) {
            String sg = "CHROMATICRAFT: Biome map: " + this.blobLocations;
            ReikaJavaLibrary.pConsole((Object)sg);
        }
        ChunkProviderChroma.finishGeneration(ThreadedGenerators.BIOME);
    }

    private void addInternalBiomes() {
        for (int i = 0; i < ChromaDimensionManager.Biomes.biomeList.length; ++i) {
            ChromaDimensionManager.Biomes b = ChromaDimensionManager.Biomes.biomeList[i];
            ChromaDimensionManager.SubBiomes s = b.getSubBiome();
            if (s == null) continue;
            Collection c = this.blobLocations.get((Object)b);
            for (Point p : c) {
                if (!(this.rand.nextDouble() < s.spawnWeight)) continue;
                int dx = BiomeDistributor.getAdj(p.x, this.rand.nextInt(33) - 16);
                int dz = BiomeDistributor.getAdj(p.y, this.rand.nextInt(33) - 16);
                for (int tries = 0; biomes[dx][dz] != b && tries < 200; ++tries) {
                    dx = BiomeDistributor.getAdj(p.x, this.rand.nextInt(33) - 16);
                    dz = BiomeDistributor.getAdj(p.y, this.rand.nextInt(33) - 16);
                }
                if (biomes[dx][dz] != b) continue;
                double f = 0.25 + this.rand.nextDouble() * 0.5;
                this.placeBlob(s, dx, dz, f, b);
            }
        }
    }

    private void addStructureBiomes() throws InterruptedException {
        boolean printed = false;
        while (!ChunkProviderChroma.isGeneratorReady(ThreadedGenerators.STRUCTURE)) {
            Thread.sleep(100L);
            if (!printed) {
                ChromatiCraft.logger.log((Object)"Waiting for structure generator to finish to place relevant biomes...");
            }
            printed = true;
        }
        for (DimensionStructureGenerator.StructurePair p : ChunkProviderChroma.getStructures()) {
            LobulatedCurve c = LobulatedCurve.fromMinMaxRadii((double)96.0, (double)384.0, (int)12).generate(this.rand);
            structureBlobs.put(p.color, c);
        }
        MonumentGenerator gen = ChunkProviderChroma.getMonumentGenerator();
        monumentBlob = LobulatedCurve.fromMinMaxRadii((double)96.0, (double)384.0, (int)12).generate(this.rand);
    }

    private void distributeDots() {
        for (int i = 0; i < ChromaDimensionManager.Biomes.biomeList.length; ++i) {
            ChromaDimensionManager.Biomes b = ChromaDimensionManager.Biomes.biomeList[i];
            for (int k = 0; k < b.spawnWeight; ++k) {
                int dx = this.rand.nextInt(4096);
                int dz = this.rand.nextInt(4096);
                while (biomes[dx][dz] != null) {
                    dx = this.rand.nextInt(4096);
                    dz = this.rand.nextInt(4096);
                }
                this.placeBlob(b, dx, dz, 1.0, null);
            }
        }
    }

    private void placeBlob(ChromaDimensionManager.ChromaDimensionBiomeType b, int dx, int dz, double f, ChromaDimensionManager.ChromaDimensionBiomeType over) {
        this.blobLocations.addValue((Object)b, (Object)new Point(dx, dz));
        double da = 0.5;
        LobulatedCurve c = new LobulatedCurve(384.0 * (f *= 1.0), 48.0 * f, 6, da).generate(this.rand);
        for (double d = 0.0; d < 360.0; d += da) {
            double r = c.getRadius(d);
            r += f * (double)(this.rand.nextInt(9) + this.rand.nextInt(9) + this.rand.nextInt(9));
            for (double dr = 0.0; dr <= r; dr += 0.5) {
                double ax = (double)dx + dr * Math.cos(Math.toRadians(d));
                double az = (double)dz + dr * Math.sin(Math.toRadians(d));
                int x = MathHelper.func_76128_c((double)ax);
                int z = MathHelper.func_76128_c((double)az);
                BiomeDistributor.paint(x, z, b, 2, over);
            }
        }
    }

    private void spreadDots() {
        while (!this.spreaders.isEmpty()) {
            Iterator<Spreader> it = this.spreaders.iterator();
            while (it.hasNext()) {
                Spreader s = it.next();
                if (s.update()) continue;
                it.remove();
            }
        }
    }

    private boolean fillEmptySpaces() {
        ArrayList<Point> li = new ArrayList<Point>();
        for (int i = 0; i < 4096; ++i) {
            for (int k = 0; k < 4096; ++k) {
                if (biomes[i][k] != null) continue;
                li.add(new Point(i, k));
            }
        }
        if (!li.isEmpty()) {
            Collections.shuffle(li);
            for (Point p : li) {
                this.fillEmptySpace(p.x, p.y);
            }
            return true;
        }
        return false;
    }

    private void fillEmptySpace(int x, int z) {
        CountMap map = new CountMap();
        int r = 6;
        for (int i = -r; i <= r; ++i) {
            for (int k = -r; k <= r; ++k) {
                ChromaDimensionManager.ChromaDimensionBiomeType b = BiomeDistributor.getAdj(x, z, i, k);
                if (b == null) continue;
                map.increment((Object)b);
            }
        }
        if (!map.isEmpty()) {
            WeightedRandom w = map.asWeightedRandom();
            ChromaDimensionManager.ChromaDimensionBiomeType b = (ChromaDimensionManager.ChromaDimensionBiomeType)w.getRandomEntry();
            BiomeDistributor.paint(x, z, b, 4, null);
        }
    }

    private void featherEdges() {
        for (int i = 0; i < 4096; ++i) {
            for (int k = 0; k < 4096; ++k) {
                ChromaDimensionManager.ChromaDimensionBiomeType b = biomes[i][k];
                ChromaDimensionManager.ChromaDimensionBiomeType bb = null;
                boolean flag = true;
                for (int d = 2; d < 6; ++d) {
                    ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[d];
                    ChromaDimensionManager.ChromaDimensionBiomeType b2 = BiomeDistributor.getAdj(i, k, dir.offsetX, dir.offsetZ);
                    if (b == b2) {
                        flag = false;
                        break;
                    }
                    bb = b2;
                }
                if (!flag) continue;
                BiomeDistributor.biomes[i][k] = bb;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void createImage(String phase) throws IOException {
        File f = new File(DragonAPICore.getMinecraftDirectory(), "DimensionMap/" + this.seed + "L/" + System.nanoTime() + "_" + phase + ".png");
        if (f.exists()) {
            f.delete();
        }
        f.getParentFile().mkdirs();
        f.createNewFile();
        BufferedImage img = new BufferedImage(biomes.length, biomes.length, 2);
        for (int i = 0; i < biomes.length; ++i) {
            for (int k = 0; k < biomes[i].length; ++k) {
                int color;
                ChromaDimensionManager.ChromaDimensionBiomeType b;
                ChromaDimensionManager.ChromaDimensionBiomeType o = b = biomes[i][k];
                if (b instanceof ChromaDimensionManager.SubBiomes) {
                    b = ((ChromaDimensionManager.SubBiomes)b).getParent();
                }
                int n = color = b != null ? 0xFF000000 | Color.HSBtoRGB((float)((ChromaDimensionManager.Biomes)b).ordinal() / (float)ChromaDimensionManager.Biomes.biomeList.length, 1.0f, 1.0f) : -1;
                if (o instanceof ChromaDimensionManager.SubBiomes) {
                    color = ReikaColorAPI.getColorWithBrightnessMultiplier((int)color, (float)0.67f);
                }
                if (o == ChromaDimensionManager.Biomes.STRUCTURE) {
                    color = 0x606060;
                }
                img.setRGB(i, k, color);
            }
        }
        ImageIO.write((RenderedImage)img, "png", f);
    }

    private static ChromaDimensionManager.ChromaDimensionBiomeType getAdj(int x, int z, int dx, int dz) {
        return biomes[BiomeDistributor.getAdj(x, dx)][BiomeDistributor.getAdj(z, dz)];
    }

    private static void setAdj(int x, int z, int dx, int dz, ChromaDimensionManager.ChromaDimensionBiomeType b) {
        BiomeDistributor.biomes[BiomeDistributor.getAdj((int)x, (int)dx)][BiomeDistributor.getAdj((int)z, (int)dz)] = b;
    }

    private static int getAdj(int p, int d) {
        return (4096 + (p + d) % 4096) % 4096;
    }

    private static void paint(int x, int z, ChromaDimensionManager.ChromaDimensionBiomeType b, int r, ChromaDimensionManager.ChromaDimensionBiomeType over) {
        for (int i = -r; i <= r; ++i) {
            for (int k = -r; k <= r; ++k) {
                if (i * i + k * k > r * r || BiomeDistributor.getAdj(x, z, i, k) != over) continue;
                BiomeDistributor.setAdj(x, z, i, k, b);
            }
        }
    }

    @Override
    public String getStateMessage() {
        return "Biome array populated, 4096x4096 with " + this.blobLocations.totalSize() + " biome patches of " + this.blobLocations.keySet().size() + " types.";
    }

    static {
        structureBlobs = new EnumMap(CrystalElement.class);
    }

    private class Spreader {
        private final ChromaDimensionManager.ChromaDimensionBiomeType biome;
        private ForgeDirection direction;
        private int posX;
        private int posZ;
        private int stepSize = 6;

        private Spreader(ChromaDimensionManager.ChromaDimensionBiomeType b, ForgeDirection dir, int x, int z) {
            this.biome = b;
            this.direction = dir;
            this.posX = x;
            this.posZ = z;
        }

        private boolean update() {
            ArrayList<ForgeDirection> li = this.getDirections();
            if (li.isEmpty()) {
                return false;
            }
            this.direction = this.randomizeDirection(li);
            this.posX = BiomeDistributor.getAdj(this.posX, this.direction.offsetX * this.stepSize);
            this.posZ = BiomeDistributor.getAdj(this.posZ, this.direction.offsetZ * this.stepSize);
            BiomeDistributor.paint(this.posX, this.posZ, this.biome, this.stepSize - 1, null);
            return true;
        }

        private ForgeDirection randomizeDirection(ArrayList<ForgeDirection> li) {
            if (BiomeDistributor.this.rand.nextInt(5) > 0 && li.contains(this.direction)) {
                return this.direction;
            }
            ForgeDirection left = ReikaDirectionHelper.getLeftBy90((ForgeDirection)this.direction);
            ForgeDirection right = ReikaDirectionHelper.getRightBy90((ForgeDirection)this.direction);
            if (BiomeDistributor.this.rand.nextBoolean() && li.contains(right)) {
                return right;
            }
            if (li.contains(left)) {
                return left;
            }
            return li.get(BiomeDistributor.this.rand.nextInt(li.size()));
        }

        private ArrayList<ForgeDirection> getDirections() {
            ArrayList<ForgeDirection> li = new ArrayList<ForgeDirection>();
            for (int i = 2; i < 6; ++i) {
                ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
                ChromaDimensionManager.ChromaDimensionBiomeType b = BiomeDistributor.getAdj(this.posX, this.posZ, dir.offsetX * this.stepSize, dir.offsetZ * this.stepSize);
                if (b != null) continue;
                li.add(dir);
            }
            return li;
        }
    }
}

