/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.World;

import Reika.ChromatiCraft.Entity.EntityBallLightning;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaOptions;
import Reika.ChromatiCraft.World.RainbowForestDecorator;
import Reika.DragonAPI.Instantiable.Worldgen.ModSpawnEntry;
import Reika.DragonAPI.Libraries.IO.ReikaColorAPI;
import Reika.DragonAPI.Libraries.Registry.ReikaDyeHelper;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import Reika.DragonAPI.ModList;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.biome.BiomeGenBase;

public class BiomeRainbowForest
extends BiomeGenBase {
    private final Random rand = new Random();
    public final int waterColor = new Color(0, 255, 255).getRGB();
    public final int skyColor = new Color(100, 140, 255).getRGB();
    private final int waterColorDamaged = new Color(64, 64, 64).getRGB();
    private final int skyColorDamaged = new Color(32, 48, 64).getRGB();
    private static final ArrayList<ModSpawnEntry> classes = new ArrayList();
    private static final ArrayList<ModSpawnEntry> caveClasses = new ArrayList();
    private static final ArrayList<ModSpawnEntry> monsterClasses = new ArrayList();

    public BiomeRainbowForest(int id) {
        super(id);
        this.func_76739_b(0xFF00FF);
        this.func_76735_a("Rainbow Forest");
        this.func_76733_a(5159473);
        this.func_76732_a(0.7f, 0.8f);
        this.initSpawnRules();
    }

    private void initSpawnRules() {
        this.field_76761_J.clear();
        this.field_76762_K.clear();
        this.field_82914_M.clear();
        this.field_76755_L.clear();
        this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntitySlime.class, 8, 4, 4));
        this.field_76762_K.add(new BiomeGenBase.SpawnListEntry(EntityWolf.class, 3, 4, 4));
        this.field_76762_K.add(new BiomeGenBase.SpawnListEntry(EntitySheep.class, 6, 4, 4));
        this.field_76762_K.add(new BiomeGenBase.SpawnListEntry(EntityPig.class, 7, 4, 4));
        this.field_76762_K.add(new BiomeGenBase.SpawnListEntry(EntityChicken.class, 6, 4, 4));
        this.field_76762_K.add(new BiomeGenBase.SpawnListEntry(EntityCow.class, 6, 4, 4));
        this.field_76762_K.add(new BiomeGenBase.SpawnListEntry(EntityHorse.class, 3, 1, 3));
        this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityBallLightning.class, 5, 1, 1));
        this.field_76755_L.add(new BiomeGenBase.SpawnListEntry(EntitySquid.class, 10, 4, 4));
        this.addModEntities();
    }

    private void addModEntities() {
        ModSpawnEntry mc;
        int i;
        for (i = 0; i < classes.size(); ++i) {
            mc = classes.get(i);
            if (!mc.isLoadable()) continue;
            this.field_76762_K.add(mc.getEntry());
        }
        for (i = 0; i < caveClasses.size(); ++i) {
            mc = caveClasses.get(i);
            if (!mc.isLoadable()) continue;
            this.field_82914_M.add(mc.getEntry());
        }
        for (i = 0; i < monsterClasses.size(); ++i) {
            mc = monsterClasses.get(i);
            if (!mc.isLoadable()) continue;
            this.field_76761_J.add(mc.getEntry());
        }
    }

    public float func_150564_a(int x, int y, int z) {
        float base = super.func_150564_a(x, y, z);
        float min = 0.125f;
        if (y > 127) {
            base -= (float)(y - 127) / 127.0f * base;
        }
        if (y > 191) {
            base = 0.15f + 0.025f * (float)(y - 255) / 64.0f;
        }
        if (y >= 255) {
            base = 0.1f;
        }
        return Math.max(base, min);
    }

    public BiomeDecorator func_76729_a() {
        return new RainbowForestDecorator();
    }

    @SideOnly(value=Side.CLIENT)
    public int getModdedBiomeGrassColor(int original) {
        Color c = ReikaDyeHelper.dyes[this.rand.nextInt(16)].getJavaColor();
        double bias = 5.0E-4;
        double d = 1.0 - bias;
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        int r2 = ReikaColorAPI.getRed((int)original);
        int g2 = ReikaColorAPI.getGreen((int)original);
        int b2 = ReikaColorAPI.getBlue((int)original);
        return new Color((int)((double)r2 * d + bias * (double)r), (int)((double)g2 * d + bias * (double)g), (int)((double)b2 * d + bias * (double)b)).getRGB();
    }

    public int func_150558_b(int x, int y, int z) {
        int original = BiomeGenBase.field_76767_f.func_150558_b(x, y, z);
        Color c = ReikaDyeHelper.dyes[(Math.abs(x / 16) + y + Math.abs(z / 16)) % 16].getJavaColor().brighter();
        double bias = BiomeRainbowForest.isDamaged(null, x, z) ? 0.5 : 9.5E-4;
        double d = 1.0 - bias;
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        int r2 = ReikaColorAPI.getRed((int)original);
        int g2 = ReikaColorAPI.getGreen((int)original);
        int b2 = ReikaColorAPI.getBlue((int)original);
        return new Color((int)((double)r2 * d + bias * (double)r), (int)((double)g2 * d + bias * (double)g), (int)((double)b2 * d + bias * (double)b)).getRGB();
    }

    public float func_76741_f() {
        return 0.1f * (float)Math.max(1, ChromaOptions.ANIMALSPAWN.getValue());
    }

    public int func_76731_a(float par1) {
        return BiomeRainbowForest.isDamaged(null, 0, 0) ? this.skyColorDamaged : this.skyColor;
    }

    public int getWaterColorMultiplier() {
        return BiomeRainbowForest.isDamaged(null, 0, 0) ? this.waterColorDamaged : this.waterColor;
    }

    public void plantFlower(World world, Random rand, int x, int y, int z) {
        if (rand.nextInt(8) > 0 && ChromaBlocks.DYEFLOWER.getBlockInstance().func_149718_j(world, x, y, z)) {
            int meta = rand.nextInt(16);
            world.func_147465_d(x, y, z, ChromaBlocks.DYEFLOWER.getBlockInstance(), meta, 3);
        } else {
            super.plantFlower(world, rand, x, y, z);
        }
    }

    public static boolean isMobAllowed(EntityLivingBase e) {
        if (e instanceof EntityBallLightning) {
            return true;
        }
        if (e instanceof EntitySlime) {
            EntitySlime es = (EntitySlime)e;
            return es.func_70809_q() <= 1;
        }
        if (ModList.THAUMCRAFT.isLoaded() && e.getClass().getSimpleName().equalsIgnoreCase("EntityWisp")) {
            return true;
        }
        return !ReikaEntityHelper.isHostile((EntityLivingBase)e);
    }

    public static boolean isDamaged(IBlockAccess world, int x, int z) {
        return false;
    }

    static {
        classes.add(new ModSpawnEntry(ModList.TWILIGHT, "twilightforest.entity.passive.EntityTFBighorn", 3, 1, 3));
        classes.add(new ModSpawnEntry(ModList.TWILIGHT, "twilightforest.entity.passive.EntityTFBunny", 4, 1, 2));
        classes.add(new ModSpawnEntry(ModList.TWILIGHT, "twilightforest.entity.passive.EntityTFDeer", 1, 1, 8));
        classes.add(new ModSpawnEntry(ModList.TWILIGHT, "twilightforest.entity.passive.EntityTFRaven", 3, 1, 1));
        classes.add(new ModSpawnEntry(ModList.TWILIGHT, "twilightforest.entity.passive.EntityTFSquirrel", 5, 1, 2));
        classes.add(new ModSpawnEntry(ModList.TWILIGHT, "twilightforest.entity.passive.EntityTFTinyBird", 10, 1, 4));
        caveClasses.add(new ModSpawnEntry(ModList.TWILIGHT, "twilightforest.entity.passive.EntityTFMobileFirefly", 20, 1, 1));
        monsterClasses.add(new ModSpawnEntry(ModList.THAUMCRAFT, "thaumcraft.common.entities.monster.EntityWisp", 5, 1, 1));
    }
}

