/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.Transport;

import Reika.ChromatiCraft.API.Interfaces.WorldRift;
import Reika.ChromatiCraft.Auxiliary.Interfaces.LinkedTile;
import Reika.ChromatiCraft.Base.TileEntity.LinkedTileBase;
import Reika.ChromatiCraft.Registry.ChromaOptions;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.DragonAPI.ASM.APIStripper;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.ASM.InterfaceInjector;
import Reika.DragonAPI.Auxiliary.ChunkManager;
import Reika.DragonAPI.Base.TileEntityBase;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Interfaces.TileEntity.ChunkLoadingTile;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.ModList;
import cofh.api.energy.IEnergyHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.awt.Color;
import java.util.Collection;
import java.util.List;
import li.cil.oc.api.Network;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.Visibility;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.api.aspects.IEssentiaTransport;
import vazkii.botania.api.internal.IManaBurst;
import vazkii.botania.api.mana.IManaCollisionGhost;
import vazkii.botania.api.mana.IManaReceiver;

@APIStripper.Strippable(value={"cofh.api.energy.IEnergyHandler", "thaumcraft.api.aspects.IEssentiaTransport", "thaumcraft.api.aspects.IAspectContainer", "vazkii.botania.api.mana.IManaCollisionGhost", "vazkii.botania.api.mana.IManaReceiver"})
@InterfaceInjector.Injectable(value={"dan200.computercraft.api.peripheral.IPeripheral", "li.cil.oc.api.network.Environment", "li.cil.oc.api.network.ManagedPeripheral", "li.cil.oc.api.network.SidedEnvironment"})
public class TileEntityRift
extends LinkedTileBase
implements WorldRift,
IFluidHandler,
IEnergyHandler,
IEssentiaTransport,
IAspectContainer,
ISidedInventory,
ChunkLoadingTile,
IManaCollisionGhost,
IManaReceiver {
    private int color = 0xFFFFFF;
    private int[] redstoneCache = new int[6];
    private ForgeDirection singleDirection;
    private final Object[] sidedOCNode = new Object[6];

    public TileEntityRift() {
        if (ModList.OPENCOMPUTERS.isLoaded() && FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            for (int i = 0; i < 6; ++i) {
                this.sidedOCNode[i] = Network.newNode((Environment)((Environment)this), (Visibility)Visibility.Network).create();
            }
        }
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.RIFT;
    }

    @Override
    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateEntity(world, x, y, z, meta);
        if (!world.field_72995_K && this.isLinked() && this.getOther() != null) {
            AxisAlignedBB box = ReikaAABBHelper.getBlockAABB((int)x, (int)y, (int)z);
            List li = world.func_72872_a(Entity.class, box);
            for (Entity e : li) {
                if (!this.shouldTeleport(e)) continue;
                this.teleport(e);
            }
        }
    }

    private void teleport(Entity e) {
        double rx = 1.0 - (e.field_70165_t - (double)this.field_145851_c);
        double ry = 1.0 - (e.field_70163_u - (double)this.field_145848_d);
        double rz = 1.0 - (e.field_70161_v - (double)this.field_145849_e);
        TileEntityRift te = this.getOther();
        if (ModList.BOTANIA.isLoaded() && e instanceof IManaBurst) {
            IManaBurst b = (IManaBurst)e;
            b.setColor(this.color);
            b.setBurstSourceCoords(te.field_145851_c, te.field_145848_d, te.field_145849_e);
            b.setMana(b.getStartingMana());
            ReikaSoundHelper.playSoundAtBlock((World)this.field_145850_b, (int)te.field_145851_c, (int)te.field_145848_d, (int)te.field_145849_e, (String)"botania:spreaderFire", (float)0.5f, (float)((float)ReikaRandomHelper.getRandomPlusMinus((double)1.0, (double)0.25)));
        }
        e.func_70012_b((double)te.field_145851_c + rx, (double)te.field_145848_d + ry, (double)te.field_145849_e + rz, e.field_70177_z, e.field_70125_A);
        e.getEntityData().func_74772_a("rift_teleported", this.field_145850_b.func_82737_E());
    }

    private boolean shouldTeleport(Entity e) {
        long get = e.getEntityData().func_74763_f("rift_teleported");
        if (this.field_145850_b.func_82737_E() - get < 5L) {
            return false;
        }
        return ModList.BOTANIA.isLoaded() && e instanceof IManaBurst;
    }

    protected void onFirstTick(World world, int x, int y, int z) {
        if (ChromaOptions.RIFTLOAD.getState()) {
            ChunkManager.instance.loadChunks((ChunkLoadingTile)this);
        }
    }

    public void setDirection(ForgeDirection dir) {
        if (this.isLinked() && this.getOther() != null) {
            this.singleDirection = dir;
            this.getOther().singleDirection = dir.getOpposite();
        }
    }

    public ForgeDirection getSingleDirection() {
        return this.singleDirection;
    }

    @Override
    public boolean canDrop(EntityPlayer ep) {
        return ep.func_110124_au().equals(this.placerUUID);
    }

    public void passThrough() {
        if (this.isLinked()) {
            WorldLocation loc = this.getLinkTarget();
            TileEntityRift te = this.getOther();
            if (te != null) {
                for (int i = 0; i < 6; ++i) {
                    TileEntity tile;
                    int pwr;
                    ForgeDirection dir = this.dirs[i];
                    ForgeDirection opp = dir.getOpposite();
                    int dx = loc.xCoord + dir.offsetX;
                    int dy = loc.yCoord + dir.offsetY;
                    int dz = loc.zCoord + dir.offsetZ;
                    int ddx = this.field_145851_c - dir.offsetX;
                    int ddy = this.field_145848_d - dir.offsetY;
                    int ddz = this.field_145849_e - dir.offsetZ;
                    Block id = this.field_145850_b.func_147439_a(dx, dy, dz);
                    Block id2 = this.field_145850_b.func_147439_a(ddx, ddy, ddz);
                    te.redstoneCache[i] = pwr = this.field_145850_b.func_72878_l(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ, opp.ordinal());
                    if (id != Blocks.field_150350_a) {
                        id.func_149695_a(this.field_145850_b, dx, dy, dz, id);
                    }
                    if ((tile = this.getAdjacentTileEntity(dir)) == this || !(tile instanceof TileEntityBase)) continue;
                    ((TileEntityBase)tile).updateCache(dir.getOpposite());
                }
            }
            loc.triggerBlockUpdate(true);
        }
    }

    public int getRedstoneLevel(ForgeDirection side) {
        return Math.max(this.redstoneCache[side.ordinal()] - 1, 0);
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    protected void createRandomLinkID() {
        this.color = this.getRandomColor();
    }

    @Override
    public void assignLinkID(LinkedTile other) {
        TileEntityRift te = (TileEntityRift)other;
        this.color = te.color;
    }

    @Override
    protected void onLinkTo(World world, int x, int y, int z, LinkedTile tile) {
        TileEntityRift te = (TileEntityRift)tile;
        if (ModList.OPENCOMPUTERS.isLoaded() && !world.field_72995_K) {
            for (int i = 0; i < 6; ++i) {
                if (this.sidedOCNode[i] == null || te.sidedOCNode[i] == null) continue;
                ((Node)te.sidedOCNode[this.dirs[i].getOpposite().ordinal()]).connect((Node)this.sidedOCNode[i]);
            }
        }
    }

    @Override
    protected void onReset() {
        TileEntityRift te;
        this.color = 0xFFFFFF;
        this.redstoneCache = new int[6];
        this.singleDirection = null;
        if (ModList.OPENCOMPUTERS.isLoaded() && !this.field_145850_b.field_72995_K && (te = this.getOther()) != null) {
            for (int i = 0; i < 6; ++i) {
                if (this.sidedOCNode[i] == null || te.sidedOCNode[i] == null) continue;
                ((Node)this.sidedOCNode[i]).disconnect((Node)te.sidedOCNode[i]);
            }
        }
    }

    @Override
    protected void onResetOther(LinkedTile tile) {
        TileEntityRift te = (TileEntityRift)tile;
        te.color = 0xFFFFFF;
        if (ModList.OPENCOMPUTERS.isLoaded() && !this.field_145850_b.field_72995_K) {
            for (int i = 0; i < 6; ++i) {
                if (this.sidedOCNode[i] == null || te.sidedOCNode[i] == null) continue;
                ((Node)te.sidedOCNode[i]).disconnect((Node)this.sidedOCNode[i]);
            }
        }
    }

    public int getColor() {
        return this.isInWorld() ? this.color : Color.HSBtoRGB((float)(System.currentTimeMillis() % 15000L) / 15000.0f, 1.0f, 1.0f);
    }

    private int getRandomColor() {
        return Color.HSBtoRGB(rand.nextFloat(), 1.0f, 1.0f);
    }

    @Override
    public boolean canLinkTo(World world, int x, int y, int z) {
        return ChromaTiles.getTile((IBlockAccess)world, x, y, z) == this.getTile();
    }

    public TileEntityRift getOther() {
        return this.isLinked() ? (TileEntityRift)this.getLinkTarget().getTileEntity() : null;
    }

    public WorldLocation getBlockFrom(ForgeDirection from) {
        return this.isLinked() ? this.getLinkTarget().move(from.getOpposite(), 1) : null;
    }

    private TileEntity getAdjacentTargetTile(ForgeDirection dir) {
        return this.isLinked() && this.getOther() != null ? this.getOther().getAdjacentTileEntity(dir) : null;
    }

    private TileEntity getSingleDirTile() {
        return this.singleDirection != null && this.isLinked() ? this.getOther().getAdjacentTileEntity(this.singleDirection.getOpposite()) : null;
    }

    @Override
    public Block getBlockIDFrom(ForgeDirection dir) {
        return this.isLinked() ? this.getBlockFrom(dir).getBlock() : null;
    }

    @Override
    public int getBlockMetadataFrom(ForgeDirection dir) {
        return this.isLinked() ? this.getBlockFrom(dir).getBlockMetadata() : -1;
    }

    @Override
    public TileEntity getTileEntityFrom(ForgeDirection dir) {
        return this.isLinked() ? this.getAdjacentTargetTile(dir) : null;
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("color", this.color);
        NBT.func_74783_a("redstone", this.redstoneCache);
        NBT.func_74768_a("dir", this.singleDirection != null ? this.singleDirection.ordinal() : -1);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.color = NBT.func_74762_e("color");
        this.redstoneCache = NBT.func_74759_k("redstone");
        int dir = NBT.func_74762_e("dir");
        this.singleDirection = dir != -1 ? this.dirs[dir] : null;
    }

    @DependentMethodStripper.ModDependent(value=ModList.THAUMCRAFT)
    public boolean isConnectable(ForgeDirection face) {
        if (this.getOther() != null && this.getAdjacentTargetTile(face.getOpposite()) instanceof IEssentiaTransport) {
            return ((IEssentiaTransport)this.getAdjacentTargetTile(face.getOpposite())).isConnectable(face);
        }
        return false;
    }

    @DependentMethodStripper.ModDependent(value=ModList.THAUMCRAFT)
    public boolean canInputFrom(ForgeDirection face) {
        if (this.getOther() != null && this.getAdjacentTargetTile(face.getOpposite()) instanceof IEssentiaTransport) {
            return ((IEssentiaTransport)this.getAdjacentTargetTile(face.getOpposite())).canInputFrom(face);
        }
        return false;
    }

    @DependentMethodStripper.ModDependent(value=ModList.THAUMCRAFT)
    public boolean canOutputTo(ForgeDirection face) {
        if (this.getOther() != null && this.getAdjacentTargetTile(face.getOpposite()) instanceof IEssentiaTransport) {
            return ((IEssentiaTransport)this.getAdjacentTargetTile(face.getOpposite())).canOutputTo(face);
        }
        return false;
    }

    @DependentMethodStripper.ModDependent(value=ModList.THAUMCRAFT)
    public void setSuction(Aspect aspect, int amount) {
        if (this.getOther() != null && this.getSingleDirTile() instanceof IEssentiaTransport) {
            ((IEssentiaTransport)this.getSingleDirTile()).setSuction(aspect, amount);
        }
    }

    @DependentMethodStripper.ModDependent(value=ModList.THAUMCRAFT)
    public Aspect getSuctionType(ForgeDirection face) {
        if (this.getOther() != null && this.getAdjacentTargetTile(face.getOpposite()) instanceof IEssentiaTransport) {
            return ((IEssentiaTransport)this.getAdjacentTargetTile(face.getOpposite())).getSuctionType(face);
        }
        return null;
    }

    @DependentMethodStripper.ModDependent(value=ModList.THAUMCRAFT)
    public int getSuctionAmount(ForgeDirection face) {
        if (this.getOther() != null && this.getAdjacentTargetTile(face.getOpposite()) instanceof IEssentiaTransport) {
            return ((IEssentiaTransport)this.getAdjacentTargetTile(face.getOpposite())).getSuctionAmount(face);
        }
        return 0;
    }

    @DependentMethodStripper.ModDependent(value=ModList.THAUMCRAFT)
    public int takeEssentia(Aspect aspect, int amount, ForgeDirection face) {
        if (this.getOther() != null && this.getAdjacentTargetTile(face.getOpposite()) instanceof IEssentiaTransport) {
            return ((IEssentiaTransport)this.getAdjacentTargetTile(face.getOpposite())).takeEssentia(aspect, amount, face);
        }
        return 0;
    }

    @DependentMethodStripper.ModDependent(value=ModList.THAUMCRAFT)
    public int addEssentia(Aspect aspect, int amount, ForgeDirection face) {
        if (this.getOther() != null && this.getAdjacentTargetTile(face.getOpposite()) instanceof IEssentiaTransport) {
            return ((IEssentiaTransport)this.getAdjacentTargetTile(face.getOpposite())).addEssentia(aspect, amount, face);
        }
        return 0;
    }

    @DependentMethodStripper.ModDependent(value=ModList.THAUMCRAFT)
    public Aspect getEssentiaType(ForgeDirection face) {
        if (this.getOther() != null && this.getAdjacentTargetTile(face.getOpposite()) instanceof IEssentiaTransport) {
            return ((IEssentiaTransport)this.getAdjacentTargetTile(face.getOpposite())).getEssentiaType(face);
        }
        return null;
    }

    @DependentMethodStripper.ModDependent(value=ModList.THAUMCRAFT)
    public int getEssentiaAmount(ForgeDirection face) {
        if (this.getOther() != null && this.getAdjacentTargetTile(face.getOpposite()) instanceof IEssentiaTransport) {
            return ((IEssentiaTransport)this.getAdjacentTargetTile(face.getOpposite())).getEssentiaAmount(face);
        }
        return 0;
    }

    @DependentMethodStripper.ModDependent(value=ModList.THAUMCRAFT)
    public int getMinimumSuction() {
        if (this.getOther() != null && this.getSingleDirTile() instanceof IEssentiaTransport) {
            return ((IEssentiaTransport)this.getSingleDirTile()).getMinimumSuction();
        }
        return 0;
    }

    @DependentMethodStripper.ModDependent(value=ModList.THAUMCRAFT)
    public boolean renderExtendedTube() {
        return false;
    }

    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (this.getOther() != null && this.getAdjacentTargetTile(from.getOpposite()) instanceof IEnergyHandler) {
            return ((IEnergyHandler)this.getAdjacentTargetTile(from.getOpposite())).receiveEnergy(from, maxReceive, simulate);
        }
        return 0;
    }

    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        if (this.getOther() != null && this.getAdjacentTargetTile(from.getOpposite()) instanceof IEnergyHandler) {
            return ((IEnergyHandler)this.getAdjacentTargetTile(from.getOpposite())).extractEnergy(from, maxExtract, simulate);
        }
        return 0;
    }

    public boolean canConnectEnergy(ForgeDirection from) {
        if (this.getOther() != null && this.getAdjacentTargetTile(from.getOpposite()) instanceof IEnergyHandler) {
            return ((IEnergyHandler)this.getAdjacentTargetTile(from.getOpposite())).canConnectEnergy(from);
        }
        return false;
    }

    public int getEnergyStored(ForgeDirection from) {
        if (this.getOther() != null && this.getAdjacentTargetTile(from.getOpposite()) instanceof IEnergyHandler) {
            return ((IEnergyHandler)this.getAdjacentTargetTile(from.getOpposite())).getEnergyStored(from);
        }
        return 0;
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        if (this.getOther() != null && this.getAdjacentTargetTile(from.getOpposite()) instanceof IEnergyHandler) {
            return ((IEnergyHandler)this.getAdjacentTargetTile(from.getOpposite())).getMaxEnergyStored(from);
        }
        return 0;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (this.getOther() != null && this.getAdjacentTargetTile(from.getOpposite()) instanceof IFluidHandler) {
            return ((IFluidHandler)this.getAdjacentTargetTile(from.getOpposite())).fill(from, resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (this.getOther() != null && this.getAdjacentTargetTile(from.getOpposite()) instanceof IFluidHandler) {
            return ((IFluidHandler)this.getAdjacentTargetTile(from.getOpposite())).drain(from, resource, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (this.getOther() != null && this.getAdjacentTargetTile(from.getOpposite()) instanceof IFluidHandler) {
            return ((IFluidHandler)this.getAdjacentTargetTile(from.getOpposite())).drain(from, maxDrain, doDrain);
        }
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        if (this.getOther() != null && this.getAdjacentTargetTile(from.getOpposite()) instanceof IFluidHandler) {
            return ((IFluidHandler)this.getAdjacentTargetTile(from.getOpposite())).canFill(from, fluid);
        }
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        if (this.getOther() != null && this.getAdjacentTargetTile(from.getOpposite()) instanceof IFluidHandler) {
            return ((IFluidHandler)this.getAdjacentTargetTile(from.getOpposite())).canDrain(from, fluid);
        }
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        if (this.getOther() != null && this.getAdjacentTargetTile(from.getOpposite()) instanceof IFluidHandler) {
            return ((IFluidHandler)this.getAdjacentTargetTile(from.getOpposite())).getTankInfo(from);
        }
        return null;
    }

    public int func_70302_i_() {
        if (this.getOther() != null && this.getSingleDirTile() instanceof IInventory) {
            return ((IInventory)this.getSingleDirTile()).func_70302_i_();
        }
        return 0;
    }

    public ItemStack func_70301_a(int i) {
        if (this.getOther() != null && this.getSingleDirTile() instanceof IInventory) {
            return ((IInventory)this.getSingleDirTile()).func_70301_a(i);
        }
        return null;
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.getOther() != null && this.getSingleDirTile() instanceof IInventory) {
            return ((IInventory)this.getSingleDirTile()).func_70298_a(i, j);
        }
        return null;
    }

    public ItemStack func_70304_b(int i) {
        if (this.getOther() != null && this.getSingleDirTile() instanceof IInventory) {
            return ((IInventory)this.getSingleDirTile()).func_70304_b(i);
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        if (this.getOther() != null && this.getSingleDirTile() instanceof IInventory) {
            ((IInventory)this.getSingleDirTile()).func_70299_a(i, itemstack);
        }
    }

    public String func_145825_b() {
        if (this.getOther() != null && this.getSingleDirTile() instanceof IInventory) {
            return ((IInventory)this.getSingleDirTile()).func_145825_b();
        }
        return null;
    }

    public boolean func_145818_k_() {
        if (this.getOther() != null && this.getSingleDirTile() instanceof IInventory) {
            return ((IInventory)this.getSingleDirTile()).func_145818_k_();
        }
        return false;
    }

    public int func_70297_j_() {
        if (this.getOther() != null && this.getSingleDirTile() instanceof IInventory) {
            return ((IInventory)this.getSingleDirTile()).func_70297_j_();
        }
        return 0;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        if (this.getOther() != null && this.getSingleDirTile() instanceof IInventory) {
            return ((IInventory)this.getSingleDirTile()).func_70300_a(entityplayer);
        }
        return false;
    }

    public void func_70295_k_() {
        if (this.getOther() != null && this.getSingleDirTile() instanceof IInventory) {
            ((IInventory)this.getSingleDirTile()).func_70295_k_();
        }
    }

    public void func_70305_f() {
        if (this.getOther() != null && this.getSingleDirTile() instanceof IInventory) {
            ((IInventory)this.getSingleDirTile()).func_70305_f();
        }
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        if (this.getOther() != null && this.getSingleDirTile() instanceof IInventory) {
            return ((IInventory)this.getSingleDirTile()).func_94041_b(i, itemstack);
        }
        return false;
    }

    public int[] func_94128_d(int var1) {
        if (this.getOther() != null) {
            if (this.getSingleDirTile() instanceof ISidedInventory) {
                return ((ISidedInventory)this.getSingleDirTile()).func_94128_d(var1);
            }
            if (this.getSingleDirTile() instanceof IInventory) {
                int size = ((IInventory)this.getSingleDirTile()).func_70302_i_();
                int[] sides = new int[size];
                for (int i = 0; i < size; ++i) {
                    sides[i] = i;
                }
                return sides;
            }
        }
        return new int[0];
    }

    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        if (this.getOther() != null) {
            if (this.getSingleDirTile() instanceof ISidedInventory) {
                return ((ISidedInventory)this.getSingleDirTile()).func_102007_a(i, itemstack, j);
            }
            if (this.getSingleDirTile() instanceof IInventory) {
                return ((IInventory)this.getSingleDirTile()).func_94041_b(i, itemstack);
            }
        }
        return false;
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        if (this.getOther() != null && this.getSingleDirTile() instanceof ISidedInventory) {
            return ((ISidedInventory)this.getSingleDirTile()).func_102008_b(i, itemstack, j);
        }
        return false;
    }

    @DependentMethodStripper.ModDependent(value=ModList.THAUMCRAFT)
    public AspectList getAspects() {
        if (this.getOther() != null && this.getSingleDirTile() instanceof IAspectContainer) {
            return ((IAspectContainer)this.getSingleDirTile()).getAspects();
        }
        return new AspectList();
    }

    @DependentMethodStripper.ModDependent(value=ModList.THAUMCRAFT)
    public void setAspects(AspectList aspects) {
        if (this.getOther() != null && this.getSingleDirTile() instanceof IAspectContainer) {
            ((IAspectContainer)this.getSingleDirTile()).setAspects(aspects);
        }
    }

    @DependentMethodStripper.ModDependent(value=ModList.THAUMCRAFT)
    public boolean doesContainerAccept(Aspect tag) {
        if (this.getOther() != null && this.getSingleDirTile() instanceof IAspectContainer) {
            return ((IAspectContainer)this.getSingleDirTile()).doesContainerAccept(tag);
        }
        return false;
    }

    @DependentMethodStripper.ModDependent(value=ModList.THAUMCRAFT)
    public int addToContainer(Aspect tag, int amount) {
        if (this.getOther() != null && this.getSingleDirTile() instanceof IAspectContainer) {
            return ((IAspectContainer)this.getSingleDirTile()).addToContainer(tag, amount);
        }
        return 0;
    }

    @DependentMethodStripper.ModDependent(value=ModList.THAUMCRAFT)
    public boolean takeFromContainer(Aspect tag, int amount) {
        if (this.getOther() != null && this.getSingleDirTile() instanceof IAspectContainer) {
            return ((IAspectContainer)this.getSingleDirTile()).takeFromContainer(tag, amount);
        }
        return false;
    }

    @DependentMethodStripper.ModDependent(value=ModList.THAUMCRAFT)
    public boolean takeFromContainer(AspectList ot) {
        if (this.getOther() != null && this.getSingleDirTile() instanceof IAspectContainer) {
            return ((IAspectContainer)this.getSingleDirTile()).takeFromContainer(ot);
        }
        return false;
    }

    @DependentMethodStripper.ModDependent(value=ModList.THAUMCRAFT)
    public boolean doesContainerContainAmount(Aspect tag, int amount) {
        if (this.getOther() != null && this.getSingleDirTile() instanceof IAspectContainer) {
            return ((IAspectContainer)this.getSingleDirTile()).doesContainerContainAmount(tag, amount);
        }
        return false;
    }

    @DependentMethodStripper.ModDependent(value=ModList.THAUMCRAFT)
    public boolean doesContainerContain(AspectList ot) {
        if (this.getOther() != null && this.getSingleDirTile() instanceof IAspectContainer) {
            return ((IAspectContainer)this.getSingleDirTile()).doesContainerContain(ot);
        }
        return false;
    }

    @DependentMethodStripper.ModDependent(value=ModList.THAUMCRAFT)
    public int containerContains(Aspect tag) {
        if (this.getOther() != null && this.getSingleDirTile() instanceof IAspectContainer) {
            return ((IAspectContainer)this.getSingleDirTile()).containerContains(tag);
        }
        return 0;
    }

    @DependentMethodStripper.ModDependent(value=ModList.COMPUTERCRAFT)
    public boolean equals(IPeripheral p) {
        if (this.getOther() != null && this.getSingleDirTile() instanceof IPeripheral) {
            return ((IPeripheral)this.getSingleDirTile()).equals(p);
        }
        return false;
    }

    @DependentMethodStripper.ModDependent(value=ModList.COMPUTERCRAFT)
    public String getType() {
        if (this.getOther() != null && this.getSingleDirTile() instanceof IPeripheral) {
            return ((IPeripheral)this.getSingleDirTile()).getType();
        }
        return "No connection";
    }

    @DependentMethodStripper.ModDependent(value=ModList.COMPUTERCRAFT)
    public String[] getMethodNames() {
        if (this.getOther() != null && this.getSingleDirTile() instanceof IPeripheral) {
            return ((IPeripheral)this.getSingleDirTile()).getMethodNames();
        }
        return new String[0];
    }

    @DependentMethodStripper.ModDependent(value=ModList.COMPUTERCRAFT)
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        if (this.getOther() != null && this.getSingleDirTile() instanceof IPeripheral) {
            return ((IPeripheral)this.getSingleDirTile()).callMethod(computer, context, method, arguments);
        }
        return null;
    }

    @DependentMethodStripper.ModDependent(value=ModList.COMPUTERCRAFT)
    public void attach(IComputerAccess computer) {
        if (this.getOther() != null && this.getSingleDirTile() instanceof IPeripheral) {
            ((IPeripheral)this.getSingleDirTile()).attach(computer);
        }
    }

    @DependentMethodStripper.ModDependent(value=ModList.COMPUTERCRAFT)
    public void detach(IComputerAccess computer) {
        if (this.getOther() != null && this.getSingleDirTile() instanceof IPeripheral) {
            ((IPeripheral)this.getSingleDirTile()).detach(computer);
        }
    }

    @DependentMethodStripper.ModDependent(value=ModList.OPENCOMPUTERS)
    public final void onConnect(Node node) {
        TileEntityRift te = this.getOther();
        if (te != null) {
            for (int i = 0; i < 6; ++i) {
                if (this.sidedOCNode[i] == null || this.sidedOCNode[i] != node || this.getOtherNode(te, i) == null) continue;
                ((Node)this.sidedOCNode[i]).connect(this.getOtherNode(te, i));
            }
        }
    }

    @DependentMethodStripper.ModDependent(value=ModList.OPENCOMPUTERS)
    private Node getOtherNode(TileEntityRift te, int side) {
        return (Node)te.sidedOCNode[this.dirs[side].getOpposite().ordinal()];
    }

    protected void onInvalidateOrUnload(World world, int x, int y, int z, boolean invalid) {
        if (ModList.OPENCOMPUTERS.isLoaded()) {
            for (int i = 0; i < 6; ++i) {
                if (this.sidedOCNode[i] == null) continue;
                ((Node)this.sidedOCNode[i]).remove();
            }
        }
    }

    public void breakBlock() {
        ChunkManager.instance.unloadChunks((TileEntity)this);
    }

    public Collection<ChunkCoordIntPair> getChunksToLoad() {
        return ChunkManager.getChunkSquare((int)this.field_145851_c, (int)this.field_145849_e, (int)2);
    }

    public int getCurrentMana() {
        return 0;
    }

    public boolean isGhost() {
        return false;
    }

    public boolean isFull() {
        return false;
    }

    public void recieveMana(int mana) {
    }

    public boolean canRecieveManaFromBursts() {
        return true;
    }

    @DependentMethodStripper.ModDependent(value=ModList.OPENCOMPUTERS)
    public Node sidedNode(ForgeDirection side) {
        return (Node)this.sidedOCNode[side.ordinal()];
    }

    @DependentMethodStripper.ModDependent(value=ModList.OPENCOMPUTERS)
    public boolean canConnect(ForgeDirection side) {
        return this.isLinked();
    }
}

