/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.Transport;

import Reika.ChromatiCraft.Base.TileEntity.TileEntityAreaDistributor;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Render.Particle.EntityBlurFX;
import Reika.ChromatiCraft.TileEntity.Transport.TileEntityRift;
import Reika.DragonAPI.ASM.APIStripper;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyReceiver;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@APIStripper.Strippable(value={"cofh.api.energy.IEnergyReceiver", "cofh.api.energy.IEnergyHandler"})
public class TileEntityRFDistributor
extends TileEntityAreaDistributor
implements IEnergyReceiver,
IEnergyHandler {
    private static final HashSet<Class> blacklist = new HashSet();

    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (this.hasRedstoneSignal()) {
            return 0;
        }
        this.addInput(new WorldLocation((TileEntity)this).move(from, 1));
        return this.tryDistributeEnergy(maxReceive, simulate);
    }

    private int tryDistributeEnergy(int maxReceive, boolean simulate) {
        int add = 0;
        Iterator<WorldLocation> it = this.getTargets();
        while (it.hasNext()) {
            WorldLocation loc = it.next();
            TileEntity te = loc.getTileEntity();
            if (te instanceof IEnergyReceiver || te instanceof IEnergyHandler) {
                int give = this.tryGiveEnergy(maxReceive, simulate, (IEnergyReceiver)te);
                if (give <= 0) continue;
                this.sendEnergy(give, loc, (IEnergyReceiver)te);
                add += give;
                if ((maxReceive -= give) > 0) continue;
                return add;
            }
            it.remove();
        }
        return add;
    }

    private int tryGiveEnergy(int maxReceive, boolean simulate, IEnergyReceiver ie) {
        int add = 0;
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = this.dirs[i];
            int give = ie.receiveEnergy(dir, maxReceive, simulate);
            if (give <= 0) continue;
            add += give;
            if ((maxReceive -= give) > 0) continue;
            return add;
        }
        return add;
    }

    private void sendEnergy(int rf, WorldLocation loc, IEnergyReceiver ie) {
        int x = loc.xCoord;
        int y = loc.yCoord;
        int z = loc.zCoord;
        ReikaPacketHelper.sendDataPacketWithRadius((String)"ChromaData", (int)ChromaPackets.RFSEND.ordinal(), (TileEntity)this, (int)48, (int[])new int[]{x, y, z, rf});
    }

    @SideOnly(value=Side.CLIENT)
    public void sendRFToClient(int x, int y, int z, int rf) {
        WorldLocation loc = new WorldLocation(this.field_145850_b, x, y, z);
        if (this.trySendParticle(loc)) {
            int l = 40;
            double dx = x - this.field_145851_c;
            double dy = y - this.field_145848_d;
            double dz = z - this.field_145849_e;
            double dd = ReikaMathLibrary.py3d((double)dx, (double)dy, (double)dz);
            double v = 0.25;
            double vx = v * dx / dd;
            double vy = v * dy / dd;
            double vz = v * dz / dd;
            double r = 0.3125;
            double dr = 0.0625;
            for (double d = -r; d <= r; d += dr) {
                double px = (double)this.field_145851_c + 0.5 + dx / dd * d;
                double py = (double)this.field_145848_d + 0.5 + dy / dd * d;
                double pz = (double)this.field_145849_e + 0.5 + dz / dd * d;
                float s = (float)(1.5 + ReikaMathLibrary.logbase((long)rf, (int)10) * (1.0 - d * d * 12.0));
                EntityBlurFX fx = new EntityBlurFX(this.field_145850_b, px, py, pz, vx, vy, vz).setColor(0xFF0000).setLife(l).setScale(s).setRapidExpand().markDestination(x, y, z);
                EntityBlurFX fx2 = new EntityBlurFX(this.field_145850_b, px, py, pz, vx, vy, vz).setColor(0xFFFFFF).setLife(l).setScale(s / 2.0f).setRapidExpand().markDestination(x, y, z);
                fx.field_70145_X = true;
                fx2.field_70145_X = true;
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx2);
            }
        }
    }

    public int getEnergyStored(ForgeDirection from) {
        return 0;
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        return Integer.MAX_VALUE;
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.RFDISTRIBUTOR;
    }

    @Override
    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateEntity(world, x, y, z, meta);
        if (world.field_72995_K) {
            this.doParticles(world, x, y, z);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void doParticles(World world, int x, int y, int z) {
        if (rand.nextInt(3) == 0) {
            double px = (double)x + rand.nextDouble();
            double py = (double)y + rand.nextDouble();
            double pz = (double)z + rand.nextDouble();
            double v = ReikaRandomHelper.getRandomPlusMinus((double)0.125, (double)0.0625);
            double vx = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)v);
            double vy = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)v);
            double vz = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)v);
            int l = 20 + rand.nextInt(60);
            float s = 1.5f;
            AxisAlignedBB box = ReikaAABBHelper.getBlockAABB((int)x, (int)y, (int)z);
            EntityBlurFX fx = new EntityBlurFX(world, px, py, pz, vx, vy, vz).setColor(0xFF0000).setLife(l).setScale(s).setRapidExpand().bound(box);
            EntityBlurFX fx2 = new EntityBlurFX(world, px, py, pz, vx, vy, vz).setColor(0xFFFFFF).setLife(l).setScale(s / 2.0f).setRapidExpand().bound(box);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx2);
        }
    }

    @Override
    protected boolean isValidTarget(TileEntity te) {
        if (te == this) {
            return false;
        }
        if (te == null) {
            return false;
        }
        if (te instanceof TileEntityRift) {
            return false;
        }
        Class<?> c = te.getClass();
        if (blacklist.contains(c)) {
            return false;
        }
        if (te instanceof TileEntityRFDistributor) {
            return te.field_145848_d < this.field_145848_d;
        }
        if (te instanceof IEnergyReceiver || te instanceof IEnergyHandler) {
            String s = c.getName().toLowerCase(Locale.ENGLISH);
            if (s.contains("conduit") || ReikaStringParser.containsWord((String)s, (String)"duct") || s.contains("cable") || s.contains("pipepower") || ReikaStringParser.containsWord((String)s, (String)"wire")) {
                blacklist.add(c);
                return false;
            }
            if (s.contains("tesseract") || s.contains("hypercube")) {
                blacklist.add(c);
                return false;
            }
            return true;
        }
        return false;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }
}

