/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.Transport;

import Reika.ChromatiCraft.Base.TileEntity.TileEntityChromaticBase;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityBlurFX;
import Reika.ChromatiCraft.Render.Particle.EntitySparkleFX;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Interfaces.TileEntity.Connectable;
import Reika.DragonAPI.Interfaces.TileEntity.SidePlacedTile;
import Reika.DragonAPI.Libraries.Java.ReikaArrayHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaDirectionHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.RotaryCraft.API.Interfaces.Screwdriverable;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityItemRift
extends TileEntityChromaticBase
implements Screwdriverable,
SidePlacedTile,
Connectable {
    private int[] source = new int[]{Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE};
    private int[] target = new int[]{Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE};
    private ForgeDirection facing;
    public boolean isEmitting;

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.ITEMRIFT;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        TileEntityItemRift tile;
        TileEntity tgt;
        ChromaTiles c;
        TileEntity src;
        boolean connected = false;
        if (!this.isEmitting && (src = this.getAdjacentTileEntity(this.getFacing())) instanceof IInventory && (c = ChromaTiles.getTile((IBlockAccess)world, this.target[0], this.target[1], this.target[2])) == this.getTile() && (tgt = (tile = (TileEntityItemRift)world.func_147438_o(this.target[0], this.target[1], this.target[2])).getAdjacentTileEntity(tile.getFacing())) instanceof IInventory) {
            if (!world.field_72995_K) {
                this.transferItems((IInventory)src, this.getFacing(), (IInventory)tgt, tile.getFacing());
            }
            connected = true;
        }
        if (!world.field_72995_K && connected) {
            this.spawnParticles(world, x, y, z);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticles(World world, int x, int y, int z) {
        ForgeDirection dir = this.getFacing().getOpposite();
        ForgeDirection left = ReikaDirectionHelper.getLeftBy90((ForgeDirection)dir);
        int index = ReikaDirectionHelper.getDirectionIndex((ForgeDirection)dir);
        int[] c = new int[]{x, y, z};
        int len = 1 + Math.abs(c[index] - this.target[index]);
        double r = 0.25;
        int n = Math.max(1, len / 2 - 1);
        for (int i = 0; i < n; ++i) {
            double d = ((double)this.getTicksExisted() / 2.0 + (double)(i * len) * 16.0 / (double)n) % (double)(len * 16) / 16.0 - 0.5;
            double ang = Math.toRadians((double)this.getTicksExisted() * 16.0 % 360.0);
            double sin = r * Math.sin(ang);
            double cos = r * Math.cos(ang);
            double px = (double)x + 0.5 + (double)dir.offsetX * d + (double)left.offsetX * cos;
            double py = (double)y + 0.5 + (double)dir.offsetY * d + sin;
            double pz = (double)z + 0.5 + (double)dir.offsetZ * d + (double)left.offsetZ * cos;
            EntityBlurFX fx = new EntityBlurFX(CrystalElement.LIGHTBLUE, world, px, py, pz, 0.0, 0.0, 0.0);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
        double d = (double)(this.getTicksExisted() * 4 % (len * 16)) / 16.0 - 0.5;
        double px = (double)x + 0.5 + d * (double)dir.offsetX;
        double py = (double)y + 0.5 + d * (double)dir.offsetY;
        double pz = (double)z + 0.5 + d * (double)dir.offsetZ;
        EntitySparkleFX fx = new EntitySparkleFX(world, px, py, pz, 0.0, 0.0, 0.0).setScale(1.0f).setLife(15);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
    }

    private void transferItems(IInventory src, ForgeDirection dir1, IInventory tgt, ForgeDirection dir2) {
        int d1 = dir1.getOpposite().ordinal();
        int d2 = dir2.getOpposite().ordinal();
        int[] from = ReikaArrayHelper.getLinearArray((int)src.func_70302_i_());
        if (src instanceof ISidedInventory) {
            from = ((ISidedInventory)src).func_94128_d(d1);
        }
        int[] to = ReikaArrayHelper.getLinearArray((int)src.func_70302_i_());
        if (src instanceof ISidedInventory) {
            to = ((ISidedInventory)src).func_94128_d(d2);
        }
        for (int i = 0; i < from.length; ++i) {
            int slotfrom = from[i];
            for (int k = 0; k < to.length; ++k) {
                boolean insert;
                boolean extract;
                int slotto = to[k];
                ItemStack in = src.func_70301_a(slotfrom);
                if (in == null) continue;
                boolean bl = extract = src instanceof ISidedInventory ? ((ISidedInventory)src).func_102008_b(slotfrom, in, d1) : true;
                if (!extract) continue;
                boolean valid = tgt.func_94041_b(slotto, in);
                boolean bl2 = insert = tgt instanceof ISidedInventory ? ((ISidedInventory)src).func_102007_a(slotto, in, d2) : true;
                if (!insert || !valid) continue;
                this.transferItem(src, slotfrom, tgt, slotto, in);
            }
        }
    }

    private void transferItem(IInventory src, int slotfrom, IInventory tgt, int slotto, ItemStack transfer) {
        int amt;
        int space;
        ItemStack already = tgt.func_70301_a(slotto);
        int maxsize = Math.min(transfer.func_77976_d(), tgt.func_70297_j_());
        int n = space = already == null ? maxsize : maxsize - already.field_77994_a;
        if (space > 0 && (amt = Math.min(space, transfer.field_77994_a)) > 0) {
            if (already != null) {
                already.field_77994_a += amt;
            } else {
                ItemStack put = ReikaItemHelper.getSizedItemStack((ItemStack)transfer, (int)amt);
                tgt.func_70299_a(slotto, put);
            }
            transfer.field_77994_a -= amt;
            if (transfer.field_77994_a == 0) {
                src.func_70299_a(slotfrom, null);
            }
        }
    }

    public final void reset() {
        this.source = new int[]{Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE};
        this.target = new int[]{Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE};
    }

    public final void resetOther() {
        if (!this.isEmitting) {
            ChromaTiles m = ChromaTiles.getTile((IBlockAccess)this.field_145850_b, this.target[0], this.target[1], this.target[2]);
            if (m == this.getTile()) {
                TileEntityItemRift te = (TileEntityItemRift)this.field_145850_b.func_147438_o(this.target[0], this.target[1], this.target[2]);
                te.reset();
            }
        } else {
            ChromaTiles m = ChromaTiles.getTile((IBlockAccess)this.field_145850_b, this.source[0], this.source[1], this.source[2]);
            if (m == this.getTile()) {
                TileEntityItemRift te = (TileEntityItemRift)this.field_145850_b.func_147438_o(this.source[0], this.source[1], this.source[2]);
                te.reset();
            }
        }
    }

    public final boolean canConnect(int x, int y, int z) {
        int dx = x - this.field_145851_c;
        int dy = y - this.field_145848_d;
        int dz = z - this.field_145849_e;
        boolean[] blArray = new boolean[3];
        blArray[0] = dx != 0;
        blArray[1] = dy != 0;
        boolean bl = blArray[2] = dz != 0;
        if (!ReikaMathLibrary.nBoolsAreTrue((int)1, (boolean[])blArray)) {
            return false;
        }
        ForgeDirection dir = ForgeDirection.UNKNOWN;
        if (dx > 0) {
            dir = ForgeDirection.EAST;
        }
        if (dx < 0) {
            dir = ForgeDirection.WEST;
        }
        if (dy > 0) {
            dir = ForgeDirection.UP;
        }
        if (dy < 0) {
            dir = ForgeDirection.DOWN;
        }
        if (dz > 0) {
            dir = ForgeDirection.SOUTH;
        }
        if (dz < 0) {
            dir = ForgeDirection.NORTH;
        }
        if (dir == null) {
            return false;
        }
        if (!this.isValidDirection(dir)) {
            return false;
        }
        for (int i = 1; i < Math.abs(dx + dy + dz); ++i) {
            int xi = this.field_145851_c + dir.offsetX * i;
            int yi = this.field_145848_d + dir.offsetY * i;
            int zi = this.field_145849_e + dir.offsetZ * i;
            Block id = this.field_145850_b.func_147439_a(xi, yi, zi);
            if (ReikaWorldHelper.softBlocks((IBlockAccess)this.field_145850_b, (int)xi, (int)yi, (int)zi)) continue;
            return false;
        }
        return true;
    }

    private boolean isValidDirection(ForgeDirection dir) {
        return true;
    }

    public final boolean setTarget(World world, int x, int y, int z) {
        if (!this.canConnect(x, y, z)) {
            return false;
        }
        this.target[0] = x;
        this.target[1] = y;
        this.target[2] = z;
        return true;
    }

    public final boolean setSource(World world, int x, int y, int z) {
        if (!this.canConnect(x, y, z)) {
            return false;
        }
        this.source[0] = x;
        this.source[1] = y;
        this.source[2] = z;
        return true;
    }

    public int[] getTarget() {
        int[] tg = new int[3];
        System.arraycopy(this.target, 0, tg, 0, 3);
        return tg;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74757_a("emit", this.isEmitting);
        NBT.func_74783_a("tg", this.target);
        NBT.func_74783_a("src", this.source);
        NBT.func_74768_a("dir", this.getFacing().ordinal());
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.isEmitting = NBT.func_74767_n("emit");
        this.source = NBT.func_74759_k("src");
        this.target = NBT.func_74759_k("tg");
        this.facing = this.dirs[NBT.func_74762_e("dir")];
    }

    public ForgeDirection getFacing() {
        return this.facing != null ? this.facing : ForgeDirection.UP;
    }

    public boolean onShiftRightClick(World world, int x, int y, int z, ForgeDirection side) {
        return false;
    }

    public boolean onRightClick(World world, int x, int y, int z, ForgeDirection side) {
        int o = this.getFacing().ordinal();
        ForgeDirection next = o == 5 ? ForgeDirection.DOWN : ForgeDirection.VALID_DIRECTIONS[o + 1];
        this.setFacing(next);
        return true;
    }

    public void setFacing(ForgeDirection next) {
        this.facing = next;
    }

    public void placeOnSide(int s) {
        this.facing = ForgeDirection.VALID_DIRECTIONS[s].getOpposite();
    }

    public boolean isEmitting() {
        return this.isEmitting;
    }

    public boolean checkLocationValidity() {
        WorldLocation loc = this.getAdjacentLocation(this.getFacing());
        return loc.getBlock().isSideSolid((IBlockAccess)this.field_145850_b, loc.xCoord, loc.yCoord, loc.zCoord, this.getFacing().getOpposite());
    }

    public void drop() {
        ReikaItemHelper.dropItem((World)this.field_145850_b, (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5), (ItemStack)this.getTile().getCraftedProduct());
        this.delete();
    }
}

