/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.Transport;

import Reika.ChromatiCraft.Auxiliary.FluidNetwork;
import Reika.ChromatiCraft.Auxiliary.Interfaces.CustomHitbox;
import Reika.ChromatiCraft.Base.TileEntity.TileEntityChromaticBase;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Effects.EntityFluidFX;
import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Interfaces.TileEntity.BreakAction;
import Reika.DragonAPI.Interfaces.TileEntity.SidePlacedTile;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityFluidRelay
extends TileEntityChromaticBase
implements BreakAction,
SidePlacedTile,
CustomHitbox {
    private final StepTimer cacheTimer = new StepTimer(100);
    public static final int RELAY_RANGE = 16;
    public static final int MAX_THROUGHPUT = 2000;
    private final HashSet<Coordinate> connections = new HashSet();
    private FluidNetwork network;
    private ForgeDirection facing;
    private final HashSet<Fluid> fluidTypes = new HashSet();
    private final Fluid[] fluidAccess = new Fluid[7];
    private int pressure;

    public void updateEntity(World world, int x, int y, int z, int meta) {
        if (!world.field_72995_K) {
            this.cacheTimer.update();
            if (this.cacheTimer.checkCap() || this.getTicksExisted() == 0) {
                this.scanAndCache(world, x, y, z);
            }
            this.network.update(world);
        }
    }

    protected void onFirstTick(World world, int x, int y, int z) {
        if (!world.field_72995_K) {
            this.network = new FluidNetwork();
            this.network.add(this);
        }
    }

    public ForgeDirection getFacing() {
        return this.facing != null ? this.facing : ForgeDirection.DOWN;
    }

    private void scanAndCache(World world, int x, int y, int z) {
        int r = 16;
        for (int i = -r; i <= r; ++i) {
            for (int k = -r; k <= r; ++k) {
                for (int j = -r; j <= 0; ++j) {
                    int dx = x + i;
                    int dy = y + j;
                    int dz = z + k;
                    if (ChromaTiles.getTile((IBlockAccess)world, dx, dy, dz) != this.getTile() || !(ReikaMathLibrary.py3d((double)i, (double)j, (double)k) <= (double)r)) continue;
                    this.connections.add(new Coordinate(dx, dy, dz));
                    TileEntityFluidRelay te = (TileEntityFluidRelay)world.func_147438_o(dx, dy, dz);
                    this.network.merge(te.network, world);
                }
            }
        }
    }

    public Collection<Coordinate> getConnections() {
        return Collections.unmodifiableCollection(this.connections);
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.FLUIDRELAY;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("face", this.getFacing().ordinal());
        NBT.func_74768_a("press", this.pressure);
        NBTTagList li = new NBTTagList();
        for (int i = 0; i < this.fluidAccess.length; ++i) {
            Fluid f = this.fluidAccess[i];
            String s = f != null ? f.getName() : "empty";
            li.func_74742_a((NBTBase)new NBTTagString(s));
        }
        NBT.func_74782_a("fluids", (NBTBase)li);
        li = new NBTTagList();
        for (Coordinate c : this.connections) {
            NBTTagCompound tag = c.writeToTag();
            li.func_74742_a((NBTBase)tag);
        }
        NBT.func_74782_a("connections", (NBTBase)li);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.pressure = NBT.func_74762_e("press");
        this.facing = this.dirs[NBT.func_74762_e("face")];
        this.fluidTypes.clear();
        NBTTagList li = NBT.func_150295_c("fluids", ReikaNBTHelper.NBTTypes.STRING.ID);
        for (int i = 0; i < li.field_74747_a.size(); ++i) {
            Fluid f;
            String s = li.func_150307_f(i);
            this.fluidAccess[i] = f = FluidRegistry.getFluid((String)s);
            if (f == null) continue;
            this.fluidTypes.add(f);
        }
        this.connections.clear();
        li = NBT.func_150295_c("connections", ReikaNBTHelper.NBTTypes.COMPOUND.ID);
        for (Object o : li.field_74747_a) {
            Coordinate c = Coordinate.readTag((NBTTagCompound)((NBTTagCompound)o));
            this.connections.add(c);
        }
    }

    public int getPressure() {
        return this.pressure;
    }

    private void renderFluid(Fluid f) {
        if (!this.field_145850_b.field_72995_K) {
            ReikaPacketHelper.sendDataPacketWithRadius((String)"ChromaData", (int)ChromaPackets.RELAYFLUID.ordinal(), (TileEntity)this, (int)32, (int[])new int[]{f.getID()});
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void sendFluidParticles(World world, int x, int y, int z, Fluid f) {
        double d = 0.0625;
        double px = (double)x + 0.5 + d * (double)this.getFacing().offsetX;
        double py = (double)y + 0.5 + d * (double)this.getFacing().offsetY;
        double pz = (double)z + 0.5 + d * (double)this.getFacing().offsetZ;
        for (Coordinate c : this.connections) {
            TileEntityFluidRelay te2 = (TileEntityFluidRelay)c.getTileEntity(world);
            double x2 = (double)c.xCoord + 0.5 + d * (double)te2.getFacing().offsetX;
            double y2 = (double)c.yCoord + 0.5 + d * (double)te2.getFacing().offsetY;
            double z2 = (double)c.zCoord + 0.5 + d * (double)te2.getFacing().offsetZ;
            double dx = x2 - px;
            double dy = y2 - py;
            double dz = z2 - pz;
            double dd = ReikaMathLibrary.py3d((double)dx, (double)dy, (double)dz);
            double v = ReikaRandomHelper.getRandomBetween((double)0.0625, (double)0.25);
            double vx = v * dx / dd;
            double vy = v * dy / dd;
            double vz = v * dz / dd;
            double dv = 0.015625;
            vx = ReikaRandomHelper.getRandomPlusMinus((double)vx, (double)dv);
            vy = ReikaRandomHelper.getRandomPlusMinus((double)vy, (double)dv);
            vz = ReikaRandomHelper.getRandomPlusMinus((double)vz, (double)dv);
            EntityFluidFX fx = new EntityFluidFX(world, px, py, pz, vx, vy, vz, f);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    public void pushFluids() {
        IFluidHandler ifl = this.getTank();
        if (ifl == null) {
            return;
        }
        for (Fluid f : this.fluidTypes) {
            int ret;
            FluidStack max = ifl.drain(this.getFacing().getOpposite(), new FluidStack(f, Integer.MAX_VALUE), false);
            if (max == null || (ret = this.network.push(this.field_145850_b, f, Math.min(max.amount, this.getThroughput()))) <= 0) continue;
            ifl.drain(this.getFacing().getOpposite(), new FluidStack(f, ret), true);
            this.renderFluid(f);
        }
    }

    public void suckFluids() {
        IFluidHandler ifl = this.getTank();
        if (ifl == null) {
            return;
        }
        for (Fluid f : this.fluidTypes) {
            int ret;
            int max = ifl.fill(this.getFacing().getOpposite(), new FluidStack(f, Integer.MAX_VALUE), false);
            if (max <= 0 || (ret = this.network.suck(this.field_145850_b, f, max = Math.min(this.getThroughput(), max))) <= 0) continue;
            ifl.fill(this.getFacing().getOpposite(), new FluidStack(f, ret), true);
            this.renderFluid(f);
        }
    }

    public Fluid[] getFluidTypes() {
        return Arrays.copyOf(this.fluidAccess, this.fluidAccess.length);
    }

    private IFluidHandler getTank() {
        TileEntity te = this.getAdjacentTileEntity(this.getFacing());
        return te instanceof IFluidHandler ? (IFluidHandler)te : null;
    }

    public int pushFluid(Fluid f, int amt) {
        if (!this.fluidTypes.contains(f)) {
            return 0;
        }
        IFluidHandler ifl = this.getTank();
        if (ifl != null) {
            int ret = ifl.fill(this.getFacing().getOpposite(), new FluidStack(f, amt), true);
            if (ret > 0) {
                this.renderFluid(f);
            }
            return ret;
        }
        return 0;
    }

    public int suckFluid(Fluid f, int amt) {
        if (!this.fluidTypes.contains(f)) {
            return 0;
        }
        IFluidHandler ifl = this.getTank();
        if (ifl != null) {
            FluidStack ret = ifl.drain(this.getFacing().getOpposite(), new FluidStack(f, amt), true);
            if (ret != null) {
                this.renderFluid(f);
            }
            return ret != null ? ret.amount : 0;
        }
        return 0;
    }

    public void breakBlock() {
        if (this.network != null) {
            this.network.remove(this);
        }
    }

    public void placeOnSide(int s) {
        this.facing = this.dirs[s].getOpposite();
    }

    public boolean checkLocationValidity() {
        return this.field_145850_b.func_147439_a(this.field_145851_c + this.facing.offsetX, this.field_145848_d + this.facing.offsetY, this.field_145849_e + this.facing.offsetZ).func_149688_o().func_76220_a();
    }

    public void drop() {
        ReikaItemHelper.dropItem((World)this.field_145850_b, (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5), (ItemStack)this.getTile().getCraftedProduct());
        this.delete();
    }

    @Override
    public AxisAlignedBB getHitbox() {
        ForgeDirection dir = this.getFacing();
        double d = 0.3125;
        return ReikaAABBHelper.getBlockAABB((TileEntity)this).func_72331_e(d, d, d).func_72317_d((double)dir.offsetX * d, (double)dir.offsetY * d, (double)dir.offsetZ * d);
    }

    public void assignNetwork(FluidNetwork net) {
        this.network = net;
    }

    public int getThroughput() {
        return Math.min(2000, 200 + Math.abs(4 * this.pressure));
    }

    public void changePressure(int p) {
        this.pressure += p;
        this.network.updateState(this);
    }

    public void setFluid(int slot, Fluid f) {
        if (this.fluidAccess[slot] != f) {
            this.fluidAccess[slot] = f;
            this.fluidTypes.clear();
            for (int i = 0; i < this.fluidAccess.length; ++i) {
                Fluid in = this.fluidAccess[i];
                if (in == null) continue;
                this.fluidTypes.add(in);
            }
            if (this.network != null) {
                this.network.updateState(this);
            }
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return ReikaAABBHelper.getBlockAABB((TileEntity)this).func_72314_b(16.0, 16.0, 16.0);
    }
}

