/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.Transport;

import Reika.ChromatiCraft.Base.TileEntity.TileEntityChromaticBase;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.HybridTank;
import cofh.api.energy.IEnergyHandler;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityConduitBridge
extends TileEntityChromaticBase
implements IFluidHandler,
IEnergyHandler {
    private static final int FLUID_CAPACITY = 2000;
    private static final int RF_CAPACITY = 60000;
    private int rfLevel;
    private final HybridTank tank = new HybridTank("bridge", 2000);
    private Coordinate otherBridge;

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.BRIDGE;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    public void link(TileEntityConduitBridge te) {
    }

    public boolean canConnectEnergy(ForgeDirection from) {
        return this.connective(from);
    }

    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.insert(Interaction.RF, from, maxReceive, simulate);
    }

    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return (Integer)this.remove(Interaction.RF, from, maxExtract, simulate);
    }

    public int getEnergyStored(ForgeDirection from) {
        return (Integer)this.amount(Interaction.RF, from);
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        return this.capacity(Interaction.RF, from);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.insert(Interaction.FLUID, from, resource, !doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return (FluidStack)this.remove(Interaction.FLUID, from, resource, !doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return (FluidStack)this.remove(Interaction.FLUID, from, maxDrain, !doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.connective(from);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.connective(from);
    }

    public boolean connective(ForgeDirection from) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{new FluidTankInfo((FluidStack)this.amount(Interaction.FLUID, from), this.capacity(Interaction.FLUID, from))};
    }

    private int insert(Interaction a, ForgeDirection dir, Object amt, boolean simulate) {
        switch (a) {
            case FLUID: {
                FluidStack fs = (FluidStack)amt;
                return this.tank.isEmpty() || fs.getFluid() == this.tank.getActualFluid() ? this.tank.fill(fs, !simulate) : 0;
            }
            case RF: {
                int val = (Integer)amt;
                int add = Math.min(60000 - this.rfLevel, val);
                if (!simulate) {
                    this.rfLevel += add;
                }
                return add;
            }
        }
        return 0;
    }

    private Object remove(Interaction a, ForgeDirection dir, Object amt, boolean simulate) {
        switch (a) {
            case FLUID: {
                if (amt instanceof FluidStack) {
                    FluidStack fs = (FluidStack)amt;
                    return fs.getFluid() == this.tank.getActualFluid() ? this.tank.drain(fs.amount, !simulate) : null;
                }
                if (amt instanceof Integer) {
                    Fluid f = this.tank.getActualFluid();
                    if (f == null) {
                        return null;
                    }
                    int val = (Integer)amt;
                    int rem = Math.min(val, this.tank.getLevel());
                    if (!simulate) {
                        this.tank.removeLiquid(rem);
                    }
                    return new FluidStack(f, rem);
                }
                return null;
            }
            case RF: {
                int val = (Integer)amt;
                int rem = Math.min(this.rfLevel, val);
                if (!simulate) {
                    this.rfLevel -= rem;
                }
                return rem;
            }
        }
        return null;
    }

    private Object amount(Interaction a, ForgeDirection dir) {
        switch (a) {
            case FLUID: {
                return this.tank.getFluid();
            }
            case RF: {
                return this.rfLevel;
            }
        }
        return null;
    }

    private int capacity(Interaction a, ForgeDirection dir) {
        switch (a) {
            case FLUID: {
                return 2000;
            }
            case RF: {
                return 60000;
            }
        }
        return 0;
    }

    public static enum Interaction {
        FLUID,
        RF;

    }
}

