/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity;

import Reika.ChromatiCraft.Auxiliary.ChromaStructures;
import Reika.ChromatiCraft.Auxiliary.CrystalMusicManager;
import Reika.ChromatiCraft.Auxiliary.Interfaces.MultiBlockChromaTile;
import Reika.ChromatiCraft.Auxiliary.Interfaces.OwnedTile;
import Reika.ChromatiCraft.Base.TileEntity.CrystalReceiverBase;
import Reika.ChromatiCraft.Magic.Interfaces.ChargingPoint;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityBlurFX;
import Reika.ChromatiCraft.Render.Particle.EntityRuneFX;
import Reika.ChromatiCraft.TileEntity.Networking.TileEntityCrystalPylon;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.FilledBlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class TileEntityPersonalCharger
extends CrystalReceiverBase
implements ChargingPoint,
OwnedTile,
MultiBlockChromaTile {
    private CrystalElement color = CrystalElement.WHITE;
    private boolean hasMultiblock = false;
    public static final int CAPACITY = 60000;

    @Override
    protected int getCooldownLength() {
        return 800;
    }

    @Override
    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateEntity(world, x, y, z, meta);
        if (this.canConduct()) {
            if (!world.field_72995_K && this.getCooldown() == 0 && this.checkTimer.checkCap()) {
                this.checkAndRequest();
            }
            if (world.field_72995_K) {
                this.doParticles(world, x, y, z);
            }
            if (this.playSound(world, x, y, z)) {
                float f = 0.75f;
                if (TileEntityCrystalPylon.TUNED_PYLONS) {
                    f = (float)((double)f * CrystalMusicManager.instance.getDingPitchScale(this.color));
                }
                if (this.getTicksExisted() % (int)(72.0f / f) == 0) {
                    ChromaSounds.POWER.playSoundAtBlock((TileEntity)this, 0.33f, f);
                }
            }
        }
    }

    private boolean playSound(World world, int x, int y, int z) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    private void doParticles(World world, int x, int y, int z) {
        double px = ReikaRandomHelper.getRandomPlusMinus((double)((double)x + 0.5), (double)1.0);
        double pz = ReikaRandomHelper.getRandomPlusMinus((double)((double)z + 0.5), (double)1.0);
        double py = ReikaRandomHelper.getRandomPlusMinus((double)y, (double)0.375);
        float g = rand.nextFloat() * 0.25f;
        float s = 2.0f;
        EntityFX fx = new EntityBlurFX(this.color, world, px, py, pz, 0.0, 0.0, 0.0).setScale(s).setLife(100).setGravity(g);
        Minecraft.func_71410_x().field_71452_i.func_78873_a(fx);
        fx = new EntityBlurFX(world, px, py, pz, 0.0, 0.0, 0.0).setScale(s * 0.5f).setLife(100).setGravity(g).setColor(0xFFFFFF);
        Minecraft.func_71410_x().field_71452_i.func_78873_a(fx);
        double d = rand.nextDouble() * 3.0;
        int l = 20 + rand.nextInt(20);
        int n = rand.nextInt(4);
        py = y - 5;
        switch (n) {
            case 0: {
                px = (double)x + 0.5 - 2.0 + d;
                pz = (double)z + 0.5 - 2.0;
                break;
            }
            case 1: {
                px = (double)x + 0.5 - 2.0 + d;
                pz = (double)z + 0.5 + 2.0;
                break;
            }
            case 2: {
                px = (double)x + 0.5 - 2.0;
                pz = (double)z + 0.5 - 2.0 + d;
                break;
            }
            case 3: {
                px = (double)x + 0.5 + 2.0;
                pz = (double)z + 0.5 - 2.0 + d;
            }
        }
        fx = new EntityRuneFX(world, px, py, pz, this.color).setScale(2.0f).setGravity(-0.0625f).setLife(l);
        Minecraft.func_71410_x().field_71452_i.func_78873_a(fx);
    }

    @Override
    protected void onFirstTick(World world, int x, int y, int z) {
        super.onFirstTick(world, x, y, z);
        this.validateStructure();
    }

    @Override
    public void validateStructure() {
        World world = this.field_145850_b;
        int x = this.field_145851_c;
        int y = this.field_145848_d;
        int z = this.field_145849_e;
        int m1 = world.func_72805_g(x - 2, y - 4, z - 2);
        int m2 = world.func_72805_g(x + 2, y - 4, z - 2);
        int m3 = world.func_72805_g(x - 2, y - 4, z + 2);
        int m4 = world.func_72805_g(x + 2, y - 4, z + 2);
        if (m1 == m2 && m1 == m3 && m1 == m4) {
            CrystalElement e = CrystalElement.elements[m1];
            FilledBlockArray arr = ChromaStructures.getPersonalStructure(world, x, y - 6, z, e);
            boolean flag = arr.matchInWorld();
            if (flag != this.hasMultiblock) {
                if (flag) {
                    ChromaSounds.CAST.playSoundAtBlock((TileEntity)this, 1.0f, 0.5f);
                    this.color = e;
                } else {
                    ChromaSounds.POWERDOWN.playSoundAtBlock((TileEntity)this, 1.0f, 0.5f);
                    this.energy.clear();
                    this.checkTimer.setTick(this.checkTimer.getCap());
                }
            }
            this.hasMultiblock = flag;
        } else {
            this.hasMultiblock = false;
        }
        this.syncAllData(true);
    }

    private void checkAndRequest() {
        if ((double)this.getEnergy(this.color) / 60000.0 < 0.75) {
            this.requestEnergy(this.color, this.getRemainingSpace(this.color));
        }
    }

    @Override
    public boolean isConductingElement(CrystalElement e) {
        return this.canConduct() && e == this.color;
    }

    @Override
    public int maxThroughput() {
        return 200;
    }

    @Override
    public boolean canConduct() {
        return this.color != null && this.hasMultiblock;
    }

    @Override
    public int getReceiveRange() {
        return 32;
    }

    @Override
    public boolean allowCharging(EntityPlayer ep, CrystalElement e) {
        return true;
    }

    @Override
    public int getMaxStorage(CrystalElement e) {
        return e == this.color ? 60000 : 0;
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.PERSONAL;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public float getChargeRateMultiplier(EntityPlayer ep, CrystalElement e) {
        return 0.4f;
    }

    @Override
    public void onUsedBy(EntityPlayer ep, CrystalElement e) {
    }

    @Override
    public CrystalElement getDeliveredColor(EntityPlayer ep, World world, int clickX, int clickY, int clickZ) {
        return this.color;
    }

    @Override
    public boolean drain(CrystalElement e, int amt) {
        boolean flag = this.energy.contains(e);
        this.drainEnergy(e, amt);
        return flag;
    }

    public CrystalElement getColor() {
        return this.color;
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.color = CrystalElement.elements[NBT.func_74762_e("color")];
        this.hasMultiblock = NBT.func_74767_n("multi");
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("color", this.color.ordinal());
        NBT.func_74757_a("multi", this.hasMultiblock);
    }

    @SideOnly(value=Side.CLIENT)
    public int getRenderColor() {
        return this.getColor().getColor();
    }

    @Override
    public Coordinate getChargeParticleOrigin(EntityPlayer ep, CrystalElement e) {
        return new Coordinate((TileEntity)this);
    }
}

