/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity;

import Reika.ChromatiCraft.Auxiliary.Interfaces.ItemOnRightClick;
import Reika.ChromatiCraft.Base.TileEntity.TileEntityChromaticBase;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.BlockArray;
import Reika.DragonAPI.Instantiable.Data.KeyedItemStack;
import Reika.DragonAPI.Interfaces.TileEntity.BreakAction;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public class TileEntityMultiStorage
extends TileEntityChromaticBase
implements ItemOnRightClick,
BreakAction {
    private HashMap<KeyedItemStack, Integer> items = new HashMap();
    private BlockArray blocks = new BlockArray();

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.STORAGE;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    public int getSize() {
        return 2;
    }

    public int getCapacity() {
        return 1024 * this.getSize() * this.getSize();
    }

    public int getNumberTypesPermitted() {
        return (int)Math.sqrt(this.getSize());
    }

    private int getTotalStoredCount() {
        int num = 0;
        for (KeyedItemStack ks : this.items.keySet()) {
            num += this.items.get(ks).intValue();
        }
        return num;
    }

    public ItemStack addItem(ItemStack is) {
        if (this.containsItem(is)) {
            return this.doAddItem(is);
        }
        if (this.canAcceptNewType(is)) {
            return this.doAddItem(is);
        }
        return is;
    }

    private ItemStack doAddItem(ItemStack is) {
        int space = this.getCapacity() - this.getTotalStoredCount();
        if (space >= is.field_77994_a) {
            this.putItem(is);
            return null;
        }
        this.putItem(ReikaItemHelper.getSizedItemStack((ItemStack)is, (int)space));
        is.field_77994_a -= space;
        return is;
    }

    private void putItem(ItemStack is) {
        KeyedItemStack ks = this.getKey(is);
        Integer get = this.items.get(ks);
        int num = get != null ? get : 0;
        this.items.put(ks, num + is.field_77994_a);
    }

    private void doRemoveItem(ItemStack is, int num) {
        KeyedItemStack ks = this.getKey(is);
        int get = this.items.get(ks);
        int res = get - num;
        if (res > 0) {
            this.items.put(ks, res);
        } else {
            this.items.remove(ks);
        }
    }

    public ItemStack removeItem(ItemStack is) {
        int rem = Math.min(is.func_77976_d(), this.countItem(is));
        if (rem > 0) {
            this.doRemoveItem(is, rem);
            return ReikaItemHelper.getSizedItemStack((ItemStack)is, (int)rem);
        }
        return null;
    }

    public Collection<KeyedItemStack> getItemTypes() {
        return Collections.unmodifiableCollection(this.items.keySet());
    }

    public int countItem(ItemStack is) {
        KeyedItemStack ks = this.getKey(is);
        return this.items.containsKey(ks) ? this.items.get(ks) : 0;
    }

    private boolean canAcceptNewType(ItemStack is) {
        return this.items.keySet().size() < this.getNumberTypesPermitted();
    }

    private boolean containsItem(ItemStack is) {
        return this.items.containsKey(this.getKey(is));
    }

    private KeyedItemStack getKey(ItemStack is) {
        return new KeyedItemStack(ReikaItemHelper.getSizedItemStack((ItemStack)is, (int)1)).setIgnoreNBT(false).setIgnoreMetadata(false).setSimpleHash(true).lock();
    }

    @Override
    public ItemStack onRightClickWith(ItemStack item, EntityPlayer ep) {
        if (item == null) {
            this.dropItem(ep);
            return null;
        }
        return this.addItem(item);
    }

    private void dropItem(EntityPlayer ep) {
    }

    @Override
    public void func_145841_b(NBTTagCompound NBT) {
        super.func_145841_b(NBT);
        NBTTagList nbttaglist = new NBTTagList();
        for (KeyedItemStack ls : this.items.keySet()) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74768_a("count", this.items.get(ls).intValue());
            ls.getItemStack().func_77955_b(nbttagcompound);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        NBT.func_74782_a("Items", (NBTBase)nbttaglist);
    }

    @Override
    public void func_145839_a(NBTTagCompound NBT) {
        super.func_145839_a(NBT);
        this.items.clear();
        NBTTagList nbttaglist = NBT.func_150295_c("Items", ReikaNBTHelper.NBTTypes.COMPOUND.ID);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            int amt = nbttagcompound.func_74762_e("count");
            if (amt < 0) continue;
            ItemStack is = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound);
            this.items.put(this.getKey(is), amt);
        }
    }

    public void breakBlock() {
        for (KeyedItemStack ls : this.items.keySet()) {
            int drop;
            ItemStack is = ls.getItemStack();
            for (int num = this.items.get(ls).intValue(); num > 0; num -= drop) {
                drop = Math.min(num, is.func_77976_d());
                ReikaItemHelper.dropItem((World)this.field_145850_b, (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5), (ItemStack)ReikaItemHelper.getSizedItemStack((ItemStack)is, (int)drop));
            }
        }
    }
}

