/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity;

import Reika.ChromatiCraft.API.Event.LumenWireToggleEvent;
import Reika.ChromatiCraft.Auxiliary.Interfaces.CustomHitbox;
import Reika.ChromatiCraft.Base.TileEntity.TileEntityChromaticBase;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Render.Particle.EntityBlurFX;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Instantiable.Rendering.FXCollection;
import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Interfaces.TileEntity.BreakAction;
import Reika.DragonAPI.Interfaces.TileEntity.RedstoneTile;
import Reika.DragonAPI.Interfaces.TileEntity.SidePlacedTile;
import Reika.DragonAPI.Libraries.IO.ReikaColorAPI;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModList;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.UUID;
import li.cil.oc.api.Network;
import li.cil.oc.api.network.Node;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityLumenWire
extends TileEntityChromaticBase
implements BreakAction,
SidePlacedTile,
CustomHitbox,
RedstoneTile {
    private ForgeDirection facing;
    private StepTimer checkTimer = new StepTimer(5);
    private Coordinate connection;
    private UUID connectionUID;
    private int activeTick = 0;
    private CheckType check = CheckType.OWNER;
    public static final int MAX_LENGTH = 6;
    public static final int ACTIVATION_LENGTH = 30;
    @SideOnly(value=Side.CLIENT)
    public FXCollection particles;

    public TileEntityLumenWire() {
        if (this.getSide() == Side.CLIENT) {
            this.particles = new FXCollection();
        }
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.LUMENWIRE;
    }

    @Override
    public AxisAlignedBB getHitbox() {
        AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5), (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5));
        switch (this.getFacing().getOpposite()) {
            case DOWN: {
                box.field_72338_b = this.field_145848_d;
                box.field_72337_e = (double)this.field_145848_d + 0.25;
                box.field_72340_a = (double)this.field_145851_c + 0.25;
                box.field_72336_d = (double)this.field_145851_c + 0.75;
                box.field_72339_c = (double)this.field_145849_e + 0.25;
                box.field_72334_f = (double)this.field_145849_e + 0.75;
                break;
            }
            case UP: {
                box.field_72337_e = this.field_145848_d + 1;
                box.field_72338_b = (double)this.field_145848_d + 0.75;
                box.field_72340_a = (double)this.field_145851_c + 0.25;
                box.field_72336_d = (double)this.field_145851_c + 0.75;
                box.field_72339_c = (double)this.field_145849_e + 0.25;
                box.field_72334_f = (double)this.field_145849_e + 0.75;
                break;
            }
            case EAST: {
                box.field_72336_d = this.field_145851_c + 1;
                box.field_72340_a = (double)this.field_145851_c + 0.75;
                box.field_72338_b = (double)this.field_145848_d + 0.25;
                box.field_72337_e = (double)this.field_145848_d + 0.75;
                box.field_72339_c = (double)this.field_145849_e + 0.25;
                box.field_72334_f = (double)this.field_145849_e + 0.75;
                break;
            }
            case WEST: {
                box.field_72340_a = this.field_145851_c;
                box.field_72336_d = (double)this.field_145851_c + 0.25;
                box.field_72338_b = (double)this.field_145848_d + 0.25;
                box.field_72337_e = (double)this.field_145848_d + 0.75;
                box.field_72339_c = (double)this.field_145849_e + 0.25;
                box.field_72334_f = (double)this.field_145849_e + 0.75;
                break;
            }
            case NORTH: {
                box.field_72339_c = this.field_145849_e;
                box.field_72334_f = (double)this.field_145849_e + 0.25;
                box.field_72338_b = (double)this.field_145848_d + 0.25;
                box.field_72337_e = (double)this.field_145848_d + 0.75;
                box.field_72340_a = (double)this.field_145851_c + 0.25;
                box.field_72336_d = (double)this.field_145851_c + 0.75;
                break;
            }
            case SOUTH: {
                box.field_72334_f = this.field_145849_e + 1;
                box.field_72339_c = (double)this.field_145849_e + 0.75;
                box.field_72338_b = (double)this.field_145848_d + 0.25;
                box.field_72337_e = (double)this.field_145848_d + 0.75;
                box.field_72340_a = (double)this.field_145851_c + 0.25;
                box.field_72336_d = (double)this.field_145851_c + 0.75;
                break;
            }
        }
        return box;
    }

    public void cycleMode() {
        ChromaSounds.USE.playSoundAtBlock((TileEntity)this);
        this.check = this.check.next();
        if (this.connection != null) {
            ((TileEntityLumenWire)this.connection.getTileEntity((World)this.field_145850_b)).check = this.check;
        }
    }

    protected void onFirstTick(World world, int x, int y, int z) {
        this.checkConnection(world, x, y, z);
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        if (!world.field_72995_K) {
            this.checkTimer.update();
            if (this.checkTimer.checkCap()) {
                this.checkConnection(world, x, y, z);
            }
        } else {
            this.particles.update();
        }
        if (this.connection != null) {
            if (this.activeTick > 0) {
                if (this.activeTick == 1) {
                    this.toggle(world, x, y, z, false);
                }
                --this.activeTick;
            }
            if (world.field_72995_K) {
                this.doConnectionParticles(world, x, y, z);
                if (this.isActive()) {
                    this.doActiveParticles(world, x, y, z);
                }
            } else if (this.testBounds(world, x, y, z)) {
                this.toggle(world, x, y, z, true);
            }
        } else {
            this.activeTick = 0;
        }
    }

    private void toggle(World world, int x, int y, int z, boolean on) {
        boolean change;
        boolean bl = change = on != this.isActive();
        if (change) {
            ReikaSoundHelper.playSoundAtBlock((World)world, (int)x, (int)y, (int)z, (String)"random.click", (float)1.0f, (float)(on ? 0.75f : 0.675f));
        }
        if (on) {
            this.activeTick = 30;
        }
        if (change) {
            this.causeUpdates(world, x, y, z);
            TileEntityLumenWire te = (TileEntityLumenWire)this.connection.getTileEntity(world);
            if (te != null) {
                te.causeUpdates(world, this.connection.xCoord, this.connection.yCoord, this.connection.zCoord);
            }
            if (ModList.OPENCOMPUTERS.isLoaded()) {
                this.sendOCActivation(world, x, y, z, on);
            }
            MinecraftForge.EVENT_BUS.post((Event)new LumenWireToggleEvent(world, x, y, z, this.connectionUID, on));
            this.syncAllData(false);
        }
    }

    private void causeUpdates(World world, int x, int y, int z) {
        ReikaWorldHelper.causeAdjacentUpdates((World)world, (int)x, (int)y, (int)z);
        ReikaWorldHelper.causeAdjacentUpdates((World)world, (int)(x - this.getFacing().offsetX), (int)(y - this.getFacing().offsetY), (int)(z - this.getFacing().offsetZ));
    }

    @DependentMethodStripper.ModDependent(value=ModList.OPENCOMPUTERS)
    private void sendOCActivation(World world, int x, int y, int z, boolean on) {
        if (!world.field_72995_K) {
            String tag = "lumen_wire";
            Node n = this.node();
            Network.newPacket((String)(n != null ? n.address() : "NULL"), null, (int)500, (Object[])new Object[]{tag, this.connectionUID.toString(), on});
            if (n != null) {
                n.sendToReachable("computer.signal", new Object[]{tag, this.connectionUID.toString(), on});
            }
        }
    }

    private boolean testBounds(World world, int x, int y, int z) {
        AxisAlignedBB box = this.getCheckBox(world, x, y, z);
        return this.check.check(this, world, box);
    }

    private AxisAlignedBB getCheckBox(World world, int x, int y, int z) {
        AxisAlignedBB box = ReikaAABBHelper.getBlockAABB((int)x, (int)y, (int)z);
        if (this.connection == null) {
            return box;
        }
        box.field_72340_a = Math.min(box.field_72340_a, (double)this.connection.xCoord);
        box.field_72338_b = Math.min(box.field_72338_b, (double)this.connection.yCoord);
        box.field_72339_c = Math.min(box.field_72339_c, (double)this.connection.zCoord);
        box.field_72336_d = Math.max(box.field_72336_d, (double)(this.connection.xCoord + 1));
        box.field_72337_e = Math.max(box.field_72337_e, (double)(this.connection.yCoord + 1));
        box.field_72334_f = Math.max(box.field_72334_f, (double)(this.connection.zCoord + 1));
        return box;
    }

    @SideOnly(value=Side.CLIENT)
    private void doConnectionParticles(World world, int x, int y, int z) {
        double dp = Minecraft.func_71410_x().field_71439_g.func_70092_e((double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
        int n = 1 + rand.nextInt(3);
        float ds = 0.0f;
        if (dp > 16384.0) {
            if (rand.nextInt(4) > 0) {
                return;
            }
        } else if (dp > 4096.0) {
            if (rand.nextInt(2) == 0) {
                return;
            }
            n /= 3;
            ds = 4.0f;
        } else if (dp > 1024.0) {
            if (rand.nextInt(3) == 0) {
                return;
            }
            n /= 2;
            ds = 1.5f;
        } else if (dp > 256.0) {
            if (rand.nextInt(4) == 0) {
                return;
            }
            n = n * 3 / 2;
            ds = 0.5f;
        }
        double in = 0.25;
        double h = 0.5;
        double inx = this.getFacing().offsetX == 0 ? 0.5 : in;
        double iny = this.getFacing().offsetY == 0 ? h : in;
        double inz = this.getFacing().offsetZ == 0 ? 0.5 : in;
        for (int i = 0; i < n; ++i) {
            double d = rand.nextDouble();
            double dx = (double)x + inx + d * ((double)(this.connection.xCoord + 1) - inx * 2.0 - (double)x);
            double dy = (double)y + iny + d * ((double)(this.connection.yCoord + 1) - iny * 2.0 - (double)y);
            double dz = (double)z + inz + d * ((double)(this.connection.zCoord + 1) - inz * 2.0 - (double)z);
            int l = 10 + rand.nextInt(10);
            float s = 1.5f + rand.nextFloat() * 1.0f + ds;
            int p = rand.nextInt(4);
            ChromaIcons ico = ChromaIcons.FADE;
            switch (p) {
                case 1: {
                    ico = ChromaIcons.FLARE;
                    break;
                }
                case 2: {
                    ico = ChromaIcons.CENTER;
                    break;
                }
                case 3: {
                    ico = ChromaIcons.BIGFLARE;
                }
            }
            this.particles.addEffect(dx - (double)x, dy - (double)y, dz - (double)z, ico.getIcon(), l, s, this.check.renderColor);
            this.particles.addEffect(dx - (double)x, dy - (double)y, dz - (double)z, ico.getIcon(), l, s / 2.0f, 0xFFFFFF);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void doActiveParticles(World world, int x, int y, int z) {
        double dp = Minecraft.func_71410_x().field_71439_g.func_70092_e((double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
        int n = 1 + rand.nextInt(3);
        if (dp > 16384.0) {
            if (rand.nextInt(4) > 0) {
                return;
            }
        } else if (dp > 4096.0) {
            if (rand.nextInt(2) == 0) {
                return;
            }
            n /= 3;
        } else if (dp > 1024.0) {
            if (rand.nextInt(3) == 0) {
                return;
            }
            n /= 2;
        } else if (dp > 256.0) {
            if (rand.nextInt(4) == 0) {
                return;
            }
            n = n * 3 / 2;
        }
        if (n <= 0) {
            return;
        }
        double in = 0.25;
        double h = 0.5;
        double inx = this.getFacing().offsetX == 0 ? 0.5 : in;
        double iny = this.getFacing().offsetY == 0 ? h : in;
        double inz = this.getFacing().offsetZ == 0 ? 0.5 : in;
        double d = rand.nextDouble();
        double dx = (double)x + inx + d * ((double)(this.connection.xCoord + 1) - inx * 2.0 - (double)x);
        double dy = (double)y + iny + d * ((double)(this.connection.yCoord + 1) - iny * 2.0 - (double)y);
        double dz = (double)z + inz + d * ((double)(this.connection.zCoord + 1) - inz * 2.0 - (double)z);
        int l = 10 + rand.nextInt(10);
        float s = (float)(2.5 + 4.0 * (0.5 - Math.abs(0.5 - d)));
        int p = rand.nextInt(4);
        int hue = ReikaRandomHelper.getRandomPlusMinus((int)ReikaColorAPI.getHue((int)this.check.renderColor), (int)60);
        int c = ReikaColorAPI.getModifiedHue((int)this.check.renderColor, (int)hue);
        EntityBlurFX fx = new EntityBlurFX(world, dx, dy, dz).setLife(l).setColor(c).setScale(s).setIcon(ChromaIcons.ROSES_WHITE);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
    }

    public boolean isActive() {
        return this.activeTick > 0;
    }

    private void checkConnection(World world, int x, int y, int z) {
        this.disconnect(true);
        for (int i = 1; i <= 6; ++i) {
            int dx = x + this.getFacing().offsetX * i;
            int dy = y + this.getFacing().offsetY * i;
            int dz = z + this.getFacing().offsetZ * i;
            ChromaTiles t = ChromaTiles.getTile((IBlockAccess)world, dx, dy, dz);
            if (t == this.getTile()) {
                TileEntityLumenWire te = (TileEntityLumenWire)world.func_147438_o(dx, dy, dz);
                if (te.getFacing() != this.getFacing().getOpposite()) continue;
                this.connect(te, true);
                continue;
            }
            if (world.func_147439_a(dx, dy, dz).isAir((IBlockAccess)world, dx, dy, dz)) continue;
            return;
        }
    }

    private void connect(TileEntityLumenWire te, boolean callOther) {
        Coordinate old = this.connection;
        this.disconnect(true);
        this.connection = new Coordinate((TileEntity)te);
        if (!this.connection.equals((Object)old)) {
            this.connectionUID = callOther ? UUID.randomUUID() : te.connectionUID;
            this.func_70296_d();
            this.syncAllData(false);
            if (callOther) {
                te.connect(this, false);
            }
        }
    }

    private void disconnect(boolean callOther) {
        TileEntityLumenWire te;
        if (this.connection != null && callOther && (te = (TileEntityLumenWire)this.connection.getTileEntity(this.field_145850_b)) != null) {
            te.disconnect(false);
        }
        this.connection = null;
        this.connectionUID = null;
        this.func_70296_d();
        this.syncAllData(false);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.connection = NBT.func_74764_b("loc") ? Coordinate.readFromNBT((String)"loc", (NBTTagCompound)NBT) : null;
        this.activeTick = NBT.func_74762_e("activet");
        this.facing = this.dirs[NBT.func_74762_e("dir")];
        this.check = CheckType.list[NBT.func_74762_e("ctype")];
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        if (this.connection != null) {
            this.connection.writeToNBT("loc", NBT);
        }
        NBT.func_74768_a("activet", this.activeTick);
        NBT.func_74768_a("dir", this.getFacing().ordinal());
        NBT.func_74768_a("ctype", this.check.ordinal());
    }

    public ForgeDirection getFacing() {
        return this.facing != null ? this.facing : ForgeDirection.UP;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    public void breakBlock() {
        this.disconnect(true);
    }

    public void placeOnSide(int s) {
        this.facing = ForgeDirection.VALID_DIRECTIONS[s];
    }

    public boolean checkLocationValidity() {
        WorldLocation loc = this.getAdjacentLocation(this.getFacing().getOpposite());
        return loc.getBlock().isSideSolid((IBlockAccess)this.field_145850_b, loc.xCoord, loc.yCoord, loc.zCoord, this.getFacing());
    }

    public void drop() {
        ReikaItemHelper.dropItem((World)this.field_145850_b, (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5), (ItemStack)this.getTile().getCraftedProduct());
        this.delete();
    }

    public int getStrongPower(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return this.activeTick > 1 ? 15 : 0;
    }

    public int getWeakPower(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return this.getStrongPower(world, x, y, z, side);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return this.getCheckBox(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public static enum CheckType {
        ANY(0xFFFFFF),
        OWNER(0x22AAFF),
        PLAYER(255),
        MOB(0xFF0000),
        PASSIVE(65280),
        LIVING(65535),
        ITEM(0xFFFF00),
        PROJECTILE(65535);

        public final int renderColor;
        private static final CheckType[] list;

        private CheckType(int c) {
            this.renderColor = c;
        }

        private boolean check(TileEntityLumenWire te, World world, AxisAlignedBB box) {
            switch (this) {
                case ANY: {
                    return !world.func_72872_a(Entity.class, box).isEmpty();
                }
                case LIVING: {
                    return !world.func_72872_a(EntityLivingBase.class, box).isEmpty();
                }
                case ITEM: {
                    return !world.func_94576_a(null, box, ReikaEntityHelper.itemOrXPSelector).isEmpty();
                }
                case MOB: {
                    return !world.func_72872_a(EntityMob.class, box).isEmpty();
                }
                case OWNER: {
                    for (EntityPlayer ep : te.getOwners(false)) {
                        if (!ep.field_70121_D.func_72326_a(box)) continue;
                        return true;
                    }
                    return false;
                }
                case PASSIVE: {
                    return !world.func_72872_a(EntityAnimal.class, box).isEmpty();
                }
                case PLAYER: {
                    return !world.func_72872_a(EntityPlayer.class, box).isEmpty();
                }
                case PROJECTILE: {
                    return !world.func_72872_a(IProjectile.class, box).isEmpty();
                }
            }
            return false;
        }

        private CheckType next() {
            return this.ordinal() == list.length - 1 ? list[0] : list[this.ordinal() + 1];
        }

        static {
            list = CheckType.values();
        }
    }
}

