/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity;

import Reika.ChromatiCraft.Base.TileEntity.TileEntityRelayPowered;
import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityBlurFX;
import Reika.ChromatiCraft.TileEntity.Auxiliary.TileEntityFunctionRelay;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Interfaces.Registry.CropType;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaCropHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaDirectionHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModRegistry.ModCropList;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityFarmer
extends TileEntityRelayPowered {
    @Override
    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateEntity(world, x, y, z, meta);
        if (!world.field_72995_K && this.getEnergy(CrystalElement.GREEN) >= 200) {
            int n = this.getNumberAttempts();
            for (int i = 0; i < n; ++i) {
                Coordinate c = this.getRandomPosition(world, x, y, z);
                if (c == null || !this.operateAt(world, c, true)) continue;
                this.sendParticles(c);
                break;
            }
        }
    }

    private boolean operateAt(World world, Coordinate c, boolean allowRelays) {
        CropType crop;
        if (c == null) {
            return false;
        }
        Object o = this.getCropOrRelayAt(world, c);
        if (allowRelays && o instanceof TileEntityFunctionRelay) {
            return this.operateAt(world, ((TileEntityFunctionRelay)((Object)o)).getRandomCoordinate(), false);
        }
        if (o instanceof CropType && (crop = (CropType)o).isRipe(world, c.xCoord, c.yCoord, c.zCoord)) {
            int fortune = this.getFortune();
            ArrayList li = crop.getDrops(world, c.xCoord, c.yCoord, c.zCoord, fortune);
            if (fortune < 3) {
                CropType.CropMethods.removeOneSeed((CropType)crop, (ArrayList)li);
            }
            ReikaItemHelper.dropItems((World)world, (double)((double)c.xCoord + 0.5), (double)((double)c.yCoord + 0.5), (double)((double)c.zCoord + 0.5), (Collection)li);
            crop.setHarvested(world, c.xCoord, c.yCoord, c.zCoord);
            ReikaSoundHelper.playBreakSound((World)world, (int)c.xCoord, (int)c.yCoord, (int)c.zCoord, (Block)c.getBlock(world));
            this.drainEnergy(CrystalElement.GREEN, 200);
            this.drainEnergy(CrystalElement.PURPLE, 50);
            return true;
        }
        return false;
    }

    private int getNumberAttempts() {
        return Math.max(1, this.getEnergy(CrystalElement.GREEN) / 2500);
    }

    private void sendParticles(Coordinate c) {
        ReikaPacketHelper.sendDataPacketWithRadius((String)"ChromaData", (int)ChromaPackets.FARMERHARVEST.ordinal(), (TileEntity)this, (int)48, (int[])new int[]{c.xCoord, c.yCoord, c.zCoord});
    }

    @SideOnly(value=Side.CLIENT)
    public void doParticles(int tx, int ty, int tz) {
        double v = 0.15;
        double vx = v * (double)(tx - this.field_145851_c);
        double vy = v * (double)(ty - this.field_145848_d);
        double vz = v * (double)(tz - this.field_145849_e);
        EntityBlurFX fx = new EntityBlurFX(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, vx, vy, vz).setColor(0, 192, 0).setScale(4.0f).setLife(10);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
    }

    private int getFortune() {
        return this.getEnergy(CrystalElement.PURPLE) / 1000;
    }

    private Object getCropOrRelayAt(World world, Coordinate c) {
        int meta;
        Block b = c.getBlock(world);
        if (ChromaTiles.getTileFromIDandMetadata(b, meta = c.getBlockMetadata(world)) == ChromaTiles.FUNCTIONRELAY) {
            TileEntityFunctionRelay te = (TileEntityFunctionRelay)c.getTileEntity(world);
            return te.getFunctionType() == TileEntityFunctionRelay.RelayFunctions.HARVEST ? te : null;
        }
        ReikaCropHelper type = ReikaCropHelper.getCrop((Block)b);
        if (type == null) {
            type = ModCropList.getModCrop((Block)b, (int)meta);
        }
        return type;
    }

    private Coordinate getRandomPosition(World world, int x, int y, int z) {
        ForgeDirection dir = this.getFacing();
        ForgeDirection left = ReikaDirectionHelper.getLeftBy90((ForgeDirection)dir);
        int r = rand.nextInt(16);
        int sp = ReikaRandomHelper.getRandomPlusMinus((int)0, (int)r);
        int dx = x + r * dir.offsetX + sp * left.offsetX;
        int dz = z + r * dir.offsetZ + sp * left.offsetZ;
        int dy = ReikaWorldHelper.findTopBlockBelowY((World)world, (int)dx, (int)y, (int)dz);
        return new Coordinate(dx, dy, dz);
    }

    @Override
    public int getMaxStorage(CrystalElement e) {
        switch (e) {
            case GREEN: {
                return 10000;
            }
            case PURPLE: {
                return 5000;
            }
        }
        return 0;
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.FARMER;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    protected boolean canReceiveFrom(CrystalElement e, ForgeDirection dir) {
        return this.isAcceptingColor(e);
    }

    @Override
    protected ElementTagCompound getRequiredEnergy() {
        ElementTagCompound tag = new ElementTagCompound();
        tag.addTag(CrystalElement.GREEN, this.getMaxStorage(CrystalElement.GREEN) - this.energy.getValue(CrystalElement.GREEN));
        tag.addTag(CrystalElement.PURPLE, this.getMaxStorage(CrystalElement.PURPLE) - this.energy.getValue(CrystalElement.PURPLE));
        return tag;
    }

    @Override
    public boolean isAcceptingColor(CrystalElement e) {
        return e == CrystalElement.GREEN || e == CrystalElement.PURPLE;
    }

    public ForgeDirection getFacing() {
        switch (this.func_145832_p()) {
            case 0: {
                return ForgeDirection.WEST;
            }
            case 1: {
                return ForgeDirection.EAST;
            }
            case 2: {
                return ForgeDirection.NORTH;
            }
            case 3: {
                return ForgeDirection.SOUTH;
            }
        }
        return ForgeDirection.UNKNOWN;
    }
}

