/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity;

import Reika.ChromatiCraft.Auxiliary.Interfaces.OperationInterval;
import Reika.ChromatiCraft.Auxiliary.ProgressionManager;
import Reika.ChromatiCraft.Base.TileEntity.TileEntityChromaticBase;
import Reika.ChromatiCraft.Magic.Lore.LoreManager;
import Reika.ChromatiCraft.Magic.Lore.Towers;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Render.Particle.EntityBlurFX;
import Reika.ChromatiCraft.Render.Particle.EntityFloatingSeedsFX;
import Reika.DragonAPI.Auxiliary.Trackers.KeyWatcher;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Interfaces.Registry.SoundEnum;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaObfuscationHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaPhysicsHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class TileEntityDataNode
extends TileEntityChromaticBase
implements OperationInterval {
    private double extension0;
    private double extension1;
    private double extension2;
    private static final double EXTENSION_SPEED = 0.03125;
    public static final double EXTENSION_LIMIT_0 = 0.75;
    public static final double EXTENSION_LIMIT_1 = 1.375;
    public static final double EXTENSION_LIMIT_2 = 1.125;
    private double rotation;
    private double rotationSpeed;
    private static final int SCAN_TIME = 120;
    private static final int SCAN_COOLDOWN = 240;
    private int scanTick;
    private int scanSustain;
    private int scanCooldown;
    private static final int PROGRESS_DELAY_LENGTH = 50;
    private EntityPlayer progressPlayer;
    private int progressDelay;
    private Towers tower;
    private final HashSet<String> scannedPlayers = new HashSet();

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.DATANODE;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        EntityPlayer ep = world.func_72977_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 16.0);
        if (!(ep == null || ReikaObfuscationHelper.isDeObfEnvironment() && KeyWatcher.instance.isKeyDown(ep, KeyWatcher.Key.LCTRL))) {
            if (this.extension0 < 0.75) {
                this.extension0 = Math.min(this.extension0 + 0.03125, 0.75);
            } else if (this.extension1 < 1.375) {
                this.extension1 = Math.min(this.extension1 + 0.03125, 1.375);
            } else {
                this.extension2 = Math.min(this.extension2 + 0.03125, 1.125);
            }
        } else if (this.extension1 == 0.0) {
            this.extension0 = Math.max(this.extension0 - 0.03125, 0.0);
        } else if (this.extension2 == 0.0) {
            this.extension1 = Math.max(this.extension1 - 0.03125, 0.0);
        } else {
            this.extension2 = Math.max(this.extension2 - 0.03125, 0.0);
        }
        if (world.field_72995_K) {
            this.doParticles(world, x, y, z);
        }
        if (this.scanSustain > 0) {
            --this.scanSustain;
            ++this.scanTick;
        } else if (this.scanTick > 0) {
            this.scanTick = Math.max(0, this.scanTick - 8);
        }
        if (this.scanTick > 0) {
            float f = 0.5f + 1.5f * this.getScanProgress();
            ChromaSounds.KILLAURA_CHARGE.playSoundAtBlock((TileEntity)this, 1.0f, f);
        }
        if (this.scanCooldown > 0) {
            --this.scanCooldown;
        }
        if (this.progressDelay > 0) {
            --this.progressDelay;
            if (this.progressDelay == 0 && this.tower != null) {
                LoreManager.instance.triggerLore(this.progressPlayer, this.tower);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void doParticles(World world, int x, int y, int z) {
        if (this.canBeAccessed()) {
            double px = ReikaRandomHelper.getRandomPlusMinus((double)((double)x + 0.5), (double)4.0);
            double pz = ReikaRandomHelper.getRandomPlusMinus((double)((double)z + 0.5), (double)4.0);
            double py = ReikaRandomHelper.getRandomBetween((double)((double)y + 3.5), (double)(y + 5));
            EntityBlurFX fx = new EntityBlurFX(world, px, py, pz).setColor(10543359).setLife(30).setIcon(ChromaIcons.FADE_RAY).setScale(0.5f);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
        if (this.canBeAccessed() && rand.nextInt(5) == 0 && !this.hasBeenScanned((EntityPlayer)Minecraft.func_71410_x().field_71439_g) && this.tower != null && this.tower != Towers.ALPHA) {
            Towers t1 = this.tower.getNeighbor1();
            Towers t2 = this.tower.getNeighbor2();
            if (t1 == null || t1.getRootPosition() == null) {
                LoreManager.instance.initTowers(world);
                t1 = this.tower.getNeighbor1();
                t2 = this.tower.getNeighbor2();
            }
            double px = ReikaRandomHelper.getRandomPlusMinus((double)((double)x + 0.5), (double)1.0);
            double pz = ReikaRandomHelper.getRandomPlusMinus((double)((double)z + 0.5), (double)1.0);
            double py = ReikaRandomHelper.getRandomBetween((double)((double)y + 3.5), (double)(y + 5));
            double dx = t1.getRootPosition().field_77276_a - this.tower.getRootPosition().field_77276_a;
            double dz = t1.getRootPosition().field_77275_b - this.tower.getRootPosition().field_77275_b;
            double a = -ReikaPhysicsHelper.cartesianToPolar((double)dx, (double)0.0, (double)dz)[2] - 90.0;
            float s = rand.nextFloat() + 0.25f;
            EntityFloatingSeedsFX fx = new EntityFloatingSeedsFX(world, px, py, pz, a, 0.0);
            fx.freedom *= 0.5;
            fx.setColor(10543359).setLife(120).setIcon(ChromaIcons.FADE).setScale(s);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            dx = t2.getRootPosition().field_77276_a - this.tower.getRootPosition().field_77276_a;
            dz = t2.getRootPosition().field_77275_b - this.tower.getRootPosition().field_77275_b;
            a = -ReikaPhysicsHelper.cartesianToPolar((double)dx, (double)0.0, (double)dz)[2] - 90.0;
            s = rand.nextFloat() + 0.25f;
            fx = new EntityFloatingSeedsFX(world, px, py, pz, a, 0.0);
            fx.freedom *= 0.5;
            fx.setColor(10543359).setLife(120).setIcon(ChromaIcons.FADE).setScale(s);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    public double getRotation() {
        return this.rotation;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
        this.rotationSpeed = this.extension2 == 1.125 ? 1.5 : (this.extension1 == 1.375 ? 1.0 : (this.extension0 == 0.75 ? 0.5 : 0.0));
        this.rotation += this.rotationSpeed;
    }

    public double getExtension0() {
        return this.extension0;
    }

    public double getExtension1() {
        return this.extension1;
    }

    public double getExtension2() {
        return this.extension2;
    }

    public boolean canBeAccessed() {
        return this.extension2 >= 1.125;
    }

    public void scan(EntityPlayer ep) {
        if (DragonAPICore.isReikasComputer() && ReikaObfuscationHelper.isDeObfEnvironment() && KeyWatcher.instance.isKeyDown(ep, KeyWatcher.Key.LCTRL)) {
            this.scannedPlayers.clear();
            this.scanCooldown = 0;
        }
        if (this.scanCooldown > 0) {
            return;
        }
        if (!this.canBeAccessed()) {
            return;
        }
        if (this.hasBeenScanned(ep)) {
            return;
        }
        ++this.scanTick;
        this.scanSustain = 4;
        if (this.scanTick >= 120 && !this.field_145850_b.field_72995_K) {
            this.doScan(ep);
        }
    }

    public float getScanProgress() {
        return (float)this.scanTick / 120.0f;
    }

    private void doScan(EntityPlayer ep) {
        this.scanTick = 0;
        this.scanSustain = 0;
        this.scanCooldown = 240;
        this.progressDelay = 50;
        this.progressPlayer = ep;
        ProgressionManager.ProgressStage.TOWER.stepPlayerTo(ep);
        this.scannedPlayers.add(ep.func_110124_au().toString());
        ReikaPacketHelper.sendDataPacketWithRadius((String)"ChromaData", (int)ChromaPackets.DATASCAN.ordinal(), (TileEntity)this, (int)128, (int[])new int[0]);
        ItemStack is = ChromaItems.DATACRYSTAL.getStackOf();
        is.field_77990_d = new NBTTagCompound();
        is.field_77990_d.func_74778_a("owner", ep.func_110124_au().toString());
        EntityItem ei = ReikaItemHelper.dropItem((World)this.field_145850_b, (double)((double)this.field_145851_c + 0.5), (double)(this.field_145848_d + 5), (double)((double)this.field_145849_e + 0.5), (ItemStack)is, (double)3.0);
        ei.field_70181_x = Math.max(ei.field_70181_x, 0.75);
        ei.field_70133_I = true;
        this.scannedPlayers.add(ep.func_110124_au().toString());
        this.syncAllData(true);
    }

    @SideOnly(value=Side.CLIENT)
    public static void doScanFX(World world, int x, int y, int z) {
        EntityBlurFX fx;
        ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.BOUNCE, (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5), (float)2.0f, (float)1.0f, (boolean)false);
        ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.BOUNCE, (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5), (float)2.0f, (float)1.0f, (boolean)false);
        ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.MONUMENTRAY, (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5), (float)2.0f, (float)0.8f, (boolean)false);
        ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.MONUMENTRAY, (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5), (float)2.0f, (float)1.6f, (boolean)false);
        ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.KILLAURA, (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5), (float)2.0f, (float)2.0f, (boolean)false);
        ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.KILLAURA, (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5), (float)2.0f, (float)1.0f, (boolean)false);
        for (double a = 0.0; a < 360.0; a += 1.0) {
            fx = new EntityFloatingSeedsFX(world, (double)x + 0.5, (double)y + 4.5, (double)z + 0.5, a, 0.0);
            fx.setColor(10543359).setLife(120).setRapidExpand();
            fx.particleVelocity *= 2.0;
            fx.freedom *= 2.0;
            fx.angleVelocity *= 2.0;
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
        for (double i = 0.0; i <= 64.0; i += 0.25) {
            fx = new EntityBlurFX(world, (double)x + 0.5, (double)y + 4.5 + i, (double)z + 0.5).setColor(10543359).setLife(120).setRapidExpand().setAlphaFading().setScale(4.0f);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            fx = new EntityBlurFX(world, (double)x + 0.5, (double)y + 4.5 + i, (double)z + 0.5).setColor(0xFFFFFF).setLife(120).setAlphaFading().setScale(1.5f);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c - 0.5), (double)this.field_145848_d, (double)((double)this.field_145849_e - 0.5), (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.75 + 1.375 + 1.125 + 2.0), (double)((double)this.field_145849_e + 0.5)).func_72314_b(3.0, 6.0, 3.0);
    }

    public double func_145833_n() {
        return super.func_145833_n() * 16.0;
    }

    @Override
    public float getOperationFraction() {
        return this.getScanProgress();
    }

    @Override
    public OperationInterval.OperationState getState() {
        return !this.canBeAccessed() || this.scanCooldown > 0 ? OperationInterval.OperationState.INVALID : (this.scanTick > 0 ? OperationInterval.OperationState.RUNNING : OperationInterval.OperationState.PENDING);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.scanCooldown = NBT.func_74762_e("cooldown");
        ReikaNBTHelper.readCollectionFromNBT(this.scannedPlayers, (NBTTagCompound)NBT, (String)"players");
        if (NBT.func_74764_b("tower")) {
            this.tower = Towers.towerList[NBT.func_74762_e("tower")];
        }
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("cooldown", this.scanCooldown);
        ReikaNBTHelper.writeCollectionToNBT(this.scannedPlayers, (NBTTagCompound)NBT, (String)"players");
        if (this.tower != null) {
            NBT.func_74768_a("tower", this.tower.ordinal());
        }
    }

    public boolean hasBeenScanned(EntityPlayer ep) {
        return this.scannedPlayers.contains(ep.func_110124_au().toString());
    }

    public void setTower(Towers tower) {
        this.tower = tower;
    }

    public Towers getTower() {
        return this.tower;
    }
}

