/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity;

import Reika.ChromatiCraft.Base.TileEntity.TileEntityChromaticBase;
import Reika.ChromatiCraft.Block.BlockCrystalTank;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.BlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.FlaggedTank;
import Reika.DragonAPI.Instantiable.HybridTank;
import Reika.DragonAPI.Interfaces.TileEntity.BreakAction;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.ReikaFluidHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import org.lwjgl.input.Keyboard;

public class TileEntityCrystalTank
extends TileEntityChromaticBase
implements IFluidHandler,
FlaggedTank.TankWatcher,
BreakAction {
    public static final int MAXCAPACITY = 2000000000;
    private final FlaggedTank tank = new FlaggedTank((FlaggedTank.TankWatcher)this, "crystaltank", 2000000000);
    private int scheduledUpdate = 0;
    public static final int MAX_UPDATE_RATE = 4;
    private final BlockArray blocks = new BlockArray();
    private int size = 1;
    private Fluid fluidType;
    public HashMap<List<Float>, CrystalElement> runes = new HashMap();
    public int ptick = -1;
    public int lastptick = -1;
    public static final int FACTOR = 4000;

    public void updateEntity(World world, int x, int y, int z, int meta) {
        if (this.scheduledUpdate > 0) {
            --this.scheduledUpdate;
            if (this.scheduledUpdate == 0) {
                this.doUpdate();
            }
        }
    }

    public int getViscosity() {
        return this.fluidType.getViscosity(this.tank.getFluid());
    }

    public int getDensity() {
        return this.fluidType.getDensity(this.tank.getFluid());
    }

    public boolean isInvertedFilled() {
        return false;
    }

    protected void onFirstTick(World world, int x, int y, int z) {
        this.initCoords(world, x, y, z);
        this.doUpdate();
    }

    private void doUpdate() {
        this.fluidType = this.tank.getActualFluid();
        for (int i = 0; i < this.blocks.getSize(); ++i) {
            Coordinate c = this.blocks.getNthBlock(i);
            c.triggerBlockUpdate(this.field_145850_b, false);
        }
    }

    private void scheduleUpdate() {
        if (this.scheduledUpdate == 0) {
            this.scheduledUpdate = 4;
        }
    }

    private void initCoords(World world, int x, int y, int z) {
        if (this.blocks.isEmpty()) {
            int dz;
            int dy;
            int dx;
            Coordinate c;
            int i;
            BlockArray toadd = new BlockArray();
            Set li = ReikaJavaLibrary.getSet((Object[])new BlockKey[]{new BlockKey(ChromaBlocks.TANK.getBlockInstance())});
            toadd.recursiveAddMultipleWithBounds(world, x, y, z, li, x - 32, y - 32, z - 32, x + 32, y + 32, z + 32);
            for (i = 0; i < toadd.getSize(); ++i) {
                c = toadd.getNthBlock(i);
                dx = c.xCoord;
                dy = c.yCoord;
                dz = c.zCoord;
                ChromaTiles ct = ChromaTiles.getTile((IBlockAccess)world, dx, dy, dz);
                if (ct != ChromaTiles.TANK || dx == x && dy == y && dz == z) continue;
                return;
            }
            for (i = 0; i < toadd.getSize(); ++i) {
                c = toadd.getNthBlock(i);
                dx = c.xCoord;
                dy = c.yCoord;
                dz = c.zCoord;
                if (world.func_147439_a(dx, dy, dz) != ChromaBlocks.TANK.getBlockInstance()) continue;
                BlockCrystalTank.CrystalTankAuxTile te = (BlockCrystalTank.CrystalTankAuxTile)world.func_147438_o(dx, dy, dz);
                te.setTile(this);
                world.func_72921_c(dx, dy, dz, 1, 3);
                te.addToTank();
            }
        }
        this.blocks.addBlockCoordinate(x, y, z);
        this.blocks.recalcLimits();
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        int add = Math.min(this.getCapacity() - this.getLevel(), resource.amount);
        if (add > 0) {
            FluidStack fs = new FluidStack(resource.getFluid(), add);
            return this.tank.fill(fs, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.canDrain(from, resource.getFluid()) ? this.tank.drain(resource.amount, doDrain) : null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.tank.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return ReikaFluidHelper.isFluidDrainableFromTank((Fluid)fluid, (HybridTank)this.tank);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.TANK;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    public int getCapacity() {
        int base = Math.min(this.size * this.size, 500000);
        int lin = base * 4000;
        double fac = Math.pow(1.005, this.size - 1);
        int bucket = (int)Math.min(2000000.0, (double)lin * fac / 1000.0);
        int rnd = 1;
        if (bucket > 100) {
            rnd = 10;
        }
        if (bucket > 1000) {
            rnd = 100;
        }
        if (bucket > 10000) {
            rnd = 1000;
        }
        if (rnd > 1) {
            bucket = ReikaMathLibrary.roundUpToX((int)rnd, (int)bucket);
        }
        return bucket * 1000;
    }

    public Fluid getFluid() {
        return this.fluidType;
    }

    public int getLevel() {
        return this.tank.getLevel();
    }

    public BlockArray getBlocks() {
        return this.blocks.copy();
    }

    public void addCoordinate(int x, int y, int z) {
        if (this.blocks.addBlockCoordinate(x, y, z)) {
            ++this.size;
        }
    }

    public void removeCoordinate(int x, int y, int z) {
        if (this.blocks.hasBlock(x, y, z)) {
            --this.size;
        }
        this.blocks.remove(x, y, z);
        if (this.tank.getLevel() > this.getCapacity()) {
            this.tank.setContents(this.getCapacity(), this.fluidType);
        }
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        this.tank.writeToNBT(NBT);
        NBT.func_74768_a("size", this.size);
        this.blocks.writeToNBT("blocks", NBT);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.tank.readFromNBT(NBT);
        this.size = NBT.func_74762_e("size");
        this.blocks.readFromNBT("blocks", NBT);
        this.blocks.addBlockCoordinate(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void func_145841_b(NBTTagCompound NBT) {
        super.func_145841_b(NBT);
    }

    @Override
    public void func_145839_a(NBTTagCompound NBT) {
        super.func_145839_a(NBT);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return this.blocks.asAABB();
    }

    @SideOnly(value=Side.CLIENT)
    public double getFillLevelForY(int y) {
        if (Keyboard.isKeyDown((int)75)) {
            return 1.0;
        }
        int height = this.blocks.getSizeY();
        int min = this.blocks.getMinY();
        int max = this.blocks.getMaxY();
        double per = this.getFillPercentage();
        int fy = (int)((double)min + (double)height * per);
        boolean flip = this.isInvertedFilled();
        if (y < fy) {
            return flip ? 0.0 : 1.0;
        }
        if (y > fy) {
            return flip ? 1.0 : 0.0;
        }
        double fracfull = fy - min;
        double ret = per * (double)height - fracfull;
        return flip ? 1.0 - ret : ret;
    }

    @SideOnly(value=Side.CLIENT)
    public double getHeightOffsetAtCorner(int x, int y, int z, int dx, int dz, double h, float ptick) {
        if (Keyboard.isKeyDown((int)79)) {
            return 0.0;
        }
        if (h == 1.0 || h == 0.0) {
            return 0.0;
        }
        Fluid f = this.fluidType;
        FluidStack fs = this.tank.getFluid();
        int visc = f.getViscosity(fs);
        double idx = 4.0 * (double)((float)this.getTicksExisted() + ptick) + 48.0 * (((double)(x + z) + (double)(dx + dz) * 0.5) % 16.0);
        double idx2 = 4.0 * (double)((float)this.getTicksExisted() + ptick) + 128.0 * (((double)(x + z) + (double)(dx + dz) * 0.5) % 32.0);
        double pow = visc < 1000 ? 0.5 : 0.5;
        double fac = Math.pow(1000.0 / (double)visc, pow);
        if (f.isGaseous(fs)) {
            fac *= 0.75;
        }
        double offset = 0.075 + 0.05 * Math.sin(Math.toRadians(idx *= fac)) + 0.05 * Math.sin(Math.toRadians(idx2 *= fac));
        if (f.isGaseous(fs)) {
            offset *= 1.25;
        }
        if (this.isInvertedFilled()) {
            if (!this.blocks.hasBlock(x, y - 1, z)) {
                offset = -offset;
                offset = Math.max(-h + 0.005, offset);
            }
        } else if (!this.blocks.hasBlock(x, y + 1, z)) {
            offset = Math.min(offset, 1.0 - h);
        }
        return offset *= (double)Math.min(1.0f, 8.0f * (float)this.tank.getLevel() / (float)this.getCapacity());
    }

    public double getFillPercentage() {
        return (double)this.tank.getLevel() / (double)this.getCapacity();
    }

    public void onTankChangeFluidType(String tank, Fluid from, Fluid to) {
        this.scheduleUpdate();
    }

    public boolean isEmpty() {
        return this.tank.isEmpty();
    }

    public void breakBlock() {
        for (int i = 0; i < this.blocks.getSize(); ++i) {
            Coordinate c = this.blocks.getNthBlock(i);
            int dx = c.xCoord;
            int dy = c.yCoord;
            int dz = c.zCoord;
            TileEntity te = this.field_145850_b.func_147438_o(dx, dy, dz);
            if (!(te instanceof BlockCrystalTank.CrystalTankAuxTile)) continue;
            ((BlockCrystalTank.CrystalTankAuxTile)te).reset();
        }
    }
}

