/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity;

import Reika.ChromatiCraft.Auxiliary.Interfaces.OwnedTile;
import Reika.ChromatiCraft.Base.TileEntity.TileEntityRelayPowered;
import Reika.ChromatiCraft.Block.BlockCrystalFence;
import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.Instantiable.Data.Perimeter;
import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaMusicHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityCrystalFence
extends TileEntityRelayPowered
implements OwnedTile {
    private final Perimeter fence = new Perimeter().disallowVertical();
    private ForgeDirection outputFace = ForgeDirection.DOWN;
    private HashMap<Integer, Integer> active = new HashMap();
    private boolean controller = true;
    private int mainCount = 1;
    public static final int RANGE = 16;
    public static final int MAX_STEPS = 32;
    private final StepTimer calcTimer = new StepTimer(100);
    private static final int FADE_STEP = 32;
    private static final int FADE_LENGTH = 128;
    private static final int FADE_START = 512;
    private int chargingTick;
    private boolean[] colorFade;
    private static final ElementTagCompound required = new ElementTagCompound();

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.FENCE;
    }

    @Override
    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateEntity(world, x, y, z, meta);
        if (!world.field_72995_K && !this.fence.isEmpty()) {
            if (this.chargingTick > 0) {
                --this.chargingTick;
                int t = 5;
                if (this.getTicksExisted() % t == 0) {
                    int i = this.getTicksExisted() / t % this.fence.segmentCount();
                    this.triggerSegment(i, false);
                    ReikaMusicHelper.Note n = (ReikaMusicHelper.Note)ReikaMusicHelper.KeySignature.C.getScale().get(i % 7);
                    ChromaSounds.DING.playSoundAtBlock((TileEntity)this, 1.0f, (float)ReikaMusicHelper.MusicKey.getByIndex((int)(ReikaMusicHelper.MusicKey.C5.ordinal() + n.ordinal() + i / 7 * 12)).getRatio(ReikaMusicHelper.MusicKey.C5));
                }
            } else if (this.controller && this.fence.isClosed() && this.energy.containsAtLeast(required)) {
                this.affectEntities();
            }
        }
        for (Integer key : this.active.keySet()) {
            if (key == null) continue;
            int val = this.active.get(key);
            if (val > 0) {
                val -= 32;
            }
            this.active.put(key, val);
        }
    }

    protected void onFirstTick(World world, int x, int y, int z) {
        this.calcFence();
    }

    public void calcFence() {
        this.fence.clear();
        this.fence.addPoint(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.findFrom(this.field_145851_c, this.field_145849_e, this.outputFace, 0);
        this.colorFade = new boolean[this.fence.segmentCount()];
        this.chargingTick = 600;
    }

    public Perimeter getFence() {
        return this.fence;
    }

    public boolean isValid() {
        return this.controller && this.fence.segmentCount() >= 1 && this.fence.isClosed();
    }

    private void findFrom(int x, int z, ForgeDirection dir, int step) {
        for (int i = 1; i < 16; ++i) {
            int dx = x + dir.offsetX * i;
            int dz = z + dir.offsetZ * i;
            TileEntity te = this.field_145850_b.func_147438_o(dx, this.field_145848_d, dz);
            if (this.isValid()) {
                return;
            }
            if (step > 32) {
                this.fence.clear();
                return;
            }
            if (te == this) {
                this.fence.addPoint(dx, this.field_145848_d, dz);
                this.controller = true;
                return;
            }
            if (te instanceof TileEntityCrystalFence) {
                TileEntityCrystalFence fen = (TileEntityCrystalFence)te;
                fen.controller = false;
                ++this.mainCount;
                this.fence.addPoint(dx, this.field_145848_d, dz);
                this.findFrom(dx, dz, fen.outputFace, step + 1);
                return;
            }
            if (!(te instanceof BlockCrystalFence.CrystalFenceAuxTile)) continue;
            BlockCrystalFence.CrystalFenceAuxTile fen = (BlockCrystalFence.CrystalFenceAuxTile)te;
            if (fen.getInput() == dir.getOpposite()) {
                this.fence.addPoint(dx, this.field_145848_d, dz);
                this.findFrom(dx, dz, fen.getOutput(), step + 1);
            } else {
                this.fence.clear();
            }
            return;
        }
    }

    private void affectEntities() {
        ArrayList li = this.fence.getAABBs();
        for (int i = 0; i < li.size(); ++i) {
            AxisAlignedBB aabb = (AxisAlignedBB)li.get(i);
            aabb.field_72338_b = this.field_145848_d - this.getFenceDepth();
            aabb.field_72337_e = this.field_145848_d + 1 + this.getFenceHeight();
            List ents = this.field_145850_b.func_72872_a(EntityLivingBase.class, aabb);
            for (EntityLivingBase e : ents) {
                boolean att = true;
                if (e instanceof EntityPlayer) {
                    EntityPlayer ep = (EntityPlayer)e;
                    if (ep == this.getPlacer()) {
                        att = false;
                    } else if (ReikaPlayerAPI.isReika((EntityPlayer)ep)) {
                        att = false;
                    }
                }
                if (!att) continue;
                e.func_70097_a(DamageSource.field_76367_g, (float)(2 + 2 * this.mainCount));
                double dx = e.field_70165_t - (double)this.field_145851_c - 0.5;
                double dz = e.field_70161_v - (double)this.field_145849_e - 0.5;
                double dd = ReikaMathLibrary.py3d((double)dx, (double)0.0, (double)dz);
                e.field_70159_w = dx / dd;
                e.field_70181_x = 0.5;
                e.field_70179_y = dz / dd;
                e.field_70133_I = true;
                ChromaSounds.DISCHARGE.playSound((Entity)e, 1.0f, 1.4f);
                this.triggerSegment(i, true);
                this.drainEnergy(required);
            }
        }
    }

    public void triggerSegment(int i, boolean fadeColor) {
        if (this.field_145850_b.field_72995_K) {
            this.active.put(i, 640);
            if (this.colorFade.length > i) {
                this.colorFade[i] = fadeColor;
            }
        } else {
            ReikaPacketHelper.sendDataPacketWithRadius((String)"ChromaData", (int)ChromaPackets.FENCETRIGGER.ordinal(), (TileEntity)this, (int)64, (int[])new int[]{i, fadeColor ? 1 : 0});
        }
    }

    public int getSegmentAlpha(int i) {
        Integer get = this.active.get(i);
        if (get == null) {
            return 0;
        }
        if (get > 512) {
            return 512 - (get - 512) * 4;
        }
        return get;
    }

    public boolean colorFade(int i) {
        return false;
    }

    public int getFenceHeight() {
        return 2;
    }

    public int getFenceDepth() {
        return 0;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74757_a("enable", this.controller);
        NBT.func_74768_a("main", this.mainCount);
        NBT.func_74768_a("face", this.outputFace.ordinal());
        NBT.func_74768_a("charge", this.chargingTick);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.controller = NBT.func_74767_n("enable");
        this.mainCount = NBT.func_74762_e("main");
        this.outputFace = this.dirs[NBT.func_74762_e("face")];
        this.chargingTick = NBT.func_74762_e("charge");
    }

    @Override
    public boolean isAcceptingColor(CrystalElement e) {
        return this.controller && required.contains(e);
    }

    @Override
    public int getMaxStorage(CrystalElement e) {
        return 20000;
    }

    @Override
    protected ElementTagCompound getRequiredEnergy() {
        return required.copy();
    }

    @Override
    protected boolean canReceiveFrom(CrystalElement e, ForgeDirection dir) {
        return true;
    }

    public void setFacing(ForgeDirection dir) {
        this.outputFace = dir;
        this.syncAllData(false);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @Override
    public boolean renderModelsInPass1() {
        return true;
    }

    static {
        required.addTag(CrystalElement.RED, 100);
    }
}

