/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity;

import Reika.ChromatiCraft.Auxiliary.CompoundConsole;
import Reika.ChromatiCraft.Base.TileEntity.InventoriedChromaticBase;
import Reika.ChromatiCraft.Items.Tools.ItemCrystalCard;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.DragonAPI.ASM.APIStripper;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.BlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Instantiable.Data.Maps.RegionMap;
import Reika.DragonAPI.Instantiable.Data.Sorter;
import Reika.DragonAPI.Interfaces.TileEntity.BreakAction;
import Reika.DragonAPI.Interfaces.TileEntity.ToggleTile;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaArrayHelper;
import java.util.ArrayList;
import java.util.Arrays;
import mrtjp.projectred.api.IBundledTile;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@APIStripper.Strippable(value={"mrtjp.projectred.api.IBundledTile"})
public class TileEntityCrystalConsole
extends InventoriedChromaticBase
implements BreakAction,
IBundledTile {
    public static final int SLOTS = 4;
    private int slotCount = 4;
    private boolean valid;
    private boolean[] states = new boolean[this.slotCount];
    public ForgeDirection placedDir = ForgeDirection.EAST;
    private ForgeDirection facing = ForgeDirection.EAST;
    private CompoundConsole console;
    private RegionMap<Integer> buttons = new RegionMap();

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.CONSOLE;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        if (this.valid && this.getTicksExisted() % 20 == 0) {
            world.func_147471_g(x, y, z);
        }
    }

    public void toggle(int slot, boolean on) {
        ItemStack is;
        if (!this.field_145850_b.field_72995_K && this.console != null && ChromaItems.CARD.matchWith(is = this.inv[slot])) {
            ArrayList<TileControl> li = ItemCrystalCard.getControllers(is);
            for (TileControl loc : li) {
                loc.toggle(this, on);
            }
        }
        ReikaSoundHelper.playSoundAtBlock((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e, (String)"random.click", (float)0.8f, (float)0.5f);
        this.states[slot] = on;
        this.syncAllData(false);
    }

    protected void onFirstTick(World world, int x, int y, int z) {
        if (!world.field_72995_K) {
            this.validateMultiblock(world, x, y, z);
        }
    }

    private void validateMultiblock(World world, int x, int y, int z) {
        TileEntityCrystalConsole te;
        BlockArray arr = new BlockArray();
        arr.recursiveAdd(world, x, y, z, this.func_145838_q());
        boolean flag = this.isValidShape(arr);
        CompoundConsole con = flag ? new CompoundConsole() : null;
        Sorter s = new Sorter(new Object[]{ForgeDirection.EAST, ForgeDirection.WEST, ForgeDirection.SOUTH, ForgeDirection.NORTH});
        ForgeDirection face = null;
        if (flag) {
            for (Coordinate c : arr.keySet()) {
                te = (TileEntityCrystalConsole)c.getTileEntity(world);
                if (te.placedDir.offsetY != 0) continue;
                s.increment((Object)te.placedDir);
            }
            ArrayList li = s.getSorted();
            for (ForgeDirection dir : li) {
                if (!this.isDirectionValidForShape(dir, arr)) continue;
                face = dir;
                break;
            }
        }
        for (Coordinate c : arr.keySet()) {
            te = (TileEntityCrystalConsole)c.getTileEntity(world);
            te.valid = flag;
            te.console = con;
            if (flag) {
                if (face != null) {
                    te.facing = face;
                }
                te.calcSlots(arr);
                te.calcButtons(arr);
            }
            te.syncAllData(true);
            c.triggerBlockUpdate(world, false);
            te.scheduleBlockUpdate(2);
        }
    }

    private void calcButtons(BlockArray arr) {
        switch (this.facing) {
            case EAST: {
                break;
            }
            case NORTH: {
                break;
            }
            case SOUTH: {
                break;
            }
            case WEST: {
                break;
            }
        }
    }

    private boolean isDirectionValidForShape(ForgeDirection dir, BlockArray arr) {
        if (arr.getSizeX() == 1) {
            return dir.offsetX != 0;
        }
        return dir.offsetZ != 0;
    }

    private void calcSlots(BlockArray arr) {
        this.slotCount = 3;
        boolean flag = false;
        switch (this.facing) {
            case EAST: {
                flag = arr.hasBlock(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1);
                break;
            }
            case NORTH: {
                flag = arr.hasBlock(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e);
                break;
            }
            case SOUTH: {
                flag = arr.hasBlock(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e);
                break;
            }
            case WEST: {
                flag = arr.hasBlock(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1);
                break;
            }
        }
        if (flag) {
            this.slotCount = 4;
        }
        this.states = Arrays.copyOf(this.states, this.slotCount);
    }

    public void setFacing(ForgeDirection dir) {
        if (dir == this.facing.getOpposite()) {
            this.facing = dir;
        }
    }

    public boolean getState(int state) {
        return this.states[state];
    }

    public boolean isValid() {
        return this.valid;
    }

    public ForgeDirection getConsoleFace() {
        return this.facing;
    }

    private boolean isValidShape(BlockArray arr) {
        return arr.getVolume() == arr.getSize() && (arr.getSizeX() == 1 || arr.getSizeZ() == 1);
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        NBT.func_74757_a("valid", this.valid);
        NBT.func_74768_a("states", ReikaArrayHelper.booleanToBitflags((boolean[])this.states));
        NBT.func_74768_a("slots", this.slotCount);
        NBT.func_74768_a("face", this.facing.ordinal());
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        this.valid = NBT.func_74767_n("valid");
        this.slotCount = NBT.func_74762_e("slots");
        this.states = ReikaArrayHelper.booleanFromBitflags((int)NBT.func_74762_e("states"), (int)this.slotCount);
        this.facing = this.dirs[NBT.func_74762_e("face")];
    }

    @Override
    public void func_145841_b(NBTTagCompound NBT) {
        super.func_145841_b(NBT);
        NBT.func_74768_a("place", this.placedDir.ordinal());
    }

    @Override
    public void func_145839_a(NBTTagCompound NBT) {
        super.func_145839_a(NBT);
        this.placedDir = this.dirs[NBT.func_74762_e("place")];
    }

    public void breakBlock() {
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = this.dirs[i];
            TileEntity te = this.getAdjacentTileEntity(dir);
            if (!(te instanceof TileEntityCrystalConsole)) continue;
            ((TileEntityCrystalConsole)te).validateMultiblock(te.field_145850_b, te.field_145851_c, te.field_145848_d, te.field_145849_e);
        }
    }

    public boolean func_102008_b(int i, ItemStack is, int side) {
        return false;
    }

    public int func_70302_i_() {
        return 4;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_94041_b(int i, ItemStack is) {
        return is.func_77973_b() == ChromaItems.CARD.getItemInstance();
    }

    public byte[] getBundledSignal(int dir) {
        return this.console != null ? this.console.getBundled() : null;
    }

    public boolean canConnectBundled(int side) {
        return side != this.getConsoleFace().ordinal();
    }

    public int getSlotCount() {
        return this.slotCount;
    }

    public TileEntity getLeftBlock() {
        switch (this.getConsoleFace()) {
            case EAST: {
                return this.getAdjacentTileEntity(ForgeDirection.SOUTH);
            }
            case NORTH: {
                return this.getAdjacentTileEntity(ForgeDirection.EAST);
            }
            case WEST: {
                return this.getAdjacentTileEntity(ForgeDirection.NORTH);
            }
            case SOUTH: {
                return this.getAdjacentTileEntity(ForgeDirection.WEST);
            }
        }
        return null;
    }

    public TileEntity getRightBlock() {
        switch (this.getConsoleFace()) {
            case EAST: {
                return this.getAdjacentTileEntity(ForgeDirection.NORTH);
            }
            case NORTH: {
                return this.getAdjacentTileEntity(ForgeDirection.WEST);
            }
            case WEST: {
                return this.getAdjacentTileEntity(ForgeDirection.SOUTH);
            }
            case SOUTH: {
                return this.getAdjacentTileEntity(ForgeDirection.EAST);
            }
        }
        return null;
    }

    public static class TileControl {
        private final ControlMode mode;
        private final Object[] data;
        private final WorldLocation location;

        private TileControl(ControlMode m, WorldLocation loc, Object ... dat) {
            this.mode = m;
            this.location = loc;
            this.data = dat;
        }

        public void toggle(TileEntityCrystalConsole te, boolean on) {
            this.mode.toggle(on, te, this.location, this.data);
        }

        public static TileControl createFromNBT(NBTTagCompound NBT) {
            ControlMode mode = ControlMode.values()[NBT.func_74762_e("mode")];
            WorldLocation loc = WorldLocation.readFromNBT((String)"loc", (NBTTagCompound)NBT);
            NBTTagCompound tag = NBT.func_74775_l("data");
            ArrayList<Integer> li = new ArrayList<Integer>();
            switch (mode) {
                case BUNDLED: {
                    li.add(tag.func_74762_e("channel"));
                    li.add(tag.func_74762_e("signal"));
                    break;
                }
                case REDSTONE: {
                    li.add(tag.func_74762_e("signal"));
                    break;
                }
            }
            return new TileControl(mode, loc, li.toArray());
        }

        public void writeToNBT(NBTTagCompound NBT) {
            NBT.func_74768_a("mode", this.mode.ordinal());
            NBTTagCompound tag = new NBTTagCompound();
            switch (this.mode) {
                case BUNDLED: {
                    tag.func_74768_a("channel", ((Integer)this.data[0]).intValue());
                    tag.func_74768_a("signal", ((Integer)this.data[1]).intValue());
                    break;
                }
                case REDSTONE: {
                    tag.func_74768_a("signal", ((Integer)this.data[0]).intValue());
                    break;
                }
            }
            NBT.func_74782_a("data", (NBTBase)tag);
            this.location.writeToNBT("loc", NBT);
        }
    }

    public static enum ControlMode {
        REDSTONE,
        TOGGLETILE,
        BUNDLED;


        private void toggle(boolean on, TileEntityCrystalConsole te, WorldLocation loc, Object ... data) {
            switch (this) {
                case BUNDLED: {
                    int ch = (Integer)data[0];
                    ((TileEntityCrystalConsole)te).console.getBundled()[ch] = (byte)(on ? (Integer)data[1] : 0);
                    break;
                }
                case REDSTONE: {
                    break;
                }
                case TOGGLETILE: {
                    TileEntity tile = loc.getTileEntity();
                    if (!(tile instanceof ToggleTile)) break;
                    ((ToggleTile)te).setEnabled(on);
                }
            }
        }

        public ControlMode next() {
            ControlMode[] list = ControlMode.values();
            return this.ordinal() == list.length - 1 ? list[0] : list[this.ordinal() + 1];
        }
    }
}

