/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity;

import Reika.ChromatiCraft.API.BiomeBlacklist;
import Reika.ChromatiCraft.Base.ChromaDimensionBiome;
import Reika.ChromatiCraft.Base.TileEntity.TileEntityChromaticBase;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Render.Particle.EntityCenterBlurFX;
import Reika.ChromatiCraft.World.BiomeGlowingCliffs;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.CubeRotation;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Interfaces.TileEntity.GuiController;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.Java.ReikaObfuscationHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class TileEntityBiomePainter
extends TileEntityChromaticBase
implements GuiController {
    private static final Collection<BiomeBlacklist.BiomeConnection> blacklist = new ArrayList<BiomeBlacklist.BiomeConnection>();
    private static final MultiMap<BiomeGenBase, BiomeGenBase> availableBiomes = new MultiMap();
    public static final int RANGE = 64;
    public final CubeRotation rotation = new CubeRotation().randomize(rand);
    private BiomeGenBase placedBiome;
    public boolean safeMode = false;

    public BiomeGenBase getNaturalBiomeAt(int dx, int dz) {
        return ReikaWorldHelper.getNaturalGennedBiomeAt((World)this.field_145850_b, (int)(this.field_145851_c + dx - 64), (int)(this.field_145849_e + dz - 64));
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.BIOMEPAINTER;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        if (world.field_72995_K) {
            this.doParticles(world, x, y, z);
        }
    }

    protected void onFirstTick(World world, int x, int y, int z) {
        this.placedBiome = world.func_72807_a(x, z);
    }

    @SideOnly(value=Side.CLIENT)
    private void doParticles(World world, int x, int y, int z) {
        double px = (double)x + 0.0625 + rand.nextDouble() * 0.875;
        double py = (double)y + 0.0625 + rand.nextDouble() * 0.875;
        double pz = (double)z + 0.0625 + rand.nextDouble() * 0.875;
        double vx = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.03125);
        double vy = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.03125);
        double vz = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.03125);
        float g = (float)ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.03125);
        EntityCenterBlurFX fx = new EntityCenterBlurFX(world, px, py, pz, vx, vy, vz).setGravity(g).setColor(rand.nextInt(0xFFFFFF));
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    public void changeBiomeAt(int dx, int dz, BiomeGenBase biome) {
        if (this.canChangeBiomeAt(dx, dz, this.field_145850_b.func_72807_a(dx, dz))) {
            if (!this.field_145850_b.field_72995_K) {
                ReikaWorldHelper.setBiomeForXZ((World)this.field_145850_b, (int)dx, (int)dz, (BiomeGenBase)biome);
            } else {
                int id = biome != null ? biome.field_76756_M : -1;
                ReikaPacketHelper.sendDataPacket((String)"ChromaData", (int)ChromaPackets.BIOMEPAINT.ordinal(), (TileEntity)this, (int)dx, (int)dz, (int)id);
            }
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound NBT) {
        super.func_145841_b(NBT);
    }

    @Override
    public void func_145839_a(NBTTagCompound NBT) {
        super.func_145839_a(NBT);
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74757_a("safe", this.safeMode);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.safeMode = NBT.func_74767_n("safe");
    }

    public boolean canChangeBiomeAt(int dx, int dz, BiomeGenBase from) {
        return !this.safeMode || from == this.placedBiome;
    }

    public static void buildBiomeList() {
        availableBiomes.clear();
        for (int i = 0; i < BiomeGenBase.field_76773_a.length; ++i) {
            BiomeGenBase b = BiomeGenBase.field_76773_a[i];
            if (b == null) continue;
            for (int k = 0; k < BiomeGenBase.field_76773_a.length; ++k) {
                BiomeGenBase b2 = BiomeGenBase.field_76773_a[k];
                if (b2 == null || !TileEntityBiomePainter.isValid(b, b2)) continue;
                availableBiomes.addValue((Object)b, (Object)b2);
            }
        }
    }

    private static boolean isValid(BiomeGenBase b, BiomeGenBase b2) {
        for (BiomeBlacklist.BiomeConnection bc : blacklist) {
            if (bc.isLegalTransition(b, b2)) continue;
            return false;
        }
        return true;
    }

    public static void addBiomeConnection(BiomeBlacklist.BiomeConnection bc) {
        blacklist.add(bc);
    }

    public static HashSet<BiomeGenBase> getValidBiomesFor(BiomeGenBase in) {
        return new HashSet<BiomeGenBase>(availableBiomes.get((Object)in));
    }

    public static Collection<BiomeGenBase> getValidBiomes() {
        return Collections.unmodifiableCollection(availableBiomes.allValues(false));
    }

    static {
        blacklist.add(new ChromaBiomeBlacklist());
    }

    private static class ChromaBiomeBlacklist
    implements BiomeBlacklist.BiomeConnection {
        private ChromaBiomeBlacklist() {
        }

        @Override
        public boolean isLegalTransition(BiomeGenBase in, BiomeGenBase out) {
            return DragonAPICore.isReikasComputer() && ReikaObfuscationHelper.isDeObfEnvironment() || this.isAccessibleBiome(in) && this.isAccessibleBiome(out);
        }

        private boolean isAccessibleBiome(BiomeGenBase in) {
            if (in == ChromatiCraft.rainbowforest) {
                // empty if block
            }
            if (in instanceof ChromaDimensionBiome) {
                return false;
            }
            return !(in instanceof BiomeGlowingCliffs);
        }
    }
}

