/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity;

import Reika.ChromatiCraft.Auxiliary.Interfaces.ItemOnRightClick;
import Reika.ChromatiCraft.Base.TileEntity.FluidReceiverInventoryBase;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.Libraries.IO.ReikaColorAPI;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class TileEntityAuraInfuser_Old1
extends FluidReceiverInventoryBase
implements ItemOnRightClick {
    private CrystalElement color;
    private int berries;
    public static final int BERRY_UNIT = 24;
    public static final int DURATION = 20;
    private int progressTimer = 0;

    public void updateEntity(World world, int x, int y, int z, int meta) {
        if (this.canProcess()) {
            if (this.progressTimer < 20) {
                ++this.progressTimer;
            } else {
                this.process();
                this.progressTimer = 0;
            }
            this.syncAllData(true);
        } else if (ChromaItems.BERRY.matchWith(this.inv[0]) && this.tank.isFull() && this.tank.getActualFluid().equals(FluidRegistry.getFluid((String)"chroma"))) {
            if (this.progressTimer < 20) {
                ++this.progressTimer;
            } else {
                this.color = CrystalElement.elements[this.inv[0].func_77960_j()];
                ++this.berries;
                this.inv[0] = null;
                this.progressTimer = 0;
            }
            this.syncAllData(true);
        } else {
            this.progressTimer = 0;
        }
    }

    public int getColor() {
        return this.color != null ? ReikaColorAPI.mixColors((int)this.color.getColor(), (int)0xFFFFFF, (float)((float)this.berries / 24.0f)) : 0xFFFFFF;
    }

    public int getProgressScaled(int a) {
        return a * this.progressTimer / 20;
    }

    public int getProgress() {
        return this.progressTimer;
    }

    private boolean canProcess() {
        boolean hasFluid;
        if (!ChromaItems.SHARD.matchWith(this.inv[0])) {
            return false;
        }
        if (this.inv[0].func_77960_j() >= 16) {
            return false;
        }
        boolean bl = hasFluid = this.tank.isFull() && this.tank.getActualFluid().equals(FluidRegistry.getFluid((String)"chroma"));
        if (!hasFluid && this.progressTimer == 0) {
            return false;
        }
        boolean hasenergy = this.berries >= 24 && this.color == CrystalElement.elements[this.inv[0].func_77960_j()];
        return hasenergy;
    }

    private void process() {
        this.inv[0].func_77964_b(this.inv[0].func_77960_j() + 16);
        this.tank.removeLiquid(this.tank.getCapacity());
        this.berries = 0;
        this.color = null;
    }

    public boolean func_102008_b(int i, ItemStack is, int j) {
        return ChromaItems.SHARD.matchWith(is) && is.func_77960_j() >= 16 && is.func_77960_j() < 32;
    }

    public int func_70302_i_() {
        return 1;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_94041_b(int i, ItemStack is) {
        if (this.progressTimer > 0) {
            return false;
        }
        boolean shard = ChromaItems.SHARD.matchWith(is) && is.func_77960_j() < 16;
        boolean berry = ChromaItems.BERRY.matchWith(is) && (this.color == null || is.func_77960_j() == this.color.ordinal()) && this.berries < 24;
        return shard || berry;
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.INFUSER;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public int getCapacity() {
        return 500;
    }

    @Override
    public Fluid getInputFluid() {
        return FluidRegistry.getFluid((String)"chroma");
    }

    @Override
    public boolean canReceiveFrom(ForgeDirection from) {
        return from.offsetY == 0 && this.progressTimer == 0 && (!ChromaItems.SHARD.matchWith(this.inv[0]) || this.inv[0].func_77960_j() < 16);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        int e = NBT.func_74762_e("color");
        this.color = e >= 0 ? CrystalElement.elements[e] : null;
        this.berries = NBT.func_74762_e("berries");
        this.progressTimer = NBT.func_74762_e("progress");
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("color", this.color != null ? this.color.ordinal() : -1);
        NBT.func_74768_a("berries", this.berries);
        NBT.func_74768_a("progress", this.progressTimer);
    }

    @Override
    public ItemStack onRightClickWith(ItemStack item, EntityPlayer ep) {
        if (item != null && !this.func_94041_b(0, item)) {
            return item;
        }
        ItemStack ret = this.inv[0];
        ItemStack itemStack = this.inv[0] = item != null ? ReikaItemHelper.getSizedItemStack((ItemStack)item, (int)1) : null;
        if (ret == null && item != null && item.field_77994_a > 1) {
            ret = ReikaItemHelper.getSizedItemStack((ItemStack)item, (int)(item.field_77994_a - 1));
        }
        return ret;
    }
}

