/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.Technical;

import Reika.ChromatiCraft.Auxiliary.ChromaStacks;
import Reika.ChromatiCraft.Auxiliary.ChromaStructures;
import Reika.ChromatiCraft.Auxiliary.MonumentCompletionRitual;
import Reika.ChromatiCraft.Auxiliary.OceanStructure;
import Reika.ChromatiCraft.Auxiliary.ProgressionManager;
import Reika.ChromatiCraft.Base.TileEntity.InventoriedChromaticBase;
import Reika.ChromatiCraft.Block.Worldgen.BlockLootChest;
import Reika.ChromatiCraft.Block.Worldgen.BlockStructureShield;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityCenterBlurFX;
import Reika.ChromatiCraft.TileEntity.Technical.TileEntityDimensionCore;
import Reika.ChromatiCraft.World.Dimension.ChunkProviderChroma;
import Reika.ChromatiCraft.World.Dimension.Structure.MonumentGenerator;
import Reika.ChromatiCraft.World.IWG.DungeonGenerator;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.BlockArray;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.FilledBlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldChunk;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Interfaces.TileEntity.BreakAction;
import Reika.DragonAPI.Interfaces.TileEntity.HitAction;
import Reika.DragonAPI.Interfaces.TileEntity.InertIInv;
import Reika.DragonAPI.Interfaces.TileEntity.PlayerBreakHook;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.IO.ReikaRenderHelper;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.MinecraftForge;

public class TileEntityStructControl
extends InventoriedChromaticBase
implements BreakAction,
HitAction,
InertIInv,
PlayerBreakHook {
    private ChromaStructures.Structures struct;
    private FilledBlockArray blocks;
    private CrystalElement color;
    private final EnumMap<CrystalElement, Coordinate> crystals = new EnumMap(CrystalElement.class);
    private boolean triggered = false;
    private boolean regenned = false;
    private int trapTick = 0;
    private UUID lastTriggerPlayer;
    private boolean isMonument;
    private boolean triggeredMonument;
    private MonumentCompletionRitual monument;

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.STRUCTCONTROL;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        if (world.field_72995_K && this.struct != null && world.func_72977_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 12.0) != null) {
            this.spawnParticles(world, x, y, z);
        }
        if (this.isMonument && this.triggeredMonument && this.monument != null) {
            this.monument.tick();
        }
        if (this.isMonument && DragonAPICore.debugtest) {
            for (int i = 0; i < 16; ++i) {
                Coordinate c = TileEntityDimensionCore.getLocation(CrystalElement.elements[i]);
                c = c.offset(x, y, z);
                c.setBlock(world, ChromaTiles.DIMENSIONCORE.getBlock(), ChromaTiles.DIMENSIONCORE.getBlockMetadata());
                ((TileEntityDimensionCore)c.getTileEntity(world)).setPlacer(world.func_72977_a((double)x, (double)y, (double)z, -1.0));
                ((TileEntityDimensionCore)c.getTileEntity(world)).prime(true);
                ((TileEntityDimensionCore)c.getTileEntity(world)).setColor(CrystalElement.elements[i]);
            }
            MonumentGenerator gen = ChunkProviderChroma.getMonumentGenerator();
            Map<Coordinate, Block> map = gen.getMineralBlocks();
            for (Coordinate c : map.keySet()) {
                c.setBlock(world, map.get(c));
            }
        }
        if (!this.triggered && this.struct != null && this.getTicksExisted() % 4 == 0) {
            List li = world.field_73010_i;
            for (EntityPlayer ep : li) {
                if (!ep.field_70121_D.func_72326_a(this.getBox(x, y, z))) continue;
                this.onPlayerProximity(world, x, y, z, ep);
                this.lastTriggerPlayer = ep.getPersistentID();
            }
        }
        if (this.struct == ChromaStructures.Structures.OCEAN) {
            if (this.trapTick > 0) {
                --this.trapTick;
            } else {
                this.resetOceanTrap();
            }
        }
    }

    public void onHit(World world, int x, int y, int z, EntityPlayer ep) {
        this.trigger(x, y, z, ep);
    }

    private void trigger(int x, int y, int z, EntityPlayer ep) {
        if (this.struct != null) {
            switch (this.struct) {
                case CAVERN: {
                    break;
                }
                case BURROW: {
                    break;
                }
                case OCEAN: {
                    if (y != this.field_145848_d && y != this.field_145848_d - 1 || Math.abs(x - this.field_145851_c) > 3 || Math.abs(z - this.field_145849_e) > 3) break;
                    this.triggerOceanTrap(ep);
                    break;
                }
                case DESERT: {
                    break;
                }
            }
        }
    }

    private void triggerOceanTrap(EntityPlayer ep) {
        BlockArray arr = OceanStructure.getPitCover(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        for (int i = 0; i < arr.getSize(); ++i) {
            Coordinate c = arr.getNthBlock(i);
            int dx = c.xCoord;
            int dy = c.yCoord;
            int dz = c.zCoord;
            this.field_145850_b.func_147449_b(dx, dy, dz, Blocks.field_150350_a);
        }
        ChromaSounds.TRAP.playSound((Entity)ep, 1.0f, 1.0f);
        this.trapTick = 40;
        this.disableJetpack(ep);
    }

    private void disableJetpack(EntityPlayer ep) {
        ItemStack chest = ep.func_82169_q(2);
        if (chest != null) {
            // empty if block
        }
    }

    private void resetOceanTrap() {
        BlockArray arr = OceanStructure.getPitCover(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        for (int i = 0; i < arr.getSize(); ++i) {
            Coordinate c = arr.getNthBlock(i);
            int dx = c.xCoord;
            int dy = c.yCoord;
            int dz = c.zCoord;
            this.field_145850_b.func_147465_d(dx, dy, dz, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.CLOAK.metadata, 3);
        }
    }

    private AxisAlignedBB getBox(int x, int y, int z) {
        AxisAlignedBB aabb = ReikaAABBHelper.getBlockAABB((int)x, (int)y, (int)z);
        switch (this.struct) {
            case CAVERN: {
                return aabb.func_72314_b(3.0, 1.0, 3.0);
            }
            case BURROW: {
                return aabb.func_72317_d(2.0, 1.0, 0.0).func_72314_b(0.5, 0.5, 0.5);
            }
            case OCEAN: {
                return aabb.func_72317_d(0.0, 2.0, 0.0).func_72314_b(1.0, 1.0, 1.0);
            }
            case DESERT: {
                return aabb.func_72314_b(5.0, 2.0, 5.0).func_72317_d(0.0, 1.0, 0.0);
            }
        }
        return aabb;
    }

    private void onPlayerProximity(World world, int x, int y, int z, EntityPlayer ep) {
        if (this.struct != null) {
            this.calcCrystals(world, x, y, z);
        }
        switch (this.struct) {
            case CAVERN: {
                if (!world.field_72995_K) {
                    world.func_147465_d(x + 7, y, z, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.CLOAK.metadata, 3);
                    world.func_147465_d(x + 7, y - 1, z, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.CLOAK.metadata, 3);
                }
                ChromaSounds.TRAP.playSound((Entity)ep, 1.0f, 1.0f);
                break;
            }
            case BURROW: {
                world.func_72921_c(x + 2, y + 1, z, BlockStructureShield.BlockType.CRACK.metadata, 3);
                ReikaSoundHelper.playBreakSound((World)world, (int)(x + 2), (int)(y + 1), (int)z, (Block)Blocks.field_150348_b);
                if (!world.field_72995_K) break;
                ReikaRenderHelper.spawnDropParticles((World)world, (int)(x + 2), (int)(y + 1), (int)z, (Block)ChromaBlocks.STRUCTSHIELD.getBlockInstance(), (int)BlockStructureShield.BlockType.STONE.metadata);
                break;
            }
            case OCEAN: {
                BlockArray blocks = OceanStructure.getCovers(x, y, z);
                for (int i = 0; i < blocks.getSize(); ++i) {
                    Coordinate c = blocks.getNthBlock(i);
                    int dx = c.xCoord;
                    int dy = c.yCoord;
                    int dz = c.zCoord;
                    world.func_72921_c(dx, dy, dz, BlockStructureShield.BlockType.CRACKS.metadata, 3);
                }
                int r = 1;
                for (int i = -r; i <= r; ++i) {
                    for (int k = -r; k <= r; ++k) {
                        ReikaSoundHelper.playBreakSound((World)world, (int)(x + i), (int)(y + 1), (int)(z + k), (Block)Blocks.field_150348_b);
                        if (!world.field_72995_K) continue;
                        ReikaRenderHelper.spawnDropParticles((World)world, (int)(x + i), (int)(y + 3), (int)(z + k), (Block)ChromaBlocks.STRUCTSHIELD.getBlockInstance(), (int)BlockStructureShield.BlockType.STONE.metadata);
                    }
                }
                ChromaSounds.TRAP.playSound((Entity)ep, 1.0f, 1.0f);
                break;
            }
            case DESERT: {
                ChromaSounds.TRAP.playSound((Entity)ep, 1.0f, 1.0f);
                ReikaSoundHelper.playBreakSound((World)world, (int)x, (int)(y + 2), (int)z, (Block)Blocks.field_150348_b);
                if (world.field_72995_K) {
                    ReikaRenderHelper.spawnDropParticles((World)world, (int)x, (int)(y + 2), (int)z, (Block)ChromaBlocks.STRUCTSHIELD.getBlockInstance(), (int)BlockStructureShield.BlockType.STONE.metadata);
                }
                world.func_147465_d((x -= 7) + 5, (y -= 3) + 9, (z -= 7) + 5, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata, 3);
                world.func_147465_d(x + 5, y + 9, z + 9, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata, 3);
                world.func_147465_d(x + 9, y + 9, z + 5, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata, 3);
                world.func_147465_d(x + 9, y + 9, z + 9, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.STONE.metadata, 3);
                world.func_147465_d(x + 5, y + 5, z + 5, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.CLOAK.metadata, 3);
                world.func_147465_d(x + 5, y + 5, z + 9, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.CLOAK.metadata, 3);
                world.func_147465_d(x + 9, y + 5, z + 5, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.CLOAK.metadata, 3);
                world.func_147465_d(x + 9, y + 5, z + 9, ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.CLOAK.metadata, 3);
                world.func_72921_c(x + 12, y + 5, z + 6, BlockStructureShield.BlockType.CRACK.metadata, 3);
                world.func_72921_c(x + 12, y + 5, z + 7, BlockStructureShield.BlockType.CRACK.metadata, 3);
                world.func_72921_c(x + 12, y + 5, z + 8, BlockStructureShield.BlockType.CRACK.metadata, 3);
                world.func_72921_c(x + 12, y + 6, z + 7, BlockStructureShield.BlockType.CRACK.metadata, 3);
                world.func_72921_c(x + 11, y + 5, z + 6, BlockStructureShield.BlockType.CRACK.metadata, 3);
                world.func_72921_c(x + 11, y + 5, z + 7, BlockStructureShield.BlockType.CRACK.metadata, 3);
                world.func_72921_c(x + 11, y + 5, z + 8, BlockStructureShield.BlockType.CRACK.metadata, 3);
                world.func_72921_c(x + 8, y + 5, z + 11, BlockStructureShield.BlockType.CRACK.metadata, 3);
                world.func_72921_c(x + 8, y + 5, z + 12, BlockStructureShield.BlockType.CRACK.metadata, 3);
                world.func_72921_c(x + 8, y + 5, z + 2, BlockStructureShield.BlockType.CRACK.metadata, 3);
                world.func_72921_c(x + 8, y + 5, z + 3, BlockStructureShield.BlockType.CRACK.metadata, 3);
                world.func_72921_c(x + 7, y + 5, z + 11, BlockStructureShield.BlockType.CRACK.metadata, 3);
                world.func_72921_c(x + 7, y + 5, z + 12, BlockStructureShield.BlockType.CRACK.metadata, 3);
                world.func_72921_c(x + 2, y + 5, z + 6, BlockStructureShield.BlockType.CRACK.metadata, 3);
                world.func_72921_c(x + 2, y + 5, z + 7, BlockStructureShield.BlockType.CRACK.metadata, 3);
                world.func_72921_c(x + 2, y + 5, z + 8, BlockStructureShield.BlockType.CRACK.metadata, 3);
                world.func_72921_c(x + 2, y + 6, z + 7, BlockStructureShield.BlockType.CRACK.metadata, 3);
                world.func_72921_c(x + 3, y + 5, z + 6, BlockStructureShield.BlockType.CRACK.metadata, 3);
                world.func_72921_c(x + 3, y + 5, z + 7, BlockStructureShield.BlockType.CRACK.metadata, 3);
                world.func_72921_c(x + 3, y + 5, z + 8, BlockStructureShield.BlockType.CRACK.metadata, 3);
                world.func_72921_c(x + 3, y + 6, z + 7, BlockStructureShield.BlockType.CRACK.metadata, 3);
                world.func_72921_c(x + 6, y + 5, z + 2, BlockStructureShield.BlockType.CRACK.metadata, 3);
                world.func_72921_c(x + 6, y + 5, z + 3, BlockStructureShield.BlockType.CRACK.metadata, 3);
                world.func_72921_c(x + 6, y + 5, z + 11, BlockStructureShield.BlockType.CRACK.metadata, 3);
                world.func_72921_c(x + 6, y + 5, z + 12, BlockStructureShield.BlockType.CRACK.metadata, 3);
                world.func_72921_c(x + 7, y + 5, z + 2, BlockStructureShield.BlockType.CRACK.metadata, 3);
                world.func_72921_c(x + 7, y + 5, z + 3, BlockStructureShield.BlockType.CRACK.metadata, 3);
                world.func_72921_c(x + 7, y + 6, z + 2, BlockStructureShield.BlockType.CRACK.metadata, 3);
                world.func_72921_c(x + 7, y + 6, z + 3, BlockStructureShield.BlockType.CRACK.metadata, 3);
                world.func_72921_c(x + 7, y + 6, z + 11, BlockStructureShield.BlockType.CRACK.metadata, 3);
                world.func_72921_c(x + 7, y + 6, z + 12, BlockStructureShield.BlockType.CRACK.metadata, 3);
                world.func_72921_c(x + 11, y + 6, z + 7, BlockStructureShield.BlockType.CRACK.metadata, 3);
                break;
            }
        }
        this.openUpperChests();
        ProgressionManager.ProgressStage.ANYSTRUCT.stepPlayerTo(ep);
        this.getProgressStage().stepPlayerTo(ep);
        this.triggered = true;
    }

    public void reopenStructure() {
        boolean flag = false;
        if (this.struct != null) {
            switch (this.struct) {
                case CAVERN: {
                    this.field_145850_b.func_147449_b(this.field_145851_c + 7, this.field_145848_d, this.field_145849_e, Blocks.field_150350_a);
                    this.field_145850_b.func_147449_b(this.field_145851_c + 7, this.field_145848_d - 1, this.field_145849_e, Blocks.field_150350_a);
                    flag = true;
                    break;
                }
                case DESERT: {
                    int x = this.field_145851_c - 7;
                    int z = this.field_145849_e - 7;
                    int y = this.field_145848_d - 3;
                    this.field_145850_b.func_147449_b(x + 5, y + 9, z + 5, Blocks.field_150350_a);
                    this.field_145850_b.func_147449_b(x + 5, y + 9, z + 9, Blocks.field_150350_a);
                    this.field_145850_b.func_147449_b(x + 9, y + 9, z + 5, Blocks.field_150350_a);
                    this.field_145850_b.func_147449_b(x + 9, y + 9, z + 9, Blocks.field_150350_a);
                    this.field_145850_b.func_147449_b(x + 5, y + 5, z + 5, Blocks.field_150322_A);
                    this.field_145850_b.func_147449_b(x + 5, y + 5, z + 9, Blocks.field_150322_A);
                    this.field_145850_b.func_147449_b(x + 9, y + 5, z + 5, Blocks.field_150322_A);
                    this.field_145850_b.func_147449_b(x + 9, y + 5, z + 9, Blocks.field_150322_A);
                    flag = true;
                    break;
                }
            }
        }
        if (flag) {
            this.triggered = false;
            this.lastTriggerPlayer = null;
        }
    }

    private void openUpperChests() {
        switch (this.struct) {
            case CAVERN: {
                if (this.blocks == null) break;
                for (int i = 0; i < this.blocks.getSize(); ++i) {
                    Coordinate c = this.blocks.getNthBlock(i);
                    int x = c.xCoord;
                    int y = c.yCoord;
                    int z = c.zCoord;
                    if (y <= this.field_145848_d || this.field_145850_b.func_147439_a(x, y, z) != ChromaBlocks.LOOTCHEST.getBlockInstance()) continue;
                    this.field_145850_b.func_72921_c(x, y, z, this.field_145850_b.func_72805_g(x, y, z) % 8, 3);
                    ReikaSoundHelper.playBreakSound((World)this.field_145850_b, (int)x, (int)y, (int)z, (Block)Blocks.field_150348_b);
                }
                break;
            }
            case BURROW: {
                if (this.blocks == null) break;
                for (int i = 0; i < this.blocks.getSize(); ++i) {
                    Coordinate c = this.blocks.getNthBlock(i);
                    int x = c.xCoord + 5;
                    int y = c.yCoord + 8;
                    int z = c.zCoord + 2;
                    if (y <= this.field_145848_d || this.field_145850_b.func_147439_a(x, y, z) != ChromaBlocks.LOOTCHEST.getBlockInstance()) continue;
                    this.field_145850_b.func_72921_c(x, y, z, this.field_145850_b.func_72805_g(x, y, z) % 8, 3);
                    ReikaSoundHelper.playBreakSound((World)this.field_145850_b, (int)x, (int)y, (int)z, (Block)Blocks.field_150348_b);
                }
                break;
            }
            case OCEAN: {
                if (this.blocks == null) break;
                for (int i = 0; i < this.blocks.getSize(); ++i) {
                    Coordinate c = this.blocks.getNthBlock(i);
                    int x = c.xCoord;
                    int y = c.yCoord;
                    int z = c.zCoord;
                    if (y <= this.field_145848_d || this.field_145850_b.func_147439_a(x, y, z) != ChromaBlocks.LOOTCHEST.getBlockInstance()) continue;
                    this.field_145850_b.func_72921_c(x, y, z, this.field_145850_b.func_72805_g(x, y, z) % 8, 3);
                    ReikaSoundHelper.playBreakSound((World)this.field_145850_b, (int)x, (int)y, (int)z, (Block)Blocks.field_150348_b);
                }
                break;
            }
            case DESERT: {
                if (this.blocks == null) break;
                for (int i = 0; i < this.blocks.getSize(); ++i) {
                    Coordinate c = this.blocks.getNthBlock(i);
                    int x = c.xCoord - 7;
                    int y = c.yCoord - 3;
                    int z = c.zCoord - 7;
                    if (y <= this.field_145848_d || this.field_145850_b.func_147439_a(x, y, z) != ChromaBlocks.LOOTCHEST.getBlockInstance()) continue;
                    this.field_145850_b.func_72921_c(x, y, z, this.field_145850_b.func_72805_g(x, y, z) % 8, 3);
                    ReikaSoundHelper.playBreakSound((World)this.field_145850_b, (int)x, (int)y, (int)z, (Block)Blocks.field_150348_b);
                }
                break;
            }
        }
    }

    public void onFirstTick(World world, int x, int y, int z) {
        if (this.struct != null) {
            this.calcCrystals(world, x, y, z);
            this.regenerate();
            DungeonGenerator.instance.generateStructure(this.struct, this);
        }
        LootChestWatcher.instance.cache(this);
        this.syncAllData(true);
    }

    private void regenerate() {
        if (this.regenned) {
            return;
        }
        if (this.struct != null) {
            FilledBlockArray copy = (FilledBlockArray)this.blocks.copy();
            if (this.struct == ChromaStructures.Structures.BURROW) {
                copy.offset(5, 8, 2);
            }
            if (this.struct == ChromaStructures.Structures.DESERT) {
                copy.offset(-7, -3, -7);
            }
            copy.placeExcept(new Coordinate((TileEntity)this), 3);
            DungeonGenerator.populateChests(this.struct, copy, rand);
            if (this.struct == ChromaStructures.Structures.OCEAN) {
                BlockLootChest.setMaxReach(this.field_145850_b, this.field_145851_c - 2, this.field_145848_d - 1, this.field_145849_e, 2.5);
                BlockLootChest.setMaxReach(this.field_145850_b, this.field_145851_c, this.field_145848_d - 1, this.field_145849_e - 1, 2.5);
            }
        }
        this.regenned = true;
        this.triggered = false;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticles(World world, int x, int y, int z) {
        switch (this.struct) {
            case CAVERN: {
                for (int i = -1; i <= 1; i += 2) {
                    if (this.crystals.isEmpty()) continue;
                    CrystalElement e = (CrystalElement)((Object)ReikaJavaLibrary.getRandomListEntry((Random)rand, new ArrayList<CrystalElement>(this.crystals.keySet())));
                    Coordinate c = this.crystals.get((Object)e);
                    double dd = ReikaMathLibrary.py3d((double)c.xCoord, (double)c.yCoord, (double)c.zCoord);
                    double v = 0.2;
                    double vx = (double)(-c.xCoord) / dd * v;
                    double vy = (double)(-c.yCoord) / dd * v + 0.15 * (double)i;
                    double vz = (double)(-c.zCoord) / dd * v;
                    c = c.offset(x, y, z);
                    EntityCenterBlurFX fx = new EntityCenterBlurFX(e, world, (double)c.xCoord + 0.5, (double)c.yCoord + 0.5, (double)c.zCoord + 0.5, vx, vy, vz);
                    fx.setGravity(0.1f * (float)i).setLife(60);
                    Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
                }
                break;
            }
            case BURROW: {
                if (world.func_147439_a(x, y - 2, z) != ChromaBlocks.LAMP.getBlockInstance()) break;
                double dx = (double)x + 0.5;
                double dz = (double)z + 0.5;
                double d = 0.4;
                switch (rand.nextInt(5)) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        dx += d;
                        break;
                    }
                    case 2: {
                        dx -= d;
                        break;
                    }
                    case 3: {
                        dz += d;
                        break;
                    }
                    case 4: {
                        dz -= d;
                    }
                }
                EntityCenterBlurFX fx = new EntityCenterBlurFX(this.color, world, dx, (double)(y - 2) + 0.5, dz, 0.0, 0.0, 0.0).setGravity(-0.05f);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
                break;
            }
            case OCEAN: {
                break;
            }
            case DESERT: {
                break;
            }
        }
    }

    public void generate(ChromaStructures.Structures s, CrystalElement e) {
        if (!s.isNatural()) {
            throw new IllegalArgumentException("You cannot generate a structure control in the wrong structure!");
        }
        this.struct = s;
        this.color = e;
        WeightedRandomChestContent[] loot = ChestGenHooks.getItems((String)"strongholdLibrary", (Random)rand);
        WeightedRandomChestContent.func_76293_a((Random)rand, (WeightedRandomChestContent[])loot, (IInventory)this, (int)ChestGenHooks.getCount((String)"strongholdLibrary", (Random)rand));
        int n = 1 + rand.nextInt(4) * (1 + rand.nextInt(2));
        for (int i = 0; i < n; ++i) {
            ReikaInventoryHelper.addToIInv((Item)ChromaItems.FRAGMENT.getItemInstance(), (IInventory)this);
        }
        switch (this.struct) {
            case CAVERN: {
                ReikaInventoryHelper.addToIInv((ItemStack)ChromaStacks.cavernLoot, (IInventory)this, (boolean)true);
                break;
            }
            case BURROW: {
                ReikaInventoryHelper.addToIInv((ItemStack)ChromaStacks.burrowLoot, (IInventory)this, (boolean)true);
                break;
            }
            case OCEAN: {
                ReikaInventoryHelper.addToIInv((ItemStack)ChromaStacks.oceanLoot, (IInventory)this, (boolean)true);
                break;
            }
            case DESERT: {
                ReikaInventoryHelper.addToIInv((ItemStack)ChromaStacks.desertLoot, (IInventory)this, (boolean)true);
                break;
            }
        }
    }

    private void calcCrystals(World world, int x, int y, int z) {
        switch (this.struct) {
            case CAVERN: {
                this.blocks = ChromaStructures.getCavernStructure(world, x, y, z);
                break;
            }
            case BURROW: {
                this.blocks = ChromaStructures.getBurrowStructure(world, x, y, z, this.color);
                break;
            }
            case OCEAN: {
                this.blocks = ChromaStructures.getOceanStructure(world, x, y, z);
                break;
            }
            case DESERT: {
                this.blocks = ChromaStructures.getDesertStructure(world, x, y, z);
                break;
            }
        }
        if (this.blocks != null) {
            for (int i = 0; i < this.blocks.getSize(); ++i) {
                Coordinate c1 = this.blocks.getNthBlock(i);
                if (this.field_145850_b.func_147439_a(c1.xCoord, c1.yCoord, c1.zCoord) != ChromaBlocks.CRYSTAL.getBlockInstance()) continue;
                Coordinate c = new Coordinate(c1.xCoord - this.field_145851_c, c1.yCoord - this.field_145848_d, c1.zCoord - this.field_145849_e);
                CrystalElement e = CrystalElement.elements[this.field_145850_b.func_72805_g(c1.xCoord, c1.yCoord, c1.zCoord)];
                this.crystals.put(e, c);
            }
        }
    }

    public void breakBlock() {
        if (this.struct != null) {
            switch (this.struct) {
                case CAVERN: {
                    if (this.blocks != null) {
                        for (int i = 0; i < this.blocks.getSize(); ++i) {
                            Coordinate c = this.blocks.getNthBlock(i);
                            int x = c.xCoord;
                            int y = c.yCoord;
                            int z = c.zCoord;
                            if (this.field_145850_b.func_147439_a(x, y, z) == ChromaBlocks.STRUCTSHIELD.getBlockInstance()) {
                                this.field_145850_b.func_72921_c(x, y, z, this.field_145850_b.func_72805_g(x, y, z) % 8, 3);
                                continue;
                            }
                            if (this.field_145850_b.func_147439_a(x, y, z) != ChromaBlocks.LOOTCHEST.getBlockInstance()) continue;
                            this.field_145850_b.func_72921_c(x, y, z, this.field_145850_b.func_72805_g(x, y, z) % 8, 3);
                            ReikaSoundHelper.playBreakSound((World)this.field_145850_b, (int)x, (int)y, (int)z, (Block)Blocks.field_150348_b);
                        }
                    }
                    this.field_145850_b.func_72921_c(this.field_145851_c + 7, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_72805_g(this.field_145851_c + 7, this.field_145848_d, this.field_145849_e) % 8, 3);
                    this.field_145850_b.func_72921_c(this.field_145851_c + 7, this.field_145848_d - 1, this.field_145849_e, this.field_145850_b.func_72805_g(this.field_145851_c + 7, this.field_145848_d - 1, this.field_145849_e) % 8, 3);
                    break;
                }
                case BURROW: {
                    if (this.blocks == null) break;
                    for (int i = 0; i < this.blocks.getSize(); ++i) {
                        Coordinate c = this.blocks.getNthBlock(i);
                        int x = c.xCoord + 5;
                        int y = c.yCoord + 8;
                        int z = c.zCoord + 2;
                        if (this.field_145850_b.func_147439_a(x, y, z) == ChromaBlocks.STRUCTSHIELD.getBlockInstance()) {
                            this.field_145850_b.func_72921_c(x, y, z, this.field_145850_b.func_72805_g(x, y, z) % 8, 3);
                            continue;
                        }
                        if (this.field_145850_b.func_147439_a(x, y, z) != ChromaBlocks.LOOTCHEST.getBlockInstance()) continue;
                        this.field_145850_b.func_72921_c(x, y, z, this.field_145850_b.func_72805_g(x, y, z) % 8, 3);
                        ReikaSoundHelper.playBreakSound((World)this.field_145850_b, (int)x, (int)y, (int)z, (Block)Blocks.field_150348_b);
                    }
                    break;
                }
                case OCEAN: {
                    this.triggerOceanTrap(this.field_145850_b.func_72977_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, 8.0));
                    if (this.blocks == null) break;
                    for (int i = 0; i < this.blocks.getSize(); ++i) {
                        Coordinate c = this.blocks.getNthBlock(i);
                        int x = c.xCoord;
                        int y = c.yCoord;
                        int z = c.zCoord;
                        if (this.field_145850_b.func_147439_a(x, y, z) == ChromaBlocks.STRUCTSHIELD.getBlockInstance()) {
                            this.field_145850_b.func_72921_c(x, y, z, this.field_145850_b.func_72805_g(x, y, z) % 8, 3);
                            continue;
                        }
                        if (this.field_145850_b.func_147439_a(x, y, z) != ChromaBlocks.LOOTCHEST.getBlockInstance()) continue;
                        this.field_145850_b.func_72921_c(x, y, z, this.field_145850_b.func_72805_g(x, y, z) % 8, 3);
                        ReikaSoundHelper.playBreakSound((World)this.field_145850_b, (int)x, (int)y, (int)z, (Block)Blocks.field_150348_b);
                    }
                    break;
                }
                case DESERT: {
                    if (this.blocks == null) break;
                    for (int i = 0; i < this.blocks.getSize(); ++i) {
                        Coordinate c = this.blocks.getNthBlock(i);
                        int x = c.xCoord - 7;
                        int y = c.yCoord - 3;
                        int z = c.zCoord - 7;
                        if (this.field_145850_b.func_147439_a(x, y, z) == ChromaBlocks.STRUCTSHIELD.getBlockInstance()) {
                            this.field_145850_b.func_72921_c(x, y, z, this.field_145850_b.func_72805_g(x, y, z) % 8, 3);
                            continue;
                        }
                        if (this.field_145850_b.func_147439_a(x, y, z) != ChromaBlocks.LOOTCHEST.getBlockInstance()) continue;
                        this.field_145850_b.func_72921_c(x, y, z, this.field_145850_b.func_72805_g(x, y, z) % 8, 3);
                        ReikaSoundHelper.playBreakSound((World)this.field_145850_b, (int)x, (int)y, (int)z, (Block)Blocks.field_150348_b);
                    }
                    break;
                }
            }
        }
        LootChestWatcher.instance.remove(this);
        if (this.struct != null) {
            DungeonGenerator.instance.deleteStructure(this.struct, this);
        }
        if (this.monument != null && this.monument.isRunning() && !this.monument.isComplete()) {
            this.monument.endRitual();
        }
    }

    public int getBrightness() {
        return this.struct == ChromaStructures.Structures.BURROW || this.struct == ChromaStructures.Structures.DESERT ? 15 : 0;
    }

    @Override
    public void func_145841_b(NBTTagCompound NBT) {
        super.func_145841_b(NBT);
        if (this.struct != null) {
            NBT.func_74778_a("struct", this.struct.name());
        }
        if (this.lastTriggerPlayer != null) {
            NBT.func_74778_a("lastPlayer", this.lastTriggerPlayer.toString());
        }
        NBT.func_74768_a("color", this.getColor().ordinal());
        NBT.func_74757_a("trigger", this.triggered);
        NBT.func_74757_a("regen", this.regenned);
        NBT.func_74768_a("ttick", this.trapTick);
        NBT.func_74757_a("monument", this.isMonument);
        NBT.func_74757_a("monument_t", this.triggeredMonument);
    }

    @Override
    public void func_145839_a(NBTTagCompound NBT) {
        super.func_145839_a(NBT);
        if (NBT.func_74764_b("struct")) {
            this.struct = ChromaStructures.Structures.valueOf(NBT.func_74779_i("struct"));
        }
        if (NBT.func_74764_b("lastPlayer")) {
            this.lastTriggerPlayer = UUID.fromString(NBT.func_74779_i("lastPlayer"));
        }
        this.color = CrystalElement.elements[NBT.func_74762_e("color")];
        this.triggered = NBT.func_74767_n("trigger");
        this.regenned = NBT.func_74767_n("regen");
        this.trapTick = NBT.func_74762_e("ttick");
        this.isMonument = NBT.func_74767_n("monument");
        this.triggeredMonument = NBT.func_74767_n("monument_t");
    }

    public boolean func_102008_b(int slot, ItemStack is, int side) {
        return false;
    }

    public int func_70302_i_() {
        return 27;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_94041_b(int slot, ItemStack is) {
        return false;
    }

    public CrystalElement getColor() {
        return this.color != null ? this.color : CrystalElement.WHITE;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isVisible() {
        return true;
    }

    public boolean isBreakable(EntityPlayer ep) {
        return !this.isMonument && this.breakByPlayer(ep);
    }

    private ProgressionManager.ProgressStage getProgressStage() {
        switch (this.struct) {
            case CAVERN: {
                return ProgressionManager.ProgressStage.CAVERN;
            }
            case BURROW: {
                return ProgressionManager.ProgressStage.BURROW;
            }
            case OCEAN: {
                return ProgressionManager.ProgressStage.OCEAN;
            }
            case DESERT: {
                return ProgressionManager.ProgressStage.DESERTSTRUCT;
            }
        }
        return null;
    }

    public void setMonument() {
        this.isMonument = true;
        this.syncAllData(false);
    }

    public boolean isMonument() {
        return this.isMonument;
    }

    public void endMonumentRitual() {
        if (this.triggeredMonument) {
            this.triggeredMonument = false;
            if (this.monument != null && this.monument.isRunning()) {
                this.monument.endRitual();
            }
            this.monument = null;
            ReikaPacketHelper.sendDataPacketWithRadius((String)"ChromaData", (int)ChromaPackets.MONUMENTEND.ordinal(), (TileEntity)this, (int)Integer.MAX_VALUE, (int[])new int[0]);
        }
    }

    public boolean triggerMonument(EntityPlayer ep) {
        this.triggeredMonument = true;
        this.monument = new MonumentCompletionRitual(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, ep);
        if (this.monument.doChecks(false)) {
            this.monument.start();
            return true;
        }
        return false;
    }

    public boolean isTriggerPlayer(EntityPlayer ep) {
        return ep.func_110124_au().equals(this.lastTriggerPlayer);
    }

    public boolean breakByPlayer(EntityPlayer ep) {
        if (this.struct == ChromaStructures.Structures.OCEAN) {
            return ep != null && ep.func_70011_f((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 2.5;
        }
        return true;
    }

    public ChromaStructures.Structures getStructureType() {
        return this.struct;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    static {
        MinecraftForge.EVENT_BUS.register((Object)LootChestWatcher.instance);
    }

    public static class LootChestWatcher {
        public static final LootChestWatcher instance = new LootChestWatcher();
        private final MultiMap<WorldChunk, WorldLocation> cache = new MultiMap();

        private LootChestWatcher() {
        }

        private void cache(TileEntityStructControl te) {
            WorldLocation loc = new WorldLocation((TileEntity)te);
            WorldChunk wc = new WorldChunk(te.field_145850_b, te.field_145850_b.func_72938_d(te.field_145851_c, te.field_145849_e));
            this.cache.addValue((Object)wc, (Object)loc);
        }

        private void remove(TileEntityStructControl te) {
            WorldLocation loc = new WorldLocation((TileEntity)te);
            WorldChunk wc = new WorldChunk(te.field_145850_b, te.field_145850_b.func_72938_d(te.field_145851_c, te.field_145849_e));
            this.cache.remove((Object)wc, (Object)loc);
        }

        @SubscribeEvent
        public void onAccess(BlockLootChest.LootChestAccessEvent evt) {
            int x = evt.x;
            int z = evt.z;
            int r = 2;
            for (int i = -r; i <= r; ++i) {
                for (int j = -r; j <= r; ++j) {
                    int dx = x + i * 16;
                    int dz = z + i * 16;
                    WorldChunk wc = new WorldChunk(evt.world, evt.world.func_72938_d(dx, dz));
                    for (WorldLocation loc : this.cache.get((Object)wc)) {
                        TileEntity tile = evt.world.func_147438_o(loc.xCoord, loc.yCoord, loc.zCoord);
                        if (!(tile instanceof TileEntityStructControl)) continue;
                        TileEntityStructControl te = (TileEntityStructControl)tile;
                        te.trigger(evt.x, evt.y, evt.z, evt.player);
                    }
                }
            }
        }
    }
}

