/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.Technical;

import Reika.ChromatiCraft.Auxiliary.CrystalMusicManager;
import Reika.ChromatiCraft.Auxiliary.Interfaces.NBTTile;
import Reika.ChromatiCraft.Auxiliary.ProgressionManager;
import Reika.ChromatiCraft.Base.DimensionStructureGenerator;
import Reika.ChromatiCraft.Base.TileEntity.TileEntityLocusPoint;
import Reika.ChromatiCraft.Block.Worldgen.BlockStructureShield;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Magic.ElementMixer;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityBlurFX;
import Reika.ChromatiCraft.Render.Particle.EntityFloatingSeedsFX;
import Reika.ChromatiCraft.Render.Particle.EntityLaserFX;
import Reika.ChromatiCraft.TileEntity.Technical.TileEntityStructControl;
import Reika.ChromatiCraft.World.Dimension.ChromaDimensionManager;
import Reika.ChromatiCraft.World.Dimension.ChunkProviderChroma;
import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.Exception.RegistrationException;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Interfaces.Registry.SoundEnum;
import Reika.DragonAPI.Interfaces.TileEntity.PlayerBreakHook;
import Reika.DragonAPI.Libraries.IO.ReikaColorAPI;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaMusicHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class TileEntityDimensionCore
extends TileEntityLocusPoint
implements NBTTile,
PlayerBreakHook {
    private CrystalElement color = CrystalElement.WHITE;
    private UUID uid = null;
    private DimensionStructureGenerator.DimensionStructureType structure = null;
    private boolean triggered = false;
    private HashSet<UUID> sentPlayers = new HashSet();
    private static final EnumMap<CrystalElement, Coordinate> locations = new EnumMap(CrystalElement.class);
    private static final EnumMap<CrystalElement, HashSet<CrystalElement>> beams = new EnumMap(CrystalElement.class);
    private static final ArrayList<ArrayList<ImmutablePair<CrystalElement, Integer>>>[] melody = new ArrayList[2];
    private boolean primed = false;

    private static void addMelodyNote(int track, ReikaMusicHelper.MusicKey key) {
        Set<CrystalElement> c = CrystalMusicManager.instance.getColorsWithKey(key);
        if (c.isEmpty()) {
            throw new RegistrationException((DragonAPIMod)ChromatiCraft.instance, "No such color for note " + key);
        }
        ArrayList<ImmutablePair> li = new ArrayList<ImmutablePair>();
        for (CrystalElement e : c) {
            int idx = CrystalMusicManager.instance.getIntervalFor(e, key);
            if (idx == -1) {
                throw new RegistrationException((DragonAPIMod)ChromatiCraft.instance, "No such index for note " + key + " for color " + (Object)((Object)e));
            }
            li.add(new ImmutablePair((Object)e, (Object)idx));
        }
        melody[track].add(li);
    }

    private static void addColor(CrystalElement e, int x, int y, int z) {
        locations.put(e, new Coordinate(x - 21, y - 5, z - 21));
    }

    private Collection<CrystalElement> getColorBeams() {
        return beams.get((Object)this.color);
    }

    public void setStructure(DimensionStructureGenerator.StructurePair p) {
        this.structure = p.generator.getType();
        this.uid = p.generator.id;
        this.color = p.color;
        this.syncAllData(false);
    }

    @Override
    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateEntity(world, x, y, z, meta);
        if (world.field_72995_K) {
            if (this.primed) {
                this.spawnConnectFX(world, x, y, z);
            } else if (this.hasStructure()) {
                this.structureControlFX(world, x, y, z);
            }
        } else if (this.hasStructure()) {
            this.doScanForEntry(world, x, y, z);
            if (!this.triggered) {
                this.doStructureCalculation(world, x, y, z);
            }
        }
    }

    public void prime(boolean set) {
        this.primed = set;
        this.syncAllData(false);
    }

    private DimensionStructureGenerator getStructure() {
        return this.structure != null ? this.structure.getGenerator(this.uid) : null;
    }

    public boolean hasStructure() {
        return this.getStructure() != null;
    }

    private void doScanForEntry(World world, int x, int y, int z) {
        AxisAlignedBB box = this.getStructureEntryBox();
        for (EntityPlayerMP ep : world.func_72872_a(EntityPlayerMP.class, box)) {
            UUID uid = ep.func_110124_au();
            if (this.sentPlayers.contains(uid)) continue;
            this.sentPlayers.add(uid);
            ReikaPacketHelper.sendDataPacket((String)"ChromaData", (int)ChromaPackets.STRUCTUREENTRY.ordinal(), (EntityPlayerMP)ep, (int[])new int[]{this.structure.ordinal()});
            ChromaDimensionManager.addPlayerToStructure((EntityPlayer)ep, this.getStructure());
        }
    }

    private AxisAlignedBB getStructureEntryBox() {
        DimensionStructureGenerator gen = this.getStructure();
        int x = gen.getEntryPosX();
        int y = gen.getPosY();
        int z = gen.getEntryPosZ();
        int r = 8;
        return AxisAlignedBB.func_72330_a((double)(x - r), (double)y, (double)(z - r), (double)(x + r + 1), (double)(ReikaWorldHelper.getTopNonAirBlock((World)this.field_145850_b, (int)x, (int)z) + 9), (double)(z + r + 1));
    }

    private void doStructureCalculation(World world, int x, int y, int z) {
        switch (this.structure) {
            case ALTAR: {
                break;
            }
            case LOCKS: {
                break;
            }
            case SHIFTMAZE: {
                break;
            }
            case TDMAZE: {
                int dx;
                AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)(x - 1), (double)(y + 2), (double)(z - 1), (double)(x + 2), (double)(y + 4), (double)(z + 2));
                List li = world.func_72872_a(EntityPlayer.class, box);
                if (li.isEmpty()) break;
                EntityPlayer ep = (EntityPlayer)li.get(0);
                this.triggered = true;
                boolean w = rand.nextBoolean();
                int n = w ? (rand.nextBoolean() ? -2 : 2) : (dx = rand.nextBoolean() ? 1 : -1);
                int dz = !w ? (rand.nextBoolean() ? -2 : 2) : (rand.nextBoolean() ? 1 : -1);
                int dx2 = Math.abs(dx) == 1 ? dx : (int)Math.signum(dx) * (Math.abs(dx) + 1);
                int dz2 = Math.abs(dz) == 1 ? dz : (int)Math.signum(dz) * (Math.abs(dz) + 1);
                world.func_72921_c(x + dx, y + 2, z + dz, BlockStructureShield.BlockType.CRACKS.metadata, 3);
                world.func_72921_c(x + dx, y + 3, z + dz, BlockStructureShield.BlockType.CRACKS.metadata, 3);
                world.func_72921_c(x - dx2, y + 1, z - dz2, BlockStructureShield.BlockType.CRACKS.metadata, 3);
                world.func_72921_c(x + dx, y, z + dz, BlockStructureShield.BlockType.CRACKS.metadata, 3);
                world.func_72921_c(x + dx, y - 1, z + dz, BlockStructureShield.BlockType.CRACKS.metadata, 3);
                ReikaSoundHelper.playBreakSound((World)world, (int)x, (int)(y + 3), (int)z, (Block)ChromaBlocks.STRUCTSHIELD.getBlockInstance(), (float)2.0f, (float)1.0f);
                ReikaSoundHelper.playBreakSound((World)world, (int)x, (int)(y + 3), (int)z, (Block)ChromaBlocks.STRUCTSHIELD.getBlockInstance(), (float)2.0f, (float)1.0f);
                ReikaSoundHelper.playBreakSound((World)world, (int)x, (int)(y + 3), (int)z, (Block)ChromaBlocks.STRUCTSHIELD.getBlockInstance(), (float)2.0f, (float)1.0f);
                break;
            }
            case MUSIC: {
                break;
            }
            case NONEUCLID: {
                break;
            }
            case GOL: {
                break;
            }
            case ANTFARM: {
                break;
            }
            case LASER: {
                break;
            }
            case PINBALL: {
                break;
            }
            case GRAVITY: {
                break;
            }
            case BRIDGE: {
                break;
            }
            case LIGHTPANEL: {
                break;
            }
            case TESSELLATION: {
                break;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void structureControlFX(World world, int x, int y, int z) {
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnConnectFX(World world, int x, int y, int z) {
        int sp = 8;
        long tick = world.func_82737_E();
        if (tick % (long)sp == 0L) {
            TileEntityStructControl ts;
            Coordinate cc;
            TileEntity tile;
            ArrayList<ArrayList<ImmutablePair<CrystalElement, Integer>>> song = melody[(ChunkProviderChroma.getMonumentGenerator().hashCode() ^ Minecraft.func_71410_x().hashCode()) % melody.length];
            ArrayList<ImmutablePair<CrystalElement, Integer>> li = song.get((int)(tick / (long)sp % (long)song.size()));
            ImmutablePair<CrystalElement, Integer> p = li.get(rand.nextInt(li.size()));
            if (p.left == this.color && (tile = (cc = this.getCenter()).getTileEntity(world)) instanceof TileEntityStructControl && (ts = (TileEntityStructControl)tile).isMonument()) {
                EntityFX fx;
                float s;
                float g;
                int l;
                double pz;
                double py;
                int i;
                float mult = this.getSoundPitch((Integer)p.right);
                Collection<CrystalElement> m = this.getColorBeams();
                boolean flag = false;
                for (CrystalElement e : m) {
                    Coordinate c = this.getOtherColor(e);
                    TileEntity te = c.getTileEntity(world);
                    if (!(te instanceof TileEntityDimensionCore) || ((TileEntityDimensionCore)te).getColor() != e) continue;
                    this.createBeamLine(world, x, y, z, c, e);
                    flag = true;
                }
                this.createBeamLine(world, x, y, z, cc, this.color);
                ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.ORB, (double)x, (double)y, (double)z, (float)1.0f, (float)mult, (boolean)false);
                ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.DING, (double)x, (double)y, (double)z, (float)0.3f, (float)mult);
                int n = 8 + rand.nextInt(8);
                for (i = 0; i < n; ++i) {
                    double px = (double)x + rand.nextDouble();
                    py = (double)y + rand.nextDouble();
                    pz = (double)z + rand.nextDouble();
                    l = 40;
                    g = (float)ReikaRandomHelper.getRandomPlusMinus((double)0.03125, (double)0.0150625);
                    s = 2.0f * (float)ReikaRandomHelper.getRandomPlusMinus((double)1.25, (double)0.5);
                    fx = new EntityLaserFX(this.color, world, px, py, pz, 0.0, 0.0, 0.0).setGravity(g).setScale(s);
                    Minecraft.func_71410_x().field_71452_i.func_78873_a(fx);
                }
                for (i = 0; i < n; ++i) {
                    double px = (double)x + rand.nextDouble();
                    py = (double)y + rand.nextDouble();
                    pz = (double)z + rand.nextDouble();
                    l = 80;
                    g = (float)ReikaRandomHelper.getRandomPlusMinus((double)0.03125, (double)0.0150625);
                    s = 2.0f * (float)ReikaRandomHelper.getRandomPlusMinus((double)1.25, (double)0.5);
                    fx = new EntityFloatingSeedsFX(world, px, py, pz, 0.0, -90.0);
                    fx = (EntityFloatingSeedsFX)fx.setGravity(g).setScale(s).setLife(l).setColor(this.color.getColor());
                    fx.angleVelocity *= 3.0;
                    fx.freedom *= 5.0;
                    Minecraft.func_71410_x().field_71452_i.func_78873_a(fx);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void createBeamLine(World world, int x, int y, int z, Coordinate c, CrystalElement e) {
        TileEntityDimensionCore.createBeamLine(world, x, y, z, c.xCoord, c.yCoord, c.zCoord, this.color, e);
    }

    @SideOnly(value=Side.CLIENT)
    public static void createBeamLine(World world, int x1, int y1, int z1, int x2, int y2, int z2, CrystalElement e1, CrystalElement e2) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        double dz = z2 - z1;
        double dd = ReikaMathLibrary.py3d((double)dx, (double)dy, (double)dz);
        double pd = 0.25;
        for (double p = 0.0; p <= dd; p += pd) {
            double f = p / dd;
            float s = 1.0f + 1.5f * (float)Math.sin(f * Math.PI);
            int l = 20;
            double px = (double)x1 + 0.5 + f * dx;
            double py = (double)y1 + 0.5 + f * dy;
            double pz = (double)z1 + 0.5 + f * dz;
            int clr = ReikaColorAPI.mixColors((int)e1.getColor(), (int)e2.getColor(), (float)(1.0f - (float)f));
            EntityBlurFX fx = new EntityBlurFX(world, px, py, pz).setLife(l).setNoSlowdown().setScale(s).setColor(clr);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    private float getSoundPitch(int p) {
        float mult = 0.0f;
        switch (p) {
            case 0: {
                mult = (float)CrystalMusicManager.instance.getDingPitchScale(this.color);
                break;
            }
            case 1: {
                mult = (float)CrystalMusicManager.instance.getThird(this.color);
                break;
            }
            case 2: {
                mult = (float)CrystalMusicManager.instance.getFifth(this.color);
                break;
            }
            case 3: {
                mult = (float)CrystalMusicManager.instance.getOctave(this.color);
            }
        }
        return mult;
    }

    private Coordinate getCenter() {
        Coordinate c = locations.get((Object)this.color);
        return new Coordinate(this.field_145851_c - c.xCoord, this.field_145848_d - c.yCoord, this.field_145849_e - c.zCoord);
    }

    private Coordinate getOtherColor(CrystalElement e) {
        Coordinate c = locations.get((Object)this.color);
        Coordinate c2 = locations.get((Object)e);
        return new Coordinate(this.field_145851_c - c.xCoord + c2.xCoord, this.field_145848_d - c.yCoord + c2.yCoord, this.field_145849_e - c.zCoord + c2.zCoord);
    }

    @Override
    protected void onFirstTick(World world, int x, int y, int z) {
        super.onFirstTick(world, x, y, z);
        if (this.getPlacer() == null && !this.hasStructure() && !world.field_72995_K) {
            ChromatiCraft.logger.logError((Object)(this + " was never given a structure!? Color = " + (Object)((Object)this.color) + ", UID=" + this.uid));
        }
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.DIMENSIONCORE;
    }

    @Override
    public int getRenderColor() {
        return this.color.getColor();
    }

    public CrystalElement getColor() {
        return this.color;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public void func_145839_a(NBTTagCompound NBT) {
        super.func_145839_a(NBT);
        int s = NBT.func_74762_e("struct");
        DimensionStructureGenerator.DimensionStructureType dimensionStructureType = this.structure = s >= 0 ? DimensionStructureGenerator.DimensionStructureType.types[s] : null;
        if (NBT.func_74764_b("uid")) {
            this.uid = UUID.fromString(NBT.func_74779_i("uid"));
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound NBT) {
        super.func_145841_b(NBT);
        NBT.func_74768_a("struct", this.structure != null ? this.structure.ordinal() : -1);
        if (this.uid != null) {
            NBT.func_74778_a("uid", this.uid.toString());
        }
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.color = CrystalElement.elements[NBT.func_74762_e("color")];
        this.primed = NBT.func_74767_n("prime");
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("color", this.color.ordinal());
        NBT.func_74757_a("prime", this.primed);
    }

    @Override
    public void getTagsToWriteToStack(NBTTagCompound NBT) {
        NBT.func_74768_a("color", this.color.ordinal());
    }

    @Override
    public void setDataFromItemStackTag(ItemStack is) {
        this.color = is.field_77990_d != null ? CrystalElement.elements[is.field_77990_d.func_74762_e("color")] : CrystalElement.WHITE;
    }

    public boolean isBreakable(EntityPlayer ep) {
        if (ep == null) {
            return false;
        }
        return this.field_145850_b.field_72995_K || ep.field_71075_bZ.field_75098_d || !this.hasStructure() || this.getStructure().hasBeenSolved(this.field_145850_b);
    }

    public boolean breakByPlayer(EntityPlayer ep) {
        if (this.field_145850_b.field_72995_K) {
            if (this.hasStructure()) {
                ChromaDimensionManager.removePlayerFromStructure(ep);
            }
            return true;
        }
        if (ep.field_71075_bZ.field_75098_d) {
            if (this.hasStructure()) {
                this.openStructure();
            }
            return true;
        }
        if (ReikaPlayerAPI.isFake((EntityPlayer)ep)) {
            return false;
        }
        if (ep.func_70011_f((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) > 5.0) {
            return false;
        }
        if (this.hasStructure()) {
            if (!ep.field_71075_bZ.field_75098_d && !this.getStructure().hasBeenSolved(this.field_145850_b)) {
                return false;
            }
            ProgressionManager.instance.markPlayerCompletedStructureColor(ep, this.color, true, true);
            ChromaDimensionManager.removePlayerFromStructure(ep);
            this.openStructure();
        }
        return true;
    }

    private void openStructure() {
        DimensionStructureGenerator gen = this.getStructure();
        Set<Coordinate> set = gen.getBreakableSpots();
        for (Coordinate c2 : set) {
            Block b = c2.getBlock(this.field_145850_b);
            BlockKey b2 = b instanceof BlockStructureShield ? new BlockKey(ChromaBlocks.STRUCTSHIELD.getBlockInstance(), BlockStructureShield.BlockType.CRACKS.metadata % 8) : new BlockKey(Blocks.field_150350_a);
            c2.setBlock(this.field_145850_b, b2.blockID, b2.metadata);
        }
        ReikaSoundHelper.playBreakSound((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e, (Block)ChromaBlocks.STRUCTSHIELD.getBlockInstance(), (float)2.0f, (float)1.0f);
        ReikaSoundHelper.playBreakSound((World)this.field_145850_b, (int)(this.field_145851_c + 4), (int)this.field_145848_d, (int)this.field_145849_e, (Block)ChromaBlocks.STRUCTSHIELD.getBlockInstance(), (float)2.0f, (float)1.0f);
        ReikaSoundHelper.playBreakSound((World)this.field_145850_b, (int)(this.field_145851_c - 4), (int)this.field_145848_d, (int)this.field_145849_e, (Block)ChromaBlocks.STRUCTSHIELD.getBlockInstance(), (float)2.0f, (float)1.0f);
        ReikaSoundHelper.playBreakSound((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)(this.field_145849_e + 4), (Block)ChromaBlocks.STRUCTSHIELD.getBlockInstance(), (float)2.0f, (float)1.0f);
        ReikaSoundHelper.playBreakSound((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)(this.field_145849_e - 4), (Block)ChromaBlocks.STRUCTSHIELD.getBlockInstance(), (float)2.0f, (float)1.0f);
        ReikaSoundHelper.playBreakSound((World)this.field_145850_b, (int)this.field_145851_c, (int)(this.field_145848_d + 4), (int)this.field_145849_e, (Block)ChromaBlocks.STRUCTSHIELD.getBlockInstance(), (float)2.0f, (float)1.0f);
        ReikaSoundHelper.playBreakSound((World)this.field_145850_b, (int)this.field_145851_c, (int)(this.field_145848_d - 4), (int)this.field_145849_e, (Block)ChromaBlocks.STRUCTSHIELD.getBlockInstance(), (float)2.0f, (float)1.0f);
    }

    public static Coordinate getLocation(CrystalElement e) {
        return locations.get((Object)e);
    }

    void setColor(CrystalElement e) {
        this.color = e;
    }

    static {
        TileEntityDimensionCore.addColor(CrystalElement.BLACK, 5, 11, 18);
        TileEntityDimensionCore.addColor(CrystalElement.RED, 8, 11, 14);
        TileEntityDimensionCore.addColor(CrystalElement.GREEN, 14, 11, 8);
        TileEntityDimensionCore.addColor(CrystalElement.BROWN, 18, 11, 5);
        TileEntityDimensionCore.addColor(CrystalElement.BLUE, 24, 11, 5);
        TileEntityDimensionCore.addColor(CrystalElement.PURPLE, 28, 11, 8);
        TileEntityDimensionCore.addColor(CrystalElement.CYAN, 34, 11, 14);
        TileEntityDimensionCore.addColor(CrystalElement.LIGHTGRAY, 37, 11, 18);
        TileEntityDimensionCore.addColor(CrystalElement.GRAY, 37, 11, 24);
        TileEntityDimensionCore.addColor(CrystalElement.PINK, 34, 11, 28);
        TileEntityDimensionCore.addColor(CrystalElement.LIME, 28, 11, 34);
        TileEntityDimensionCore.addColor(CrystalElement.YELLOW, 24, 11, 37);
        TileEntityDimensionCore.addColor(CrystalElement.LIGHTBLUE, 18, 11, 37);
        TileEntityDimensionCore.addColor(CrystalElement.MAGENTA, 14, 11, 34);
        TileEntityDimensionCore.addColor(CrystalElement.ORANGE, 8, 11, 28);
        TileEntityDimensionCore.addColor(CrystalElement.WHITE, 5, 11, 24);
        for (int i = 0; i < 16; ++i) {
            CrystalElement e = CrystalElement.elements[i];
            HashSet<CrystalElement> m = new HashSet<CrystalElement>();
            Collection<CrystalElement> m2 = ElementMixer.instance.getMixablesWith(e);
            if (m2 != null) {
                m.addAll(m2);
            }
            if ((m2 = ElementMixer.instance.getMixParents(e)) != null) {
                m.addAll(m2);
            }
            if ((m2 = ElementMixer.instance.getChildrenOf(e)) != null) {
                m.addAll(m2);
            }
            beams.put(e, m);
        }
        TileEntityDimensionCore.melody[0] = new ArrayList();
        TileEntityDimensionCore.addMelodyNote(0, ReikaMusicHelper.MusicKey.G4);
        TileEntityDimensionCore.addMelodyNote(0, ReikaMusicHelper.MusicKey.A4);
        TileEntityDimensionCore.addMelodyNote(0, ReikaMusicHelper.MusicKey.B4);
        TileEntityDimensionCore.addMelodyNote(0, ReikaMusicHelper.MusicKey.D5);
        TileEntityDimensionCore.addMelodyNote(0, ReikaMusicHelper.MusicKey.C5);
        TileEntityDimensionCore.addMelodyNote(0, ReikaMusicHelper.MusicKey.C5);
        TileEntityDimensionCore.addMelodyNote(0, ReikaMusicHelper.MusicKey.E5);
        TileEntityDimensionCore.addMelodyNote(0, ReikaMusicHelper.MusicKey.D5);
        TileEntityDimensionCore.addMelodyNote(0, ReikaMusicHelper.MusicKey.D5);
        TileEntityDimensionCore.addMelodyNote(0, ReikaMusicHelper.MusicKey.G5);
        TileEntityDimensionCore.addMelodyNote(0, ReikaMusicHelper.MusicKey.Fs5);
        TileEntityDimensionCore.addMelodyNote(0, ReikaMusicHelper.MusicKey.G5);
        TileEntityDimensionCore.addMelodyNote(0, ReikaMusicHelper.MusicKey.D5);
        TileEntityDimensionCore.addMelodyNote(0, ReikaMusicHelper.MusicKey.B4);
        TileEntityDimensionCore.addMelodyNote(0, ReikaMusicHelper.MusicKey.G4);
        TileEntityDimensionCore.addMelodyNote(0, ReikaMusicHelper.MusicKey.A4);
        TileEntityDimensionCore.addMelodyNote(0, ReikaMusicHelper.MusicKey.B4);
        TileEntityDimensionCore.addMelodyNote(0, ReikaMusicHelper.MusicKey.C5);
        TileEntityDimensionCore.addMelodyNote(0, ReikaMusicHelper.MusicKey.D5);
        TileEntityDimensionCore.addMelodyNote(0, ReikaMusicHelper.MusicKey.E5);
        TileEntityDimensionCore.addMelodyNote(0, ReikaMusicHelper.MusicKey.D5);
        TileEntityDimensionCore.addMelodyNote(0, ReikaMusicHelper.MusicKey.C5);
        TileEntityDimensionCore.addMelodyNote(0, ReikaMusicHelper.MusicKey.B4);
        TileEntityDimensionCore.addMelodyNote(0, ReikaMusicHelper.MusicKey.A4);
        TileEntityDimensionCore.addMelodyNote(0, ReikaMusicHelper.MusicKey.B4);
        TileEntityDimensionCore.addMelodyNote(0, ReikaMusicHelper.MusicKey.G4);
        TileEntityDimensionCore.addMelodyNote(0, ReikaMusicHelper.MusicKey.Fs4);
        TileEntityDimensionCore.addMelodyNote(0, ReikaMusicHelper.MusicKey.G4);
        TileEntityDimensionCore.addMelodyNote(0, ReikaMusicHelper.MusicKey.A4);
        TileEntityDimensionCore.addMelodyNote(0, ReikaMusicHelper.MusicKey.D5);
        TileEntityDimensionCore.addMelodyNote(0, ReikaMusicHelper.MusicKey.Fs5);
        TileEntityDimensionCore.addMelodyNote(0, ReikaMusicHelper.MusicKey.A5);
        TileEntityDimensionCore.addMelodyNote(0, ReikaMusicHelper.MusicKey.C6);
        TileEntityDimensionCore.addMelodyNote(0, ReikaMusicHelper.MusicKey.B5);
        TileEntityDimensionCore.addMelodyNote(0, ReikaMusicHelper.MusicKey.A5);
        TileEntityDimensionCore.addMelodyNote(0, ReikaMusicHelper.MusicKey.B5);
        TileEntityDimensionCore.addMelodyNote(0, ReikaMusicHelper.MusicKey.G5);
        TileEntityDimensionCore.addMelodyNote(0, ReikaMusicHelper.MusicKey.A5);
        TileEntityDimensionCore.addMelodyNote(0, ReikaMusicHelper.MusicKey.B5);
        TileEntityDimensionCore.addMelodyNote(0, ReikaMusicHelper.MusicKey.D6);
        TileEntityDimensionCore.addMelodyNote(0, ReikaMusicHelper.MusicKey.C6);
        TileEntityDimensionCore.addMelodyNote(0, ReikaMusicHelper.MusicKey.C6);
        TileEntityDimensionCore.addMelodyNote(0, ReikaMusicHelper.MusicKey.E6);
        TileEntityDimensionCore.addMelodyNote(0, ReikaMusicHelper.MusicKey.D5);
        TileEntityDimensionCore.addMelodyNote(0, ReikaMusicHelper.MusicKey.D6);
        TileEntityDimensionCore.addMelodyNote(0, ReikaMusicHelper.MusicKey.D6);
        TileEntityDimensionCore.addMelodyNote(0, ReikaMusicHelper.MusicKey.G5);
        TileEntityDimensionCore.addMelodyNote(0, ReikaMusicHelper.MusicKey.Fs5);
        TileEntityDimensionCore.addMelodyNote(0, ReikaMusicHelper.MusicKey.G5);
        TileEntityDimensionCore.addMelodyNote(0, ReikaMusicHelper.MusicKey.D6);
        TileEntityDimensionCore.addMelodyNote(0, ReikaMusicHelper.MusicKey.B5);
        TileEntityDimensionCore.addMelodyNote(0, ReikaMusicHelper.MusicKey.G5);
        TileEntityDimensionCore.addMelodyNote(0, ReikaMusicHelper.MusicKey.A5);
        TileEntityDimensionCore.addMelodyNote(0, ReikaMusicHelper.MusicKey.B5);
        TileEntityDimensionCore.addMelodyNote(0, ReikaMusicHelper.MusicKey.E5);
        TileEntityDimensionCore.addMelodyNote(0, ReikaMusicHelper.MusicKey.D6);
        TileEntityDimensionCore.addMelodyNote(0, ReikaMusicHelper.MusicKey.C6);
        TileEntityDimensionCore.addMelodyNote(0, ReikaMusicHelper.MusicKey.B5);
        TileEntityDimensionCore.addMelodyNote(0, ReikaMusicHelper.MusicKey.A5);
        TileEntityDimensionCore.addMelodyNote(0, ReikaMusicHelper.MusicKey.G5);
        TileEntityDimensionCore.addMelodyNote(0, ReikaMusicHelper.MusicKey.D5);
        TileEntityDimensionCore.addMelodyNote(0, ReikaMusicHelper.MusicKey.G5);
        TileEntityDimensionCore.addMelodyNote(0, ReikaMusicHelper.MusicKey.Fs5);
        TileEntityDimensionCore.addMelodyNote(0, ReikaMusicHelper.MusicKey.G5);
        TileEntityDimensionCore.addMelodyNote(0, ReikaMusicHelper.MusicKey.G5);
        TileEntityDimensionCore.addMelodyNote(0, ReikaMusicHelper.MusicKey.G5);
        TileEntityDimensionCore.addMelodyNote(0, ReikaMusicHelper.MusicKey.G5);
        TileEntityDimensionCore.melody[1] = new ArrayList();
        TileEntityDimensionCore.addMelodyNote(1, ReikaMusicHelper.MusicKey.C5);
        TileEntityDimensionCore.addMelodyNote(1, ReikaMusicHelper.MusicKey.E5);
        TileEntityDimensionCore.addMelodyNote(1, ReikaMusicHelper.MusicKey.G5);
        TileEntityDimensionCore.addMelodyNote(1, ReikaMusicHelper.MusicKey.C6);
        TileEntityDimensionCore.addMelodyNote(1, ReikaMusicHelper.MusicKey.G4);
        TileEntityDimensionCore.addMelodyNote(1, ReikaMusicHelper.MusicKey.B4);
        TileEntityDimensionCore.addMelodyNote(1, ReikaMusicHelper.MusicKey.D5);
        TileEntityDimensionCore.addMelodyNote(1, ReikaMusicHelper.MusicKey.G5);
        TileEntityDimensionCore.addMelodyNote(1, ReikaMusicHelper.MusicKey.A4);
        TileEntityDimensionCore.addMelodyNote(1, ReikaMusicHelper.MusicKey.C5);
        TileEntityDimensionCore.addMelodyNote(1, ReikaMusicHelper.MusicKey.E5);
        TileEntityDimensionCore.addMelodyNote(1, ReikaMusicHelper.MusicKey.A5);
        TileEntityDimensionCore.addMelodyNote(1, ReikaMusicHelper.MusicKey.E4);
        TileEntityDimensionCore.addMelodyNote(1, ReikaMusicHelper.MusicKey.G4);
        TileEntityDimensionCore.addMelodyNote(1, ReikaMusicHelper.MusicKey.B4);
        TileEntityDimensionCore.addMelodyNote(1, ReikaMusicHelper.MusicKey.G5);
        TileEntityDimensionCore.addMelodyNote(1, ReikaMusicHelper.MusicKey.F4);
        TileEntityDimensionCore.addMelodyNote(1, ReikaMusicHelper.MusicKey.A4);
        TileEntityDimensionCore.addMelodyNote(1, ReikaMusicHelper.MusicKey.C5);
        TileEntityDimensionCore.addMelodyNote(1, ReikaMusicHelper.MusicKey.F5);
        TileEntityDimensionCore.addMelodyNote(1, ReikaMusicHelper.MusicKey.C4);
        TileEntityDimensionCore.addMelodyNote(1, ReikaMusicHelper.MusicKey.E4);
        TileEntityDimensionCore.addMelodyNote(1, ReikaMusicHelper.MusicKey.G4);
        TileEntityDimensionCore.addMelodyNote(1, ReikaMusicHelper.MusicKey.C5);
        TileEntityDimensionCore.addMelodyNote(1, ReikaMusicHelper.MusicKey.F4);
        TileEntityDimensionCore.addMelodyNote(1, ReikaMusicHelper.MusicKey.A4);
        TileEntityDimensionCore.addMelodyNote(1, ReikaMusicHelper.MusicKey.C5);
        TileEntityDimensionCore.addMelodyNote(1, ReikaMusicHelper.MusicKey.F5);
        TileEntityDimensionCore.addMelodyNote(1, ReikaMusicHelper.MusicKey.G4);
        TileEntityDimensionCore.addMelodyNote(1, ReikaMusicHelper.MusicKey.B4);
        TileEntityDimensionCore.addMelodyNote(1, ReikaMusicHelper.MusicKey.D5);
        TileEntityDimensionCore.addMelodyNote(1, ReikaMusicHelper.MusicKey.G5);
    }
}

