/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.Storage;

import Reika.ChromatiCraft.Auxiliary.ChromaAux;
import Reika.ChromatiCraft.Auxiliary.ChromaFX;
import Reika.ChromatiCraft.Auxiliary.ChromaStructures;
import Reika.ChromatiCraft.Auxiliary.CrystalMusicManager;
import Reika.ChromatiCraft.Auxiliary.Interfaces.MultiBlockChromaTile;
import Reika.ChromatiCraft.Auxiliary.Interfaces.OwnedTile;
import Reika.ChromatiCraft.Auxiliary.ProgressionManager;
import Reika.ChromatiCraft.Base.TileEntity.CrystalReceiverBase;
import Reika.ChromatiCraft.Base.TileEntity.TileEntityWirelessPowered;
import Reika.ChromatiCraft.Block.Crystal.BlockPowerTree;
import Reika.ChromatiCraft.Magic.CrystalTarget;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalBattery;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalReceiver;
import Reika.ChromatiCraft.Magic.Interfaces.WirelessSource;
import Reika.ChromatiCraft.Magic.PlayerElementBuffer;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.Chromabilities;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.APIPacketHandler;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.FilledBlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockVector;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaDirectionHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityPowerTree
extends CrystalReceiverBase
implements CrystalBattery,
OwnedTile,
WirelessSource,
MultiBlockChromaTile {
    private static final EnumMap<CrystalElement, BlockVector> origins = new EnumMap(CrystalElement.class);
    private static final EnumMap<CrystalElement, Integer> yOffsets = new EnumMap(CrystalElement.class);
    private static final EnumMap<CrystalElement, ArrayList<Coordinate>> locations = new EnumMap(CrystalElement.class);
    private static final ArrayList<Integer> directions = new ArrayList();
    private final EnumMap<CrystalElement, Integer> growth = new EnumMap(CrystalElement.class);
    private final EnumMap<CrystalElement, Integer> steps = new EnumMap(CrystalElement.class);
    private final EnumMap<CrystalElement, Integer> boost = new EnumMap(CrystalElement.class);
    private ArrayList<CrystalTarget> targets = new ArrayList();
    private ArrayList<CrystalTarget.TickingCrystalTarget> tickingTargets = new ArrayList();
    private boolean hasMultiblock = false;
    private boolean enhanced = false;
    private boolean hadEnhancedProgress = false;
    public static final int BASE = 1000;
    public static final int RATIO = 4000;
    public static final int POWER = 3;
    public static final int POWER_TURBO = 4;
    public static final int BOOST_LENGTH = 5400;

    public TileEntityPowerTree() {
        for (int i = 0; i < CrystalElement.elements.length; ++i) {
            CrystalElement e = CrystalElement.elements[i];
            this.growth.put(e, 0);
        }
    }

    private static void addOrigin(CrystalElement e, BlockVector vec) {
        origins.put(e, vec);
        yOffsets.put(e, vec.yCoord);
    }

    private static void addLeaf(CrystalElement e, int x, int y, int z) {
        ArrayList<Object> li = locations.get((Object)e);
        if (li == null) {
            li = new ArrayList();
            locations.put(e, li);
        }
        li.add(new Coordinate(x, y, z));
    }

    public static ForgeDirection getDirection(CrystalElement e) {
        return TileEntityPowerTree.origins.get((Object)((Object)e)).direction;
    }

    public static int getYOffset(CrystalElement e) {
        return yOffsets.get((Object)e);
    }

    @Override
    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateEntity(world, x, y, z, meta);
        if (world.field_72995_K && !this.targets.isEmpty()) {
            ChromaFX.drawLeyLineParticles(world, x, y, z, this.getOutgoingBeamRadius(), this.targets);
        }
        if (this.canConduct()) {
            if (!world.field_72995_K) {
                CrystalElement e;
                int i;
                for (i = 0; i < 16; ++i) {
                    int base;
                    e = CrystalElement.elements[i];
                    boolean acc = this.growAndTickBoost(e);
                    int n = base = acc ? 40 : 150;
                    if (rand.nextInt(base * 16) != 0) continue;
                    this.grow(e);
                }
                if (DragonAPICore.debugtest) {
                    for (i = 0; i < 64; ++i) {
                        this.grow(CrystalElement.randomElement());
                    }
                }
                if (rand.nextInt(100) == 0) {
                    for (i = 0; i < CrystalElement.elements.length; ++i) {
                        e = CrystalElement.elements[i];
                        if (this.getRemainingSpace(e) <= 0) continue;
                        this.requestEnergy(e, this.getRemainingSpace(e));
                    }
                }
            }
            for (EntityPlayer ep : this.getOwners(false)) {
                int cap;
                int space;
                CrystalElement e;
                if (!Chromabilities.RECHARGE.enabledOn(ep) || !(ep.func_70092_e((double)x + 0.5, (double)y + 0.5, (double)z + 0.5) <= 2048.0) || this.getEnergy(e = CrystalElement.elements[this.getTicksExisted() / 16 % 16]) <= 0 || (space = (cap = PlayerElementBuffer.instance.getElementCap(ep)) - PlayerElementBuffer.instance.getPlayerContent(ep, e)) <= 0) continue;
                int amt = Math.min(this.getEnergy(e), Math.min(space, Math.max(cap / 24 / 8, 1 + rand.nextInt(Math.max(1, space / 4 * 4)))));
                ChromaAux.chargePlayerFromPylon(ep, this, e, amt);
            }
        }
        this.tickTargets();
    }

    private void tickTargets() {
        if (!this.tickingTargets.isEmpty()) {
            Iterator<CrystalTarget.TickingCrystalTarget> it = this.tickingTargets.iterator();
            while (it.hasNext()) {
                CrystalTarget.TickingCrystalTarget t = it.next();
                if (!t.tick()) continue;
                it.remove();
                this.targets.remove(t);
                this.syncAllData(true);
            }
        }
    }

    private boolean growAndTickBoost(CrystalElement e) {
        Integer get = this.boost.get((Object)e);
        if (get != null && get > 0) {
            Integer n = get;
            Integer n2 = get = Integer.valueOf(get - 1);
            this.boost.put(e, get);
            return true;
        }
        if (rand.nextInt(20) == 0 && this.findBoost(e)) {
            this.boost.put(e, 5400);
            return true;
        }
        return false;
    }

    private boolean findBoost(CrystalElement e) {
        AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1)).func_72314_b(7.0, 7.0, 7.0).func_72317_d(0.0, -6.0, 0.0);
        List li = this.field_145850_b.func_72872_a(EntityItem.class, box);
        for (EntityItem ei : li) {
            if (ei.field_70128_L || ei.field_145804_b != 0) continue;
            ItemStack is = ei.func_92059_d();
            if (is.field_77994_a <= 0 || !ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)ChromaItems.ELEMENTAL.getStackOf(e))) continue;
            --is.field_77994_a;
            if (is.field_77994_a > 0) {
                ei.func_92058_a(is);
            } else {
                ei.func_70106_y();
            }
            return true;
        }
        return false;
    }

    @Override
    public void onFirstTick(World world, int x, int y, int z) {
        super.onFirstTick(world, x, y, z);
        if (!world.field_72995_K) {
            this.validateStructure();
        }
        this.targets.clear();
    }

    @Override
    public void validateStructure() {
        FilledBlockArray f = ChromaStructures.getTreeStructure(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        boolean flag = f.matchInWorld();
        if (!flag && this.hasMultiblock) {
            this.onBreakMultiblock();
        }
        this.hasMultiblock = flag;
        EntityPlayer ep = this.getPlacer();
        if (ep != null && !ReikaPlayerAPI.isFake((EntityPlayer)ep)) {
            this.hadEnhancedProgress = ProgressionManager.ProgressStage.CTM.isPlayerAtStage(ep);
        }
        this.enhanced = this.hasMultiblock && this.hadEnhancedProgress && ChromaStructures.getBoostedTreeStructure(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e).matchInWorld();
        for (int i = 0; i < 16; ++i) {
            this.clamp(CrystalElement.elements[i]);
        }
        this.syncAllData(true);
    }

    public boolean hasMultiBlock() {
        return this.hasMultiblock;
    }

    private void onBreakMultiblock() {
        for (int i = 0; i < 16; ++i) {
            CrystalElement e = CrystalElement.elements[i];
            BlockVector c = origins.get((Object)e);
            this.field_145850_b.func_147449_b(this.field_145851_c + c.xCoord, this.field_145848_d + c.yCoord, this.field_145849_e + c.zCoord, Blocks.field_150350_a);
        }
        this.energy.clear();
    }

    private void grow(CrystalElement e) {
        int stage = this.growth.get((Object)e);
        ArrayList<Coordinate> li = locations.get((Object)e);
        if (this.getRemainingSpace(e) == 0) {
            if (stage < li.size()) {
                Coordinate c = li.get(stage).offset(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                Block b = c.getBlock(this.field_145850_b);
                if (b == ChromaBlocks.POWERTREE.getBlockInstance()) {
                    BlockPowerTree.TileEntityPowerTreeAux te = (BlockPowerTree.TileEntityPowerTreeAux)c.getTileEntity(this.field_145850_b);
                    if (te.grow()) {
                        this.steps.put(e, te.getGrowth());
                    } else {
                        this.growth.put(e, ++stage);
                        this.steps.put(e, 0);
                    }
                } else if (ReikaWorldHelper.softBlocks((IBlockAccess)this.field_145850_b, (int)c.xCoord, (int)c.yCoord, (int)c.zCoord)) {
                    int dir;
                    c.setBlock(this.field_145850_b, ChromaBlocks.POWERTREE.getBlockInstance(), e.ordinal());
                    BlockPowerTree.TileEntityPowerTreeAux te = (BlockPowerTree.TileEntityPowerTreeAux)c.getTileEntity(this.field_145850_b);
                    int n = dir = stage < directions.size() ? directions.get(stage) : -1;
                    if (dir >= 0) {
                        ForgeDirection direc = TileEntityPowerTree.origins.get((Object)((Object)e)).direction;
                        if (dir == 90) {
                            direc = ReikaDirectionHelper.getRightBy90((ForgeDirection)direc);
                        } else if (dir == -90) {
                            direc = ReikaDirectionHelper.getLeftBy90((ForgeDirection)direc);
                        } else if (dir == 180) {
                            direc = direc.getOpposite();
                        }
                        te.setDirection(direc);
                    }
                    te.setOrigin(this);
                    this.steps.put(e, 0);
                }
            } else {
                this.steps.put(e, 0);
            }
        } else if (stage > 0 ? this.energy.getValue(e) <= this.getStorageForStep(e, stage - 1) : this.energy.getValue(e) <= 1000) {
            if (stage < li.size()) {
                Coordinate c = li.get(stage).offset(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                Block b = c.getBlock(this.field_145850_b);
                if (b == ChromaBlocks.POWERTREE.getBlockInstance()) {
                    BlockPowerTree.TileEntityPowerTreeAux te = (BlockPowerTree.TileEntityPowerTreeAux)c.getTileEntity(this.field_145850_b);
                    if (te.ungrow()) {
                        this.steps.put(e, te.getGrowth());
                    } else {
                        c.setBlock(this.field_145850_b, Blocks.field_150350_a);
                        if (stage > 0) {
                            --stage;
                        }
                        this.growth.put(e, stage);
                        this.steps.put(e, 0);
                    }
                }
            } else {
                if (stage > 0) {
                    --stage;
                }
                this.growth.put(e, stage);
            }
        }
        this.syncAllData(true);
    }

    @Override
    public int getReceiveRange() {
        return 32;
    }

    @Override
    public boolean isConductingElement(CrystalElement e) {
        return e != null && this.energy.getValue(e) > 0;
    }

    @Override
    public int maxThroughput() {
        return this.isEnhanced() ? 20000 : 1000;
    }

    @Override
    public boolean canConduct() {
        return this.hasMultiblock && this.isOnTop() && this.field_145850_b.func_72937_j(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
    }

    private boolean isOnTop() {
        return this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e).isAir((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
    }

    @Override
    public int getMaxStorage(CrystalElement e) {
        if (!this.canConduct()) {
            return 0;
        }
        int s = this.growth.get((Object)e);
        return this.getStorageForStep(e, s);
    }

    private int getStorageForStep(CrystalElement e, int step) {
        return 1000 + ReikaMathLibrary.intpow2((int)step, (int)(this.isEnhanced() ? 4 : 3)) * 4000;
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.POWERTREE;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    public boolean isEnhanced() {
        return this.enhanced;
    }

    @Override
    public boolean drain(CrystalElement e, int amt) {
        if (this.energy.containsAtLeast(e, amt)) {
            this.drainEnergy(e, amt);
            this.grow(e);
            return true;
        }
        return false;
    }

    @Override
    public int getSendRange() {
        return this.getReceiveRange();
    }

    @Override
    public final void addTarget(WorldLocation loc, CrystalElement e, double dx, double dy, double dz, double w) {
        CrystalTarget tg = new CrystalTarget(loc, e, dx, dy, dz, w);
        if (!this.field_145850_b.field_72995_K) {
            if (!this.targets.contains(tg)) {
                this.targets.add(tg);
            }
            this.onTargetChanged();
        }
    }

    @Override
    public final void addSelfTickingTarget(WorldLocation loc, CrystalElement e, double dx, double dy, double dz, double w, int duration) {
        CrystalTarget.TickingCrystalTarget tg = new CrystalTarget.TickingCrystalTarget(loc, e, dx, dy, dz, w, duration);
        if (!this.field_145850_b.field_72995_K) {
            if (!this.targets.contains(tg)) {
                this.targets.add(tg);
                this.tickingTargets.add(tg);
            }
            this.onTargetChanged();
        }
    }

    @Override
    public final void removeTarget(WorldLocation loc, CrystalElement e) {
        if (!this.field_145850_b.field_72995_K) {
            this.targets.remove(new CrystalTarget(loc, e, 0.0));
            this.onTargetChanged();
        }
    }

    @Override
    public final void clearTargets(boolean unload) {
        if (!this.field_145850_b.field_72995_K) {
            this.targets.clear();
            if (!unload) {
                this.onTargetChanged();
            }
        }
    }

    private void onTargetChanged() {
        this.syncAllData(true);
    }

    @Override
    public boolean needsLineOfSightToReceiver(CrystalReceiver r) {
        return true;
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.hasMultiblock = NBT.func_74767_n("multi");
        this.enhanced = NBT.func_74767_n("boosted");
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74757_a("multi", this.hasMultiblock);
        NBT.func_74757_a("boosted", this.enhanced);
    }

    @Override
    public void func_145839_a(NBTTagCompound NBT) {
        super.func_145839_a(NBT);
        for (int i = 0; i < 16; ++i) {
            CrystalElement e = CrystalElement.elements[i];
            this.steps.put(e, NBT.func_74762_e("step" + i));
            this.growth.put(e, NBT.func_74762_e("grow" + i));
        }
        this.targets = new ArrayList();
        int num = NBT.func_74762_e("targetcount");
        for (int i = 0; i < num; ++i) {
            this.targets.add(CrystalTarget.readFromNBT("target" + i, NBT));
        }
        this.hadEnhancedProgress = NBT.func_74767_n("progress");
    }

    @Override
    public void func_145841_b(NBTTagCompound NBT) {
        int i;
        super.func_145841_b(NBT);
        for (i = 0; i < 16; ++i) {
            CrystalElement e = CrystalElement.elements[i];
            NBT.func_74768_a("step" + i, this.steps.containsKey((Object)e) ? this.steps.get((Object)e) : 0);
            NBT.func_74768_a("grow" + i, this.growth.containsKey((Object)e) ? this.growth.get((Object)e) : 0);
        }
        NBT.func_74768_a("targetcount", this.targets.size());
        for (i = 0; i < this.targets.size(); ++i) {
            this.targets.get(i).writeToNBT("target" + i, NBT);
        }
        NBT.func_74757_a("progress", this.hadEnhancedProgress);
    }

    public void onBreakLeaf(World world, int x, int y, int z, CrystalElement e) {
        Coordinate c = new Coordinate(x - this.field_145851_c, y - this.field_145848_d, z - this.field_145849_e);
        ArrayList<Coordinate> li = locations.get((Object)e);
        int index = li.indexOf(c);
        if (index >= 0) {
            this.growth.put(e, Math.min(this.growth.get((Object)e), index));
            this.steps.put(e, 0);
            this.clamp(e);
            for (int i = index + 1; i < li.size(); ++i) {
                Coordinate c2 = li.get(i).offset(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                ArrayList items = c2.getBlock(world).getDrops(world, c2.xCoord, c2.yCoord, c2.zCoord, c2.getBlockMetadata(world), 0);
                ReikaItemHelper.dropItems((World)world, (double)((double)c2.xCoord + rand.nextDouble()), (double)((double)c2.yCoord + rand.nextDouble()), (double)((double)c2.zCoord + rand.nextDouble()), (Collection)items);
                c2.setBlock(world, Blocks.field_150350_a);
                ReikaSoundHelper.playBreakSound((World)world, (int)c2.xCoord, (int)c2.yCoord, (int)c2.zCoord, (Block)Blocks.field_150359_w);
            }
        }
    }

    @Override
    public Collection<CrystalTarget> getTargets() {
        return Collections.unmodifiableCollection(this.targets);
    }

    @Override
    public int getSourcePriority() {
        return 500;
    }

    @Override
    public boolean canSupply(CrystalReceiver te, CrystalElement e) {
        return !(te instanceof TileEntityPowerTree) && this.getEnergy(e) >= 60000;
    }

    @Override
    public boolean canTransmitTo(CrystalReceiver te) {
        return true;
    }

    @Override
    public void onUsedBy(EntityPlayer ep, CrystalElement e) {
        World world = this.field_145850_b;
        Coordinate c = locations.get((Object)e).get(rand.nextInt(locations.get((Object)e).size()));
        c = c.offset(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        int x = c.xCoord;
        int y = c.yCoord;
        int z = c.zCoord;
        int r = e.getRed();
        int g = e.getGreen();
        int b = e.getBlue();
        ReikaPacketHelper.sendDataPacket((String)"DragonAPIData", (int)APIPacketHandler.PacketIDs.COLOREDPARTICLE.ordinal(), (World)world, (int)x, (int)y, (int)z, (int[])new int[]{r, g, b, 32, 8});
        int mod = (int)(world.func_82737_E() % 16L);
        if (mod == 0) {
            ChromaSounds.DING.playSoundAtBlock(world, x, y, z, 1.0f, (float)CrystalMusicManager.instance.getDingPitchScale(e));
        } else if (mod == 4) {
            ChromaSounds.DING.playSoundAtBlock(world, x, y, z, 1.0f, (float)CrystalMusicManager.instance.getThird(e));
        } else if (mod == 8) {
            ChromaSounds.DING.playSoundAtBlock(world, x, y, z, 1.0f, (float)CrystalMusicManager.instance.getFifth(e));
        } else if (mod == 12) {
            ChromaSounds.DING.playSoundAtBlock(world, x, y, z, 1.0f, (float)CrystalMusicManager.instance.getOctave(e));
        }
    }

    @Override
    public boolean playerCanUse(EntityPlayer ep) {
        return this.isOwnedByPlayer(ep);
    }

    @Override
    public boolean allowCharging(EntityPlayer ep, CrystalElement e) {
        return this.playerCanUse(ep);
    }

    @Override
    public float getChargeRateMultiplier(EntityPlayer ep, CrystalElement e) {
        return 0.85f;
    }

    @Override
    public CrystalElement getDeliveredColor(EntityPlayer ep, World world, int clickX, int clickY, int clickZ) {
        return CrystalElement.elements[world.func_72805_g(clickX, clickY, clickZ)];
    }

    @Override
    public Coordinate getChargeParticleOrigin(EntityPlayer ep, CrystalElement e) {
        ArrayList<Coordinate> li = locations.get((Object)e);
        int step = this.growth.get((Object)e);
        return step == 0 ? new Coordinate((TileEntity)this) : li.get(Math.min(step - 1, rand.nextInt(li.size()))).offset(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.hasMultiBlock()) {
            AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1));
            if (this.isEnhanced()) {
                box = box.func_72314_b(7.0, 7.0, 7.0).func_72317_d(0.0, -6.0, 0.0);
            }
            return box;
        }
        return super.getRenderBoundingBox();
    }

    public double func_145833_n() {
        return super.func_145833_n() * 4.0;
    }

    @Override
    public boolean canTransmitTo(TileEntityWirelessPowered te) {
        return this.getDistanceSqTo(te.field_145851_c, te.field_145848_d, te.field_145849_e) <= 1024.0;
    }

    @Override
    public int request(CrystalElement e, int amt, int x, int y, int z) {
        int has = this.energy.getValue(e);
        if ((amt = Math.min(amt, has)) > 0) {
            this.drain(e, amt);
            return amt;
        }
        return 0;
    }

    @Override
    public int getPathPriority() {
        return this.getSourcePriority();
    }

    static {
        TileEntityPowerTree.addOrigin(CrystalElement.WHITE, new BlockVector(ForgeDirection.NORTH, 1, -3, -2));
        TileEntityPowerTree.addOrigin(CrystalElement.BLACK, new BlockVector(ForgeDirection.NORTH, 1, -9, -2));
        TileEntityPowerTree.addOrigin(CrystalElement.RED, new BlockVector(ForgeDirection.EAST, 2, -9, 0));
        TileEntityPowerTree.addOrigin(CrystalElement.GREEN, new BlockVector(ForgeDirection.SOUTH, 0, -5, 1));
        TileEntityPowerTree.addOrigin(CrystalElement.BROWN, new BlockVector(ForgeDirection.WEST, -1, -7, -1));
        TileEntityPowerTree.addOrigin(CrystalElement.BLUE, new BlockVector(ForgeDirection.EAST, 2, -3, 0));
        TileEntityPowerTree.addOrigin(CrystalElement.PURPLE, new BlockVector(ForgeDirection.EAST, 2, -5, 0));
        TileEntityPowerTree.addOrigin(CrystalElement.CYAN, new BlockVector(ForgeDirection.SOUTH, 0, -3, 1));
        TileEntityPowerTree.addOrigin(CrystalElement.LIGHTGRAY, new BlockVector(ForgeDirection.NORTH, 1, -5, -2));
        TileEntityPowerTree.addOrigin(CrystalElement.GRAY, new BlockVector(ForgeDirection.NORTH, 1, -7, -2));
        TileEntityPowerTree.addOrigin(CrystalElement.PINK, new BlockVector(ForgeDirection.WEST, -1, -5, -1));
        TileEntityPowerTree.addOrigin(CrystalElement.LIME, new BlockVector(ForgeDirection.SOUTH, 0, -7, 1));
        TileEntityPowerTree.addOrigin(CrystalElement.YELLOW, new BlockVector(ForgeDirection.SOUTH, 0, -9, 1));
        TileEntityPowerTree.addOrigin(CrystalElement.LIGHTBLUE, new BlockVector(ForgeDirection.WEST, -1, -3, -1));
        TileEntityPowerTree.addOrigin(CrystalElement.MAGENTA, new BlockVector(ForgeDirection.EAST, 2, -7, 0));
        TileEntityPowerTree.addOrigin(CrystalElement.ORANGE, new BlockVector(ForgeDirection.WEST, -1, -9, -1));
        directions.add(0);
        directions.add(0);
        directions.add(0);
        directions.add(0);
        directions.add(0);
        directions.add(0);
        directions.add(0);
        directions.add(0);
        directions.add(90);
        directions.add(0);
        directions.add(90);
        directions.add(0);
        directions.add(0);
        directions.add(90);
        for (int i = 0; i < CrystalElement.elements.length; ++i) {
            CrystalElement e = CrystalElement.elements[i];
            BlockVector bv = origins.get((Object)e);
            ForgeDirection dir = bv.direction;
            ForgeDirection left = ReikaDirectionHelper.getLeftBy90((ForgeDirection)dir);
            int x = bv.xCoord;
            int y = bv.yCoord;
            int z = bv.zCoord;
            TileEntityPowerTree.addLeaf(e, x, y, z);
            TileEntityPowerTree.addLeaf(e, x += left.offsetX, y += left.offsetY, z += left.offsetZ);
            y -= left.offsetY;
            TileEntityPowerTree.addLeaf(e, x -= left.offsetX, ++y, z -= left.offsetZ);
            TileEntityPowerTree.addLeaf(e, x += left.offsetX, y += left.offsetY, z += left.offsetZ);
            x = bv.xCoord;
            y = bv.yCoord;
            z = bv.zCoord;
            TileEntityPowerTree.addLeaf(e, x += dir.offsetX, y += dir.offsetY, z += dir.offsetZ);
            TileEntityPowerTree.addLeaf(e, x += left.offsetX, y += left.offsetY, z += left.offsetZ);
            y -= left.offsetY;
            TileEntityPowerTree.addLeaf(e, x -= left.offsetX, ++y, z -= left.offsetZ);
            TileEntityPowerTree.addLeaf(e, x += left.offsetX, y += left.offsetY, z += left.offsetZ);
            x = bv.xCoord;
            y = bv.yCoord;
            z = bv.zCoord;
            TileEntityPowerTree.addLeaf(e, x -= left.offsetX, y -= left.offsetY, z -= left.offsetZ);
            TileEntityPowerTree.addLeaf(e, x += dir.offsetX, y += dir.offsetY, z += dir.offsetZ);
            y -= dir.offsetY;
            TileEntityPowerTree.addLeaf(e, x -= dir.offsetX, ++y, z -= dir.offsetZ);
            x = bv.xCoord;
            y = bv.yCoord;
            z = bv.zCoord;
            TileEntityPowerTree.addLeaf(e, x += dir.offsetX * 2, y += dir.offsetY * 2, z += dir.offsetZ * 2);
            TileEntityPowerTree.addLeaf(e, x += left.offsetX, y += left.offsetY, z += left.offsetZ);
            x = bv.xCoord;
            y = bv.yCoord;
            z = bv.zCoord;
            TileEntityPowerTree.addLeaf(e, x -= left.offsetX * 2, y -= left.offsetY * 2, z -= left.offsetZ * 2);
        }
    }
}

