/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.Recipe;

import Reika.ChromatiCraft.Auxiliary.CrystalNetworkLogger;
import Reika.ChromatiCraft.Auxiliary.Interfaces.OwnedTile;
import Reika.ChromatiCraft.Auxiliary.RecipeManagers.CastingRecipe;
import Reika.ChromatiCraft.Base.TileEntity.CrystalReceiverBase;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.Magic.ItemElementCalculator;
import Reika.ChromatiCraft.Magic.Network.CrystalFlow;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityBlurFX;
import Reika.ChromatiCraft.Render.Particle.EntityCenterBlurFX;
import Reika.ChromatiCraft.Render.Particle.EntityGlobeFX;
import Reika.ChromatiCraft.Render.Particle.EntityLaserFX;
import Reika.ChromatiCraft.TileEntity.Recipe.TileEntityCastingTable;
import Reika.ChromatiCraft.TileEntity.Recipe.TileEntityItemStand;
import Reika.DragonAPI.ASM.APIStripper;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Base.TileEntityBase;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.Collections.ItemCollection;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.KeyedItemStack;
import Reika.DragonAPI.Instantiable.ModInteract.BasicAEInterface;
import Reika.DragonAPI.Instantiable.Recipe.ItemMatch;
import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Interfaces.TileEntity.GuiController;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.ModInteract.DeepInteract.MESystemReader;
import Reika.DragonAPI.ModList;
import appeng.api.AEApi;
import appeng.api.config.FuzzyMode;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.util.AECableType;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@APIStripper.Strippable(value={"appeng.api.networking.IActionHost"})
public class TileEntityCastingAuto
extends CrystalReceiverBase
implements GuiController,
OwnedTile,
IActionHost {
    private static final ElementTagCompound required = new ElementTagCompound();
    private CastingRecipe recipe;
    private StepTimer stepDelay = new StepTimer(5);
    private StepTimer cacheTimer = new StepTimer(40);
    private int recipesToGo = 0;
    private int recipeCycles = 0;
    private final ItemCollection ingredients = new ItemCollection();
    @DependentMethodStripper.ModDependent(value=ModList.APPENG)
    private MESystemReader network;
    private Object aeGridBlock;
    private Object aeGridNode;

    public TileEntityCastingAuto() {
        if (ModList.APPENG.isLoaded()) {
            this.aeGridBlock = new BasicAEInterface((TileEntity)this, this.getTile().getCraftedProduct());
            this.aeGridNode = FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER ? AEApi.instance().createGridNode((IGridBlock)this.aeGridBlock) : null;
        }
    }

    private TileEntityCastingTable getTable(World world, int x, int y, int z) {
        for (int i = 1; i < 5; ++i) {
            Block b = world.func_147439_a(x, y - i, z);
            if (b.isAir((IBlockAccess)world, x, y - i, z)) continue;
            return null;
        }
        TileEntity te = world.func_147438_o(x, y - 5, z);
        return te instanceof TileEntityCastingTable ? (TileEntityCastingTable)te : null;
    }

    public Collection<CastingRecipe> getAvailableRecipes() {
        TileEntityCastingTable te = this.getTable(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return te != null ? te.getCompletedRecipes() : new HashSet<CastingRecipe>();
    }

    public CastingRecipe getCurrentRecipeOutput() {
        return this.recipe;
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.AUTOMATOR;
    }

    protected void onInvalidateOrUnload(World world, int x, int y, int z, boolean invalid) {
        super.onInvalidateOrUnload(world, x, y, z, invalid);
        if (ModList.APPENG.isLoaded() && this.aeGridNode != null) {
            ((IGridNode)this.aeGridNode).destroy();
        }
    }

    @Override
    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateEntity(world, x, y, z, meta);
        TileEntityCastingTable te = this.getTable(world, x, y, z);
        if (te != null && world.field_72995_K) {
            this.doConnectionParticles(world, x, y, z, te);
        }
        if (!world.field_72995_K) {
            this.cacheTimer.update();
            if (this.cacheTimer.checkCap()) {
                this.buildCache();
            }
            if (this.getCooldown() == 0 && this.checkTimer.checkCap()) {
                this.checkAndRequest();
            }
            if (ModList.APPENG.isLoaded() && this.aeGridBlock != null && !world.field_72995_K) {
                ((BasicAEInterface)this.aeGridBlock).setPowerCost(this.recipe != null ? 6.0 : 1.0);
            }
            if (this.recipe != null && this.recipesToGo > 0 && this.energy.containsAtLeast(required)) {
                if (te != null && this.canCraft(world, x, y, z, te)) {
                    if (this.isRecipeReady(world, x, y, z, te)) {
                        if (this.triggerCrafting(world, x, y, z, te)) {
                            te.syncAllData(true);
                            ElementTagCompound tag = required.copy();
                            tag.scale(this.recipe.getAutomationCostFactor(this, te, null));
                            this.drainEnergy(tag);
                            this.recipesToGo -= this.recipeCycles;
                            this.recipeCycles = 0;
                        }
                    } else {
                        int amt = Math.min(this.recipesToGo, this.recipe.getOutput().func_77976_d() / this.recipe.getOutput().field_77994_a);
                        UpdateStep c = this.prepareRecipeStep(world, x, y, z, te, amt);
                        if (c != null) {
                            this.recipeCycles = this.recipeCycles > 0 ? Math.min(this.recipeCycles, ((UpdateStep)c).item.field_77994_a) : ((UpdateStep)c).item.field_77994_a;
                            ChromaSounds.CAST.playSoundAtBlock(world, ((UpdateStep)c).loc.xCoord, ((UpdateStep)c).loc.yCoord, ((UpdateStep)c).loc.zCoord);
                            int[] dat = new int[]{((UpdateStep)c).loc.xCoord, ((UpdateStep)c).loc.yCoord, ((UpdateStep)c).loc.zCoord, 0, Item.func_150891_b((Item)c.item.func_77973_b()), c.item.func_77960_j(), ((UpdateStep)c).item.field_77990_d != null ? 1 : 0};
                            ReikaPacketHelper.sendDataPacketWithRadius((String)"ChromaData", (int)ChromaPackets.CASTAUTOUPDATE.ordinal(), (TileEntity)this, (int)48, (int[])dat);
                            ElementTagCompound tag = required.copy();
                            tag.scale(this.recipe.getAutomationCostFactor(this, te, c.item));
                            this.drainEnergy(tag);
                            te.func_70296_d();
                            TileEntity tile = c.loc.getTileEntity(world);
                            if (tile != null) {
                                tile.func_70296_d();
                                if (tile instanceof TileEntityBase) {
                                    ((TileEntityBase)tile).syncAllData(true);
                                }
                            }
                        }
                    }
                }
            } else if (this.recipe == null || this.recipesToGo == 0) {
                this.cancelCrafting();
            }
        }
    }

    private void checkAndRequest() {
        for (CrystalElement e : required.elementSet()) {
            int sp;
            int amt = this.getEnergy(e);
            if (amt >= (sp = this.getRemainingSpace(e))) continue;
            this.requestEnergy(e, sp);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void doConnectionParticles(World world, int x, int y, int z, TileEntityCastingTable te) {
        double a = Math.toRadians(this.getTicksExisted() * 2 % 360);
        int n = 6;
        int sp = 360 / n;
        double r = 0.5 + 0.125 * Math.sin((double)this.getTicksExisted() / 10.0);
        for (int i = 0; i < 360; i += sp) {
            double ri = Math.toRadians(i);
            double dx = (double)x + 0.5 + r * Math.sin(a + ri);
            double dy = te.field_145848_d + 1;
            double dz = (double)z + 0.5 + r * Math.cos(a + ri);
            EntityGlobeFX fx = new EntityGlobeFX(world, dx, dy, dz, 0.0, 0.125, 0.0);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void receiveUpdatePacket(int[] data) {
        double x = (double)data[0] + 0.5;
        double y = (double)data[1] + 0.5;
        double z = (double)data[2] + 0.5;
        ItemStack is = new ItemStack(Item.func_150899_d((int)data[4]), 1, data[5]);
        boolean nbt = data[6] > 0;
        ElementTagCompound tag = ItemElementCalculator.instance.getValueForItem(is);
        if (nbt && tag != null) {
            tag.addTag(CrystalElement.PURPLE, 1);
            tag.addTag(CrystalElement.BLACK, 1);
        }
        for (int i = 0; i < 32; ++i) {
            CrystalElement e = tag != null ? (CrystalElement)((Object)ReikaJavaLibrary.getRandomCollectionEntry((Random)rand, tag.elementSet())) : null;
            int color = e != null ? e.getColor() : 43775;
            double px = ReikaRandomHelper.getRandomPlusMinus((double)x, (double)1.0);
            double py = ReikaRandomHelper.getRandomPlusMinus((double)y, (double)0.5);
            double pz = ReikaRandomHelper.getRandomPlusMinus((double)z, (double)1.0);
            EntityFX fx = null;
            float g = -((float)ReikaRandomHelper.getRandomPlusMinus((double)0.0625, (double)0.03125));
            switch (rand.nextInt(3)) {
                case 0: {
                    fx = new EntityCenterBlurFX(this.field_145850_b, px, py, pz).setColor(color).setGravity(g);
                    break;
                }
                case 1: {
                    fx = new EntityLaserFX(CrystalElement.WHITE, this.field_145850_b, px, py, pz).setColor(color).setGravity(g);
                    break;
                }
                default: {
                    fx = new EntityBlurFX(this.field_145850_b, px, py, pz).setColor(color).setGravity(g);
                }
            }
            fx.field_70181_x = 0.03125 + rand.nextDouble() * 0.0625;
            Minecraft.func_71410_x().field_71452_i.func_78873_a(fx);
        }
    }

    private void buildCache() {
        this.ingredients.clear();
        TileEntity te = this.getAdjacentTileEntity(ForgeDirection.UP);
        if (te instanceof IInventory) {
            this.ingredients.addInventory((IInventory)te);
        }
        if (ModList.APPENG.isLoaded()) {
            if (this.aeGridNode == null) {
                this.aeGridNode = FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER ? AEApi.instance().createGridNode((IGridBlock)this.aeGridBlock) : null;
            }
            ((IGridNode)this.aeGridNode).updateState();
            this.network = this.aeGridNode != null ? new MESystemReader((IGridNode)this.aeGridNode, (IActionHost)this) : null;
        }
    }

    private boolean canCraft(World world, int x, int y, int z, TileEntityCastingTable te) {
        return te.isReadyToCraft() && te.getPlacerUUID() != null && te.getPlacerUUID().equals(this.getPlacerUUID());
    }

    private boolean triggerCrafting(World world, int x, int y, int z, TileEntityCastingTable te) {
        return te.trigger();
    }

    private boolean isRecipeReady(World world, int x, int y, int z, TileEntityCastingTable te) {
        return te.getActiveRecipe() == this.recipe;
    }

    private UpdateStep prepareRecipeStep(World world, int x, int y, int z, TileEntityCastingTable te, int amt) {
        block9: {
            this.stepDelay.update();
            if (!this.stepDelay.checkCap()) break block9;
            if (this.recipe instanceof CastingRecipe.MultiBlockCastingRecipe) {
                CastingRecipe.MultiBlockCastingRecipe mr = (CastingRecipe.MultiBlockCastingRecipe)this.recipe;
                HashMap<List<Integer>, TileEntityItemStand> map = te.getOtherStands();
                Map<List<Integer>, ItemMatch> items = mr.getAuxItems();
                for (List<Integer> key : map.keySet()) {
                    ItemMatch item = items.get(key);
                    TileEntityItemStand stand = map.get(key);
                    if (stand == null) continue;
                    ItemStack in = stand.func_70301_a(0);
                    if ((item != null || in == null) && (item == null || item.match(in))) continue;
                    if (in != null) {
                        if (!this.recoverItem(in)) continue;
                        stand.func_70299_a(0, null);
                        return new UpdateStep((TileEntity)stand, in);
                    }
                    ItemStack ret = this.findItem(item, amt);
                    if (ret == null) continue;
                    stand.func_70299_a(0, ret);
                    return new UpdateStep((TileEntity)stand, ret);
                }
                ItemStack ctr = mr.getMainInput();
                for (int i = 0; i < 9; ++i) {
                    ItemStack in = te.func_70301_a(i);
                    if (i == 4) {
                        if (in != null) {
                            if (ReikaItemHelper.matchStacks((ItemStack)in, (ItemStack)ctr) && (ctr.field_77990_d == null || ItemStack.func_77970_a((ItemStack)in, (ItemStack)ctr)) || !this.recoverItem(in)) continue;
                            te.func_70299_a(i, null);
                            return new UpdateStep((TileEntity)te, in);
                        }
                        ItemStack ret = this.findItem(ctr, amt);
                        if (ret == null) continue;
                        te.func_70299_a(i, ret);
                        return new UpdateStep((TileEntity)te, ret);
                    }
                    if (in == null || !this.recoverItem(in)) continue;
                    te.func_70299_a(i, null);
                    return new UpdateStep((TileEntity)te, in);
                }
            } else {
                Object[] arr = this.recipe.getInputArray();
                for (int i = 0; i < 9; ++i) {
                    Object item = arr[i];
                    ItemStack in = te.func_70301_a(i);
                    if (this.matches(item, in)) continue;
                    if (in != null) {
                        if (!this.recoverItem(in)) continue;
                        te.func_70299_a(i, null);
                        return new UpdateStep((TileEntity)te, in);
                    }
                    ItemStack ret = this.findItem(item, amt);
                    if (ret == null) continue;
                    te.func_70299_a(i, ret);
                    return new UpdateStep((TileEntity)te, ret);
                }
            }
        }
        return null;
    }

    private boolean matches(Object object, ItemStack is) {
        if (object instanceof ItemStack) {
            return ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)((ItemStack)object)) && ItemStack.func_77970_a((ItemStack)is, (ItemStack)((ItemStack)object));
        }
        if (object instanceof List) {
            return ReikaItemHelper.listContainsItemStack((Collection)((Collection)object), (ItemStack)is, (boolean)true);
        }
        return object == null && is == null;
    }

    private ItemStack findItem(Object item, int amt) {
        ArrayList<ItemStack> li = new ArrayList<ItemStack>();
        if (item instanceof ItemStack) {
            li.add((ItemStack)item);
        }
        if (item instanceof List) {
            li.addAll((List)item);
        }
        if (item instanceof ItemMatch) {
            for (KeyedItemStack ks : ((ItemMatch)item).getItemList()) {
                li.add(ks.getItemStack());
            }
        }
        if (DragonAPICore.debugtest) {
            return ReikaItemHelper.getSizedItemStack((ItemStack)((ItemStack)li.get(0)), (int)amt);
        }
        if (ModList.APPENG.isLoaded()) {
            ChromatiCraft.logger.debug((Object)("Delegate " + this + " requesting " + li + " from " + this.ingredients + " / " + this.network));
        } else {
            ChromatiCraft.logger.debug((Object)("Delegate " + this + " requesting " + li + " from " + this.ingredients));
        }
        for (ItemStack is : li) {
            int has;
            if (ModList.APPENG.isLoaded()) {
                if (is.func_77960_j() == Short.MAX_VALUE) {
                    MESystemReader.ExtractedItem rem = this.network.removeItemFuzzy(ReikaItemHelper.getSizedItemStack((ItemStack)is, (int)amt), false, FuzzyMode.IGNORE_ALL, false, is.field_77990_d != null);
                    if (rem != null) {
                        ItemStack ret = ReikaItemHelper.getSizedItemStack((ItemStack)rem.getItem(), (int)((int)rem.amount));
                        ret.func_77964_b(0);
                        return ret;
                    }
                } else {
                    int rem = (int)this.network.removeItem(ReikaItemHelper.getSizedItemStack((ItemStack)is, (int)amt), false, is.field_77990_d != null);
                    if (rem > 0) {
                        return ReikaItemHelper.getSizedItemStack((ItemStack)is, (int)rem);
                    }
                }
                ChromatiCraft.logger.debug((Object)(this + " failed to find " + is + " in its ME System."));
            }
            if ((has = this.ingredients.getItemCount(is)) <= 0) continue;
            int rem = Math.min(amt, has);
            this.ingredients.removeXItems(is, rem);
            return ReikaItemHelper.getSizedItemStack((ItemStack)is, (int)rem);
        }
        return null;
    }

    private boolean recoverItem(ItemStack is) {
        int left;
        if (DragonAPICore.debugtest) {
            return true;
        }
        if (ModList.APPENG.isLoaded()) {
            is.field_77994_a = left = (int)this.network.addItem(is, false);
            if (left == 0) {
                return true;
            }
        }
        return (left = this.ingredients.addItemsToUnderlyingInventories(is, false)) <= 0;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public void onPathBroken(CrystalFlow p, CrystalNetworkLogger.FlowFail f) {
        this.setRecipe(null, 0);
    }

    public void setRecipe(CastingRecipe c, int amt) {
        this.recipe = c;
        this.recipesToGo = amt;
    }

    public void cancelCrafting() {
        this.setRecipe(null, 0);
    }

    @Override
    public int getReceiveRange() {
        return 16;
    }

    @Override
    public boolean isConductingElement(CrystalElement e) {
        return required.contains(e);
    }

    @Override
    public int maxThroughput() {
        return 2500;
    }

    @Override
    public boolean canConduct() {
        return true;
    }

    @Override
    public int getMaxStorage(CrystalElement e) {
        return 12000;
    }

    @DependentMethodStripper.ModDependent(value=ModList.APPENG)
    public IGridNode getGridNode(ForgeDirection dir) {
        return (IGridNode)this.aeGridNode;
    }

    @DependentMethodStripper.ModDependent(value=ModList.APPENG)
    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.COVERED;
    }

    @DependentMethodStripper.ModDependent(value=ModList.APPENG)
    public void securityBreak() {
    }

    @Override
    public boolean onlyAllowOwnersToUse() {
        return true;
    }

    @DependentMethodStripper.ModDependent(value=ModList.APPENG)
    public IGridNode getActionableNode() {
        return (IGridNode)this.aeGridNode;
    }

    static {
        required.addTag(CrystalElement.BLACK, 50);
        required.addTag(CrystalElement.PURPLE, 20);
        required.addTag(CrystalElement.LIGHTBLUE, 10);
        required.addTag(CrystalElement.WHITE, 20);
    }

    private static class UpdateStep {
        private final Coordinate loc;
        private final ItemStack item;

        private UpdateStep(TileEntity te, ItemStack is) {
            this(new Coordinate(te), is);
        }

        private UpdateStep(Coordinate c, ItemStack is) {
            this.loc = c;
            this.item = is;
        }
    }
}

