/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.Recipe;

import Reika.ChromatiCraft.Auxiliary.ChromaStacks;
import Reika.ChromatiCraft.Auxiliary.ChromaStructures;
import Reika.ChromatiCraft.Auxiliary.Interfaces.FocusAcceleratable;
import Reika.ChromatiCraft.Auxiliary.Interfaces.ItemCollision;
import Reika.ChromatiCraft.Auxiliary.Interfaces.ItemOnRightClick;
import Reika.ChromatiCraft.Auxiliary.Interfaces.MultiBlockChromaTile;
import Reika.ChromatiCraft.Auxiliary.Interfaces.OperationInterval;
import Reika.ChromatiCraft.Auxiliary.Interfaces.OwnedTile;
import Reika.ChromatiCraft.Auxiliary.MultiBlockCheck;
import Reika.ChromatiCraft.Auxiliary.ProgressionManager;
import Reika.ChromatiCraft.Base.TileEntity.InventoriedChromaticBase;
import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityChromaFluidFX;
import Reika.ChromatiCraft.Render.Particle.EntityFlareFX;
import Reika.ChromatiCraft.TileEntity.Auxiliary.TileEntityFocusCrystal;
import Reika.DragonAPI.ASM.APIStripper;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.FilledBlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.InertItem;
import Reika.DragonAPI.Interfaces.TileEntity.InertIInv;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.ModList;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@APIStripper.Strippable(value={"buildcraft.api.transport.IPipeConnection"})
public class TileEntityAuraInfuser
extends InventoriedChromaticBase
implements ItemOnRightClick,
ItemCollision,
OwnedTile,
InertIInv,
IPipeConnection,
OperationInterval,
MultiBlockChromaTile,
FocusAcceleratable {
    private InertItem item;
    private int craftingTick = 0;
    private boolean hasStructure = true;
    private static final ElementTagCompound required = new ElementTagCompound();
    private EntityPlayer craftingPlayer;
    private static final int DURATION = 608;

    public void updateEntity(World world, int x, int y, int z, int meta) {
        if (this.hasStructure) {
            if (this.craftingTick > 0) {
                this.onCraftingTick(world, x, y, z);
            }
        } else {
            this.craftingTick = 0;
        }
        if (DragonAPICore.debugtest) {
            ChromaStructures.getInfusionStructure(world, x, y, z).place();
        }
    }

    protected void onFirstTick(World world, int x, int y, int z) {
        this.validateStructure();
    }

    @Override
    public void validateStructure() {
        this.hasStructure = ChromaStructures.getInfusionStructure(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e).matchInWorld();
        if (!this.hasStructure) {
            if (this.craftingTick > 0) {
                this.killCrafting();
            }
            this.craftingTick = 0;
        }
        this.func_70296_d();
        this.syncAllData(false);
    }

    private void killCrafting() {
    }

    public boolean hasStructure() {
        return this.hasStructure;
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.hasStructure = NBT.func_74767_n("struct");
        this.craftingTick = NBT.func_74762_e("craft");
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74757_a("struct", this.hasStructure);
        NBT.func_74768_a("craft", this.craftingTick);
    }

    private void onCraftingTick(World world, int x, int y, int z) {
        if (world.field_72995_K) {
            this.spawnParticles(world, x, y, z);
        }
        if (this.craftingTick % 304 == 0) {
            ChromaSounds.INFUSION.playSoundAtBlock((TileEntity)this);
        }
        --this.craftingTick;
        if (this.craftingTick == 0) {
            this.craft();
            if (world.field_72995_K) {
                this.craftParticles(world, x, y, z);
            }
            this.craftingPlayer = null;
        }
    }

    private void craft() {
        ChromaSounds.INFUSE.playSoundAtBlock((TileEntity)this);
        this.inv[0] = ReikaItemHelper.getSizedItemStack((ItemStack)ChromaStacks.iridCrystal, (int)this.inv[0].field_77994_a);
        FilledBlockArray arr = ChromaStructures.getInfusionStructure(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        for (int i = 0; i < arr.getSize(); ++i) {
            Coordinate c = arr.getNthBlock(i);
            int dx = c.xCoord;
            int dy = c.yCoord;
            int dz = c.zCoord;
            if (!arr.hasBlockAt(dx, dy, dz, ChromaBlocks.CHROMA.getBlockInstance(), 0)) continue;
            this.field_145850_b.func_147449_b(dx, dy, dz, Blocks.field_150350_a);
        }
        this.validateStructure();
        this.scheduleCallback(new MultiBlockCheck(this), 20);
        this.scheduleCallback(new MultiBlockCheck(this), 100);
        this.scheduleCallback(new MultiBlockCheck(this), 200);
        this.func_70296_d();
    }

    @SideOnly(value=Side.CLIENT)
    private void craftParticles(World world, int x, int y, int z) {
        for (int i = 0; i < 360; i += 15) {
            double ang = Math.toRadians(ReikaRandomHelper.getRandomPlusMinus((int)i, (int)5));
            double v = 0.075;
            double vx = v * Math.sin(ang);
            double vz = v * Math.cos(ang);
            EntityFlareFX fx = new EntityFlareFX(CrystalElement.WHITE, world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, vx, 0.0, vz);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    @Override
    public void func_70296_d() {
        super.func_70296_d();
        ItemStack is = this.inv[0];
        boolean flag = false;
        if (this.item == null) {
            flag = is != null;
        } else if (!ReikaItemHelper.matchStacks((ItemStack)this.inv[0], (ItemStack)this.item.func_92059_d())) {
            flag = true;
        }
        if (flag) {
            InertItem inertItem = this.item = is != null ? new InertItem(this.field_145850_b, is) : null;
        }
        if (this.canCraft()) {
            if (this.craftingTick == 0) {
                this.craftingTick = (int)(608.0f / TileEntityFocusCrystal.getSummedFocusFactor((TileEntity)this));
            }
        } else {
            if (this.craftingTick > 0) {
                this.killCrafting();
            }
            this.craftingTick = 0;
        }
    }

    private boolean canCraft() {
        return ReikaItemHelper.matchStacks((ItemStack)this.inv[0], (ItemStack)ChromaStacks.rawCrystal) && this.craftingPlayer != null && ProgressionManager.ProgressStage.ALLOY.isPlayerAtStage(this.craftingPlayer);
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticles(World world, int x, int y, int z) {
        double ang = Math.toRadians(this.getTicksExisted() * 2 % 360);
        float fac = (float)Math.sin(Math.toRadians(this.getTicksExisted() * 4));
        float s = 1.25f + 0.25f * fac;
        for (int i = 0; i < 360; i += 60) {
            boolean tall = i % 120 == 0;
            float g = tall ? 0.375f * (0.5f + 0.5f * fac) : 0.375f;
            double a = ang + Math.toRadians(i);
            double r = 1.85;
            double v = tall ? 0.0425 * (double)(1.0f + fac) : ReikaRandomHelper.getRandomPlusMinus((double)0.0425, (double)0.005);
            double px = (double)x + 0.5 + r * Math.sin(a);
            double py = (double)y - 0.75;
            double pz = (double)z + 0.5 + r * Math.cos(a);
            double vx = -v * (px - (double)x - 0.5);
            double vy = 0.3;
            double vz = -v * (pz - (double)z - 0.5);
            EntityChromaFluidFX fx = new EntityChromaFluidFX(CrystalElement.WHITE, world, px, py, pz, vx, vy, vz).setScale(s).setGravity(g);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    public boolean func_102008_b(int side, ItemStack is, int slot) {
        return false;
    }

    public int func_70302_i_() {
        return 1;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_94041_b(int slot, ItemStack is) {
        return ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)ChromaStacks.rawCrystal);
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.INFUSER;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    public EntityItem getItem() {
        return this.item;
    }

    @Override
    public ItemStack onRightClickWith(ItemStack item, EntityPlayer ep) {
        if (!this.isOwnedByPlayer(ep)) {
            return item;
        }
        if (!this.hasStructure) {
            if (this.inv[0] != null && item == null) {
                ReikaItemHelper.dropItem((World)this.field_145850_b, (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5), (ItemStack)this.inv[0]);
                this.inv[0] = null;
            }
            return item;
        }
        if (item != null && !this.func_94041_b(0, item)) {
            return item;
        }
        if (this.inv[0] != null) {
            ReikaItemHelper.dropItem((World)this.field_145850_b, (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5), (ItemStack)this.inv[0]);
        }
        this.inv[0] = item != null ? item.func_77946_l() : null;
        this.craftingPlayer = ep;
        this.syncAllData(true);
        return null;
    }

    @Override
    public boolean onItemCollision(EntityItem ei) {
        if (!this.field_145850_b.field_72995_K) {
            ItemStack is = ei.func_92059_d();
            if (ei.field_145804_b == 0 && this.func_94041_b(0, is) && (this.inv[0] == null || ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)this.inv[0]))) {
                int has = this.inv[0] != null ? this.inv[0].field_77994_a : 0;
                int max = is.field_77994_a;
                int add = Math.min(max, is.func_77976_d() - has);
                if (add > 0) {
                    this.craftingTick = 0;
                    this.inv[0] = ReikaItemHelper.getSizedItemStack((ItemStack)is, (int)(has + add));
                    is.field_77994_a -= add;
                    this.craftingPlayer = ReikaItemHelper.getDropper((EntityItem)ei);
                    this.syncAllData(true);
                    if (is.field_77994_a <= 0) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public int getCraftingTick() {
        return this.craftingTick;
    }

    @DependentMethodStripper.ModDependent(value=ModList.BCTRANSPORT)
    public IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType type, ForgeDirection with) {
        return IPipeConnection.ConnectOverride.DISCONNECT;
    }

    @Override
    public float getOperationFraction() {
        return 1.0f - (float)this.craftingTick / 608.0f;
    }

    @Override
    public OperationInterval.OperationState getState() {
        return this.canCraft() ? (this.hasStructure ? OperationInterval.OperationState.RUNNING : OperationInterval.OperationState.PENDING) : OperationInterval.OperationState.INVALID;
    }

    static {
        required.addTag(CrystalElement.PURPLE, 500);
        required.addTag(CrystalElement.BLACK, 2500);
    }
}

