/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.Processing;

import Reika.ChromatiCraft.API.Interfaces.ProgrammableSpawner;
import Reika.ChromatiCraft.Auxiliary.Interfaces.OperationInterval;
import Reika.ChromatiCraft.Base.TileEntity.InventoriedRelayPowered;
import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.Extras.ItemSpawner;
import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.ReikaSpawnerHelper;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.monster.EntityGiantZombie;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntitySpawnerReprogrammer
extends InventoriedRelayPowered
implements OperationInterval {
    private String selectedMob;
    private static final ArrayList<String> disallowedMobs = new ArrayList();
    private StepTimer progress = new StepTimer(180);
    public int progressTimer;
    private int minDelay = 200;
    private int maxDelay = 800;
    private int maxNear = 6;
    private int spawnCount = 4;
    private int spawnRange = 4;
    private int activeRange = 16;
    private static final ElementTagCompound required = new ElementTagCompound();
    public static final int MIN_MINDELAY = 100;

    @Override
    protected ElementTagCompound getRequiredEnergy() {
        return required.copy();
    }

    private static void addDisallowedMob(String name) {
        disallowedMobs.add(name);
    }

    private static void addDisallowedMob(Class<? extends EntityLiving> name) {
        TileEntitySpawnerReprogrammer.addDisallowedMob((String)EntityList.field_75626_c.get(name));
    }

    public static boolean isMobAllowed(String mob) {
        return !ReikaEntityHelper.isTameHostile((String)mob) && ReikaEntityHelper.isLivingMob((String)mob, (boolean)false) && !disallowedMobs.contains(mob);
    }

    public static boolean isMobAllowed(Class<? extends EntityLiving> mob) {
        return TileEntitySpawnerReprogrammer.isMobAllowed((String)EntityList.field_75626_c.get(mob));
    }

    public String getSelectedMob() {
        return this.selectedMob;
    }

    public int[] getData() {
        return new int[]{this.minDelay, this.maxDelay, this.maxNear, this.spawnCount, this.spawnRange, this.activeRange};
    }

    @Override
    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateEntity(world, x, y, z, meta);
        if (this.canConvert()) {
            this.progress.update();
            if (this.progress.checkCap()) {
                this.programSpawner();
            }
        } else {
            this.progress.reset();
        }
        this.progressTimer = this.progress.getTick();
    }

    public int getProgressScaled(int a) {
        return this.progressTimer * a / this.progress.getCap();
    }

    private boolean canConvert() {
        return this.energy.containsAtLeast(required) && this.isValidSpawner(this.inv[0]) && this.inv[1] == null;
    }

    private void programSpawner() {
        ItemStack is = ReikaItemHelper.getSizedItemStack((ItemStack)this.inv[0], (int)1);
        ReikaInventoryHelper.decrStack((int)0, (ItemStack[])this.inv);
        if (ReikaItemHelper.matchStackWithBlock((ItemStack)is, (Block)Blocks.field_150474_ac)) {
            if (ReikaEntityHelper.hasID((String)this.selectedMob)) {
                int id = ReikaEntityHelper.mobNameToID((String)this.selectedMob);
                is.func_77964_b(id);
            }
        } else if (is.func_77973_b() instanceof ItemSpawner) {
            ReikaSpawnerHelper.setSpawnerItemNBT((ItemStack)is, (int)this.minDelay, (int)this.maxDelay, (int)this.maxNear, (int)this.spawnCount, (int)this.spawnRange, (int)this.activeRange, (boolean)true);
            ReikaSpawnerHelper.setSpawnerItemNBT((ItemStack)is, (String)this.selectedMob, (boolean)true);
        } else if (is.func_77973_b() instanceof ProgrammableSpawner) {
            ((ProgrammableSpawner)is.func_77973_b()).setSpawnerType(is, this.getMobClass(this.selectedMob));
            ((ProgrammableSpawner)is.func_77973_b()).setSpawnerData(is, this.minDelay, this.maxDelay, this.maxNear, this.spawnCount, this.spawnRange, this.activeRange);
        }
        this.inv[1] = is;
        this.drainEnergy(required);
    }

    private Class<? extends EntityLiving> getMobClass(String name) {
        return (Class)EntityList.field_75625_b.get(name);
    }

    public void setMobType(String type) {
        this.selectedMob = type;
    }

    public void setData(int min, int max, int near, int count, int range, int active) {
        this.minDelay = min;
        this.maxDelay = max;
        this.maxNear = near;
        this.spawnCount = count;
        this.spawnRange = range;
        this.activeRange = active;
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return i == 1;
    }

    public int func_70302_i_() {
        return 2;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return i == 0 && this.isValidSpawner(itemstack);
    }

    private boolean isValidSpawner(ItemStack is) {
        if (is == null) {
            return false;
        }
        return ReikaItemHelper.matchStackWithBlock((ItemStack)is, (Block)Blocks.field_150474_ac) || is.func_77973_b() instanceof ItemSpawner || is.func_77973_b() instanceof ProgrammableSpawner;
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.REPROGRAMMER;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.selectedMob = NBT.func_74779_i("mob");
        this.minDelay = NBT.func_74762_e("min");
        this.maxDelay = NBT.func_74762_e("max");
        this.maxNear = NBT.func_74762_e("near");
        this.spawnCount = NBT.func_74762_e("count");
        this.spawnRange = NBT.func_74762_e("range");
        this.activeRange = NBT.func_74762_e("active");
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        if (this.selectedMob != null && !this.selectedMob.isEmpty()) {
            NBT.func_74778_a("mob", this.selectedMob);
        }
        NBT.func_74768_a("min", this.minDelay);
        NBT.func_74768_a("max", this.maxDelay);
        NBT.func_74768_a("near", this.maxNear);
        NBT.func_74768_a("count", this.spawnCount);
        NBT.func_74768_a("range", this.spawnRange);
        NBT.func_74768_a("active", this.activeRange);
    }

    public boolean hasSpawner() {
        return this.isValidSpawner(this.inv[0]);
    }

    @Override
    public boolean isAcceptingColor(CrystalElement e) {
        return required.contains(e);
    }

    @Override
    public int getMaxStorage(CrystalElement e) {
        return 10000;
    }

    @Override
    protected boolean canReceiveFrom(CrystalElement e, ForgeDirection dir) {
        return dir != ForgeDirection.DOWN;
    }

    @Override
    public float getOperationFraction() {
        return !this.canConvert() ? 0.0f : this.progress.getFraction();
    }

    @Override
    public OperationInterval.OperationState getState() {
        return this.isValidSpawner(this.inv[0]) ? (this.energy.containsAtLeast(required) ? OperationInterval.OperationState.RUNNING : OperationInterval.OperationState.PENDING) : OperationInterval.OperationState.INVALID;
    }

    static {
        required.addTag(CrystalElement.PINK, 2000);
        required.addTag(CrystalElement.GRAY, 500);
        TileEntitySpawnerReprogrammer.addDisallowedMob(EntityWither.class);
        TileEntitySpawnerReprogrammer.addDisallowedMob(EntityDragon.class);
        TileEntitySpawnerReprogrammer.addDisallowedMob(EntityGiantZombie.class);
        TileEntitySpawnerReprogrammer.addDisallowedMob(EntityLiving.class);
        TileEntitySpawnerReprogrammer.addDisallowedMob(EntityMob.class);
        TileEntitySpawnerReprogrammer.addDisallowedMob("Void Monster");
        TileEntitySpawnerReprogrammer.addDisallowedMob("TaintedCow");
        TileEntitySpawnerReprogrammer.addDisallowedMob("TaintedSheep");
        TileEntitySpawnerReprogrammer.addDisallowedMob("TaintedCreeper");
        TileEntitySpawnerReprogrammer.addDisallowedMob("TaintSpider");
        TileEntitySpawnerReprogrammer.addDisallowedMob("TaintedChicken");
        TileEntitySpawnerReprogrammer.addDisallowedMob("TaintedPig");
        TileEntitySpawnerReprogrammer.addDisallowedMob("TaintedVillager");
        TileEntitySpawnerReprogrammer.addDisallowedMob("TaintVillager");
        TileEntitySpawnerReprogrammer.addDisallowedMob("Thaumcraft.TaintacleTiny");
        TileEntitySpawnerReprogrammer.addDisallowedMob("Thaumcraft.Golem");
        TileEntitySpawnerReprogrammer.addDisallowedMob("Thaumcraft.TravelingTrunk");
        TileEntitySpawnerReprogrammer.addDisallowedMob("Thaumcraft.TaintedVillager");
        TileEntitySpawnerReprogrammer.addDisallowedMob("Thaumcraft.TaintSpider");
        TileEntitySpawnerReprogrammer.addDisallowedMob("Thaumcraft.TaintedChicken");
        TileEntitySpawnerReprogrammer.addDisallowedMob("Thaumcraft.TaintedSheep");
        TileEntitySpawnerReprogrammer.addDisallowedMob("Thaumcraft.TaintedCow");
        TileEntitySpawnerReprogrammer.addDisallowedMob("Thaumcraft.TaintedPig");
        TileEntitySpawnerReprogrammer.addDisallowedMob("Thaumcraft.TaintedCreeper");
        TileEntitySpawnerReprogrammer.addDisallowedMob("Thaumcraft.CultistPortal");
        TileEntitySpawnerReprogrammer.addDisallowedMob("TwilightForest.Hydra");
        TileEntitySpawnerReprogrammer.addDisallowedMob("TwilightForest.Naga");
        TileEntitySpawnerReprogrammer.addDisallowedMob("TwilightForest.HydraHead");
        TileEntitySpawnerReprogrammer.addDisallowedMob("TwilightForest.Lich Minion");
        TileEntitySpawnerReprogrammer.addDisallowedMob("TwilightForest.Knight Phantom");
        TileEntitySpawnerReprogrammer.addDisallowedMob("TwilightForest.Twilight Lich");
        TileEntitySpawnerReprogrammer.addDisallowedMob("TwilightForest.Tower Boss");
        TileEntitySpawnerReprogrammer.addDisallowedMob("TwilightForest.Loyal Zombie");
        TileEntitySpawnerReprogrammer.addDisallowedMob("TwilightForest.Minoshroom");
        TileEntitySpawnerReprogrammer.addDisallowedMob("TwilightForest.Boggard");
        TileEntitySpawnerReprogrammer.addDisallowedMob("OpenBlocks.Luggage");
        TileEntitySpawnerReprogrammer.addDisallowedMob("Linkbook");
        TileEntitySpawnerReprogrammer.addDisallowedMob("Robit");
        TileEntitySpawnerReprogrammer.addDisallowedMob("etfuturum.ender_dragon");
        TileEntitySpawnerReprogrammer.addDisallowedMob("DraconicEvolution.EnderDragon");
    }
}

