/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.Processing;

import Reika.ChromatiCraft.Auxiliary.Interfaces.ItemOnRightClick;
import Reika.ChromatiCraft.Auxiliary.RecipeManagers.FabricationRecipes;
import Reika.ChromatiCraft.Base.TileEntity.InventoriedChromaticBase;
import Reika.ChromatiCraft.Magic.ElementMixer;
import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.Magic.Interfaces.LumenTile;
import Reika.ChromatiCraft.Magic.ItemElementCalculator;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityBlurFX;
import Reika.ChromatiCraft.Render.Particle.EntityFloatingSeedsFX;
import Reika.DragonAPI.Interfaces.TileEntity.BreakAction;
import Reika.DragonAPI.Interfaces.TileEntity.InertIInv;
import Reika.DragonAPI.Libraries.IO.ReikaColorAPI;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.Java.ReikaArrayHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaPhysicsHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class TileEntityGlowFire
extends InventoriedChromaticBase
implements LumenTile,
InertIInv,
ItemOnRightClick,
BreakAction {
    public static final int MAX_BRANCHES = 6;
    private static final float BASE_ITEM_FACTOR = 10.0f;
    public static final String DROP_TAG = "GlowFire";
    private final ElementTagCompound energy = new ElementTagCompound();
    private double primaryAngleTheta = rand.nextDouble() * 360.0;
    private double primaryAngleThetaVel = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)90.0);
    private double primaryAnglePhi = ReikaRandomHelper.getRandomPlusMinus((int)0, (int)3);
    private double primaryAnglePhiVel = ReikaRandomHelper.getRandomPlusMinus((int)0, (int)3);
    private double[] secondaryAngleTheta = new double[6];
    private double[] secondaryAnglePhi = new double[6];
    private double[] secondaryAngleThetaVel = new double[6];
    private double[] secondaryAnglePhiVel = new double[6];
    private int[] secondaryLife = new int[6];

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.GLOWFIRE;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        if (world.field_72995_K) {
            this.doParticles(world, x, y, z);
        } else {
            this.consumeItems(world, x, y, z);
        }
    }

    public boolean craft() {
        if (this.inv[0] == null) {
            return false;
        }
        if (this.energy.isEmpty()) {
            return false;
        }
        ItemStack in = this.inv[0];
        this.inv[0] = null;
        boolean flag = true;
        boolean flag2 = false;
        while (flag) {
            this.dropItem(in);
            flag = this.craftAndDrop(in);
            flag2 |= flag;
        }
        return flag2;
    }

    private boolean craftAndDrop(ItemStack in) {
        ElementTagCompound cost = TileEntityGlowFire.getCost(in);
        ElementTagCompound remove = new ElementTagCompound();
        boolean[] flags = ReikaArrayHelper.getTrueArray((int)16);
        for (CrystalElement e : cost.elementSet()) {
            int req = cost.getValue(e);
            if (this.energy.getValue(e) >= req) {
                remove.addTag(e, req);
                continue;
            }
            flags[e.ordinal()] = false;
        }
        for (int i = 0; i < 16; ++i) {
            CrystalElement e;
            if (flags[i]) continue;
            e = CrystalElement.elements[i];
            if (e.isPrimary()) {
                return false;
            }
            ElementTagCompound combine = TileEntityGlowFire.getCompositionCost(e, cost.getValue(e));
            for (CrystalElement e2 : combine.elementSet()) {
                int add = combine.getValue(e2);
                remove.addValueToColor(e2, add);
            }
        }
        for (CrystalElement e : remove.elementSet()) {
            int val = remove.getValue(e);
            if (this.energy.getValue(e) >= val) continue;
            return false;
        }
        this.energy.subtract(remove);
        return true;
    }

    public static ElementTagCompound getCompositionCost(CrystalElement e, int amt) {
        ElementTagCompound tag = new ElementTagCompound();
        Collection<CrystalElement> parents = ElementMixer.instance.getMixParents(e);
        if (parents == null) {
            return null;
        }
        for (CrystalElement in : parents) {
            tag.addTag(in, 2);
        }
        while (!tag.isPrimaryOnly()) {
            for (CrystalElement in : tag.elementSet()) {
                if (in.isPrimary()) continue;
                int get = tag.removeTag(in);
                Collection<CrystalElement> parents2 = ElementMixer.instance.getMixParents(in);
                for (CrystalElement in2 : parents2) {
                    tag.addTag(in2, get + 1);
                }
            }
        }
        for (CrystalElement in : tag.elementSet()) {
            tag.setTag(in, MathHelper.func_76143_f((double)Math.pow(amt, -0.75 + (double)tag.getValue(in))));
        }
        return tag;
    }

    private void consumeItems(World world, int x, int y, int z) {
        AxisAlignedBB box = ReikaAABBHelper.getBlockAABB((int)x, (int)y, (int)z).func_72331_e(0.2, 0.2, 0.2);
        List li = world.func_72872_a(EntityItem.class, box);
        for (EntityItem ei : li) {
            ItemStack is;
            ElementTagCompound tag;
            if (ei.getEntityData().func_74767_n(DROP_TAG) || (tag = this.consumeItem(is = ei.func_92059_d())) == null) continue;
            --is.field_77994_a;
            if (is.field_77994_a <= 0) {
                ei.func_70106_y();
            }
            this.energy.addTag(tag);
            ReikaPacketHelper.sendDataPacketWithRadius((String)"ChromaData", (int)ChromaPackets.FIRECONSUMEITEM.ordinal(), (TileEntity)this, (int)32, (int[])new int[]{tag.keySetAsBits()});
        }
    }

    private ElementTagCompound consumeItem(ItemStack is) {
        ElementTagCompound tag = TileEntityGlowFire.getDecompositionValue(is);
        if (tag != null) {
            for (CrystalElement e : tag.elementSet()) {
                if (this.energy.getValue(e) + tag.getValue(e) <= this.getMaxStorage(e)) continue;
                return null;
            }
        }
        return tag;
    }

    public static ElementTagCompound getCost(ItemStack is) {
        if (!FabricationRecipes.recipes().isItemFabricable(is)) {
            return null;
        }
        ElementTagCompound tag = ItemElementCalculator.instance.getValueForItem(is).copy();
        return (tag = TileEntityGlowFire.scaleCostTag(is, tag)) != null && !tag.isEmpty() ? tag : null;
    }

    public static ElementTagCompound getDecompositionValue(ItemStack is) {
        ElementTagCompound tag = ItemElementCalculator.instance.getValueForItem(is);
        if (tag == null || tag.isEmpty()) {
            return null;
        }
        tag = tag.copy();
        tag = TileEntityGlowFire.scaleDecompositionTag(is, tag);
        return tag;
    }

    private static ElementTagCompound scaleCostTag(ItemStack is, ElementTagCompound tag) {
        boolean sc = tag.getMaximumValue() == 1;
        tag.power(1.15).scale(1.5f);
        if (ChromaBlocks.CRYSTAL.match(is)) {
            tag.power(1.1);
            tag.scale(2.0f);
        }
        tag.scale(10.0f);
        if (is.func_77973_b() == Items.field_151100_aR || ChromaItems.DYE.matchWith(is)) {
            tag.scale(0.25f);
        }
        if (sc) {
            tag.scale(1.2f);
        }
        return tag;
    }

    private static ElementTagCompound scaleDecompositionTag(ItemStack is, ElementTagCompound tag) {
        if (is.func_77973_b() != Items.field_151100_aR && !ChromaItems.DYE.matchWith(is)) {
            tag.scale(10.0f);
        }
        return tag;
    }

    @SideOnly(value=Side.CLIENT)
    public static void consumeItemFX(World world, int x, int y, int z, int colors) {
        for (int i = 0; i < 16; ++i) {
            CrystalElement e = CrystalElement.elements[i];
            if ((colors & 1 << e.ordinal()) == 0) continue;
            int n = 1 + rand.nextInt(5);
            for (int k = 0; k < n; ++k) {
                double rx = (double)x + rand.nextDouble();
                double ry = (double)y + rand.nextDouble();
                double rz = (double)z + rand.nextDouble();
                float s = 1.0f + rand.nextFloat();
                int l = 12 + rand.nextInt(18);
                EntityBlurFX fx = new EntityBlurFX(world, rx, ry, rz).setColor(e.getColor()).setLife(l).setScale(s).setRapidExpand();
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            }
        }
    }

    public void empty() {
        if (!this.field_145850_b.field_72995_K) {
            ChromaSounds.RIFT.playSoundAtBlock((TileEntity)this);
            ReikaPacketHelper.sendDataPacketWithRadius((String)"ChromaData", (int)ChromaPackets.FIREDUMP.ordinal(), (TileEntity)this, (int)64, (int[])new int[]{this.energy.keySetAsBits()});
            this.energy.clear();
            if (this.inv[0] != null) {
                this.dropItem(this.inv[0]);
            }
            this.inv[0] = null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void emptyClientFX(World world, int x, int y, int z, int colors) {
        ArrayList<Integer> li = new ArrayList<Integer>();
        for (int i = 0; i < 16; ++i) {
            CrystalElement e = CrystalElement.elements[i];
            if ((colors & 1 << e.ordinal()) == 0) continue;
            li.add(e.getColor());
        }
        if (li.isEmpty()) {
            li.add(2134271);
        }
        int n = 20 + rand.nextInt(90);
        for (int i = 0; i < n; ++i) {
            EntityBlurFX fx = new EntityFloatingSeedsFX(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, rand.nextDouble() * 360.0, ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)10.0)).setColor((Integer)li.get(rand.nextInt(li.size()))).setColliding();
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void doParticles(World world, int x, int y, int z) {
        this.addParticle(world, x, y, z, this.primaryAnglePhi, this.primaryAngleTheta, true, 0.0);
        this.primaryAngleTheta += this.primaryAngleThetaVel;
        this.primaryAnglePhi += this.primaryAnglePhiVel;
        if (rand.nextInt(200) == 0) {
            this.primaryAngleThetaVel = ReikaRandomHelper.getRandomPlusMinus((int)0, (int)3);
            this.primaryAnglePhiVel = ReikaRandomHelper.getRandomPlusMinus((int)0, (int)3);
        }
        for (int i = 0; i < 6; ++i) {
            if (this.secondaryLife[i] > 0) {
                int n = i;
                this.secondaryLife[n] = this.secondaryLife[n] - 1;
                this.addParticle(world, x, y, z, this.secondaryAnglePhi[i], this.secondaryAngleTheta[i], false, this.secondaryLife[i]);
                int n2 = i;
                this.secondaryAngleTheta[n2] = this.secondaryAngleTheta[n2] + this.secondaryAngleThetaVel[i];
                int n3 = i;
                this.secondaryAnglePhi[n3] = this.secondaryAnglePhi[n3] + this.secondaryAnglePhiVel[i];
                if (rand.nextInt(20) != 0) continue;
                this.retargetSecondary(i);
                continue;
            }
            if (rand.nextInt(40) != 0) continue;
            this.secondaryLife[i] = 30 + rand.nextInt(270);
            this.retargetSecondary(i);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void addParticle(World world, int x, int y, int z, double phi, double theta, boolean primary, double timer) {
        int l = primary ? 10 + rand.nextInt(30) : 10 + rand.nextInt(10);
        float s = primary ? 2.2f : 1.25f;
        double[] v = ReikaPhysicsHelper.polarToCartesian((double)(0.125 / (double)l * 6.0), (double)theta, (double)phi);
        int c = ReikaColorAPI.getModifiedHue((int)1077503, (int)((int)(215.0 + 70.0 * Math.sin(timer / 40.0))));
        EntityBlurFX fx = new EntityBlurFX(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, v[0], v[1], v[2]).setColor(c).setScale(s).setLife(l);
        if (rand.nextBoolean()) {
            fx.setColliding();
        }
        if (primary) {
            fx.setRapidExpand();
        }
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
    }

    private void retargetSecondary(int i) {
        this.secondaryAngleThetaVel[i] = ReikaRandomHelper.getRandomPlusMinus((int)0, (int)2);
        this.secondaryAnglePhiVel[i] = ReikaRandomHelper.getRandomPlusMinus((int)0, (int)2);
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public int getEnergy(CrystalElement e) {
        return this.energy.getValue(e);
    }

    @Override
    public ElementTagCompound getEnergy() {
        return this.energy.copy();
    }

    @Override
    public int getMaxStorage(CrystalElement e) {
        return 10000;
    }

    public boolean func_102008_b(int i, ItemStack is, int side) {
        return false;
    }

    public int func_70302_i_() {
        return 1;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_94041_b(int slot, ItemStack is) {
        return false;
    }

    @Override
    public ItemStack onRightClickWith(ItemStack item, EntityPlayer ep) {
        if (this.inv[0] != null) {
            this.dropItem(this.inv[0]);
            this.inv[0] = null;
        }
        if (item != null) {
            if (TileEntityGlowFire.getCost(item) != null) {
                this.inv[0] = ReikaItemHelper.getSizedItemStack((ItemStack)item, (int)1);
                --item.field_77994_a;
                return item.field_77994_a > 0 ? item : null;
            }
        }
        return item;
    }

    private void dropItem(ItemStack is) {
        EntityItem ei = ReikaItemHelper.dropItem((World)this.field_145850_b, (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5), (ItemStack)is);
        ei.getEntityData().func_74757_a(DROP_TAG, true);
        this.field_145850_b.func_72980_b((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "random.pop", 1.0f, 0.8f, true);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.energy.readFromNBT("energy", NBT);
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        this.energy.writeToNBT("energy", NBT);
    }

    public void breakBlock() {
        this.empty();
    }
}

