/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.Processing;

import Reika.ChromatiCraft.Auxiliary.Interfaces.OperationInterval;
import Reika.ChromatiCraft.Base.TileEntity.InventoriedRelayPowered;
import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.ASM.APIStripper;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Instantiable.HybridTank;
import Reika.DragonAPI.Interfaces.Registry.OreType;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaOreHelper;
import Reika.DragonAPI.Libraries.ReikaFluidHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.World.ReikaBlockHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.ThaumItemHelper;
import Reika.DragonAPI.ModList;
import Reika.DragonAPI.ModRegistry.ModOreList;
import Reika.DragonAPI.ModRegistry.ModWoodList;
import Reika.GeoStrata.Registry.RockTypes;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Auxiliary.RecipeManagers.ExtractorModOres;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.oredict.OreDictionary;

@APIStripper.Strippable(value={"buildcraft.api.transport.IPipeConnection"})
public class TileEntityCrystalFurnace
extends InventoriedRelayPowered
implements IFluidHandler,
IPipeConnection,
OperationInterval {
    private static final ElementTagCompound smelt = new ElementTagCompound();
    public static final int MULTIPLY = 2;
    public int smeltTimer;
    private float xp;
    private final HybridTank tank = new HybridTank("crystalfurn", 4000);

    @Override
    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateEntity(world, x, y, z, meta);
        if (this.canSmelt()) {
            this.smeltTimer += this.getSmeltSpeed();
            if (this.smeltTimer >= this.getSmeltTime()) {
                this.smelt();
                this.smeltTimer = 0;
            }
        } else {
            this.smeltTimer = 0;
        }
    }

    public int getSmeltSpeed() {
        return 1 + this.energy.getTotalEnergy() / 12000;
    }

    public int getSmeltTime() {
        return Math.max(5, 200 - this.getEnergy(CrystalElement.LIGHTBLUE) / 100);
    }

    public boolean func_102008_b(int slot, ItemStack is, int side) {
        return slot == 1;
    }

    public int func_70302_i_() {
        return 2;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_94041_b(int slot, ItemStack is) {
        return slot == 0 && FurnaceRecipes.func_77602_a().func_151395_a(is) != null;
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.FURNACE;
    }

    private boolean canSmelt() {
        if (this.inv[0] == null) {
            return false;
        }
        if (!this.energy.containsAtLeast(smelt)) {
            return false;
        }
        ItemStack out = FurnaceRecipes.func_77602_a().func_151395_a(this.inv[0]);
        if (out == null) {
            return false;
        }
        out = out.func_77946_l();
        out.field_77994_a *= TileEntityCrystalFurnace.getMultiplyRate(this.inv[0], out);
        if (this.inv[1] == null) {
            return true;
        }
        return ReikaItemHelper.areStacksCombinable((ItemStack)out, (ItemStack)this.inv[1], (int)this.func_70297_j_());
    }

    private void smelt() {
        ItemStack is = FurnaceRecipes.func_77602_a().func_151395_a(this.inv[0]).func_77946_l();
        ElementTagCompound tag = TileEntityCrystalFurnace.getSmeltingCost(this.inv[0], is);
        is.field_77994_a *= TileEntityCrystalFurnace.getMultiplyRate(this.inv[0], is);
        ReikaInventoryHelper.addOrSetStack((ItemStack)is, (ItemStack[])this.inv, (int)1);
        this.xp += FurnaceRecipes.func_77602_a().func_151398_b(this.inv[1]) * 6.0f;
        if (this.xp >= 1.0f) {
            int amt = (int)(this.xp / 1.0f);
            this.tank.addLiquid(amt, FluidRegistry.getFluid((String)"chroma"));
            this.xp = 0.0f;
        }
        ReikaInventoryHelper.decrStack((int)0, (ItemStack[])this.inv);
        this.drainEnergy(tag);
        this.energy.subtract(CrystalElement.LIGHTBLUE, 250);
    }

    public static ElementTagCompound getSmeltingCost(ItemStack in, ItemStack out) {
        ElementTagCompound tag = smelt.copy();
        if (ReikaBlockHelper.isOre((ItemStack)in)) {
            tag.scale(1.5f);
        } else if (ModList.ROTARYCRAFT.isLoaded() && ExtractorModOres.isOreFlake((ItemStack)in)) {
            tag.scale(2.0f);
            OreType ore = ExtractorModOres.getOreFromExtract((ItemStack)in);
            if (ore.getRarity() == OreType.OreRarity.RARE) {
                tag.scale(1.5f);
            }
        } else if (in.func_77973_b() instanceof ItemFood) {
            tag.scale(0.5f);
        } else if (ReikaItemHelper.matchStackWithBlock((ItemStack)in, (Block)Blocks.field_150364_r) || ReikaItemHelper.matchStackWithBlock((ItemStack)in, (Block)Blocks.field_150363_s)) {
            tag.scale(0.75f);
        } else if (ModWoodList.isModWood((ItemStack)in)) {
            tag.scale(0.75f);
        }
        return tag.scale((float)Math.pow((float)TileEntityCrystalFurnace.getMultiplyRate(in, out) / 2.0f, 2.0));
    }

    public static int getMultiplyRate(ItemStack in, ItemStack out) {
        if (ChromaBlocks.PYLONSTRUCT.match(out)) {
            return 1;
        }
        if (in.func_82833_r() != null && in.func_82833_r().toLowerCase(Locale.ENGLISH).contains("cobblestone")) {
            return 1;
        }
        if (ModList.GEOSTRATA.isLoaded() && RockTypes.getTypeFromID((Block)Block.func_149634_a((Item)in.func_77973_b())) != null) {
            return 1;
        }
        if (ModList.ROTARYCRAFT.isLoaded() && ReikaItemHelper.matchStacks((ItemStack)in, (ItemStack)ItemStacks.ironscrap)) {
            return 1;
        }
        if (ModList.THAUMCRAFT.isLoaded() && in.func_77973_b() == ThaumItemHelper.ItemEntry.NUGGETCLUSTER.getItem().func_77973_b()) {
            return 4;
        }
        if (ReikaBlockHelper.isOre((ItemStack)in)) {
            int ret = 4;
            ReikaOreHelper ore = ReikaOreHelper.getEntryByOreDict((ItemStack)in);
            if (ore == null) {
                ore = ModOreList.getModOreFromOre((ItemStack)in);
            }
            if (ore != null && ore.getRarity() == OreType.OreRarity.RARE) {
                ret = 8;
            }
            return ret;
        }
        int[] ids = OreDictionary.getOreIDs((ItemStack)in);
        for (int i = 0; i < ids.length; ++i) {
            String name = OreDictionary.getOreName((int)ids[i]);
            if (name.startsWith("dust")) {
                return 1;
            }
            if (!name.equalsIgnoreCase("cobblestone")) continue;
            return 1;
        }
        return 2;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.smeltTimer = NBT.func_74762_e("time");
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("time", this.smeltTimer);
        this.tank.writeToNBT(NBT);
    }

    @Override
    public void func_145839_a(NBTTagCompound NBT) {
        super.func_145839_a(NBT);
        this.tank.readFromNBT(NBT);
    }

    @Override
    public void func_145841_b(NBTTagCompound NBT) {
        super.func_145841_b(NBT);
    }

    @Override
    protected ElementTagCompound getRequiredEnergy() {
        ElementTagCompound tag = smelt.copy();
        tag.addTag(CrystalElement.LIGHTBLUE, 500);
        return tag;
    }

    @Override
    public int getMaxStorage(CrystalElement e) {
        return e == CrystalElement.LIGHTBLUE ? 20000 : 120000;
    }

    public static ElementTagCompound smeltTags() {
        return smelt.copy();
    }

    public int getCookProgressScaled(int a) {
        return this.smeltTimer * a / this.getSmeltTime();
    }

    @Override
    public boolean isAcceptingColor(CrystalElement e) {
        return smelt.contains(e) || e == CrystalElement.LIGHTBLUE;
    }

    @Override
    protected boolean canReceiveFrom(CrystalElement e, ForgeDirection dir) {
        return true;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.canDrain(from, resource.getFluid()) ? this.tank.drain(resource.amount, doDrain) : null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.canDrain(from, null) ? this.tank.drain(maxDrain, doDrain) : null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return ReikaFluidHelper.isFluidDrainableFromTank((Fluid)fluid, (HybridTank)this.tank);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    @DependentMethodStripper.ModDependent(value=ModList.BCTRANSPORT)
    public IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType type, ForgeDirection with) {
        return IPipeConnection.ConnectOverride.DEFAULT;
    }

    @Override
    public int getIconState(int side) {
        return side > 1 && this.canSmelt() ? 1 : 0;
    }

    @Override
    public float getOperationFraction() {
        return !this.canSmelt() ? 0.0f : (float)this.smeltTimer / (float)Math.max(1, this.getSmeltTime());
    }

    @Override
    public OperationInterval.OperationState getState() {
        return this.inv[0] != null && FurnaceRecipes.func_77602_a().func_151395_a(this.inv[0]) != null ? (this.energy.containsAtLeast(smelt) ? OperationInterval.OperationState.RUNNING : OperationInterval.OperationState.PENDING) : OperationInterval.OperationState.INVALID;
    }

    static {
        smelt.addTag(CrystalElement.ORANGE, 200);
        smelt.addTag(CrystalElement.YELLOW, 40);
        smelt.addTag(CrystalElement.PURPLE, 100);
    }
}

