/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.Processing;

import Reika.ChromatiCraft.API.Interfaces.EnchantableItem;
import Reika.ChromatiCraft.Auxiliary.Interfaces.ChromaPowered;
import Reika.ChromatiCraft.Auxiliary.Interfaces.OperationInterval;
import Reika.ChromatiCraft.Base.ChromaticEnchantment;
import Reika.ChromatiCraft.Base.TileEntity.FluidReceiverInventoryBase;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaEnchants;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Libraries.ReikaEnchantmentHelper;
import Reika.DragonAPI.Libraries.ReikaRegistryHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.TinkerToolHandler;
import Reika.DragonAPI.ModList;
import cpw.mods.fml.common.Loader;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class TileEntityAutoEnchanter
extends FluidReceiverInventoryBase
implements ChromaPowered,
OperationInterval {
    private HashMap<Enchantment, Integer> selected = new HashMap();
    public static final int CHROMA_PER_LEVEL_BASE = 500;
    private static final HashMap<Enchantment, EnchantmentTier> tiers;
    private static final HashMap<Enchantment, Integer> boostedLevels;
    private static final HashSet<Enchantment> blacklist;
    private StepTimer progress = new StepTimer(40);
    public int progressTimer;

    public static Map<Enchantment, Integer> getBoostedLevels() {
        return Collections.unmodifiableMap(boostedLevels);
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.ENCHANTER;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        if (this.canProgress()) {
            this.progress.update();
            if (this.progress.checkCap() && !world.field_72995_K) {
                this.applyEnchants();
            }
        } else {
            this.progress.reset();
        }
        this.progressTimer = this.progress.getTick();
    }

    public int getProgressScaled(int a) {
        return a * this.progressTimer / this.progress.getCap();
    }

    private boolean canProgress() {
        return this.isValid(this.inv[0]) && this.hasSufficientChroma() && this.enchanting();
    }

    private boolean hasSufficientChroma() {
        return this.getChroma() >= this.getConsumedChroma();
    }

    private boolean enchanting() {
        if (this.selected.isEmpty()) {
            return false;
        }
        for (Enchantment e : this.selected.keySet()) {
            int level = this.selected.get(e);
            if (level <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getChroma() {
        return this.tank.getLevel();
    }

    @Override
    public boolean addChroma(int amt) {
        if (this.tank.canTakeIn(amt)) {
            this.tank.addLiquid(amt, FluidRegistry.getFluid((String)"chroma"));
            return true;
        }
        return false;
    }

    private boolean isValid(ItemStack is) {
        return is != null && this.isItemEnchantable(is) && this.areEnchantsValid(is);
    }

    private boolean isItemEnchantable(ItemStack is) {
        if (is.func_77973_b() == Items.field_151122_aG) {
            return true;
        }
        if (is.func_77973_b() instanceof EnchantableItem) {
            return true;
        }
        if (is.func_77973_b() instanceof ItemShears) {
            return true;
        }
        if (ChromaItems.BEEFRAME.matchWith(is)) {
            return true;
        }
        if (ModList.TINKERER.isLoaded() && (TinkerToolHandler.getInstance().isTool(is) || TinkerToolHandler.getInstance().isWeapon(is))) {
            return true;
        }
        if (Loader.isModLoaded((String)"Backpack") && is.func_77973_b().getClass().getName().toLowerCase(Locale.ENGLISH).contains("backpack")) {
            return true;
        }
        if (Loader.isModLoaded((String)"EnderStorage") && is.func_77973_b().getClass().getName().toLowerCase(Locale.ENGLISH).contains("enderpouch")) {
            return true;
        }
        if (ModList.THAUMICTINKER.isLoaded() && is.func_77973_b().getClass().getName().toLowerCase(Locale.ENGLISH).contains("ichorpouch")) {
            return true;
        }
        if (ModList.THAUMCRAFT.isLoaded() && is.func_77973_b().getClass().getName().toLowerCase(Locale.ENGLISH).contains("focuspouch")) {
            return true;
        }
        return is.func_77973_b().getItemEnchantability(is) > 0;
    }

    private boolean areEnchantsValid(ItemStack is) {
        Item i = is.func_77973_b();
        for (Enchantment e : this.selected.keySet()) {
            if (i == Items.field_151122_aG) {
                if (!e.isAllowedOnBooks()) {
                    return false;
                }
            } else if (ModList.TINKERER.isLoaded() && TinkerToolHandler.getInstance().isTool(is)) {
                if (!(e instanceof ChromaticEnchantment)) {
                    return false;
                }
                if (((ChromaticEnchantment)e).field_77351_y != EnumEnchantmentType.all && ((ChromaticEnchantment)e).field_77351_y != EnumEnchantmentType.digger) {
                    return false;
                }
            } else if (ModList.TINKERER.isLoaded() && TinkerToolHandler.getInstance().isWeapon(is)) {
                if (!(e instanceof ChromaticEnchantment)) {
                    return false;
                }
                if (((ChromaticEnchantment)e).field_77351_y != EnumEnchantmentType.all && ((ChromaticEnchantment)e).field_77351_y != EnumEnchantmentType.weapon) {
                    return false;
                }
            } else if (!(e.func_92089_a(is) || i instanceof EnchantableItem && ((EnchantableItem)i).isEnchantValid(e, is))) {
                return false;
            }
            if (ChromaItems.BEEFRAME.matchWith(is) && e != Enchantment.field_77347_r) {
                return false;
            }
            if (Loader.isModLoaded((String)"Backpack") && is.func_77973_b().getClass().getName().toLowerCase(Locale.ENGLISH).contains("backpack") && !e.func_77320_a().toLowerCase(Locale.ENGLISH).contains("soulbound")) {
                return false;
            }
            if (Loader.isModLoaded((String)"EnderStorage") && is.func_77973_b().getClass().getName().toLowerCase(Locale.ENGLISH).contains("enderpouch") && !e.func_77320_a().toLowerCase(Locale.ENGLISH).contains("soulbound")) {
                return false;
            }
            if (ModList.THAUMCRAFT.isLoaded() && is.func_77973_b().getClass().getName().toLowerCase(Locale.ENGLISH).contains("focuspouch") && !e.func_77320_a().toLowerCase(Locale.ENGLISH).contains("soulbound")) {
                return false;
            }
            if (ModList.THAUMICTINKER.isLoaded() && is.func_77973_b().getClass().getName().toLowerCase(Locale.ENGLISH).contains("ichorpouch") && !e.func_77320_a().toLowerCase(Locale.ENGLISH).contains("soulbound")) {
                return false;
            }
            if (ReikaEnchantmentHelper.getEnchantmentLevel((Enchantment)e, (ItemStack)is) < this.selected.get(e)) continue;
            return false;
        }
        return true;
    }

    private void applyEnchants() {
        if (this.inv[0].func_77973_b() == Items.field_151122_aG) {
            this.inv[0] = new ItemStack((Item)Items.field_151134_bR);
        }
        ReikaEnchantmentHelper.removeEnchantments((ItemStack)this.inv[0], this.selected.keySet());
        ReikaEnchantmentHelper.applyEnchantments((ItemStack)this.inv[0], this.selected);
        this.tank.removeLiquid(this.getConsumedChroma());
        this.syncAllData(true);
    }

    private int getConsumedChroma() {
        int total = 0;
        for (Enchantment e : this.selected.keySet()) {
            int level = this.selected.get(e);
            total = (int)((float)total + (float)(level * 500) * this.getCostFactor(e));
        }
        return total;
    }

    private float getCostFactor(Enchantment e) {
        EnchantmentTier t = tiers.get(e);
        if (t == null) {
            t = EnchantmentTier.NORMAL;
        }
        return t.costFactor;
    }

    public boolean setEnchantment(Enchantment e, int level) {
        this.onEnchantChanged(e);
        level = Math.min(this.getMaxEnchantmentLevel(e), level);
        if (level <= 0) {
            this.removeEnchantment(e);
            return true;
        }
        if (this.getEnchantment(e) == 0 && !ReikaEnchantmentHelper.isCompatible(this.selected.keySet(), (Enchantment)e)) {
            return false;
        }
        this.selected.put(e, level);
        return true;
    }

    private void onEnchantChanged(Enchantment e) {
        this.progress.reset();
        this.progressTimer = 0;
    }

    public int getMaxEnchantmentLevel(Enchantment e) {
        if (e == Enchantment.field_77346_s) {
            return 5;
        }
        if (e == Enchantment.field_77335_o) {
            return 5;
        }
        if (e == Enchantment.field_77340_h) {
            return 5;
        }
        if (e == Enchantment.field_151370_z) {
            return 5;
        }
        if (e == Enchantment.field_77345_t) {
            return 10;
        }
        if (e == Enchantment.field_77338_j) {
            return 10;
        }
        if (e == Enchantment.field_77347_r) {
            return 5;
        }
        return e.func_77325_b();
    }

    public void removeEnchantment(Enchantment e) {
        this.selected.remove(e);
        this.onEnchantChanged(e);
    }

    public boolean incrementEnchantment(Enchantment e) {
        int level = this.getEnchantment(e);
        return this.setEnchantment(e, level + 1);
    }

    public void decrementEnchantment(Enchantment e) {
        int level = this.getEnchantment(e);
        int newlevel = Math.max(level - 1, 0);
        this.setEnchantment(e, newlevel);
    }

    public void clearEnchantments() {
        this.selected.clear();
    }

    public int getEnchantment(Enchantment e) {
        return this.selected.containsKey(e) ? this.selected.get(e) : 0;
    }

    public Map<Enchantment, Integer> getEnchantments() {
        return Collections.unmodifiableMap(this.selected);
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    public int func_70302_i_() {
        return 1;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return this.isValid(itemstack);
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return ReikaEnchantmentHelper.hasEnchantments((ItemStack)itemstack);
    }

    public int func_70297_j_() {
        return 1;
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        for (int i = 0; i < Enchantment.field_77331_b.length; ++i) {
            if (Enchantment.field_77331_b[i] == null) continue;
            int lvl = this.getEnchantment(Enchantment.field_77331_b[i]);
            NBT.func_74768_a(Enchantment.field_77331_b[i].func_77320_a(), lvl);
        }
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.selected = new HashMap();
        for (int i = 0; i < Enchantment.field_77331_b.length; ++i) {
            int lvl;
            if (Enchantment.field_77331_b[i] == null || (lvl = NBT.func_74762_e(Enchantment.field_77331_b[i].func_77320_a())) <= 0) continue;
            this.selected.put(Enchantment.field_77331_b[i], lvl);
        }
    }

    @Override
    public int getCapacity() {
        return 12000;
    }

    @Override
    public Fluid getInputFluid() {
        return FluidRegistry.getFluid((String)"chroma");
    }

    @Override
    public boolean canReceiveFrom(ForgeDirection from) {
        return true;
    }

    @Override
    public float getOperationFraction() {
        return !this.canProgress() ? 0.0f : this.progress.getFraction();
    }

    @Override
    public OperationInterval.OperationState getState() {
        return this.isValid(this.inv[0]) && this.enchanting() ? (this.hasSufficientChroma() ? OperationInterval.OperationState.RUNNING : OperationInterval.OperationState.PENDING) : OperationInterval.OperationState.INVALID;
    }

    public static boolean isBlacklisted(Enchantment e) {
        return blacklist.contains(e);
    }

    public static void blacklistEnchantment(Enchantment e) {
        if (ReikaEnchantmentHelper.isVanillaEnchant((Enchantment)e)) {
            ChromatiCraft.logger.logError((Object)"You cannot blacklist vanilla enchantments!");
        } else if (e instanceof ChromaticEnchantment) {
            ChromatiCraft.logger.logError((Object)"You cannot blacklist ChromatiCraft enchantments!");
        } else {
            blacklist.add(e);
            ChromatiCraft.logger.log((Object)("Received request to blacklist enchantment " + e.func_77320_a() + " from " + ReikaRegistryHelper.getActiveLoadingMod()));
        }
    }

    static {
        Enchantment soulbound;
        tiers = new HashMap();
        boostedLevels = new HashMap();
        blacklist = new HashSet();
        tiers.put(Enchantment.field_77336_l, EnchantmentTier.WORTHLESS);
        tiers.put(Enchantment.field_77339_k, EnchantmentTier.WORTHLESS);
        tiers.put(Enchantment.field_77337_m, EnchantmentTier.BASIC);
        tiers.put(Enchantment.field_77344_u, EnchantmentTier.BASIC);
        tiers.put(Enchantment.field_151369_A, EnchantmentTier.BASIC);
        tiers.put(ChromaEnchants.FASTSINK.getEnchantment(), EnchantmentTier.BASIC);
        tiers.put(Enchantment.field_77346_s, EnchantmentTier.VALUABLE);
        tiers.put(Enchantment.field_77338_j, EnchantmentTier.VALUABLE);
        tiers.put(Enchantment.field_77335_o, EnchantmentTier.VALUABLE);
        tiers.put(Enchantment.field_77345_t, EnchantmentTier.VALUABLE);
        tiers.put(Enchantment.field_77332_c, EnchantmentTier.VALUABLE);
        tiers.put(ChromaEnchants.USEREPAIR.getEnchantment(), EnchantmentTier.VALUABLE);
        tiers.put(ChromaEnchants.ENDERLOCK.getEnchantment(), EnchantmentTier.VALUABLE);
        tiers.put(ChromaEnchants.AGGROMASK.getEnchantment(), EnchantmentTier.VALUABLE);
        tiers.put(Enchantment.field_77348_q, EnchantmentTier.RARE);
        tiers.put(Enchantment.field_77342_w, EnchantmentTier.RARE);
        tiers.put(ChromaEnchants.RARELOOT.getEnchantment(), EnchantmentTier.RARE);
        tiers.put(ChromaEnchants.WEAPONAOE.getEnchantment(), EnchantmentTier.RARE);
        tiers.put(ChromaEnchants.HARVESTLEVEL.getEnchantment(), EnchantmentTier.RARE);
        tiers.put(ChromaEnchants.PHASING.getEnchantment(), EnchantmentTier.RARE);
        Enchantment multishot = ReikaEnchantmentHelper.getEnchantmentByName((String)"Multishot");
        if (multishot != null) {
            tiers.put(multishot, EnchantmentTier.RARE);
        }
        if ((soulbound = ReikaEnchantmentHelper.getEnchantmentByName((String)"Soulbound")) != null) {
            tiers.put(soulbound, EnchantmentTier.RARE);
        }
        boostedLevels.put(Enchantment.field_77346_s, 5);
        boostedLevels.put(Enchantment.field_77335_o, 5);
        boostedLevels.put(Enchantment.field_77340_h, 5);
        boostedLevels.put(Enchantment.field_151370_z, 5);
        boostedLevels.put(Enchantment.field_77345_t, 10);
        boostedLevels.put(Enchantment.field_77338_j, 10);
    }

    private static enum EnchantmentTier {
        WORTHLESS(0.25f),
        BASIC(0.75f),
        NORMAL(1.0f),
        VALUABLE(1.5f),
        RARE(2.0f);

        public final float costFactor;

        private EnchantmentTier(float f) {
            this.costFactor = f;
        }
    }
}

