/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.Plants;

import Reika.ChromatiCraft.Base.TileEntity.TileEntityMagicPlant;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Interfaces.TileEntity.LocationCached;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaPlantHelper;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityHeatLily
extends TileEntityMagicPlant
implements LocationCached {
    private StepTimer timer = new StepTimer(40);
    private static final Collection<WorldLocation> cache = new ArrayList<WorldLocation>();

    @Override
    public ForgeDirection getGrowthDirection() {
        return ForgeDirection.UP;
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.HEATLILY;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        this.timer.update();
        if (this.timer.checkCap()) {
            this.meltIce(world, x, y, z);
        }
    }

    protected void onFirstTick(World world, int x, int y, int z) {
        WorldLocation loc = new WorldLocation((TileEntity)this);
        if (!cache.contains(loc)) {
            cache.add(loc);
        }
    }

    public void breakBlock() {
        WorldLocation loc = new WorldLocation((TileEntity)this);
        cache.remove(loc);
    }

    public static boolean stopFreeze(World world, int x, int y, int z) {
        for (WorldLocation te : cache) {
            int dd = Math.abs(x - te.xCoord) + Math.abs(y - te.yCoord) + Math.abs(z - te.zCoord);
            if (dd > 7) continue;
            return true;
        }
        return false;
    }

    private void meltIce(World world, int x, int y, int z) {
        int dz;
        int dy;
        int r = 3;
        int dx = ReikaRandomHelper.getRandomPlusMinus((int)x, (int)r);
        Block b = world.func_147439_a(dx, dy = y - 1, dz = ReikaRandomHelper.getRandomPlusMinus((int)z, (int)r));
        if (b == Blocks.field_150432_aD) {
            world.func_147449_b(dx, dy, dz, (Block)Blocks.field_150358_i);
        } else if (b == Blocks.field_150431_aC) {
            world.func_147449_b(dx, dy, dz, Blocks.field_150350_a);
        }
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public boolean isPlantable(World world, int x, int y, int z) {
        return ReikaPlantHelper.LILYPAD.canPlantAt(world, x, y, z);
    }
}

