/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.Plants;

import Reika.ChromatiCraft.Base.TileEntity.TileEntityMagicPlant;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.DragonAPI.APIPacketHandler;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.WeightedRandom;
import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaPlantHelper;
import Reika.DragonAPI.Libraries.World.ReikaBlockHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityHarvesterPlant
extends TileEntityMagicPlant {
    private static double[][] randomDistrib = new double[][]{{3.0, 2.0, 1.0, 1.0, 2.0, 3.0, 2.0, 1.0, 1.0, 2.0, 3.0}, {1.0, 6.0, 4.0, 3.0, 4.0, 5.0, 4.0, 3.0, 4.0, 6.0, 2.0}, {1.0, 4.0, 7.0, 5.0, 4.0, 6.0, 4.0, 5.0, 7.0, 4.0, 1.0}, {1.0, 3.0, 5.0, 8.0, 6.0, 7.0, 6.0, 8.0, 5.0, 3.0, 1.0}, {2.0, 4.0, 4.0, 6.0, 9.0, 0.0, 9.0, 6.0, 4.0, 4.0, 2.0}, {3.0, 5.0, 6.0, 7.0, 0.0, 0.0, 0.0, 7.0, 6.0, 5.0, 3.0}, {2.0, 4.0, 4.0, 6.0, 9.0, 0.0, 9.0, 6.0, 4.0, 4.0, 2.0}, {1.0, 3.0, 5.0, 8.0, 6.0, 7.0, 6.0, 8.0, 5.0, 3.0, 1.0}, {1.0, 4.0, 7.0, 5.0, 4.0, 6.0, 4.0, 5.0, 7.0, 4.0, 1.0}, {2.0, 6.0, 4.0, 3.0, 3.0, 5.0, 3.0, 3.0, 4.0, 6.0, 2.0}, {3.0, 2.0, 1.0, 1.0, 2.0, 3.0, 2.0, 1.0, 1.0, 2.0, 3.0}};
    private static double[] heightDistrib = new double[]{10.0, 8.0, 5.0, 2.0};
    private static final WeightedRandom<Coordinate> coordinateRand = WeightedRandom.fromArray((double[][])randomDistrib);
    private static final WeightedRandom<Integer> verticalRand = new WeightedRandom();
    private final HashSet<BlockKey> flowerCache = new HashSet();
    private final StepTimer cacheTimer = new StepTimer(20);

    @Override
    public ForgeDirection getGrowthDirection() {
        return ForgeDirection.UP;
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.HARVESTPLANT;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        if (!world.field_72995_K) {
            this.cacheTimer.update();
            if (this.cacheTimer.checkCap()) {
                this.loadCache(world, x, y, z);
            }
            if (this.isActive(world, x, y, z)) {
                int n = 1 + this.getAccelerationPlants();
                for (int i = 0; i < n; ++i) {
                    int dy = (Integer)verticalRand.getRandomEntry();
                    Coordinate c = ((Coordinate)coordinateRand.getRandomEntry()).offset(x, y + dy, z);
                    Block b = c.getBlock(world);
                    int bmeta = c.getBlockMetadata(world);
                    if (c.getTaxicabDistanceTo(new Coordinate((TileEntity)this)) <= 1 || !this.canHarvest(b, bmeta, world, c.xCoord, c.yCoord, c.zCoord)) continue;
                    this.harvest(world, c.xCoord, c.yCoord, c.zCoord, b, bmeta);
                }
            }
        }
    }

    private boolean isActive(World world, int x, int y, int z) {
        return world.func_72937_j(x, y + 1, z) && world.func_72935_r() && !world.func_72864_z(x, y - 1, z);
    }

    private void harvest(World world, int x, int y, int z, Block b, int meta) {
        ItemStack in = new ItemStack((Item)Items.field_151097_aZ);
        ArrayList li = b.getDrops(world, x, y, z, meta, 0);
        if (b instanceof IShearable && ((IShearable)b).isShearable(in, (IBlockAccess)world, x, y, z)) {
            li = ((IShearable)b).onSheared(in, (IBlockAccess)world, x, y, z, 0);
        }
        ReikaItemHelper.dropItems((World)world, (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5), (Collection)li);
        ReikaSoundHelper.playBreakSound((World)world, (int)x, (int)y, (int)z, (Block)Blocks.field_150349_c);
        ReikaPacketHelper.sendDataPacket((String)"DragonAPIData", (int)APIPacketHandler.PacketIDs.BREAKPARTICLES.ordinal(), (World)world, (int)x, (int)y, (int)z, (int)Block.func_149682_b((Block)b), (int)meta);
        world.func_147449_b(x, y, z, Blocks.field_150350_a);
    }

    protected void onFirstTick(World world, int x, int y, int z) {
        this.loadCache(world, x, y, z);
    }

    private void loadCache(World world, int x, int y, int z) {
        this.flowerCache.clear();
        for (int i = 2; i < 6; ++i) {
            ForgeDirection dir = this.dirs[i];
            BlockKey bk = BlockKey.getAt((IBlockAccess)world, (int)(x + dir.offsetX), (int)(y + dir.offsetY), (int)(z + dir.offsetZ));
            if (bk.blockID.func_149688_o() != Material.field_151585_k) continue;
            this.flowerCache.add(bk);
        }
    }

    private boolean canHarvest(Block b, int meta, World world, int x, int y, int z) {
        return this.flowerCache.contains(new BlockKey(b, meta)) && ReikaWorldHelper.checkForAdjBlock((World)world, (int)x, (int)y, (int)z, (Block)b, (int)meta) != null && ReikaWorldHelper.checkForAdjBlock((World)world, (int)x, (int)y, (int)z, (Block)this.getTile().getBlock(), (int)this.getTile().getBlockMetadata()) == null;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public boolean isPlantable(World world, int x, int y, int z) {
        return ReikaPlantHelper.FLOWER.canPlantAt(world, x, y, z) || ReikaBlockHelper.isLeaf((IBlockAccess)world, (int)x, (int)(y - 1), (int)z) || ChromaTiles.getTile((IBlockAccess)world, x, y - 1, z) == ChromaTiles.PLANTACCEL;
    }

    static {
        for (int i = 0; i < heightDistrib.length; ++i) {
            verticalRand.addEntry((Object)(-i), heightDistrib[i]);
        }
    }
}

