/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.TileEntity.Networking;

import Reika.ChromatiCraft.Auxiliary.ChromaStructures;
import Reika.ChromatiCraft.Auxiliary.Interfaces.MultiBlockChromaTile;
import Reika.ChromatiCraft.Base.TileEntity.CrystalReceiverBase;
import Reika.ChromatiCraft.Base.TileEntity.TileEntityWirelessPowered;
import Reika.ChromatiCraft.Magic.Interfaces.WirelessSource;
import Reika.ChromatiCraft.Magic.Network.PylonFinder;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.GlowTendril;
import Reika.ChromatiCraft.Render.Particle.EntityBlurFX;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Instantiable.ParticleController.AttractiveMotionController;
import Reika.DragonAPI.Instantiable.Rendering.StructureRenderer;
import Reika.DragonAPI.Interfaces.MotionController;
import Reika.DragonAPI.Interfaces.TileEntity.LocationCached;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaPhysicsHelper;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class TileEntityWirelessSource
extends CrystalReceiverBase
implements WirelessSource,
LocationCached,
MultiBlockChromaTile {
    public static final int TRANSMIT_RANGE = 18;
    public static final double LOSS_PER_LUMEN = 0.2;
    public static final int OCCLUSION_FACTOR = 20;
    private boolean broadcasting = false;
    private boolean enhancedBroadcasting = false;
    @SideOnly(value=Side.CLIENT)
    public GlowTendril tendril;
    private static final HashSet<WorldLocation> cache = new HashSet();

    public TileEntityWirelessSource() {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            this.loadTendril();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void loadTendril() {
        this.tendril = new GlowTendril(1.25, 6);
    }

    protected void animateWithTick(World world, int x, int y, int z) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            if (world != null) {
                for (int i = 0; i < 5; ++i) {
                    this.tendril.update();
                }
            }
            this.tendril.update();
        }
    }

    @Override
    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateEntity(world, x, y, z, meta);
        if (world.field_72995_K) {
            this.doParticles(world, x, y, z);
        }
        if (!world.field_72995_K && this.getCooldown() == 0 && this.checkTimer.checkCap()) {
            this.checkAndRequest();
        }
        if (!world.field_72995_K && this.isBeacon()) {
            this.broadcastEnergy(world);
        }
    }

    @Override
    protected void onFirstTick(World world, int x, int y, int z) {
        super.onFirstTick(world, x, y, z);
        if (!world.field_72995_K) {
            cache.add(new WorldLocation((TileEntity)this));
        }
        this.validateStructure();
    }

    @Override
    public void validateStructure() {
        this.broadcasting = !this.field_145850_b.field_72995_K && ChromaStructures.getWirelessPedestalStructure(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e).matchInWorld();
        this.enhancedBroadcasting = this.broadcasting && ChromaStructures.getWirelessPedestalStructure2(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e).matchInWorld();
    }

    private void broadcastEnergy(World world) {
        ArrayList<WorldLocation> li = new ArrayList<WorldLocation>(cache);
        for (int i = 0; i < 16; ++i) {
            WorldLocation loc;
            TileEntity te;
            Collections.shuffle(li);
            Iterator<WorldLocation> i$ = li.iterator();
            while (!(!i$.hasNext() || (te = (loc = i$.next()).getTileEntity()) instanceof TileEntityWirelessSource && this.longRangeTransfer((TileEntityWirelessSource)te, CrystalElement.randomElement()))) {
            }
        }
    }

    private boolean longRangeTransfer(TileEntityWirelessSource te, CrystalElement e) {
        if (te.isBeacon()) {
            return false;
        }
        if (this.placerUUID != null && !this.placerUUID.equals(te.placerUUID)) {
            return false;
        }
        int amt = Math.min(this.getEnergy(e), te.getRemainingSpace(e));
        if (amt > 0) {
            amt = Math.min(amt, Math.max(25, amt / 8));
            this.drainEnergy(e, amt);
            te.receiveElement(e, amt / (te.field_145850_b.field_73011_w.field_76574_g != this.field_145850_b.field_73011_w.field_76574_g ? 4 : 2));
            te.syncAllData(false);
            return true;
        }
        return false;
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.broadcasting = NBT.func_74767_n("broadcast");
        this.enhancedBroadcasting = NBT.func_74767_n("broadcast2");
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74757_a("broadcast", this.broadcasting);
        NBT.func_74757_a("broadcast2", this.enhancedBroadcasting);
    }

    private void checkAndRequest() {
        for (int i = 0; i < CrystalElement.elements.length; ++i) {
            CrystalElement e = CrystalElement.elements[i];
            int space = this.getRemainingSpace(e);
            if (space <= (this.isBeacon() ? 0 : this.getEnergy(e))) continue;
            this.requestEnergy(e, space);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void doParticles(World world, int x, int y, int z) {
        int c;
        if (rand.nextInt(1 + Minecraft.func_71410_x().field_71474_y.field_74362_aa) == 0) {
            c = CrystalElement.getBlendedColor(this.getTicksExisted() + 15, 25);
            double v = ReikaRandomHelper.getRandomBetween((double)0.03125, (double)0.125);
            double[] vel = ReikaPhysicsHelper.polarToCartesian((double)v, (double)(rand.nextDouble() * 360.0), (double)(rand.nextDouble() * 360.0));
            float g = rand.nextBoolean() ? 0.0625f : -0.0625f;
            EntityBlurFX fx = new EntityBlurFX(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, vel[0], vel[1], vel[2]).setColor(c).setRapidExpand().setGravity(g).setColliding();
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
        if (this.broadcasting) {
            c = CrystalElement.getBlendedColor(this.getTicksExisted() + 43, 25);
            double d = (double)(this.getTicksExisted() % 80) / 80.0 * 6.0 - 2.5;
            double px = (double)x - 2.5;
            double pz = (double)z + d;
            AttractiveMotionController am = new AttractiveMotionController((TileEntity)this, 0.0013020833333333333, 0.1875, 0.9875);
            EntityBlurFX fx = new EntityBlurFX(world, px, y - 3, pz).setColor(c).setAlphaFading().setRapidExpand().setGravity(-0.0625f).setMotionController((MotionController)am).setLife(80);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            px = (double)x + 3.5;
            pz = (double)(z + 1) - d;
            fx = new EntityBlurFX(world, px, y - 3, pz).setColor(c).setAlphaFading().setRapidExpand().setGravity(-0.0625f).setMotionController((MotionController)am).setLife(80);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            pz = (double)z + 3.5;
            px = (double)x + d;
            fx = new EntityBlurFX(world, px, y - 3, pz).setColor(c).setAlphaFading().setRapidExpand().setGravity(-0.0625f).setMotionController((MotionController)am).setLife(80);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            pz = (double)z - 2.5;
            px = (double)(x + 1) - d;
            fx = new EntityBlurFX(world, px, y - 3, pz).setColor(c).setAlphaFading().setRapidExpand().setGravity(-0.0625f).setMotionController((MotionController)am).setLife(80);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    @Override
    public int getReceiveRange() {
        return 24;
    }

    @Override
    public boolean isConductingElement(CrystalElement e) {
        return e != null;
    }

    @Override
    public int maxThroughput() {
        return this.isBeacon() ? (this.enhancedBroadcasting ? 24000 : 9000) : 1000;
    }

    @Override
    public boolean canConduct() {
        return true;
    }

    @Override
    public int getMaxStorage(CrystalElement e) {
        return this.isBeacon() ? (this.enhancedBroadcasting ? 720000 : 360000) : 120000;
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.WIRELESS;
    }

    @Override
    public boolean canTransmitTo(TileEntityWirelessPowered te) {
        return te.func_145835_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 324.0;
    }

    @Override
    public int request(CrystalElement e, int amt, int x, int y, int z) {
        int ret;
        int has = this.getEnergy(e);
        int rem = ret = Math.min(amt, has);
        ret = (int)((double)ret / 1.2);
        if (!PylonFinder.lineOfSight(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, x, y, z)) {
            ret /= 20;
        }
        this.energy.subtract(e, rem);
        return ret;
    }

    public void breakBlock() {
        cache.remove(new WorldLocation((TileEntity)this));
    }

    public boolean isBeacon() {
        return this.broadcasting;
    }

    @SideOnly(value=Side.CLIENT)
    public int getRenderColor(float ptick) {
        int t = this.isInWorld() && !StructureRenderer.isRenderingTiles() ? this.getTicksExisted() : Math.abs((int)(System.currentTimeMillis() / 50L));
        return CrystalElement.getBlendedColor(t, 25);
    }
}

